/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.advancements.FrameType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;

public class DisplayInfo {
    private final ITextComponent field_192300_a;
    private final ITextComponent field_193225_b;
    private final ItemStack field_192301_b;
    private final ResourceLocation field_192302_c;
    private final FrameType field_192303_d;
    private final boolean field_193226_f;
    private final boolean field_193227_g;
    private final boolean field_193228_h;
    private float field_192304_e;
    private float field_192305_f;

    public DisplayInfo(ItemStack itemStack, ITextComponent iTextComponent, ITextComponent iTextComponent2, @Nullable ResourceLocation resourceLocation, FrameType frameType, boolean bl, boolean bl2, boolean bl3) {
        this.field_192300_a = iTextComponent;
        this.field_193225_b = iTextComponent2;
        this.field_192301_b = itemStack;
        this.field_192302_c = resourceLocation;
        this.field_192303_d = frameType;
        this.field_193226_f = bl;
        this.field_193227_g = bl2;
        this.field_193228_h = bl3;
    }

    public void func_192292_a(float f, float f2) {
        this.field_192304_e = f;
        this.field_192305_f = f2;
    }

    public ITextComponent func_192297_a() {
        return this.field_192300_a;
    }

    public ITextComponent func_193222_b() {
        return this.field_193225_b;
    }

    public ItemStack func_192298_b() {
        return this.field_192301_b;
    }

    @Nullable
    public ResourceLocation func_192293_c() {
        return this.field_192302_c;
    }

    public FrameType func_192291_d() {
        return this.field_192303_d;
    }

    public float func_192299_e() {
        return this.field_192304_e;
    }

    public float func_192296_f() {
        return this.field_192305_f;
    }

    public boolean func_193223_h() {
        return this.field_193226_f;
    }

    public boolean func_193220_i() {
        return this.field_193227_g;
    }

    public boolean func_193224_j() {
        return this.field_193228_h;
    }

    public static DisplayInfo func_192294_a(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext) {
        ITextComponent iTextComponent = JSONUtils.func_188174_a(jsonObject, "title", jsonDeserializationContext, ITextComponent.class);
        \u2603 = JSONUtils.func_188174_a(jsonObject, "description", jsonDeserializationContext, ITextComponent.class);
        if (iTextComponent == null || \u2603 == null) {
            throw new JsonSyntaxException("Both title and description must be set");
        }
        ItemStack \u26032 = DisplayInfo.func_193221_a(JSONUtils.func_152754_s(jsonObject, "icon"));
        ResourceLocation \u26033 = jsonObject.has("background") ? new ResourceLocation(JSONUtils.func_151200_h(jsonObject, "background")) : null;
        FrameType \u26034 = jsonObject.has("frame") ? FrameType.func_192308_a(JSONUtils.func_151200_h(jsonObject, "frame")) : FrameType.TASK;
        boolean \u26035 = JSONUtils.func_151209_a(jsonObject, "show_toast", true);
        boolean \u26036 = JSONUtils.func_151209_a(jsonObject, "announce_to_chat", true);
        boolean \u26037 = JSONUtils.func_151209_a(jsonObject, "hidden", false);
        return new DisplayInfo(\u26032, iTextComponent, \u2603, \u26033, \u26034, \u26035, \u26036, \u26037);
    }

    private static ItemStack func_193221_a(JsonObject jsonObject) {
        if (!jsonObject.has("item")) {
            throw new JsonSyntaxException("Unsupported icon type, currently only items are supported (add 'item' key)");
        }
        Item item = JSONUtils.func_188180_i(jsonObject, "item");
        if (jsonObject.has("data")) {
            throw new JsonParseException("Disallowed data tag found");
        }
        ItemStack \u26032 = new ItemStack(item);
        if (jsonObject.has("nbt")) {
            try {
                CompoundNBT compoundNBT = JsonToNBT.func_180713_a(JSONUtils.func_151206_a(jsonObject.get("nbt"), "nbt"));
                \u26032.func_77982_d(compoundNBT);
            }
            catch (CommandSyntaxException commandSyntaxException) {
                throw new JsonSyntaxException("Invalid nbt tag: " + commandSyntaxException.getMessage());
            }
        }
        return \u26032;
    }

    public void func_192290_a(PacketBuffer packetBuffer) {
        packetBuffer.func_179256_a(this.field_192300_a);
        packetBuffer.func_179256_a(this.field_193225_b);
        packetBuffer.func_150788_a(this.field_192301_b);
        packetBuffer.func_179249_a(this.field_192303_d);
        int n = 0;
        if (this.field_192302_c != null) {
            n |= 1;
        }
        if (this.field_193226_f) {
            n |= 2;
        }
        if (this.field_193228_h) {
            n |= 4;
        }
        packetBuffer.writeInt(n);
        if (this.field_192302_c != null) {
            packetBuffer.func_192572_a(this.field_192302_c);
        }
        packetBuffer.writeFloat(this.field_192304_e);
        packetBuffer.writeFloat(this.field_192305_f);
    }

    public static DisplayInfo func_192295_b(PacketBuffer packetBuffer) {
        ITextComponent iTextComponent = packetBuffer.func_179258_d();
        \u2603 = packetBuffer.func_179258_d();
        ItemStack \u26032 = packetBuffer.func_150791_c();
        FrameType \u26033 = packetBuffer.func_179257_a(FrameType.class);
        int \u26034 = packetBuffer.readInt();
        ResourceLocation \u26035 = (\u26034 & 1) != 0 ? packetBuffer.func_192575_l() : null;
        boolean \u26036 = (\u26034 & 2) != 0;
        boolean \u26037 = (\u26034 & 4) != 0;
        DisplayInfo \u26038 = new DisplayInfo(\u26032, iTextComponent, \u2603, \u26035, \u26033, \u26036, false, \u26037);
        \u26038.func_192292_a(packetBuffer.readFloat(), packetBuffer.readFloat());
        return \u26038;
    }

    public JsonElement func_200290_k() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("icon", (JsonElement)this.func_200289_l());
        jsonObject.add("title", ITextComponent.Serializer.func_200528_b(this.field_192300_a));
        jsonObject.add("description", ITextComponent.Serializer.func_200528_b(this.field_193225_b));
        jsonObject.addProperty("frame", this.field_192303_d.func_192307_a());
        jsonObject.addProperty("show_toast", Boolean.valueOf(this.field_193226_f));
        jsonObject.addProperty("announce_to_chat", Boolean.valueOf(this.field_193227_g));
        jsonObject.addProperty("hidden", Boolean.valueOf(this.field_193228_h));
        if (this.field_192302_c != null) {
            jsonObject.addProperty("background", this.field_192302_c.toString());
        }
        return jsonObject;
    }

    private JsonObject func_200289_l() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("item", Registry.field_212630_s.func_177774_c(this.field_192301_b.func_77973_b()).toString());
        if (this.field_192301_b.func_77942_o()) {
            jsonObject.addProperty("nbt", this.field_192301_b.func_77978_p().toString());
        }
        return jsonObject;
    }
}

