/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.util;

import com.mojang.realmsclient.RealmsMainScreen;
import com.mojang.realmsclient.client.RealmsClient;
import com.mojang.realmsclient.dto.Backup;
import com.mojang.realmsclient.dto.RealmsServer;
import com.mojang.realmsclient.dto.RealmsServerAddress;
import com.mojang.realmsclient.dto.WorldDownload;
import com.mojang.realmsclient.dto.WorldTemplate;
import com.mojang.realmsclient.exception.RealmsServiceException;
import com.mojang.realmsclient.exception.RetryCallException;
import com.mojang.realmsclient.gui.LongRunningTask;
import com.mojang.realmsclient.gui.screens.RealmsBrokenWorldScreen;
import com.mojang.realmsclient.gui.screens.RealmsConfigureWorldScreen;
import com.mojang.realmsclient.gui.screens.RealmsDownloadLatestWorldScreen;
import com.mojang.realmsclient.gui.screens.RealmsGenericErrorScreen;
import com.mojang.realmsclient.gui.screens.RealmsLongConfirmationScreen;
import com.mojang.realmsclient.gui.screens.RealmsLongRunningMcoTaskScreen;
import com.mojang.realmsclient.gui.screens.RealmsResetWorldScreen;
import com.mojang.realmsclient.gui.screens.RealmsResourcePackScreen;
import com.mojang.realmsclient.gui.screens.RealmsTermsScreen;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraft.realms.Realms;
import net.minecraft.realms.RealmsConfirmResultListener;
import net.minecraft.realms.RealmsConnect;
import net.minecraft.realms.RealmsScreen;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RealmsTasks {
    private static final Logger field_225184_a = LogManager.getLogger();

    private static void func_225182_b(int n) {
        try {
            Thread.sleep(n * 1000);
        }
        catch (InterruptedException interruptedException) {
            field_225184_a.error("", (Throwable)interruptedException);
        }
    }

    public static class DownloadTask
    extends LongRunningTask {
        private final long field_224996_b;
        private final int field_224997_c;
        private final RealmsScreen field_224998_d;
        private final String field_224999_e;

        public DownloadTask(long l, int n, String string, RealmsScreen realmsScreen) {
            this.field_224996_b = l;
            this.field_224997_c = n;
            this.field_224998_d = realmsScreen;
            this.field_224999_e = string;
        }

        @Override
        public void run() {
            this.func_224989_b(RealmsScreen.getLocalizedString("mco.download.preparing"));
            RealmsClient realmsClient = RealmsClient.func_224911_a();
            for (int i = 0; i < 25; ++i) {
                try {
                    if (this.func_224988_a()) {
                        return;
                    }
                    WorldDownload worldDownload = realmsClient.func_224917_b(this.field_224996_b, this.field_224997_c);
                    RealmsTasks.func_225182_b(1);
                    if (this.func_224988_a()) {
                        return;
                    }
                    Realms.setScreen(new RealmsDownloadLatestWorldScreen(this.field_224998_d, worldDownload, this.field_224999_e));
                    return;
                }
                catch (RetryCallException retryCallException) {
                    if (this.func_224988_a()) {
                        return;
                    }
                    RealmsTasks.func_225182_b(retryCallException.field_224985_e);
                    continue;
                }
                catch (RealmsServiceException realmsServiceException) {
                    if (this.func_224988_a()) {
                        return;
                    }
                    field_225184_a.error("Couldn't download world data");
                    Realms.setScreen(new RealmsGenericErrorScreen(realmsServiceException, this.field_224998_d));
                    return;
                }
                catch (Exception exception) {
                    if (this.func_224988_a()) {
                        return;
                    }
                    field_225184_a.error("Couldn't download world data", (Throwable)exception);
                    this.func_224986_a(exception.getLocalizedMessage());
                    return;
                }
            }
        }
    }

    public static class RestoreTask
    extends LongRunningTask {
        private final Backup field_225021_b;
        private final long field_225022_c;
        private final RealmsConfigureWorldScreen field_225023_d;

        public RestoreTask(Backup backup, long l, RealmsConfigureWorldScreen realmsConfigureWorldScreen) {
            this.field_225021_b = backup;
            this.field_225022_c = l;
            this.field_225023_d = realmsConfigureWorldScreen;
        }

        @Override
        public void run() {
            this.func_224989_b(RealmsScreen.getLocalizedString("mco.backup.restoring"));
            RealmsClient realmsClient = RealmsClient.func_224911_a();
            for (int i = 0; i < 25; ++i) {
                try {
                    if (this.func_224988_a()) {
                        return;
                    }
                    realmsClient.func_224928_c(this.field_225022_c, this.field_225021_b.backupId);
                    RealmsTasks.func_225182_b(1);
                    if (this.func_224988_a()) {
                        return;
                    }
                    Realms.setScreen(this.field_225023_d.func_224407_b());
                    return;
                }
                catch (RetryCallException retryCallException) {
                    if (this.func_224988_a()) {
                        return;
                    }
                    RealmsTasks.func_225182_b(retryCallException.field_224985_e);
                    continue;
                }
                catch (RealmsServiceException realmsServiceException) {
                    if (this.func_224988_a()) {
                        return;
                    }
                    field_225184_a.error("Couldn't restore backup", (Throwable)realmsServiceException);
                    Realms.setScreen(new RealmsGenericErrorScreen(realmsServiceException, (RealmsScreen)this.field_225023_d));
                    return;
                }
                catch (Exception exception) {
                    if (this.func_224988_a()) {
                        return;
                    }
                    field_225184_a.error("Couldn't restore backup", (Throwable)exception);
                    this.func_224986_a(exception.getLocalizedMessage());
                    return;
                }
            }
        }
    }

    public static class TrialCreationTask
    extends LongRunningTask {
        private final String field_225031_b;
        private final String field_225032_c;
        private final RealmsMainScreen field_225033_d;

        public TrialCreationTask(String string, String string2, RealmsMainScreen realmsMainScreen) {
            this.field_225031_b = string;
            this.field_225032_c = string2;
            this.field_225033_d = realmsMainScreen;
        }

        @Override
        public void run() {
            String string = RealmsScreen.getLocalizedString("mco.create.world.wait");
            this.func_224989_b(string);
            RealmsClient \u26032 = RealmsClient.func_224911_a();
            try {
                RealmsServer realmsServer = \u26032.func_224936_a(this.field_225031_b, this.field_225032_c);
                if (realmsServer != null) {
                    this.field_225033_d.func_223954_a(true);
                    this.field_225033_d.func_223948_g();
                    RealmsResetWorldScreen realmsResetWorldScreen = new RealmsResetWorldScreen(this.field_225033_d, realmsServer, this.field_225033_d.func_223942_f(), RealmsScreen.getLocalizedString("mco.selectServer.create"), RealmsScreen.getLocalizedString("mco.create.world.subtitle"), 0xA0A0A0, RealmsScreen.getLocalizedString("mco.create.world.skip"));
                    realmsResetWorldScreen.func_224432_a(RealmsScreen.getLocalizedString("mco.create.world.reset.title"));
                    Realms.setScreen(realmsResetWorldScreen);
                } else {
                    this.func_224986_a(RealmsScreen.getLocalizedString("mco.trial.unavailable"));
                }
            }
            catch (RealmsServiceException realmsServiceException) {
                field_225184_a.error("Couldn't create trial");
                this.func_224986_a(realmsServiceException.toString());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                field_225184_a.error("Couldn't create trial");
                this.func_224986_a(unsupportedEncodingException.getLocalizedMessage());
            }
            catch (IOException iOException) {
                field_225184_a.error("Could not parse response creating trial");
                this.func_224986_a(iOException.getLocalizedMessage());
            }
            catch (Exception exception) {
                field_225184_a.error("Could not create trial");
                this.func_224986_a(exception.getLocalizedMessage());
            }
        }
    }

    public static class WorldCreationTask
    extends LongRunningTask {
        private final String field_225034_b;
        private final String field_225035_c;
        private final long field_225036_d;
        private final RealmsScreen field_225037_e;

        public WorldCreationTask(long l, String string, String string2, RealmsScreen realmsScreen) {
            this.field_225036_d = l;
            this.field_225034_b = string;
            this.field_225035_c = string2;
            this.field_225037_e = realmsScreen;
        }

        @Override
        public void run() {
            String string = RealmsScreen.getLocalizedString("mco.create.world.wait");
            this.func_224989_b(string);
            RealmsClient \u26032 = RealmsClient.func_224911_a();
            try {
                \u26032.func_224900_a(this.field_225036_d, this.field_225034_b, this.field_225035_c);
                Realms.setScreen(this.field_225037_e);
            }
            catch (RealmsServiceException \u26033) {
                field_225184_a.error("Couldn't create world");
                this.func_224986_a(\u26033.toString());
            }
            catch (UnsupportedEncodingException \u26034) {
                field_225184_a.error("Couldn't create world");
                this.func_224986_a(\u26034.getLocalizedMessage());
            }
            catch (IOException \u26035) {
                field_225184_a.error("Could not parse response creating world");
                this.func_224986_a(\u26035.getLocalizedMessage());
            }
            catch (Exception \u26036) {
                field_225184_a.error("Could not create world");
                this.func_224986_a(\u26036.getLocalizedMessage());
            }
        }
    }

    public static class RealmsConnectTask
    extends LongRunningTask {
        private final RealmsConnect field_225004_b;
        private final RealmsServerAddress field_225005_c;

        public RealmsConnectTask(RealmsScreen realmsScreen, RealmsServerAddress realmsServerAddress) {
            this.field_225005_c = realmsServerAddress;
            this.field_225004_b = new RealmsConnect(realmsScreen);
        }

        @Override
        public void run() {
            this.func_224989_b(RealmsScreen.getLocalizedString("mco.connect.connecting"));
            net.minecraft.realms.RealmsServerAddress realmsServerAddress = net.minecraft.realms.RealmsServerAddress.parseString(this.field_225005_c.address);
            this.field_225004_b.connect(realmsServerAddress.getHost(), realmsServerAddress.getPort());
        }

        @Override
        public void func_224992_d() {
            this.field_225004_b.abort();
            Realms.clearResourcePack();
        }

        @Override
        public void func_224990_b() {
            this.field_225004_b.tick();
        }
    }

    public static class RealmsGetServerDetailsTask
    extends LongRunningTask {
        private final RealmsServer field_225007_b;
        private final RealmsScreen field_225008_c;
        private final RealmsMainScreen field_225009_d;
        private final ReentrantLock field_225010_e;

        public RealmsGetServerDetailsTask(RealmsMainScreen realmsMainScreen, RealmsScreen realmsScreen, RealmsServer realmsServer, ReentrantLock reentrantLock) {
            this.field_225008_c = realmsScreen;
            this.field_225009_d = realmsMainScreen;
            this.field_225007_b = realmsServer;
            this.field_225010_e = reentrantLock;
        }

        @Override
        public void run() {
            this.func_224989_b(RealmsScreen.getLocalizedString("mco.connect.connecting"));
            RealmsClient realmsClient = RealmsClient.func_224911_a();
            boolean \u26032 = false;
            boolean \u26033 = false;
            int \u26034 = 5;
            RealmsServerAddress \u26035 = null;
            boolean \u26036 = false;
            boolean \u26037 = false;
            for (int i = 0; i < 40 && !this.func_224988_a(); ++i) {
                try {
                    \u26035 = realmsClient.func_224904_b(this.field_225007_b.id);
                    \u26032 = true;
                }
                catch (RetryCallException retryCallException) {
                    \u26034 = retryCallException.field_224985_e;
                }
                catch (RealmsServiceException realmsServiceException) {
                    if (realmsServiceException.field_224983_c == 6002) {
                        \u26036 = true;
                        break;
                    }
                    if (realmsServiceException.field_224983_c == 6006) {
                        \u26037 = true;
                        break;
                    }
                    \u26033 = true;
                    this.func_224986_a(realmsServiceException.toString());
                    field_225184_a.error("Couldn't connect to world", (Throwable)realmsServiceException);
                    break;
                }
                catch (IOException iOException) {
                    field_225184_a.error("Couldn't parse response connecting to world", (Throwable)iOException);
                }
                catch (Exception exception) {
                    \u26033 = true;
                    field_225184_a.error("Couldn't connect to world", (Throwable)exception);
                    this.func_224986_a(exception.getLocalizedMessage());
                    break;
                }
                if (\u26032) break;
                this.func_225006_a(\u26034);
            }
            if (\u26036) {
                Realms.setScreen(new RealmsTermsScreen(this.field_225008_c, this.field_225009_d, this.field_225007_b));
            } else if (\u26037) {
                if (this.field_225007_b.ownerUUID.equals(Realms.getUUID())) {
                    RealmsBrokenWorldScreen realmsBrokenWorldScreen = new RealmsBrokenWorldScreen(this.field_225008_c, this.field_225009_d, this.field_225007_b.id);
                    if (this.field_225007_b.worldType.equals((Object)RealmsServer.ServerType.MINIGAME)) {
                        realmsBrokenWorldScreen.func_224052_a(RealmsScreen.getLocalizedString("mco.brokenworld.minigame.title"));
                    }
                    Realms.setScreen(realmsBrokenWorldScreen);
                } else {
                    Realms.setScreen(new RealmsGenericErrorScreen(RealmsScreen.getLocalizedString("mco.brokenworld.nonowner.title"), RealmsScreen.getLocalizedString("mco.brokenworld.nonowner.error"), this.field_225008_c));
                }
            } else if (!this.func_224988_a() && !\u26033) {
                if (\u26032) {
                    if (\u26035.resourcePackUrl != null && \u26035.resourcePackHash != null) {
                        String string = RealmsScreen.getLocalizedString("mco.configure.world.resourcepack.question.line1");
                        \u2603 = RealmsScreen.getLocalizedString("mco.configure.world.resourcepack.question.line2");
                        Realms.setScreen(new RealmsLongConfirmationScreen(new RealmsResourcePackScreen(this.field_225008_c, \u26035, this.field_225010_e), RealmsLongConfirmationScreen.Type.Info, string, \u2603, true, 100));
                    } else {
                        RealmsLongRunningMcoTaskScreen realmsLongRunningMcoTaskScreen = new RealmsLongRunningMcoTaskScreen(this.field_225008_c, new RealmsConnectTask(this.field_225008_c, \u26035));
                        realmsLongRunningMcoTaskScreen.func_224233_a();
                        Realms.setScreen(realmsLongRunningMcoTaskScreen);
                    }
                } else {
                    this.func_224986_a(RealmsScreen.getLocalizedString("mco.errorMessage.connectionFailure"));
                }
            }
        }

        private void func_225006_a(int n) {
            try {
                Thread.sleep(n * 1000);
            }
            catch (InterruptedException interruptedException) {
                field_225184_a.warn(interruptedException.getLocalizedMessage());
            }
        }
    }

    public static class ResettingWorldTask
    extends LongRunningTask {
        private final String field_225013_b;
        private final WorldTemplate field_225014_c;
        private final int field_225015_d;
        private final boolean field_225016_e;
        private final long field_225017_f;
        private final RealmsScreen field_225018_g;
        private int field_225019_h = -1;
        private String field_225020_i = RealmsScreen.getLocalizedString("mco.reset.world.resetting.screen.title");

        public ResettingWorldTask(long l, RealmsScreen realmsScreen, WorldTemplate worldTemplate) {
            this.field_225013_b = null;
            this.field_225014_c = worldTemplate;
            this.field_225015_d = -1;
            this.field_225016_e = true;
            this.field_225017_f = l;
            this.field_225018_g = realmsScreen;
        }

        public ResettingWorldTask(long l, RealmsScreen realmsScreen, String string, int n, boolean bl) {
            this.field_225013_b = string;
            this.field_225014_c = null;
            this.field_225015_d = n;
            this.field_225016_e = bl;
            this.field_225017_f = l;
            this.field_225018_g = realmsScreen;
        }

        public void func_225011_a(int n) {
            this.field_225019_h = n;
        }

        public void func_225012_c(String string) {
            this.field_225020_i = string;
        }

        @Override
        public void run() {
            RealmsClient realmsClient = RealmsClient.func_224911_a();
            this.func_224989_b(this.field_225020_i);
            for (int i = 0; i < 25; ++i) {
                try {
                    if (this.func_224988_a()) {
                        return;
                    }
                    if (this.field_225014_c != null) {
                        realmsClient.func_224924_g(this.field_225017_f, this.field_225014_c.id);
                    } else {
                        realmsClient.func_224943_a(this.field_225017_f, this.field_225013_b, this.field_225015_d, this.field_225016_e);
                    }
                    if (this.func_224988_a()) {
                        return;
                    }
                    if (this.field_225019_h == -1) {
                        Realms.setScreen(this.field_225018_g);
                    } else {
                        this.field_225018_g.confirmResult(true, this.field_225019_h);
                    }
                    return;
                }
                catch (RetryCallException retryCallException) {
                    if (this.func_224988_a()) {
                        return;
                    }
                    RealmsTasks.func_225182_b(retryCallException.field_224985_e);
                    continue;
                }
                catch (Exception exception) {
                    if (this.func_224988_a()) {
                        return;
                    }
                    field_225184_a.error("Couldn't reset world");
                    this.func_224986_a(exception.toString());
                    return;
                }
            }
        }
    }

    public static class SwitchMinigameTask
    extends LongRunningTask {
        private final long field_225024_b;
        private final WorldTemplate field_225025_c;
        private final RealmsConfigureWorldScreen field_225026_d;

        public SwitchMinigameTask(long l, WorldTemplate worldTemplate, RealmsConfigureWorldScreen realmsConfigureWorldScreen) {
            this.field_225024_b = l;
            this.field_225025_c = worldTemplate;
            this.field_225026_d = realmsConfigureWorldScreen;
        }

        @Override
        public void run() {
            RealmsClient realmsClient = RealmsClient.func_224911_a();
            String \u26032 = RealmsScreen.getLocalizedString("mco.minigame.world.starting.screen.title");
            this.func_224989_b(\u26032);
            for (int i = 0; i < 25; ++i) {
                try {
                    if (this.func_224988_a()) {
                        return;
                    }
                    if (!realmsClient.func_224905_d(this.field_225024_b, this.field_225025_c.id).booleanValue()) continue;
                    Realms.setScreen(this.field_225026_d);
                    break;
                }
                catch (RetryCallException retryCallException) {
                    if (this.func_224988_a()) {
                        return;
                    }
                    RealmsTasks.func_225182_b(retryCallException.field_224985_e);
                    continue;
                }
                catch (Exception exception) {
                    if (this.func_224988_a()) {
                        return;
                    }
                    field_225184_a.error("Couldn't start mini game!");
                    this.func_224986_a(exception.toString());
                }
            }
        }
    }

    public static class SwitchSlotTask
    extends LongRunningTask {
        private final long field_225027_b;
        private final int field_225028_c;
        private final RealmsConfirmResultListener field_225029_d;
        private final int field_225030_e;

        public SwitchSlotTask(long l, int n, RealmsConfirmResultListener realmsConfirmResultListener, int n2) {
            this.field_225027_b = l;
            this.field_225028_c = n;
            this.field_225029_d = realmsConfirmResultListener;
            this.field_225030_e = n2;
        }

        @Override
        public void run() {
            RealmsClient realmsClient = RealmsClient.func_224911_a();
            String \u26032 = RealmsScreen.getLocalizedString("mco.minigame.world.slot.screen.title");
            this.func_224989_b(\u26032);
            for (int i = 0; i < 25; ++i) {
                try {
                    if (this.func_224988_a()) {
                        return;
                    }
                    if (!realmsClient.func_224927_a(this.field_225027_b, this.field_225028_c)) continue;
                    this.field_225029_d.confirmResult(true, this.field_225030_e);
                    break;
                }
                catch (RetryCallException retryCallException) {
                    if (this.func_224988_a()) {
                        return;
                    }
                    RealmsTasks.func_225182_b(retryCallException.field_224985_e);
                    continue;
                }
                catch (Exception exception) {
                    if (this.func_224988_a()) {
                        return;
                    }
                    field_225184_a.error("Couldn't switch world!");
                    this.func_224986_a(exception.toString());
                }
            }
        }
    }

    public static class CloseServerTask
    extends LongRunningTask {
        private final RealmsServer field_224994_b;
        private final RealmsConfigureWorldScreen field_224995_c;

        public CloseServerTask(RealmsServer realmsServer, RealmsConfigureWorldScreen realmsConfigureWorldScreen) {
            this.field_224994_b = realmsServer;
            this.field_224995_c = realmsConfigureWorldScreen;
        }

        @Override
        public void run() {
            this.func_224989_b(RealmsScreen.getLocalizedString("mco.configure.world.closing"));
            RealmsClient realmsClient = RealmsClient.func_224911_a();
            for (int i = 0; i < 25; ++i) {
                if (this.func_224988_a()) {
                    return;
                }
                try {
                    boolean bl = realmsClient.func_224932_f(this.field_224994_b.id);
                    if (!bl) continue;
                    this.field_224995_c.func_224398_a();
                    this.field_224994_b.state = RealmsServer.Status.CLOSED;
                    Realms.setScreen(this.field_224995_c);
                    break;
                }
                catch (RetryCallException retryCallException) {
                    if (this.func_224988_a()) {
                        return;
                    }
                    RealmsTasks.func_225182_b(retryCallException.field_224985_e);
                    continue;
                }
                catch (Exception exception) {
                    if (this.func_224988_a()) {
                        return;
                    }
                    field_225184_a.error("Failed to close server", (Throwable)exception);
                    this.func_224986_a("Failed to close the server");
                }
            }
        }
    }

    public static class OpenServerTask
    extends LongRunningTask {
        private final RealmsServer field_225000_b;
        private final RealmsScreen field_225001_c;
        private final boolean field_225002_d;
        private final RealmsScreen field_225003_e;

        public OpenServerTask(RealmsServer realmsServer, RealmsScreen realmsScreen, RealmsScreen realmsScreen2, boolean bl) {
            this.field_225000_b = realmsServer;
            this.field_225001_c = realmsScreen;
            this.field_225002_d = bl;
            this.field_225003_e = realmsScreen2;
        }

        @Override
        public void run() {
            this.func_224989_b(RealmsScreen.getLocalizedString("mco.configure.world.opening"));
            RealmsClient realmsClient = RealmsClient.func_224911_a();
            for (int i = 0; i < 25; ++i) {
                if (this.func_224988_a()) {
                    return;
                }
                try {
                    boolean bl = realmsClient.func_224942_e(this.field_225000_b.id);
                    if (!bl) continue;
                    if (this.field_225001_c instanceof RealmsConfigureWorldScreen) {
                        ((RealmsConfigureWorldScreen)this.field_225001_c).func_224398_a();
                    }
                    this.field_225000_b.state = RealmsServer.Status.OPEN;
                    if (this.field_225002_d) {
                        ((RealmsMainScreen)this.field_225003_e).func_223911_a(this.field_225000_b, this.field_225001_c);
                        break;
                    }
                    Realms.setScreen(this.field_225001_c);
                    break;
                }
                catch (RetryCallException retryCallException) {
                    if (this.func_224988_a()) {
                        return;
                    }
                    RealmsTasks.func_225182_b(retryCallException.field_224985_e);
                    continue;
                }
                catch (Exception exception) {
                    if (this.func_224988_a()) {
                        return;
                    }
                    field_225184_a.error("Failed to open server", (Throwable)exception);
                    this.func_224986_a("Failed to open the server");
                }
            }
        }
    }
}

