/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.gui.screens;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.realmsclient.RealmsMainScreen;
import com.mojang.realmsclient.client.RealmsClient;
import com.mojang.realmsclient.dto.RealmsServer;
import com.mojang.realmsclient.dto.RealmsWorldOptions;
import com.mojang.realmsclient.dto.WorldDownload;
import com.mojang.realmsclient.exception.RealmsServiceException;
import com.mojang.realmsclient.gui.RealmsConstants;
import com.mojang.realmsclient.gui.screens.RealmsDownloadLatestWorldScreen;
import com.mojang.realmsclient.gui.screens.RealmsGenericErrorScreen;
import com.mojang.realmsclient.gui.screens.RealmsLongConfirmationScreen;
import com.mojang.realmsclient.gui.screens.RealmsLongRunningMcoTaskScreen;
import com.mojang.realmsclient.gui.screens.RealmsResetWorldScreen;
import com.mojang.realmsclient.util.RealmsTasks;
import com.mojang.realmsclient.util.RealmsTextureManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.realms.Realms;
import net.minecraft.realms.RealmsButton;
import net.minecraft.realms.RealmsMth;
import net.minecraft.realms.RealmsScreen;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RealmsBrokenWorldScreen
extends RealmsScreen {
    private static final Logger field_224071_a = LogManager.getLogger();
    private final RealmsScreen field_224072_b;
    private final RealmsMainScreen field_224073_c;
    private RealmsServer field_224074_d;
    private final long field_224075_e;
    private String field_224076_f = RealmsBrokenWorldScreen.getLocalizedString("mco.brokenworld.title");
    private final String field_224077_g = RealmsBrokenWorldScreen.getLocalizedString("mco.brokenworld.message.line1") + "\\n" + RealmsBrokenWorldScreen.getLocalizedString("mco.brokenworld.message.line2");
    private int field_224078_h;
    private int field_224079_i;
    private final int field_224080_j = 80;
    private final int field_224081_k = 5;
    private static final List<Integer> field_224082_l = Arrays.asList(1, 2, 3);
    private static final List<Integer> field_224083_m = Arrays.asList(4, 5, 6);
    private static final List<Integer> field_224084_n = Arrays.asList(7, 8, 9);
    private static final List<Integer> field_224085_o = Arrays.asList(10, 11, 12);
    private final List<Integer> field_224086_p = new ArrayList<Integer>();
    private int field_224087_q;

    public RealmsBrokenWorldScreen(RealmsScreen realmsScreen, RealmsMainScreen realmsMainScreen, long l) {
        this.field_224072_b = realmsScreen;
        this.field_224073_c = realmsMainScreen;
        this.field_224075_e = l;
    }

    public void func_224052_a(String string) {
        this.field_224076_f = string;
    }

    @Override
    public void init() {
        this.field_224078_h = this.width() / 2 - 150;
        this.field_224079_i = this.width() / 2 + 190;
        this.buttonsAdd(new RealmsButton(0, this.field_224079_i - 80 + 8, RealmsConstants.func_225109_a(13) - 5, 70, 20, RealmsBrokenWorldScreen.getLocalizedString("gui.back")){

            @Override
            public void onPress() {
                RealmsBrokenWorldScreen.this.func_224060_e();
            }
        });
        if (this.field_224074_d == null) {
            this.func_224068_a(this.field_224075_e);
        } else {
            this.func_224058_a();
        }
        this.setKeyboardHandlerSendRepeatsToGui(true);
    }

    public void func_224058_a() {
        for (Map.Entry<Integer, RealmsWorldOptions> entry : this.field_224074_d.slots.entrySet()) {
            RealmsWorldOptions realmsWorldOptions = entry.getValue();
            boolean \u26032 = entry.getKey() != this.field_224074_d.activeSlot || this.field_224074_d.worldType.equals((Object)RealmsServer.ServerType.MINIGAME);
            RealmsButton \u26033 = \u26032 ? new PlayButton((int)field_224082_l.get(entry.getKey() - 1), this.func_224065_a(entry.getKey()), RealmsBrokenWorldScreen.getLocalizedString("mco.brokenworld.play")) : new DownloadButton((int)field_224084_n.get(entry.getKey() - 1), this.func_224065_a(entry.getKey()), RealmsBrokenWorldScreen.getLocalizedString("mco.brokenworld.download"));
            if (this.field_224086_p.contains(entry.getKey())) {
                \u26033.active(false);
                \u26033.setMessage(RealmsBrokenWorldScreen.getLocalizedString("mco.brokenworld.downloaded"));
            }
            this.buttonsAdd(\u26033);
            this.buttonsAdd(new RealmsButton(field_224083_m.get(entry.getKey() - 1), this.func_224065_a(entry.getKey()), RealmsConstants.func_225109_a(10), 80, 20, RealmsBrokenWorldScreen.getLocalizedString("mco.brokenworld.reset")){

                @Override
                public void onPress() {
                    int n = field_224083_m.indexOf(this.id()) + 1;
                    RealmsResetWorldScreen \u26032 = new RealmsResetWorldScreen(RealmsBrokenWorldScreen.this, RealmsBrokenWorldScreen.this.field_224074_d, RealmsBrokenWorldScreen.this);
                    if (n != ((RealmsBrokenWorldScreen)RealmsBrokenWorldScreen.this).field_224074_d.activeSlot || ((RealmsBrokenWorldScreen)RealmsBrokenWorldScreen.this).field_224074_d.worldType.equals((Object)RealmsServer.ServerType.MINIGAME)) {
                        \u26032.func_224445_b(n);
                    }
                    \u26032.func_224444_a(14);
                    Realms.setScreen(\u26032);
                }
            });
        }
    }

    @Override
    public void tick() {
        ++this.field_224087_q;
    }

    @Override
    public void render(int n, int n2, float f) {
        this.renderBackground();
        super.render(n, n2, f);
        this.drawCenteredString(this.field_224076_f, this.width() / 2, 17, 0xFFFFFF);
        String[] stringArray = this.field_224077_g.split("\\\\n");
        for (int i = 0; i < stringArray.length; ++i) {
            this.drawCenteredString(stringArray[i], this.width() / 2, RealmsConstants.func_225109_a(-1) + 3 + i * 12, 0xA0A0A0);
        }
        if (this.field_224074_d == null) {
            return;
        }
        for (Map.Entry<Integer, RealmsWorldOptions> entry : this.field_224074_d.slots.entrySet()) {
            if (entry.getValue().templateImage != null && entry.getValue().templateId != -1L) {
                this.func_224053_a(this.func_224065_a(entry.getKey()), RealmsConstants.func_225109_a(1) + 5, n, n2, this.field_224074_d.activeSlot == entry.getKey() && !this.func_224069_f(), entry.getValue().getSlotName(entry.getKey()), entry.getKey(), entry.getValue().templateId, entry.getValue().templateImage, entry.getValue().empty);
                continue;
            }
            this.func_224053_a(this.func_224065_a(entry.getKey()), RealmsConstants.func_225109_a(1) + 5, n, n2, this.field_224074_d.activeSlot == entry.getKey() && !this.func_224069_f(), entry.getValue().getSlotName(entry.getKey()), entry.getKey(), -1L, null, entry.getValue().empty);
        }
    }

    private int func_224065_a(int n) {
        return this.field_224078_h + (n - 1) * 110;
    }

    @Override
    public void removed() {
        this.setKeyboardHandlerSendRepeatsToGui(false);
    }

    @Override
    public boolean keyPressed(int n, int n2, int n3) {
        if (n == 256) {
            this.func_224060_e();
            return true;
        }
        return super.keyPressed(n, n2, n3);
    }

    private void func_224060_e() {
        Realms.setScreen(this.field_224072_b);
    }

    private void func_224068_a(final long l) {
        new Thread(){

            @Override
            public void run() {
                RealmsClient realmsClient = RealmsClient.func_224911_a();
                try {
                    RealmsBrokenWorldScreen.this.field_224074_d = realmsClient.func_224935_a(l);
                    RealmsBrokenWorldScreen.this.func_224058_a();
                }
                catch (RealmsServiceException \u26032) {
                    field_224071_a.error("Couldn't get own world");
                    Realms.setScreen(new RealmsGenericErrorScreen(\u26032.getMessage(), RealmsBrokenWorldScreen.this.field_224072_b));
                }
                catch (IOException \u26033) {
                    field_224071_a.error("Couldn't parse response getting own world");
                }
            }
        }.start();
    }

    @Override
    public void confirmResult(boolean bl, int n) {
        if (!bl) {
            Realms.setScreen(this);
            return;
        }
        if (n == 13 || n == 14) {
            new Thread(){

                @Override
                public void run() {
                    RealmsClient realmsClient = RealmsClient.func_224911_a();
                    if (((RealmsBrokenWorldScreen)RealmsBrokenWorldScreen.this).field_224074_d.state.equals((Object)RealmsServer.Status.CLOSED)) {
                        RealmsTasks.OpenServerTask openServerTask = new RealmsTasks.OpenServerTask(RealmsBrokenWorldScreen.this.field_224074_d, RealmsBrokenWorldScreen.this, RealmsBrokenWorldScreen.this.field_224072_b, true);
                        RealmsLongRunningMcoTaskScreen \u26032 = new RealmsLongRunningMcoTaskScreen(RealmsBrokenWorldScreen.this, openServerTask);
                        \u26032.func_224233_a();
                        Realms.setScreen(\u26032);
                    } else {
                        try {
                            RealmsBrokenWorldScreen.this.field_224073_c.func_223942_f().func_223911_a(realmsClient.func_224935_a(RealmsBrokenWorldScreen.this.field_224075_e), RealmsBrokenWorldScreen.this);
                        }
                        catch (RealmsServiceException \u26033) {
                            field_224071_a.error("Couldn't get own world");
                            Realms.setScreen(RealmsBrokenWorldScreen.this.field_224072_b);
                        }
                        catch (IOException \u26034) {
                            field_224071_a.error("Couldn't parse response getting own world");
                            Realms.setScreen(RealmsBrokenWorldScreen.this.field_224072_b);
                        }
                    }
                }
            }.start();
        } else if (field_224084_n.contains(n)) {
            this.func_224066_b(field_224084_n.indexOf(n) + 1);
        } else if (field_224085_o.contains(n)) {
            this.field_224086_p.add(field_224085_o.indexOf(n) + 1);
            this.childrenClear();
            this.func_224058_a();
        }
    }

    private void func_224066_b(int n) {
        RealmsClient realmsClient = RealmsClient.func_224911_a();
        try {
            WorldDownload worldDownload = realmsClient.func_224917_b(this.field_224074_d.id, n);
            RealmsDownloadLatestWorldScreen \u26032 = new RealmsDownloadLatestWorldScreen(this, worldDownload, this.field_224074_d.name + " (" + this.field_224074_d.slots.get(n).getSlotName(n) + ")");
            \u26032.func_224167_a(field_224085_o.get(n - 1));
            Realms.setScreen(\u26032);
        }
        catch (RealmsServiceException realmsServiceException) {
            field_224071_a.error("Couldn't download world data");
            Realms.setScreen(new RealmsGenericErrorScreen(realmsServiceException, (RealmsScreen)this));
        }
    }

    private boolean func_224069_f() {
        return this.field_224074_d != null && this.field_224074_d.worldType.equals((Object)RealmsServer.ServerType.MINIGAME);
    }

    private void func_224053_a(int n6, int n2, int n3, int n4, boolean bl, String string, int n5, long l, String string2, boolean bl2) {
        int n6;
        if (bl2) {
            RealmsBrokenWorldScreen.bind("realms:textures/gui/realms/empty_frame.png");
        } else if (string2 != null && l != -1L) {
            RealmsTextureManager.func_225202_a(String.valueOf(l), string2);
        } else if (n5 == 1) {
            RealmsBrokenWorldScreen.bind("textures/gui/title/background/panorama_0.png");
        } else if (n5 == 2) {
            RealmsBrokenWorldScreen.bind("textures/gui/title/background/panorama_2.png");
        } else if (n5 == 3) {
            RealmsBrokenWorldScreen.bind("textures/gui/title/background/panorama_3.png");
        } else {
            RealmsTextureManager.func_225202_a(String.valueOf(this.field_224074_d.minigameId), this.field_224074_d.minigameImage);
        }
        if (!bl) {
            GlStateManager.color4f(0.56f, 0.56f, 0.56f, 1.0f);
        } else if (bl) {
            float f = 0.9f + 0.1f * RealmsMth.cos((float)this.field_224087_q * 0.2f);
            GlStateManager.color4f(f, f, f, 1.0f);
        }
        RealmsScreen.blit(n6 + 3, n2 + 3, 0.0f, 0.0f, 74, 74, 74, 74);
        RealmsBrokenWorldScreen.bind("realms:textures/gui/realms/slot_frame.png");
        if (bl) {
            GlStateManager.color4f(1.0f, 1.0f, 1.0f, 1.0f);
        } else {
            GlStateManager.color4f(0.56f, 0.56f, 0.56f, 1.0f);
        }
        RealmsScreen.blit(n6, n2, 0.0f, 0.0f, 80, 80, 80, 80);
        this.drawCenteredString(string, n6 + 40, n2 + 66, 0xFFFFFF);
    }

    private void func_224056_c(int n) {
        RealmsTasks.SwitchSlotTask switchSlotTask = new RealmsTasks.SwitchSlotTask(this.field_224074_d.id, n, this, 13);
        RealmsLongRunningMcoTaskScreen \u26032 = new RealmsLongRunningMcoTaskScreen(this.field_224072_b, switchSlotTask);
        \u26032.func_224233_a();
        Realms.setScreen(\u26032);
    }

    class DownloadButton
    extends RealmsButton {
        public DownloadButton(int n, int n2, String string) {
            super(n, n2, RealmsConstants.func_225109_a(8), 80, 20, string);
        }

        @Override
        public void onPress() {
            String string = RealmsScreen.getLocalizedString("mco.configure.world.restore.download.question.line1");
            \u2603 = RealmsScreen.getLocalizedString("mco.configure.world.restore.download.question.line2");
            Realms.setScreen(new RealmsLongConfirmationScreen(RealmsBrokenWorldScreen.this, RealmsLongConfirmationScreen.Type.Info, string, \u2603, true, this.id()));
        }
    }

    class PlayButton
    extends RealmsButton {
        public PlayButton(int n, int n2, String string) {
            super(n, n2, RealmsConstants.func_225109_a(8), 80, 20, string);
        }

        @Override
        public void onPress() {
            int n = field_224082_l.indexOf(this.id()) + 1;
            if (((RealmsBrokenWorldScreen)RealmsBrokenWorldScreen.this).field_224074_d.slots.get((Object)Integer.valueOf((int)n)).empty) {
                RealmsResetWorldScreen realmsResetWorldScreen = new RealmsResetWorldScreen(RealmsBrokenWorldScreen.this, RealmsBrokenWorldScreen.this.field_224074_d, RealmsBrokenWorldScreen.this, RealmsScreen.getLocalizedString("mco.configure.world.switch.slot"), RealmsScreen.getLocalizedString("mco.configure.world.switch.slot.subtitle"), 0xA0A0A0, RealmsScreen.getLocalizedString("gui.cancel"));
                realmsResetWorldScreen.func_224445_b(n);
                realmsResetWorldScreen.func_224432_a(RealmsScreen.getLocalizedString("mco.create.world.reset.title"));
                realmsResetWorldScreen.func_224444_a(14);
                Realms.setScreen(realmsResetWorldScreen);
            } else {
                RealmsBrokenWorldScreen.this.func_224056_c(n);
            }
        }
    }
}

