/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.dto;

import com.google.gson.JsonObject;
import com.mojang.realmsclient.dto.ValueObject;
import com.mojang.realmsclient.util.JsonUtils;
import net.minecraft.realms.RealmsScreen;

public class RealmsWorldOptions
extends ValueObject {
    public Boolean pvp;
    public Boolean spawnAnimals;
    public Boolean spawnMonsters;
    public Boolean spawnNPCs;
    public Integer spawnProtection;
    public Boolean commandBlocks;
    public Boolean forceGameMode;
    public Integer difficulty;
    public Integer gameMode;
    public String slotName;
    public long templateId;
    public String templateImage;
    public boolean adventureMap;
    public boolean empty;
    private static final boolean forceGameModeDefault = false;
    private static final boolean pvpDefault = true;
    private static final boolean spawnAnimalsDefault = true;
    private static final boolean spawnMonstersDefault = true;
    private static final boolean spawnNPCsDefault = true;
    private static final int spawnProtectionDefault = 0;
    private static final boolean commandBlocksDefault = false;
    private static final int difficultyDefault = 2;
    private static final int gameModeDefault = 0;
    private static final String slotNameDefault = "";
    private static final long templateIdDefault = -1L;
    private static final String templateImageDefault = null;
    private static final boolean adventureMapDefault = false;

    public RealmsWorldOptions(Boolean bl, Boolean bl2, Boolean bl3, Boolean bl4, Integer n, Boolean bl5, Integer n2, Integer n3, Boolean bl6, String string) {
        this.pvp = bl;
        this.spawnAnimals = bl2;
        this.spawnMonsters = bl3;
        this.spawnNPCs = bl4;
        this.spawnProtection = n;
        this.commandBlocks = bl5;
        this.difficulty = n2;
        this.gameMode = n3;
        this.forceGameMode = bl6;
        this.slotName = string;
    }

    public static RealmsWorldOptions getDefaults() {
        return new RealmsWorldOptions(true, true, true, true, 0, false, 2, 0, false, slotNameDefault);
    }

    public static RealmsWorldOptions getEmptyDefaults() {
        RealmsWorldOptions realmsWorldOptions = new RealmsWorldOptions(true, true, true, true, 0, false, 2, 0, false, slotNameDefault);
        realmsWorldOptions.setEmpty(true);
        return realmsWorldOptions;
    }

    public void setEmpty(boolean bl) {
        this.empty = bl;
    }

    public static RealmsWorldOptions parse(JsonObject jsonObject) {
        RealmsWorldOptions realmsWorldOptions = new RealmsWorldOptions(JsonUtils.func_225170_a("pvp", jsonObject, true), JsonUtils.func_225170_a("spawnAnimals", jsonObject, true), JsonUtils.func_225170_a("spawnMonsters", jsonObject, true), JsonUtils.func_225170_a("spawnNPCs", jsonObject, true), JsonUtils.func_225172_a("spawnProtection", jsonObject, 0), JsonUtils.func_225170_a("commandBlocks", jsonObject, false), JsonUtils.func_225172_a("difficulty", jsonObject, 2), JsonUtils.func_225172_a("gameMode", jsonObject, 0), JsonUtils.func_225170_a("forceGameMode", jsonObject, false), JsonUtils.func_225171_a("slotName", jsonObject, slotNameDefault));
        realmsWorldOptions.templateId = JsonUtils.func_225169_a("worldTemplateId", jsonObject, -1L);
        realmsWorldOptions.templateImage = JsonUtils.func_225171_a("worldTemplateImage", jsonObject, templateImageDefault);
        realmsWorldOptions.adventureMap = JsonUtils.func_225170_a("adventureMap", jsonObject, false);
        return realmsWorldOptions;
    }

    public String getSlotName(int n) {
        if (this.slotName == null || this.slotName.isEmpty()) {
            if (this.empty) {
                return RealmsScreen.getLocalizedString("mco.configure.world.slot.empty");
            }
            return this.getDefaultSlotName(n);
        }
        return this.slotName;
    }

    public String getDefaultSlotName(int n) {
        return RealmsScreen.getLocalizedString("mco.configure.world.slot", n);
    }

    public String toJson() {
        JsonObject jsonObject = new JsonObject();
        if (!this.pvp.booleanValue()) {
            jsonObject.addProperty("pvp", this.pvp);
        }
        if (!this.spawnAnimals.booleanValue()) {
            jsonObject.addProperty("spawnAnimals", this.spawnAnimals);
        }
        if (!this.spawnMonsters.booleanValue()) {
            jsonObject.addProperty("spawnMonsters", this.spawnMonsters);
        }
        if (!this.spawnNPCs.booleanValue()) {
            jsonObject.addProperty("spawnNPCs", this.spawnNPCs);
        }
        if (this.spawnProtection != 0) {
            jsonObject.addProperty("spawnProtection", (Number)this.spawnProtection);
        }
        if (this.commandBlocks.booleanValue()) {
            jsonObject.addProperty("commandBlocks", this.commandBlocks);
        }
        if (this.difficulty != 2) {
            jsonObject.addProperty("difficulty", (Number)this.difficulty);
        }
        if (this.gameMode != 0) {
            jsonObject.addProperty("gameMode", (Number)this.gameMode);
        }
        if (this.forceGameMode.booleanValue()) {
            jsonObject.addProperty("forceGameMode", this.forceGameMode);
        }
        if (this.slotName != null && !this.slotName.equals(slotNameDefault)) {
            jsonObject.addProperty("slotName", this.slotName);
        }
        return jsonObject.toString();
    }

    public RealmsWorldOptions clone() {
        return new RealmsWorldOptions(this.pvp, this.spawnAnimals, this.spawnMonsters, this.spawnNPCs, this.spawnProtection, this.commandBlocks, this.difficulty, this.gameMode, this.forceGameMode, this.slotName);
    }
}

