/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.platform;

import com.mojang.blaze3d.platform.GLX;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.util.LWJGLMemoryUntracker;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;
import org.lwjgl.system.MemoryUtil;

public class GlStateManager {
    private static final int LIGHT_COUNT = 8;
    private static final int TEXTURE_COUNT = 8;
    private static final FloatBuffer MATRIX_BUFFER = GLX.make(MemoryUtil.memAllocFloat((int)16), floatBuffer -> LWJGLMemoryUntracker.func_197933_a(MemoryUtil.memAddress((FloatBuffer)floatBuffer)));
    private static final FloatBuffer COLOR_BUFFER = GLX.make(MemoryUtil.memAllocFloat((int)4), floatBuffer -> LWJGLMemoryUntracker.func_197933_a(MemoryUtil.memAddress((FloatBuffer)floatBuffer)));
    private static final AlphaState ALPHA_TEST = new AlphaState();
    private static final BooleanState LIGHTING = new BooleanState(2896);
    private static final BooleanState[] LIGHT_ENABLE = (BooleanState[])IntStream.range(0, 8).mapToObj(n -> new BooleanState(16384 + n)).toArray(BooleanState[]::new);
    private static final ColorMaterialState COLOR_MATERIAL = new ColorMaterialState();
    private static final BlendState BLEND = new BlendState();
    private static final DepthState DEPTH = new DepthState();
    private static final FogState FOG = new FogState();
    private static final CullState CULL = new CullState();
    private static final PolygonOffsetState POLY_OFFSET = new PolygonOffsetState();
    private static final ColorLogicState COLOR_LOGIC = new ColorLogicState();
    private static final TexGenState TEX_GEN = new TexGenState();
    private static final ClearState CLEAR = new ClearState();
    private static final StencilState STENCIL = new StencilState();
    private static final BooleanState NORMALIZE = new BooleanState(2977);
    private static int activeTexture;
    private static final TextureState[] TEXTURES;
    private static int shadeModel;
    private static final BooleanState RESCALE_NORMAL;
    private static final ColorMask COLOR_MASK;
    private static final Color COLOR;
    private static final float DEFAULTALPHACUTOFF = 0.1f;

    public static void pushLightingAttributes() {
        GL11.glPushAttrib((int)8256);
    }

    public static void pushTextureAttributes() {
        GL11.glPushAttrib((int)270336);
    }

    public static void popAttributes() {
        GL11.glPopAttrib();
    }

    public static void disableAlphaTest() {
        GlStateManager.ALPHA_TEST.field_179208_a.func_179198_a();
    }

    public static void enableAlphaTest() {
        GlStateManager.ALPHA_TEST.field_179208_a.func_179200_b();
    }

    public static void alphaFunc(int n, float f) {
        if (n != GlStateManager.ALPHA_TEST.field_179206_b || f != GlStateManager.ALPHA_TEST.field_179207_c) {
            GlStateManager.ALPHA_TEST.field_179206_b = n;
            GlStateManager.ALPHA_TEST.field_179207_c = f;
            GL11.glAlphaFunc((int)n, (float)f);
        }
    }

    public static void enableLighting() {
        LIGHTING.func_179200_b();
    }

    public static void disableLighting() {
        LIGHTING.func_179198_a();
    }

    public static void enableLight(int n) {
        LIGHT_ENABLE[n].func_179200_b();
    }

    public static void disableLight(int n) {
        LIGHT_ENABLE[n].func_179198_a();
    }

    public static void enableColorMaterial() {
        GlStateManager.COLOR_MATERIAL.field_179191_a.func_179200_b();
    }

    public static void disableColorMaterial() {
        GlStateManager.COLOR_MATERIAL.field_179191_a.func_179198_a();
    }

    public static void colorMaterial(int n, int n2) {
        if (n != GlStateManager.COLOR_MATERIAL.field_179189_b || n2 != GlStateManager.COLOR_MATERIAL.field_179190_c) {
            GlStateManager.COLOR_MATERIAL.field_179189_b = n;
            GlStateManager.COLOR_MATERIAL.field_179190_c = n2;
            GL11.glColorMaterial((int)n, (int)n2);
        }
    }

    public static void light(int n, int n2, FloatBuffer floatBuffer) {
        GL11.glLightfv((int)n, (int)n2, (FloatBuffer)floatBuffer);
    }

    public static void lightModel(int n, FloatBuffer floatBuffer) {
        GL11.glLightModelfv((int)n, (FloatBuffer)floatBuffer);
    }

    public static void normal3f(float f, float f2, float f3) {
        GL11.glNormal3f((float)f, (float)f2, (float)f3);
    }

    public static void disableDepthTest() {
        GlStateManager.DEPTH.field_179052_a.func_179198_a();
    }

    public static void enableDepthTest() {
        GlStateManager.DEPTH.field_179052_a.func_179200_b();
    }

    public static void depthFunc(int n) {
        if (n != GlStateManager.DEPTH.field_179051_c) {
            GlStateManager.DEPTH.field_179051_c = n;
            GL11.glDepthFunc((int)n);
        }
    }

    public static void depthMask(boolean bl) {
        if (bl != GlStateManager.DEPTH.field_179050_b) {
            GlStateManager.DEPTH.field_179050_b = bl;
            GL11.glDepthMask((boolean)bl);
        }
    }

    public static void disableBlend() {
        GlStateManager.BLEND.field_179213_a.func_179198_a();
    }

    public static void enableBlend() {
        GlStateManager.BLEND.field_179213_a.func_179200_b();
    }

    public static void blendFunc(SourceFactor sourceFactor, DestFactor destFactor) {
        GlStateManager.blendFunc(sourceFactor.value, destFactor.value);
    }

    public static void blendFunc(int n, int n2) {
        if (n != GlStateManager.BLEND.field_179211_b || n2 != GlStateManager.BLEND.field_179212_c) {
            GlStateManager.BLEND.field_179211_b = n;
            GlStateManager.BLEND.field_179212_c = n2;
            GL11.glBlendFunc((int)n, (int)n2);
        }
    }

    public static void blendFuncSeparate(SourceFactor sourceFactor, DestFactor destFactor, SourceFactor sourceFactor2, DestFactor destFactor2) {
        GlStateManager.blendFuncSeparate(sourceFactor.value, destFactor.value, sourceFactor2.value, destFactor2.value);
    }

    public static void blendFuncSeparate(int n, int n2, int n3, int n4) {
        if (n != GlStateManager.BLEND.field_179211_b || n2 != GlStateManager.BLEND.field_179212_c || n3 != GlStateManager.BLEND.field_179209_d || n4 != GlStateManager.BLEND.field_179210_e) {
            GlStateManager.BLEND.field_179211_b = n;
            GlStateManager.BLEND.field_179212_c = n2;
            GlStateManager.BLEND.field_179209_d = n3;
            GlStateManager.BLEND.field_179210_e = n4;
            GLX.glBlendFuncSeparate(n, n2, n3, n4);
        }
    }

    public static void blendEquation(int n) {
        GL14.glBlendEquation((int)n);
    }

    public static void setupSolidRenderingTextureCombine(int n) {
        COLOR_BUFFER.put(0, (float)(n >> 16 & 0xFF) / 255.0f);
        COLOR_BUFFER.put(1, (float)(n >> 8 & 0xFF) / 255.0f);
        COLOR_BUFFER.put(2, (float)(n >> 0 & 0xFF) / 255.0f);
        COLOR_BUFFER.put(3, (float)(n >> 24 & 0xFF) / 255.0f);
        GlStateManager.texEnv(8960, 8705, COLOR_BUFFER);
        GlStateManager.texEnv(8960, 8704, 34160);
        GlStateManager.texEnv(8960, 34161, 7681);
        GlStateManager.texEnv(8960, 34176, 34166);
        GlStateManager.texEnv(8960, 34192, 768);
        GlStateManager.texEnv(8960, 34162, 7681);
        GlStateManager.texEnv(8960, 34184, 5890);
        GlStateManager.texEnv(8960, 34200, 770);
    }

    public static void tearDownSolidRenderingTextureCombine() {
        GlStateManager.texEnv(8960, 8704, 8448);
        GlStateManager.texEnv(8960, 34161, 8448);
        GlStateManager.texEnv(8960, 34162, 8448);
        GlStateManager.texEnv(8960, 34176, 5890);
        GlStateManager.texEnv(8960, 34184, 5890);
        GlStateManager.texEnv(8960, 34192, 768);
        GlStateManager.texEnv(8960, 34200, 770);
    }

    public static void enableFog() {
        GlStateManager.FOG.field_179049_a.func_179200_b();
    }

    public static void disableFog() {
        GlStateManager.FOG.field_179049_a.func_179198_a();
    }

    public static void fogMode(FogMode fogMode) {
        GlStateManager.fogMode(fogMode.field_187351_d);
    }

    private static void fogMode(int n) {
        if (n != GlStateManager.FOG.field_179047_b) {
            GlStateManager.FOG.field_179047_b = n;
            GL11.glFogi((int)2917, (int)n);
        }
    }

    public static void fogDensity(float f) {
        if (f != GlStateManager.FOG.field_179048_c) {
            GlStateManager.FOG.field_179048_c = f;
            GL11.glFogf((int)2914, (float)f);
        }
    }

    public static void fogStart(float f) {
        if (f != GlStateManager.FOG.field_179045_d) {
            GlStateManager.FOG.field_179045_d = f;
            GL11.glFogf((int)2915, (float)f);
        }
    }

    public static void fogEnd(float f) {
        if (f != GlStateManager.FOG.field_179046_e) {
            GlStateManager.FOG.field_179046_e = f;
            GL11.glFogf((int)2916, (float)f);
        }
    }

    public static void fog(int n, FloatBuffer floatBuffer) {
        GL11.glFogfv((int)n, (FloatBuffer)floatBuffer);
    }

    public static void fogi(int n, int n2) {
        GL11.glFogi((int)n, (int)n2);
    }

    public static void enableCull() {
        GlStateManager.CULL.field_179054_a.func_179200_b();
    }

    public static void disableCull() {
        GlStateManager.CULL.field_179054_a.func_179198_a();
    }

    public static void cullFace(CullFace cullFace) {
        GlStateManager.cullFace(cullFace.field_187328_d);
    }

    private static void cullFace(int n) {
        if (n != GlStateManager.CULL.field_179053_b) {
            GlStateManager.CULL.field_179053_b = n;
            GL11.glCullFace((int)n);
        }
    }

    public static void polygonMode(int n, int n2) {
        GL11.glPolygonMode((int)n, (int)n2);
    }

    public static void enablePolygonOffset() {
        GlStateManager.POLY_OFFSET.field_179044_a.func_179200_b();
    }

    public static void disablePolygonOffset() {
        GlStateManager.POLY_OFFSET.field_179044_a.func_179198_a();
    }

    public static void enableLineOffset() {
        GlStateManager.POLY_OFFSET.field_179042_b.func_179200_b();
    }

    public static void disableLineOffset() {
        GlStateManager.POLY_OFFSET.field_179042_b.func_179198_a();
    }

    public static void polygonOffset(float f, float f2) {
        if (f != GlStateManager.POLY_OFFSET.field_179043_c || f2 != GlStateManager.POLY_OFFSET.field_179041_d) {
            GlStateManager.POLY_OFFSET.field_179043_c = f;
            GlStateManager.POLY_OFFSET.field_179041_d = f2;
            GL11.glPolygonOffset((float)f, (float)f2);
        }
    }

    public static void enableColorLogicOp() {
        GlStateManager.COLOR_LOGIC.field_179197_a.func_179200_b();
    }

    public static void disableColorLogicOp() {
        GlStateManager.COLOR_LOGIC.field_179197_a.func_179198_a();
    }

    public static void logicOp(LogicOp logicOp) {
        GlStateManager.logicOp(logicOp.field_187370_q);
    }

    public static void logicOp(int n) {
        if (n != GlStateManager.COLOR_LOGIC.field_179196_b) {
            GlStateManager.COLOR_LOGIC.field_179196_b = n;
            GL11.glLogicOp((int)n);
        }
    }

    public static void enableTexGen(TexGen texGen) {
        GlStateManager.getTexGen((TexGen)texGen).field_179067_a.func_179200_b();
    }

    public static void disableTexGen(TexGen texGen) {
        GlStateManager.getTexGen((TexGen)texGen).field_179067_a.func_179198_a();
    }

    public static void texGenMode(TexGen texGen, int n) {
        TexGenCoord texGenCoord = GlStateManager.getTexGen(texGen);
        if (n != texGenCoord.field_179066_c) {
            texGenCoord.field_179066_c = n;
            GL11.glTexGeni((int)texGenCoord.field_179065_b, (int)9472, (int)n);
        }
    }

    public static void texGenParam(TexGen texGen, int n, FloatBuffer floatBuffer) {
        GL11.glTexGenfv((int)GlStateManager.getTexGen((TexGen)texGen).field_179065_b, (int)n, (FloatBuffer)floatBuffer);
    }

    private static TexGenCoord getTexGen(TexGen texGen) {
        switch (texGen) {
            case S: {
                return GlStateManager.TEX_GEN.field_179064_a;
            }
            case T: {
                return GlStateManager.TEX_GEN.field_179062_b;
            }
            case R: {
                return GlStateManager.TEX_GEN.field_179063_c;
            }
            case Q: {
                return GlStateManager.TEX_GEN.field_179061_d;
            }
        }
        return GlStateManager.TEX_GEN.field_179064_a;
    }

    public static void activeTexture(int n) {
        if (activeTexture != n - GLX.GL_TEXTURE0) {
            activeTexture = n - GLX.GL_TEXTURE0;
            GLX.glActiveTexture(n);
        }
    }

    public static void enableTexture() {
        GlStateManager.TEXTURES[GlStateManager.activeTexture].field_179060_a.func_179200_b();
    }

    public static void disableTexture() {
        GlStateManager.TEXTURES[GlStateManager.activeTexture].field_179060_a.func_179198_a();
    }

    public static void texEnv(int n, int n2, FloatBuffer floatBuffer) {
        GL11.glTexEnvfv((int)n, (int)n2, (FloatBuffer)floatBuffer);
    }

    public static void texEnv(int n, int n2, int n3) {
        GL11.glTexEnvi((int)n, (int)n2, (int)n3);
    }

    public static void texEnv(int n, int n2, float f) {
        GL11.glTexEnvf((int)n, (int)n2, (float)f);
    }

    public static void texParameter(int n, int n2, float f) {
        GL11.glTexParameterf((int)n, (int)n2, (float)f);
    }

    public static void texParameter(int n, int n2, int n3) {
        GL11.glTexParameteri((int)n, (int)n2, (int)n3);
    }

    public static int getTexLevelParameter(int n, int n2, int n3) {
        return GL11.glGetTexLevelParameteri((int)n, (int)n2, (int)n3);
    }

    public static int genTexture() {
        return GL11.glGenTextures();
    }

    public static void deleteTexture(int n) {
        GL11.glDeleteTextures((int)n);
        for (TextureState textureState : TEXTURES) {
            if (textureState.field_179059_b != n) continue;
            textureState.field_179059_b = -1;
        }
    }

    public static void bindTexture(int n) {
        if (n != GlStateManager.TEXTURES[GlStateManager.activeTexture].field_179059_b) {
            GlStateManager.TEXTURES[GlStateManager.activeTexture].field_179059_b = n;
            GL11.glBindTexture((int)3553, (int)n);
        }
    }

    public static void texImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, @Nullable IntBuffer intBuffer) {
        GL11.glTexImage2D((int)n, (int)n2, (int)n3, (int)n4, (int)n5, (int)n6, (int)n7, (int)n8, (IntBuffer)intBuffer);
    }

    public static void texSubImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, long l) {
        GL11.glTexSubImage2D((int)n, (int)n2, (int)n3, (int)n4, (int)n5, (int)n6, (int)n7, (int)n8, (long)l);
    }

    public static void copyTexSubImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        GL11.glCopyTexSubImage2D((int)n, (int)n2, (int)n3, (int)n4, (int)n5, (int)n6, (int)n7, (int)n8);
    }

    public static void getTexImage(int n, int n2, int n3, int n4, long l) {
        GL11.glGetTexImage((int)n, (int)n2, (int)n3, (int)n4, (long)l);
    }

    public static void enableNormalize() {
        NORMALIZE.func_179200_b();
    }

    public static void disableNormalize() {
        NORMALIZE.func_179198_a();
    }

    public static void shadeModel(int n) {
        if (n != shadeModel) {
            shadeModel = n;
            GL11.glShadeModel((int)n);
        }
    }

    public static void enableRescaleNormal() {
        RESCALE_NORMAL.func_179200_b();
    }

    public static void disableRescaleNormal() {
        RESCALE_NORMAL.func_179198_a();
    }

    public static void viewport(int n, int n2, int n3, int n4) {
        Viewport.INSTANCE.field_199289_b = n;
        Viewport.INSTANCE.field_199290_c = n2;
        Viewport.INSTANCE.field_199291_d = n3;
        Viewport.INSTANCE.field_199292_e = n4;
        GL11.glViewport((int)n, (int)n2, (int)n3, (int)n4);
    }

    public static void colorMask(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (bl != GlStateManager.COLOR_MASK.field_179188_a || bl2 != GlStateManager.COLOR_MASK.field_179186_b || bl3 != GlStateManager.COLOR_MASK.field_179187_c || bl4 != GlStateManager.COLOR_MASK.field_179185_d) {
            GlStateManager.COLOR_MASK.field_179188_a = bl;
            GlStateManager.COLOR_MASK.field_179186_b = bl2;
            GlStateManager.COLOR_MASK.field_179187_c = bl3;
            GlStateManager.COLOR_MASK.field_179185_d = bl4;
            GL11.glColorMask((boolean)bl, (boolean)bl2, (boolean)bl3, (boolean)bl4);
        }
    }

    public static void stencilFunc(int n, int n2, int n3) {
        if (n != GlStateManager.STENCIL.field_179078_a.field_179081_a || n != GlStateManager.STENCIL.field_179078_a.field_212902_b || n != GlStateManager.STENCIL.field_179078_a.field_179080_c) {
            GlStateManager.STENCIL.field_179078_a.field_179081_a = n;
            GlStateManager.STENCIL.field_179078_a.field_212902_b = n2;
            GlStateManager.STENCIL.field_179078_a.field_179080_c = n3;
            GL11.glStencilFunc((int)n, (int)n2, (int)n3);
        }
    }

    public static void stencilMask(int n) {
        if (n != GlStateManager.STENCIL.field_179076_b) {
            GlStateManager.STENCIL.field_179076_b = n;
            GL11.glStencilMask((int)n);
        }
    }

    public static void stencilOp(int n, int n2, int n3) {
        if (n != GlStateManager.STENCIL.field_179077_c || n2 != GlStateManager.STENCIL.field_179074_d || n3 != GlStateManager.STENCIL.field_179075_e) {
            GlStateManager.STENCIL.field_179077_c = n;
            GlStateManager.STENCIL.field_179074_d = n2;
            GlStateManager.STENCIL.field_179075_e = n3;
            GL11.glStencilOp((int)n, (int)n2, (int)n3);
        }
    }

    public static void clearDepth(double d) {
        if (d != GlStateManager.CLEAR.field_179205_a) {
            GlStateManager.CLEAR.field_179205_a = d;
            GL11.glClearDepth((double)d);
        }
    }

    public static void clearColor(float f, float f2, float f3, float f4) {
        if (f != GlStateManager.CLEAR.field_179203_b.field_179195_a || f2 != GlStateManager.CLEAR.field_179203_b.field_179193_b || f3 != GlStateManager.CLEAR.field_179203_b.field_179194_c || f4 != GlStateManager.CLEAR.field_179203_b.field_179192_d) {
            GlStateManager.CLEAR.field_179203_b.field_179195_a = f;
            GlStateManager.CLEAR.field_179203_b.field_179193_b = f2;
            GlStateManager.CLEAR.field_179203_b.field_179194_c = f3;
            GlStateManager.CLEAR.field_179203_b.field_179192_d = f4;
            GL11.glClearColor((float)f, (float)f2, (float)f3, (float)f4);
        }
    }

    public static void clearStencil(int n) {
        if (n != GlStateManager.CLEAR.field_212901_c) {
            GlStateManager.CLEAR.field_212901_c = n;
            GL11.glClearStencil((int)n);
        }
    }

    public static void clear(int n, boolean bl) {
        GL11.glClear((int)n);
        if (bl) {
            GlStateManager.getError();
        }
    }

    public static void matrixMode(int n) {
        GL11.glMatrixMode((int)n);
    }

    public static void loadIdentity() {
        GL11.glLoadIdentity();
    }

    public static void pushMatrix() {
        GL11.glPushMatrix();
    }

    public static void popMatrix() {
        GL11.glPopMatrix();
    }

    public static void getMatrix(int n, FloatBuffer floatBuffer) {
        GL11.glGetFloatv((int)n, (FloatBuffer)floatBuffer);
    }

    public static Matrix4f getMatrix4f(int n) {
        GL11.glGetFloatv((int)n, (FloatBuffer)MATRIX_BUFFER);
        MATRIX_BUFFER.rewind();
        Matrix4f matrix4f = new Matrix4f();
        matrix4f.func_195874_a(MATRIX_BUFFER);
        MATRIX_BUFFER.rewind();
        return matrix4f;
    }

    public static void ortho(double d, double d2, double d3, double d4, double d5, double d6) {
        GL11.glOrtho((double)d, (double)d2, (double)d3, (double)d4, (double)d5, (double)d6);
    }

    public static void rotatef(float f, float f2, float f3, float f4) {
        GL11.glRotatef((float)f, (float)f2, (float)f3, (float)f4);
    }

    public static void rotated(double d, double d2, double d3, double d4) {
        GL11.glRotated((double)d, (double)d2, (double)d3, (double)d4);
    }

    public static void scalef(float f, float f2, float f3) {
        GL11.glScalef((float)f, (float)f2, (float)f3);
    }

    public static void scaled(double d, double d2, double d3) {
        GL11.glScaled((double)d, (double)d2, (double)d3);
    }

    public static void translatef(float f, float f2, float f3) {
        GL11.glTranslatef((float)f, (float)f2, (float)f3);
    }

    public static void translated(double d, double d2, double d3) {
        GL11.glTranslated((double)d, (double)d2, (double)d3);
    }

    public static void multMatrix(FloatBuffer floatBuffer) {
        GL11.glMultMatrixf((FloatBuffer)floatBuffer);
    }

    public static void multMatrix(Matrix4f matrix4f) {
        matrix4f.func_195879_b(MATRIX_BUFFER);
        MATRIX_BUFFER.rewind();
        GL11.glMultMatrixf((FloatBuffer)MATRIX_BUFFER);
    }

    public static void color4f(float f, float f2, float f3, float f4) {
        if (f != GlStateManager.COLOR.field_179195_a || f2 != GlStateManager.COLOR.field_179193_b || f3 != GlStateManager.COLOR.field_179194_c || f4 != GlStateManager.COLOR.field_179192_d) {
            GlStateManager.COLOR.field_179195_a = f;
            GlStateManager.COLOR.field_179193_b = f2;
            GlStateManager.COLOR.field_179194_c = f3;
            GlStateManager.COLOR.field_179192_d = f4;
            GL11.glColor4f((float)f, (float)f2, (float)f3, (float)f4);
        }
    }

    public static void color3f(float f, float f2, float f3) {
        GlStateManager.color4f(f, f2, f3, 1.0f);
    }

    public static void texCoord2f(float f, float f2) {
        GL11.glTexCoord2f((float)f, (float)f2);
    }

    public static void vertex3f(float f, float f2, float f3) {
        GL11.glVertex3f((float)f, (float)f2, (float)f3);
    }

    public static void clearCurrentColor() {
        GlStateManager.COLOR.field_179195_a = -1.0f;
        GlStateManager.COLOR.field_179193_b = -1.0f;
        GlStateManager.COLOR.field_179194_c = -1.0f;
        GlStateManager.COLOR.field_179192_d = -1.0f;
    }

    public static void normalPointer(int n, int n2, int n3) {
        GL11.glNormalPointer((int)n, (int)n2, (long)n3);
    }

    public static void normalPointer(int n, int n2, ByteBuffer byteBuffer) {
        GL11.glNormalPointer((int)n, (int)n2, (ByteBuffer)byteBuffer);
    }

    public static void texCoordPointer(int n, int n2, int n3, int n4) {
        GL11.glTexCoordPointer((int)n, (int)n2, (int)n3, (long)n4);
    }

    public static void texCoordPointer(int n, int n2, int n3, ByteBuffer byteBuffer) {
        GL11.glTexCoordPointer((int)n, (int)n2, (int)n3, (ByteBuffer)byteBuffer);
    }

    public static void vertexPointer(int n, int n2, int n3, int n4) {
        GL11.glVertexPointer((int)n, (int)n2, (int)n3, (long)n4);
    }

    public static void vertexPointer(int n, int n2, int n3, ByteBuffer byteBuffer) {
        GL11.glVertexPointer((int)n, (int)n2, (int)n3, (ByteBuffer)byteBuffer);
    }

    public static void colorPointer(int n, int n2, int n3, int n4) {
        GL11.glColorPointer((int)n, (int)n2, (int)n3, (long)n4);
    }

    public static void colorPointer(int n, int n2, int n3, ByteBuffer byteBuffer) {
        GL11.glColorPointer((int)n, (int)n2, (int)n3, (ByteBuffer)byteBuffer);
    }

    public static void disableClientState(int n) {
        GL11.glDisableClientState((int)n);
    }

    public static void enableClientState(int n) {
        GL11.glEnableClientState((int)n);
    }

    public static void begin(int n) {
        GL11.glBegin((int)n);
    }

    public static void end() {
        GL11.glEnd();
    }

    public static void drawArrays(int n, int n2, int n3) {
        GL11.glDrawArrays((int)n, (int)n2, (int)n3);
    }

    public static void lineWidth(float f) {
        GL11.glLineWidth((float)f);
    }

    public static void callList(int n) {
        GL11.glCallList((int)n);
    }

    public static void deleteLists(int n, int n2) {
        GL11.glDeleteLists((int)n, (int)n2);
    }

    public static void newList(int n, int n2) {
        GL11.glNewList((int)n, (int)n2);
    }

    public static void endList() {
        GL11.glEndList();
    }

    public static int genLists(int n) {
        return GL11.glGenLists((int)n);
    }

    public static void pixelStore(int n, int n2) {
        GL11.glPixelStorei((int)n, (int)n2);
    }

    public static void pixelTransfer(int n, float f) {
        GL11.glPixelTransferf((int)n, (float)f);
    }

    public static void readPixels(int n, int n2, int n3, int n4, int n5, int n6, ByteBuffer byteBuffer) {
        GL11.glReadPixels((int)n, (int)n2, (int)n3, (int)n4, (int)n5, (int)n6, (ByteBuffer)byteBuffer);
    }

    public static void readPixels(int n, int n2, int n3, int n4, int n5, int n6, long l) {
        GL11.glReadPixels((int)n, (int)n2, (int)n3, (int)n4, (int)n5, (int)n6, (long)l);
    }

    public static int getError() {
        return GL11.glGetError();
    }

    public static String getString(int n) {
        return GL11.glGetString((int)n);
    }

    public static void getInteger(int n, IntBuffer intBuffer) {
        GL11.glGetIntegerv((int)n, (IntBuffer)intBuffer);
    }

    public static int getInteger(int n) {
        return GL11.glGetInteger((int)n);
    }

    public static void setProfile(Profile profile) {
        profile.func_187373_a();
    }

    public static void unsetProfile(Profile profile) {
        profile.func_187374_b();
    }

    static {
        TEXTURES = (TextureState[])IntStream.range(0, 8).mapToObj(n -> new TextureState()).toArray(TextureState[]::new);
        shadeModel = 7425;
        RESCALE_NORMAL = new BooleanState(32826);
        COLOR_MASK = new ColorMask();
        COLOR = new Color();
    }

    public static enum Profile {
        DEFAULT{

            @Override
            public void func_187373_a() {
                GlStateManager.disableAlphaTest();
                GlStateManager.alphaFunc(519, 0.0f);
                GlStateManager.disableLighting();
                GlStateManager.lightModel(2899, RenderHelper.func_74521_a(0.2f, 0.2f, 0.2f, 1.0f));
                for (int i = 0; i < 8; ++i) {
                    GlStateManager.disableLight(i);
                    GlStateManager.light(16384 + i, 4608, RenderHelper.func_74521_a(0.0f, 0.0f, 0.0f, 1.0f));
                    GlStateManager.light(16384 + i, 4611, RenderHelper.func_74521_a(0.0f, 0.0f, 1.0f, 0.0f));
                    if (i == 0) {
                        GlStateManager.light(16384 + i, 4609, RenderHelper.func_74521_a(1.0f, 1.0f, 1.0f, 1.0f));
                        GlStateManager.light(16384 + i, 4610, RenderHelper.func_74521_a(1.0f, 1.0f, 1.0f, 1.0f));
                        continue;
                    }
                    GlStateManager.light(16384 + i, 4609, RenderHelper.func_74521_a(0.0f, 0.0f, 0.0f, 1.0f));
                    GlStateManager.light(16384 + i, 4610, RenderHelper.func_74521_a(0.0f, 0.0f, 0.0f, 1.0f));
                }
                GlStateManager.disableColorMaterial();
                GlStateManager.colorMaterial(1032, 5634);
                GlStateManager.disableDepthTest();
                GlStateManager.depthFunc(513);
                GlStateManager.depthMask(true);
                GlStateManager.disableBlend();
                GlStateManager.blendFunc(SourceFactor.ONE, DestFactor.ZERO);
                GlStateManager.blendFuncSeparate(SourceFactor.ONE, DestFactor.ZERO, SourceFactor.ONE, DestFactor.ZERO);
                GlStateManager.blendEquation(32774);
                GlStateManager.disableFog();
                GlStateManager.fogi(2917, 2048);
                GlStateManager.fogDensity(1.0f);
                GlStateManager.fogStart(0.0f);
                GlStateManager.fogEnd(1.0f);
                GlStateManager.fog(2918, RenderHelper.func_74521_a(0.0f, 0.0f, 0.0f, 0.0f));
                if (GL.getCapabilities().GL_NV_fog_distance) {
                    GlStateManager.fogi(2917, 34140);
                }
                GlStateManager.polygonOffset(0.0f, 0.0f);
                GlStateManager.disableColorLogicOp();
                GlStateManager.logicOp(5379);
                GlStateManager.disableTexGen(TexGen.S);
                GlStateManager.texGenMode(TexGen.S, 9216);
                GlStateManager.texGenParam(TexGen.S, 9474, RenderHelper.func_74521_a(1.0f, 0.0f, 0.0f, 0.0f));
                GlStateManager.texGenParam(TexGen.S, 9217, RenderHelper.func_74521_a(1.0f, 0.0f, 0.0f, 0.0f));
                GlStateManager.disableTexGen(TexGen.T);
                GlStateManager.texGenMode(TexGen.T, 9216);
                GlStateManager.texGenParam(TexGen.T, 9474, RenderHelper.func_74521_a(0.0f, 1.0f, 0.0f, 0.0f));
                GlStateManager.texGenParam(TexGen.T, 9217, RenderHelper.func_74521_a(0.0f, 1.0f, 0.0f, 0.0f));
                GlStateManager.disableTexGen(TexGen.R);
                GlStateManager.texGenMode(TexGen.R, 9216);
                GlStateManager.texGenParam(TexGen.R, 9474, RenderHelper.func_74521_a(0.0f, 0.0f, 0.0f, 0.0f));
                GlStateManager.texGenParam(TexGen.R, 9217, RenderHelper.func_74521_a(0.0f, 0.0f, 0.0f, 0.0f));
                GlStateManager.disableTexGen(TexGen.Q);
                GlStateManager.texGenMode(TexGen.Q, 9216);
                GlStateManager.texGenParam(TexGen.Q, 9474, RenderHelper.func_74521_a(0.0f, 0.0f, 0.0f, 0.0f));
                GlStateManager.texGenParam(TexGen.Q, 9217, RenderHelper.func_74521_a(0.0f, 0.0f, 0.0f, 0.0f));
                GlStateManager.activeTexture(0);
                GlStateManager.texParameter(3553, 10240, 9729);
                GlStateManager.texParameter(3553, 10241, 9986);
                GlStateManager.texParameter(3553, 10242, 10497);
                GlStateManager.texParameter(3553, 10243, 10497);
                GlStateManager.texParameter(3553, 33085, 1000);
                GlStateManager.texParameter(3553, 33083, 1000);
                GlStateManager.texParameter(3553, 33082, -1000);
                GlStateManager.texParameter(3553, 34049, 0.0f);
                GlStateManager.texEnv(8960, 8704, 8448);
                GlStateManager.texEnv(8960, 8705, RenderHelper.func_74521_a(0.0f, 0.0f, 0.0f, 0.0f));
                GlStateManager.texEnv(8960, 34161, 8448);
                GlStateManager.texEnv(8960, 34162, 8448);
                GlStateManager.texEnv(8960, 34176, 5890);
                GlStateManager.texEnv(8960, 34177, 34168);
                GlStateManager.texEnv(8960, 34178, 34166);
                GlStateManager.texEnv(8960, 34184, 5890);
                GlStateManager.texEnv(8960, 34185, 34168);
                GlStateManager.texEnv(8960, 34186, 34166);
                GlStateManager.texEnv(8960, 34192, 768);
                GlStateManager.texEnv(8960, 34193, 768);
                GlStateManager.texEnv(8960, 34194, 770);
                GlStateManager.texEnv(8960, 34200, 770);
                GlStateManager.texEnv(8960, 34201, 770);
                GlStateManager.texEnv(8960, 34202, 770);
                GlStateManager.texEnv(8960, 34163, 1.0f);
                GlStateManager.texEnv(8960, 3356, 1.0f);
                GlStateManager.disableNormalize();
                GlStateManager.shadeModel(7425);
                GlStateManager.disableRescaleNormal();
                GlStateManager.colorMask(true, true, true, true);
                GlStateManager.clearDepth(1.0);
                GlStateManager.lineWidth(1.0f);
                GlStateManager.normal3f(0.0f, 0.0f, 1.0f);
                GlStateManager.polygonMode(1028, 6914);
                GlStateManager.polygonMode(1029, 6914);
            }

            @Override
            public void func_187374_b() {
            }
        }
        ,
        PLAYER_SKIN{

            @Override
            public void func_187373_a() {
                GlStateManager.enableBlend();
                GlStateManager.blendFuncSeparate(770, 771, 1, 0);
            }

            @Override
            public void func_187374_b() {
                GlStateManager.disableBlend();
            }
        }
        ,
        TRANSPARENT_MODEL{

            @Override
            public void func_187373_a() {
                GlStateManager.color4f(1.0f, 1.0f, 1.0f, 0.15f);
                GlStateManager.depthMask(false);
                GlStateManager.enableBlend();
                GlStateManager.blendFunc(SourceFactor.SRC_ALPHA, DestFactor.ONE_MINUS_SRC_ALPHA);
                GlStateManager.alphaFunc(516, 0.003921569f);
            }

            @Override
            public void func_187374_b() {
                GlStateManager.disableBlend();
                GlStateManager.alphaFunc(516, 0.1f);
                GlStateManager.depthMask(true);
            }
        };


        public abstract void func_187373_a();

        public abstract void func_187374_b();
    }

    public static enum DestFactor {
        CONSTANT_ALPHA(32771),
        CONSTANT_COLOR(32769),
        DST_ALPHA(772),
        DST_COLOR(774),
        ONE(1),
        ONE_MINUS_CONSTANT_ALPHA(32772),
        ONE_MINUS_CONSTANT_COLOR(32770),
        ONE_MINUS_DST_ALPHA(773),
        ONE_MINUS_DST_COLOR(775),
        ONE_MINUS_SRC_ALPHA(771),
        ONE_MINUS_SRC_COLOR(769),
        SRC_ALPHA(770),
        SRC_COLOR(768),
        ZERO(0);

        public final int value;

        private DestFactor(int n2) {
            this.value = n2;
        }
    }

    public static enum SourceFactor {
        CONSTANT_ALPHA(32771),
        CONSTANT_COLOR(32769),
        DST_ALPHA(772),
        DST_COLOR(774),
        ONE(1),
        ONE_MINUS_CONSTANT_ALPHA(32772),
        ONE_MINUS_CONSTANT_COLOR(32770),
        ONE_MINUS_DST_ALPHA(773),
        ONE_MINUS_DST_COLOR(775),
        ONE_MINUS_SRC_ALPHA(771),
        ONE_MINUS_SRC_COLOR(769),
        SRC_ALPHA(770),
        SRC_ALPHA_SATURATE(776),
        SRC_COLOR(768),
        ZERO(0);

        public final int value;

        private SourceFactor(int n2) {
            this.value = n2;
        }
    }

    static class BooleanState {
        private final int field_179202_a;
        private boolean field_179201_b;

        public BooleanState(int n) {
            this.field_179202_a = n;
        }

        public void func_179198_a() {
            this.func_179199_a(false);
        }

        public void func_179200_b() {
            this.func_179199_a(true);
        }

        public void func_179199_a(boolean bl) {
            if (bl != this.field_179201_b) {
                this.field_179201_b = bl;
                if (bl) {
                    GL11.glEnable((int)this.field_179202_a);
                } else {
                    GL11.glDisable((int)this.field_179202_a);
                }
            }
        }
    }

    static class Color {
        public float field_179195_a = 1.0f;
        public float field_179193_b = 1.0f;
        public float field_179194_c = 1.0f;
        public float field_179192_d = 1.0f;

        public Color() {
            this(1.0f, 1.0f, 1.0f, 1.0f);
        }

        public Color(float f, float f2, float f3, float f4) {
            this.field_179195_a = f;
            this.field_179193_b = f2;
            this.field_179194_c = f3;
            this.field_179192_d = f4;
        }
    }

    static class ColorMask {
        public boolean field_179188_a = true;
        public boolean field_179186_b = true;
        public boolean field_179187_c = true;
        public boolean field_179185_d = true;

        private ColorMask() {
        }
    }

    public static enum TexGen {
        S,
        T,
        R,
        Q;

    }

    static class TexGenCoord {
        public final BooleanState field_179067_a;
        public final int field_179065_b;
        public int field_179066_c = -1;

        public TexGenCoord(int n, int n2) {
            this.field_179065_b = n;
            this.field_179067_a = new BooleanState(n2);
        }
    }

    static class TexGenState {
        public final TexGenCoord field_179064_a = new TexGenCoord(8192, 3168);
        public final TexGenCoord field_179062_b = new TexGenCoord(8193, 3169);
        public final TexGenCoord field_179063_c = new TexGenCoord(8194, 3170);
        public final TexGenCoord field_179061_d = new TexGenCoord(8195, 3171);

        private TexGenState() {
        }
    }

    static class StencilState {
        public final StencilFunc field_179078_a = new StencilFunc();
        public int field_179076_b = -1;
        public int field_179077_c = 7680;
        public int field_179074_d = 7680;
        public int field_179075_e = 7680;

        private StencilState() {
        }
    }

    static class StencilFunc {
        public int field_179081_a = 519;
        public int field_212902_b;
        public int field_179080_c = -1;

        private StencilFunc() {
        }
    }

    static class ClearState {
        public double field_179205_a = 1.0;
        public final Color field_179203_b = new Color(0.0f, 0.0f, 0.0f, 0.0f);
        public int field_212901_c;

        private ClearState() {
        }
    }

    static class ColorLogicState {
        public final BooleanState field_179197_a = new BooleanState(3058);
        public int field_179196_b = 5379;

        private ColorLogicState() {
        }
    }

    static class PolygonOffsetState {
        public final BooleanState field_179044_a = new BooleanState(32823);
        public final BooleanState field_179042_b = new BooleanState(10754);
        public float field_179043_c;
        public float field_179041_d;

        private PolygonOffsetState() {
        }
    }

    static class CullState {
        public final BooleanState field_179054_a = new BooleanState(2884);
        public int field_179053_b = 1029;

        private CullState() {
        }
    }

    static class FogState {
        public final BooleanState field_179049_a = new BooleanState(2912);
        public int field_179047_b = 2048;
        public float field_179048_c = 1.0f;
        public float field_179045_d;
        public float field_179046_e = 1.0f;

        private FogState() {
        }
    }

    static class DepthState {
        public final BooleanState field_179052_a = new BooleanState(2929);
        public boolean field_179050_b = true;
        public int field_179051_c = 513;

        private DepthState() {
        }
    }

    static class BlendState {
        public final BooleanState field_179213_a = new BooleanState(3042);
        public int field_179211_b = 1;
        public int field_179212_c = 0;
        public int field_179209_d = 1;
        public int field_179210_e = 0;

        private BlendState() {
        }
    }

    static class ColorMaterialState {
        public final BooleanState field_179191_a = new BooleanState(2903);
        public int field_179189_b = 1032;
        public int field_179190_c = 5634;

        private ColorMaterialState() {
        }
    }

    static class AlphaState {
        public final BooleanState field_179208_a = new BooleanState(3008);
        public int field_179206_b = 519;
        public float field_179207_c = -1.0f;

        private AlphaState() {
        }
    }

    static class TextureState {
        public final BooleanState field_179060_a = new BooleanState(3553);
        public int field_179059_b;

        private TextureState() {
        }
    }

    public static enum Viewport {
        INSTANCE;

        protected int field_199289_b;
        protected int field_199290_c;
        protected int field_199291_d;
        protected int field_199292_e;
    }

    public static enum LogicOp {
        AND(5377),
        AND_INVERTED(5380),
        AND_REVERSE(5378),
        CLEAR(5376),
        COPY(5379),
        COPY_INVERTED(5388),
        EQUIV(5385),
        INVERT(5386),
        NAND(5390),
        NOOP(5381),
        NOR(5384),
        OR(5383),
        OR_INVERTED(5389),
        OR_REVERSE(5387),
        SET(5391),
        XOR(5382);

        public final int field_187370_q;

        private LogicOp(int n2) {
            this.field_187370_q = n2;
        }
    }

    public static enum CullFace {
        FRONT(1028),
        BACK(1029),
        FRONT_AND_BACK(1032);

        public final int field_187328_d;

        private CullFace(int n2) {
            this.field_187328_d = n2;
        }
    }

    public static enum FogMode {
        LINEAR(9729),
        EXP(2048),
        EXP2(2049);

        public final int field_187351_d;

        private FogMode(int n2) {
            this.field_187351_d = n2;
        }
    }
}

