/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.infernalmobs.common;

import atomicstryker.infernalmobs.common.InfernalMobsCore;
import java.util.Collection;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public abstract class MobModifier {
    private static final int TARGETING_TICKS_BEFORE_ATTACK = 30;
    protected MobModifier nextMod;
    private float actualHealth = 100.0f;
    private String[] bufferedNames;
    private float actualMaxHealth = -1.0f;
    private LivingEntity attackTarget;
    private LivingEntity previousAttackTarget;
    private int targetingTicksSteadyTarget = 0;
    private int bufferedSize = 0;
    private String bufferedEntityName;

    public MobModifier() {
    }

    protected MobModifier(MobModifier nxtMod) {
        this();
        this.nextMod = nxtMod;
    }

    public abstract String getModName();

    public String getLinkedModName() {
        return I18n.func_135052_a((String)("translation.infernalmobs:mod." + this.getModName()), (Object[])new Object[0]) + " " + (this.nextMod != null ? this.nextMod.getLinkedModName() : "");
    }

    public String getLinkedModNameUntranslated() {
        return this.getModName() + " " + (this.nextMod != null ? this.nextMod.getLinkedModNameUntranslated() : "");
    }

    public String[] getDisplayNames() {
        if (this.bufferedNames == null) {
            String[] allMods = this.getLinkedModName().split(" ");
            int index = 0;
            int j = 0;
            this.bufferedNames = new String[3];
            this.bufferedNames[index] = "";
            for (String m : allMods) {
                this.bufferedNames[index] = this.bufferedNames[index] + " " + m;
                if (++j % 5 != 0 || index + 1 >= this.bufferedNames.length) continue;
                this.bufferedNames[++index] = "";
            }
        }
        return this.bufferedNames;
    }

    public boolean containsModifierClass(Class<?> checkfor) {
        return checkfor.equals(this.getClass()) || this.nextMod != null && this.nextMod.containsModifierClass(checkfor);
    }

    public void onSpawningComplete(LivingEntity entity) {
        String oldTag = entity.getPersistentData().func_74779_i(InfernalMobsCore.instance().getNBTTag());
        if (!oldTag.isEmpty() && !oldTag.equals(this.getLinkedModNameUntranslated())) {
            InfernalMobsCore.LOGGER.info("Infernal Mobs tag mismatch!! Was [{}}], now trying to set [{}}] \n", (Object)oldTag, (Object)this.getLinkedModNameUntranslated());
        }
        entity.getPersistentData().func_74778_a(InfernalMobsCore.instance().getNBTTag(), this.getLinkedModNameUntranslated());
    }

    public boolean onDeath() {
        this.attackTarget = null;
        return this.nextMod != null && this.nextMod.onDeath();
    }

    public void onDropItems(LivingEntity moddedMob, DamageSource killSource, Collection<ItemEntity> drops, int lootingLevel, boolean recentlyHit, int specialDropValue) {
        if (recentlyHit) {
            InfernalMobsCore.instance().dropLootForEnt(moddedMob, this);
        }
    }

    public void onSetAttackTarget(LivingEntity target) {
        this.previousAttackTarget = this.attackTarget;
        this.attackTarget = target;
        if (this.previousAttackTarget != target) {
            this.targetingTicksSteadyTarget = 0;
        }
        if (this.nextMod != null) {
            this.nextMod.onSetAttackTarget(target);
        }
    }

    public float onAttack(LivingEntity entity, DamageSource source, float amount) {
        if (this.nextMod != null) {
            return this.nextMod.onAttack(entity, source, amount);
        }
        return amount;
    }

    public float onHurt(LivingEntity mob, DamageSource source, float amount) {
        if (this.nextMod != null) {
            amount = this.nextMod.onHurt(mob, source, amount);
        } else if (source.func_76346_g() != null && source.func_76346_g().field_70170_p.field_72995_K && source.func_76346_g() instanceof PlayerEntity) {
            InfernalMobsCore.instance().sendHealthRequestPacket(source.func_76346_g().func_200200_C_().func_150261_e(), mob);
        }
        return amount;
    }

    public boolean onFall(float distance) {
        return this.nextMod != null && this.nextMod.onFall(distance);
    }

    public void onJump(LivingEntity entityLiving) {
        if (this.nextMod != null) {
            this.nextMod.onJump(entityLiving);
        }
    }

    public boolean onUpdate(LivingEntity mob) {
        if (this.nextMod != null) {
            return this.nextMod.onUpdate(mob);
        }
        if (this.attackTarget == null) {
            this.attackTarget = mob.field_70170_p.func_217362_a((Entity)mob, 7.5);
        }
        if (this.attackTarget != null && (!this.attackTarget.func_70089_S() || this.attackTarget.func_70032_d((Entity)mob) > 15.0f)) {
            this.attackTarget = null;
        }
        return false;
    }

    public boolean hasSteadyTarget() {
        if (this.attackTarget != null) {
            ++this.targetingTicksSteadyTarget;
            if (this.targetingTicksSteadyTarget > 30) {
                return true;
            }
        }
        return false;
    }

    public float getActualHealth(LivingEntity mob) {
        if (!mob.field_70170_p.field_72995_K) {
            this.increaseHealthForMob(mob);
        }
        return this.actualHealth;
    }

    public void setHealthAlreadyHacked(LivingEntity mob) {
        if (!mob.field_70170_p.field_72995_K) {
            this.actualMaxHealth = this.getActualMaxHealth(mob);
            mob.getPersistentData().func_74757_a("infernalMaxHealth", true);
        }
    }

    private void increaseHealthForMob(LivingEntity mob) {
        if (!mob.getPersistentData().func_74767_n("infernalMaxHealth")) {
            this.actualHealth = this.actualMaxHealth = this.getActualMaxHealth(mob);
            InfernalMobsCore.instance().setEntityHealthPastMax(mob, this.actualHealth);
            mob.getPersistentData().func_74757_a("infernalMaxHealth", true);
        }
    }

    public float getActualMaxHealth(LivingEntity mob) {
        if (this.actualMaxHealth < 0.0f) {
            this.actualMaxHealth = (float)(InfernalMobsCore.instance().getMobClassMaxHealth(mob) * (double)this.getModSize() * InfernalMobsCore.instance().getMobModHealthFactor());
        }
        return this.actualMaxHealth;
    }

    public void setActualHealth(float health, float maxHealth) {
        this.actualHealth = health;
        this.actualMaxHealth = maxHealth;
    }

    protected LivingEntity getMobTarget() {
        return this.attackTarget;
    }

    public Class<?>[] getBlackListMobClasses() {
        return null;
    }

    public Class<?>[] getModsNotToMixWith() {
        return null;
    }

    public boolean equals(Object o) {
        return o instanceof MobModifier && ((MobModifier)o).getModName().equals(this.getModName());
    }

    public int getModSize() {
        if (this.bufferedSize == 0) {
            this.bufferedSize = 1;
            MobModifier nextmod = this.nextMod;
            while (nextmod != null) {
                ++this.bufferedSize;
                nextmod = nextmod.nextMod;
            }
        }
        return this.bufferedSize;
    }

    protected String[] getModNamePrefix() {
        return null;
    }

    protected String[] getModNameSuffix() {
        return null;
    }

    public String getEntityDisplayName(LivingEntity target) {
        if (this.bufferedEntityName == null) {
            String entTrans;
            String buffer = ForgeRegistries.ENTITIES.getKey((IForgeRegistryEntry)target.func_200600_R()).func_110623_a();
            String[] subStrings = buffer.split("\\.");
            if (subStrings.length > 1) {
                buffer = subStrings[subStrings.length - 1];
            }
            buffer = buffer.replaceFirst("Entity", "");
            String entLoc = "translation.infernalmobs:entity." + buffer;
            if (!entLoc.equals(entTrans = I18n.func_135052_a((String)entLoc, (Object[])new Object[0]))) {
                buffer = entTrans;
            }
            buffer = buffer.substring(0, 1).toUpperCase() + buffer.substring(1);
            int size = this.getModSize();
            MobModifier mod = this;
            for (int randomMod = target.func_70681_au().nextInt(this.getModSize()); randomMod > 0; --randomMod) {
                mod = mod.nextMod;
            }
            String modprefix = "";
            if (mod.getModNamePrefix() != null) {
                modprefix = mod.getModNamePrefix()[target.func_70681_au().nextInt(mod.getModNamePrefix().length)];
                modprefix = I18n.func_135052_a((String)("translation.infernalmobs:prefix." + modprefix), (Object[])new Object[0]);
            }
            String prefix = size <= 5 ? TextFormatting.AQUA + I18n.func_135052_a((String)"translation.infernalmobs:rareClass", (Object[])new Object[0]) : (size <= 10 ? TextFormatting.YELLOW + I18n.func_135052_a((String)"translation.infernalmobs:ultraClass", (Object[])new Object[0]) : TextFormatting.GOLD + I18n.func_135052_a((String)"translation.infernalmobs:infernalClass", (Object[])new Object[0]));
            buffer = String.format("%s %s %s", prefix, modprefix, buffer);
            if (size > 1) {
                MobModifier mobModifier = mod = mod.nextMod != null ? mod.nextMod : this;
                if (mod.getModNameSuffix() != null) {
                    String pickedSuffix = mod.getModNameSuffix()[target.func_70681_au().nextInt(mod.getModNameSuffix().length)];
                    pickedSuffix = I18n.func_135052_a((String)("translation.infernalmobs:suffix." + pickedSuffix), (Object[])new Object[0]);
                    buffer = String.format("%s %s", buffer, pickedSuffix);
                }
            }
            this.bufferedEntityName = buffer;
        }
        return this.bufferedEntityName;
    }

    public void resetModifiedVictim(PlayerEntity victim) {
    }
}

