/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.trashslot.client;

import com.electronwill.nightconfig.core.CommentedConfig;
import net.minecraftforge.fml.config.ModConfig;

public class ContainerSettings {
    public static final ContainerSettings NONE = new ContainerSettings(){

        @Override
        public void setEnabled(boolean isEnabled) {
        }
    };
    private final String category;
    private int slotX;
    private int slotY;
    private float anchorX;
    private float anchorY;
    private boolean isEnabled;

    private ContainerSettings() {
        this.category = "null";
    }

    public ContainerSettings(ModConfig config, String category, int defaultSlotX, int defaultSlotY, boolean isEnabledDefault) {
        this.category = category;
        CommentedConfig configData = config.getConfigData();
        this.slotX = configData.getIntOrElse(category + ".slotX", defaultSlotX);
        this.slotY = configData.getIntOrElse(category + ".slotY", defaultSlotY);
        this.anchorX = ((Float)configData.getOrElse(category + ".anchorX", (Object)Float.valueOf(0.5f))).floatValue();
        this.anchorY = ((Float)configData.getOrElse(category + ".anchorY", (Object)Float.valueOf(0.5f))).floatValue();
        this.isEnabled = (Boolean)configData.getOrElse(category + ".enabled", (Object)isEnabledDefault);
    }

    public void save(ModConfig config) {
        CommentedConfig configData = config.getConfigData();
        this.setWithComment(configData, this.category + ".slotX", this.slotX, "True if this screen should have a trash slot.");
        this.setWithComment(configData, this.category + ".slotY", this.slotY, "The x coordinate of the slot relative to the anchor.");
        this.setWithComment(configData, this.category + ".anchorX", this.anchorX, "The y coordinate of the slot relative to the anchor.");
        this.setWithComment(configData, this.category + ".anchorY", this.anchorY, "The x coordinate of the anchor point for the slot position.");
        this.setWithComment(configData, this.category + ".enabled", this.isEnabled, "The y coordinate of the anchor point for the slot position.");
        config.save();
    }

    private void setWithComment(CommentedConfig configData, String key, Object value, String comment) {
        configData.set(key, value);
        configData.setComment(key, comment);
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public int getSlotX() {
        return this.slotX;
    }

    public void setSlotX(int slotX) {
        this.slotX = slotX;
    }

    public int getSlotY() {
        return this.slotY;
    }

    public void setSlotY(int slotY) {
        this.slotY = slotY;
    }

    public float getAnchorX() {
        return this.anchorX;
    }

    public void setAnchorX(float anchorX) {
        this.anchorX = anchorX;
    }

    public float getAnchorY() {
        return this.anchorY;
    }

    public void setAnchorY(float anchorY) {
        this.anchorY = anchorY;
    }
}

