/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.trashslot;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.blay09.mods.trashslot.TrashSlot;
import net.blay09.mods.trashslot.api.IGuiContainerLayout;
import net.blay09.mods.trashslot.client.ContainerSettings;
import net.blay09.mods.trashslot.client.deletion.CreativeDeletionProvider;
import net.blay09.mods.trashslot.client.deletion.DefaultDeletionProvider;
import net.blay09.mods.trashslot.client.deletion.DeletionProvider;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="trashslot", bus=Mod.EventBusSubscriber.Bus.MOD)
public class TrashSlotConfig {
    static final ForgeConfigSpec clientSpec;
    public static final Client CLIENT;
    public static ModConfig clientConfig;
    private static final Map<String, ContainerSettings> settingsMap;
    private static final Set<String> hardcodedGuiBlackList;
    private static DeletionProvider deletionProvider;

    @OnlyIn(value=Dist.CLIENT)
    public static ContainerSettings getSettings(ContainerScreen<?> gui, IGuiContainerLayout layout) {
        String category = TrashSlotConfig.getConfigCategory(gui, layout);
        if (hardcodedGuiBlackList.contains(category)) {
            return ContainerSettings.NONE;
        }
        return settingsMap.computeIfAbsent(category, c -> new ContainerSettings(clientConfig, (String)c, layout.getDefaultSlotX(gui), layout.getDefaultSlotY(gui), layout.isEnabledByDefault()));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static String getConfigCategory(ContainerScreen<?> gui, IGuiContainerLayout layout) {
        return "client.gui." + layout.getContainerId(gui);
    }

    @SubscribeEvent
    public static void onConfig(ModConfig.ModConfigEvent event) {
        if (event.getConfig().getType() == ModConfig.Type.CLIENT) {
            clientConfig = event.getConfig();
            deletionProvider = null;
        }
    }

    @Nullable
    public static DeletionProvider getDeletionProvider() {
        if (TrashSlot.isServerSideInstalled && deletionProvider == null) {
            deletionProvider = (Boolean)TrashSlotConfig.CLIENT.instantDeletion.get() != false ? new CreativeDeletionProvider() : new DefaultDeletionProvider();
        }
        return deletionProvider;
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Client::new);
        clientSpec = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (Client)specPair.getLeft();
        settingsMap = Maps.newHashMap();
        hardcodedGuiBlackList = Sets.newHashSet();
        hardcodedGuiBlackList.add("client.gui.slimeknights/tconstruct/tools/common/client/module/GuiTinkerTabs");
        hardcodedGuiBlackList.add("client.gui.slimeknights/tconstruct/tools/common/client/GuiCraftingStation");
        hardcodedGuiBlackList.add("client.gui.slimeknights/tconstruct/tools/common/client/GuiPatternChest");
        hardcodedGuiBlackList.add("client.gui.slimeknights/tconstruct/tools/common/client/module/GuiButtonsStencilTable");
        hardcodedGuiBlackList.add("client.gui.slimeknights/tconstruct/tools/common/client/GuiPartBuilder");
    }

    public static class Client {
        public final ForgeConfigSpec.BooleanValue instantDeletion;

        Client(ForgeConfigSpec.Builder builder) {
            builder.comment("Client only settings").push("client");
            this.instantDeletion = builder.comment("This causes the deletion slot to delete items instantly, similar to Creative Mode.").translation("trashslot.config.instantDeletion").define("instantDeletion", false);
        }
    }
}

