/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.jar.Manifest;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.LogMarkers;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModJarURLHandler
extends URLStreamHandler {
    private static final Logger LOGGER = LogManager.getLogger();

    @Override
    protected URLConnection openConnection(URL url) {
        return new ModJarURLConnection(url);
    }

    static class ModJarURLConnection
    extends URLConnection {
        private Path resource;
        private String modpath;
        private String modid;
        private Optional<Manifest> manifest;

        public ModJarURLConnection(URL url) {
            super(url);
        }

        @Override
        public void connect() {
            if (this.resource == null) {
                this.modid = this.url.getHost();
                this.modpath = this.url.getPath().substring(1);
                this.resource = FMLLoader.getLoadingModList().getModFileById(this.modid).getFile().findResource(this.modpath);
                this.manifest = FMLLoader.getLoadingModList().getModFileById(this.modid).getManifest();
            }
        }

        @Override
        public InputStream getInputStream() throws IOException {
            this.connect();
            LOGGER.trace(LogMarkers.CORE, "Loading modjar URL {} got resource {} {}", (Object)this.url, (Object)this.resource, this.resource != null ? Boolean.valueOf(Files.exists(this.resource, new LinkOption[0])) : "missing");
            return Files.newInputStream(this.resource, new OpenOption[0]);
        }

        @Override
        public long getContentLengthLong() {
            try {
                this.connect();
                return Files.size(this.resource);
            }
            catch (IOException e) {
                return -1L;
            }
        }

        public Optional<Manifest> getManifest() {
            return this.manifest;
        }
    }
}

