/*
 * Decompiled with CFR 0.152.
 */
package its_meow.betteranimalsplus.util;

import its_meow.betteranimalsplus.util.EntityTypeContainer;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.MobEntity;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.ForgeConfigSpec;

public class EntityTypeContainerTameable<T extends MobEntity>
extends EntityTypeContainer<T> {
    protected String[] tameItemsStore;
    protected ForgeConfigSpec.ConfigValue<List<? extends String>> tameItems;
    protected String[] defaultTameItems;

    private EntityTypeContainerTameable(Class<T> EntityClass, Function<World, T> func, String entityNameIn, EntityClassification type, int solidColorIn, int spotColorIn, int prob, int min, int max, float width, float height, boolean despawn, String[] defaultTameItems, @Nullable EntityTypeContainer.CustomConfigurationHolder customConfig, Supplier<Set<Biome>> biomes, EntitySpawnPlacementRegistry.PlacementType placementType, Heightmap.Type heightMapType, EntitySpawnPlacementRegistry.IPlacementPredicate<T> placementPredicate) {
        super(EntityClass, func, entityNameIn, type, solidColorIn, spotColorIn, prob, min, max, width, height, despawn, customConfig, biomes, placementType, heightMapType, placementPredicate);
        this.defaultTameItems = defaultTameItems;
    }

    public String[] getTameItems() {
        return this.tameItemsStore;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setTameItems(String[] items) {
        this.tameItemsStore = items;
    }

    @Override
    public void configurationLoad() {
        super.configurationLoad();
        this.tameItemsStore = ((List)this.tameItems.get()).toArray(new String[0]);
    }

    @Override
    public void customConfigurationInit(ForgeConfigSpec.Builder builder) {
        super.customConfigurationInit(builder);
        this.tameItems = builder.comment("List of acceptable item IDs to use for taming. Accepts tags by prefixing them with '#'.").worldRestart().defineList("tameItems", Arrays.asList(this.defaultTameItems), input -> input instanceof String);
    }

    public static class TameableBuilder<T extends MobEntity>
    extends EntityTypeContainer.Builder<T> {
        protected String[] defaultTameItems;

        private TameableBuilder(Class<T> EntityClass, Function<World, T> func, String entityNameIn) {
            super(EntityClass, func, entityNameIn);
        }

        @Override
        public TameableBuilder<T> spawn(EntityClassification type, int weight, int min, int max) {
            super.spawn(type, weight, min, max);
            return this;
        }

        @Override
        public TameableBuilder<T> egg(int solid, int spot) {
            super.egg(solid, spot);
            return this;
        }

        @Override
        public TameableBuilder<T> size(float width, float height) {
            super.size(width, height);
            return this;
        }

        @Override
        public TameableBuilder<T> despawn() {
            super.despawn();
            return this;
        }

        @Override
        public TameableBuilder<T> config(EntityTypeContainer.CustomConfigurationHolder config) {
            super.config(config);
            return this;
        }

        @Override
        public TameableBuilder<T> biomes(BiomeDictionary.Type ... biomeTypes) {
            super.biomes(biomeTypes);
            return this;
        }

        @Override
        public TameableBuilder<T> biomes(Supplier<Biome[]> biomes) {
            super.biomes(biomes);
            return this;
        }

        @Override
        public TameableBuilder<T> placement(EntitySpawnPlacementRegistry.PlacementType type, Heightmap.Type heightMap, EntitySpawnPlacementRegistry.IPlacementPredicate<T> predicate) {
            super.placement(type, heightMap, predicate);
            return this;
        }

        @Override
        public TameableBuilder<T> defaultPlacement(EntitySpawnPlacementRegistry.IPlacementPredicate<T> predicate) {
            super.defaultPlacement(predicate);
            return this;
        }

        @Override
        public TameableBuilder<T> waterPlacement() {
            super.waterPlacement();
            return this;
        }

        @Override
        public TameableBuilder<T> waterPlacement(EntitySpawnPlacementRegistry.IPlacementPredicate<T> predicate) {
            super.waterPlacement(predicate);
            return this;
        }

        public TameableBuilder<T> tameItems(String ... items) {
            this.defaultTameItems = items;
            return this;
        }

        @Override
        public EntityTypeContainerTameable<T> build() {
            return new EntityTypeContainerTameable(this.entityClass, this.factory, this.entityName, this.spawnType, this.eggColorSolid, this.eggColorSpot, this.spawnWeight, this.spawnMinGroup, this.spawnMaxGroup, this.width, this.height, this.despawn, this.defaultTameItems, this.customConfig, this.defaultBiomeSupplier, this.placementType, this.heightMapType, this.placementPredicate);
        }

        public static <T extends MobEntity> TameableBuilder<T> create(Class<T> EntityClass, Function<World, T> func, String entityNameIn) {
            return new TameableBuilder<T>(EntityClass, func, entityNameIn);
        }
    }
}

