/*
 * Decompiled with CFR 0.152.
 */
package its_meow.betteranimalsplus.config;

import its_meow.betteranimalsplus.BetterAnimalsPlusMod;
import its_meow.betteranimalsplus.init.ModEntities;
import its_meow.betteranimalsplus.util.EntityTypeContainer;
import its_meow.betteranimalsplus.util.EntityTypeContainerTameable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="betteranimalsplus", bus=Mod.EventBusSubscriber.Bus.MOD)
public class BetterAnimalsPlusConfig {
    private static EntityConfig ENTITY_CONFIG = null;
    public static ForgeConfigSpec SERVER_CONFIG = null;
    public static boolean coyotesHostileDaytime = false;
    public static boolean biomeBasedVariants = false;
    public static boolean goatVanillaMilk = false;

    public static void setupConfig() {
        Pair specPair = new ForgeConfigSpec.Builder().configure(EntityConfig::new);
        SERVER_CONFIG = (ForgeConfigSpec)specPair.getRight();
        ENTITY_CONFIG = (EntityConfig)specPair.getLeft();
    }

    @SubscribeEvent
    public static void onLoad(ModConfig.Loading configEvent) {
        BetterAnimalsPlusMod.logger.debug("Loading {} {}", (Object)"betteranimalsplus", (Object)configEvent.getConfig().getFileName());
        if (configEvent.getConfig().getSpec() == SERVER_CONFIG) {
            ENTITY_CONFIG.onWorldLoad();
        }
    }

    @SubscribeEvent
    public static void onLoad(ModConfig.ConfigReloading configEvent) {
        BetterAnimalsPlusMod.logger.debug("Reloading {} {}", (Object)"betteranimalsplus", (Object)configEvent.getConfig().getFileName());
        if (configEvent.getConfig().getSpec() == SERVER_CONFIG) {
            ENTITY_CONFIG.loadEntityData();
        }
    }

    public static Map<String, String[]> getTameItemsMap() {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        for (EntityTypeContainer<? extends MobEntity> cont : ModEntities.ENTITIES.values()) {
            if (!(cont instanceof EntityTypeContainerTameable)) continue;
            EntityTypeContainerTameable cont2 = (EntityTypeContainerTameable)cont;
            map.put(cont2.entityName, cont2.getTameItems());
        }
        return map;
    }

    public static class EntityConfig {
        public ForgeConfigSpec.Builder builder;
        private final ForgeConfigSpec.BooleanValue biomeBasedVariants;

        EntityConfig(ForgeConfigSpec.Builder builder) {
            this.builder = builder;
            for (EntityTypeContainer<? extends MobEntity> cont : ModEntities.ENTITIES.values()) {
                cont.initConfiguration(builder);
            }
            builder.push("misc");
            this.biomeBasedVariants = builder.comment("Setting to true enables biome based variant spawning. This will make some entities choose variants based on the biome they spawn in. However, it will also affect eggs, possibly reducing the amount of visible content.").worldRestart().define("biomeBasedVariants", false);
            builder.pop();
            builder.build();
        }

        public void loadEntityData() {
            for (EntityTypeContainer<? extends MobEntity> container : ModEntities.ENTITIES.values()) {
                EntityTypeContainer.EntityConfiguration section = container.getConfiguration();
                container.configurationLoad();
                ArrayList<Biome> biomesList = new ArrayList<Biome>();
                for (String biomeID : (List)section.biomesList.get()) {
                    Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation(biomeID));
                    if (biome == null) {
                        BetterAnimalsPlusMod.logger.error("Invalid biome configuration entered for entity \"" + container.entityName + "\" (biome was mistyped or a biome mod was removed?): " + biomeID);
                        continue;
                    }
                    biomesList.add(biome);
                }
                container.setBiomes(biomesList.toArray(new Biome[0]));
            }
        }

        public void onWorldLoad() {
            biomeBasedVariants = (Boolean)this.biomeBasedVariants.get();
            this.loadEntityData();
            if (!ModEntities.ENTITIES.values().isEmpty()) {
                for (EntityTypeContainer<? extends MobEntity> entry : ModEntities.ENTITIES.values()) {
                    EntityType type = entry.entityType;
                    if (!entry.doSpawning) continue;
                    entry.registerPlacement();
                    for (Biome biome : entry.getBiomes()) {
                        biome.func_201866_a(entry.spawnType, new Biome.SpawnListEntry(type, entry.spawnWeight, entry.spawnMinGroup, entry.spawnMaxGroup));
                    }
                }
            }
        }
    }
}

