/*
 * Decompiled with CFR 0.152.
 */
package its_meow.betteranimalsplus.common.tileentity;

import its_meow.betteranimalsplus.init.ModTileEntities;
import its_meow.betteranimalsplus.util.HeadTypes;
import java.util.HashMap;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.loading.FMLEnvironment;

public class TileEntityHead
extends TileEntity {
    @OnlyIn(value=Dist.CLIENT)
    private Class<? extends EntityModel<Entity>> modelT;
    protected int typeNum = 0;
    private float offset;
    private float rotation = 0.0f;
    private boolean shouldDrop = true;
    private Function<Integer, ResourceLocation> textureFunc;
    public HeadTypes field_200663_e;
    public HashMap<Integer, ResourceLocation> textures;

    public TileEntityHead() {
        super(ModTileEntities.HEAD_TYPE);
    }

    public TileEntityHead(HeadTypes type, float yOffset, ResourceLocation ... textureList) {
        this(type, yOffset, (Function<Integer, ResourceLocation>)null, textureList);
    }

    public TileEntityHead(HeadTypes type, float yOffset, Function<Integer, ResourceLocation> textureFunc, ResourceLocation ... textureList) {
        super(ModTileEntities.HEAD_TYPE);
        this.field_200663_e = type;
        if (FMLEnvironment.dist == Dist.CLIENT) {
            this.modelT = type.getModelSupplier().get().get();
        }
        this.textures = new HashMap();
        int i = 1;
        for (ResourceLocation texture : textureList) {
            this.textures.put(i, texture);
            ++i;
        }
        if (!this.getTileData().func_74764_b("TYPENUM")) {
            this.setType(new Random().nextInt(type.textureCount) + 1);
            this.func_70296_d();
        }
        this.offset = yOffset;
        this.textureFunc = textureFunc;
    }

    @OnlyIn(value=Dist.CLIENT)
    public EntityModel<Entity> getModel() {
        try {
            return this.modelT.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.func_174877_v().func_177982_a(-1, -1, -1), this.func_174877_v().func_177982_a(2, 2, 2));
    }

    public ResourceLocation getTexture() {
        if (this.textureFunc == null) {
            return this.textures.get(this.typeNum);
        }
        ResourceLocation rl = this.textureFunc.apply(this.typeNum);
        if (rl == null || rl.toString().equals("")) {
            rl = this.textures.get(this.typeNum);
        }
        return rl;
    }

    public void setType(int i) {
        this.typeNum = i;
        this.func_70296_d();
    }

    public int typeValue() {
        return this.typeNum;
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("TYPENUM")) {
            this.typeNum = compound.func_74762_e("TYPENUM");
        } else {
            this.setType(new Random().nextInt(this.textures.size()) + 1);
        }
        if (compound.func_74764_b("rotation")) {
            this.rotation = compound.func_74760_g("rotation");
        }
        if (compound.func_74764_b("GENERIC_TYPE")) {
            this.field_200663_e = HeadTypes.valueOf(compound.func_74779_i("GENERIC_TYPE"));
            TileEntityHead te2 = this.field_200663_e.teFactory.apply(this.field_200663_e);
            if (FMLEnvironment.dist == Dist.CLIENT) {
                this.modelT = te2.modelT;
            }
            this.textures = te2.textures;
            this.offset = te2.offset;
            this.textureFunc = te2.textureFunc;
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("TYPENUM", this.typeNum);
        compound.func_74776_a("rotation", this.rotation);
        compound.func_74778_a("GENERIC_TYPE", this.field_200663_e.name());
        return compound;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT tag = new CompoundNBT();
        this.func_189515_b(tag);
        return new SUpdateTileEntityPacket(this.field_174879_c, 1, tag);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        this.func_145839_a(packet.func_148857_g());
        this.field_145850_b.func_205220_G_().func_205360_a(this.field_174879_c, (Object)this.func_195044_w().func_177230_c(), 100);
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT tag = new CompoundNBT();
        this.func_189515_b(tag);
        return tag;
    }

    public void handleUpdateTag(CompoundNBT tag) {
        this.func_145839_a(tag);
    }

    public float getOffset() {
        return this.offset;
    }

    public void setRotation(float rotation) {
        this.rotation = rotation;
        this.func_70296_d();
    }

    public float getSkullRotation() {
        return this.rotation;
    }

    public static void disableDrop(IBlockReader world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityHead) {
            ((TileEntityHead)te).shouldDrop = false;
        }
    }

    public boolean shouldDrop() {
        return this.shouldDrop;
    }
}

