/*
 * Decompiled with CFR 0.152.
 */
package its_meow.betteranimalsplus.common.item;

import its_meow.betteranimalsplus.BetterAnimalsPlusMod;
import its_meow.betteranimalsplus.common.tileentity.TileEntityHead;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.WallOrFloorItem;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class ItemBlockSkull
extends WallOrFloorItem {
    public final boolean allowFloor;
    public final int typeNum;

    public ItemBlockSkull(Block block, boolean allowFloor, int typeNum) {
        super(block, block, new Item.Properties().func_200916_a(BetterAnimalsPlusMod.group));
        if (block.getRegistryName() != null) {
            this.setRegistryName(block.getRegistryName());
        }
        this.allowFloor = allowFloor;
        this.typeNum = typeNum;
    }

    public ItemBlockSkull(Block block, boolean allowFloor, int typeNum, Item.Properties prop) {
        super(block, block, prop);
        if (block.getRegistryName() != null) {
            this.setRegistryName(block.getRegistryName());
        }
        this.allowFloor = allowFloor;
        this.typeNum = typeNum;
    }

    @Nullable
    protected BlockState func_195945_b(BlockItemUseContext ctx) {
        BlockState returnedState = null;
        World world = ctx.func_195991_k();
        BlockPos clickPos = ctx.func_195995_a();
        for (Direction side : ctx.func_196009_e()) {
            if (side == Direction.DOWN && !this.allowFloor) {
                return returnedState;
            }
            BlockState newState = this.func_179223_d().func_196258_a(ctx);
            if (newState == null || !newState.func_196955_c((IWorldReader)world, clickPos)) continue;
            returnedState = newState;
            break;
        }
        return returnedState;
    }

    public ActionResultType func_195942_a(BlockItemUseContext ctx) {
        if (!ctx.func_196011_b()) {
            return ActionResultType.FAIL;
        }
        if (ctx.func_196000_l() == Direction.DOWN) {
            return ActionResultType.FAIL;
        }
        BlockState iblockstate = this.func_195945_b(ctx);
        if (iblockstate == null) {
            return ActionResultType.FAIL;
        }
        if (!this.func_195941_b(ctx, iblockstate)) {
            return ActionResultType.FAIL;
        }
        if (ctx.func_196000_l() == Direction.UP && !this.allowFloor) {
            return ActionResultType.FAIL;
        }
        BlockPos blockpos = ctx.func_195995_a();
        World world = ctx.func_195991_k();
        PlayerEntity player = ctx.func_195999_j();
        ItemStack stack = ctx.func_195996_i();
        BlockState iblockstate1 = world.func_180495_p(blockpos);
        Block block = iblockstate1.func_177230_c();
        if (block == iblockstate.func_177230_c()) {
            this.func_195943_a(blockpos, world, player, stack, iblockstate1);
            block.func_180633_a(world, blockpos, iblockstate1, (LivingEntity)player, stack);
            if (player instanceof ServerPlayerEntity) {
                CriteriaTriggers.field_193137_x.func_193173_a((ServerPlayerEntity)player, blockpos, stack);
            }
            TileEntity tile = world.func_175625_s(blockpos);
            this.populateTile(stack, ctx.func_196000_l(), player, tile);
        }
        SoundType soundtype = iblockstate1.getSoundType((IWorldReader)world, blockpos, (Entity)ctx.func_195999_j());
        world.func_184133_a(player, blockpos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
        stack.func_190918_g(1);
        return ActionResultType.SUCCESS;
    }

    protected void populateTile(ItemStack stack, Direction side, PlayerEntity player, TileEntity tile) {
        if (tile instanceof TileEntityHead) {
            TileEntityHead tileSkull = (TileEntityHead)tile;
            float rotation = 0.0f;
            rotation = side == Direction.UP || side == Direction.DOWN ? Direction.func_176733_a((double)player.field_70759_as).func_185119_l() : (float)((int)side.func_185119_l());
            tileSkull.setRotation(rotation);
            tileSkull.setType(this.typeNum);
        }
    }

    public String func_77658_a() {
        return "block.betteranimalsplus." + this.getRegistryName().func_110623_a();
    }
}

