/*
 * Decompiled with CFR 0.152.
 */
package its_meow.betteranimalsplus.common.entity;

import com.google.common.base.Predicates;
import com.google.common.collect.Sets;
import its_meow.betteranimalsplus.common.entity.EntityAnimalWithSelectiveTypes;
import its_meow.betteranimalsplus.common.entity.EntityAnimalWithTypes;
import its_meow.betteranimalsplus.common.entity.IVariantTypes;
import its_meow.betteranimalsplus.init.ModEntities;
import its_meow.betteranimalsplus.init.ModLootTables;
import its_meow.betteranimalsplus.util.EntityTypeContainer;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.LogBlock;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.controller.FlyingMovementController;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.IFlyingAnimal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.BiomeDictionary;

public class EntitySongbird
extends EntityAnimalWithSelectiveTypes
implements IFlyingAnimal {
    protected static final Set<Item> SEEDS = Sets.newHashSet((Object[])new Item[]{Items.field_151014_N, Items.field_151081_bc, Items.field_151080_bb, Items.field_185163_cU});

    public EntitySongbird(World worldIn) {
        super((EntityType<? extends EntityAnimalWithSelectiveTypes>)ModEntities.SONGBIRD.entityType, worldIn);
        this.field_70765_h = new FlyingMovementController((MobEntity)this);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal((CreatureEntity)this, 1.25));
        com.google.common.base.Predicate avoidPredicate = input -> {
            boolean result1 = input instanceof PlayerEntity;
            boolean result2 = !SEEDS.contains(((PlayerEntity)input).func_184586_b(Hand.MAIN_HAND).func_77973_b()) && !SEEDS.contains(((PlayerEntity)input).func_184586_b(Hand.OFF_HAND).func_77973_b());
            return result1 && result2;
        };
        this.field_70714_bg.func_75776_a(2, (Goal)new AvoidEntityGoal((CreatureEntity)this, PlayerEntity.class, (Predicate)avoidPredicate, 10.0f, 0.8, 1.0, (Predicate)Predicates.alwaysTrue()));
        this.field_70714_bg.func_75776_a(3, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(4, (Goal)new BreedGoal((AnimalEntity)this, (double)0.4f));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomFlyingGoal((CreatureEntity)this, 1.0));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_193334_e);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(6.0);
        this.func_110148_a(SharedMonsterAttributes.field_193334_e).func_111128_a(0.4);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
    }

    public boolean func_213380_a(IWorld world, SpawnReason reason) {
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        int j = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b);
        int k = MathHelper.func_76128_c((double)this.field_70161_v);
        BlockPos blockpos = new BlockPos(i, j, k);
        if (world instanceof World && !((World)world).func_195588_v(new BlockPos((Vec3i)blockpos))) {
            Block block = this.field_70170_p.func_180495_p(blockpos.func_177977_b()).func_177230_c();
            return block instanceof LeavesBlock || block == Blocks.field_150349_c || block instanceof LogBlock || block == Blocks.field_150350_a && this.field_70170_p.func_201696_r(blockpos) > 8 && super.func_213380_a(world, reason);
        }
        return super.func_213380_a(world, reason);
    }

    protected PathNavigator func_175447_b(World worldIn) {
        FlyingPathNavigator pathnavigateflying = new FlyingPathNavigator((MobEntity)this, worldIn);
        pathnavigateflying.func_192879_a(false);
        pathnavigateflying.func_212239_d(true);
        pathnavigateflying.func_192878_b(true);
        return pathnavigateflying;
    }

    public boolean func_70877_b(ItemStack stack) {
        return SEEDS.contains(stack.func_77973_b());
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    protected void func_180429_a(BlockPos pos, BlockState state) {
        this.func_184185_a(SoundEvents.field_192795_es, 0.15f, 1.0f);
    }

    protected float func_191954_d(float p_191954_1_) {
        this.func_184185_a(SoundEvents.field_192796_et, 0.15f, 1.0f);
        return p_191954_1_;
    }

    protected boolean func_191957_ae() {
        return true;
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.NEUTRAL;
    }

    public boolean func_70104_M() {
        return true;
    }

    public boolean isFlying() {
        return !this.field_70122_E;
    }

    public boolean func_70878_b(AnimalEntity otherAnimal) {
        if (super.func_70878_b(otherAnimal)) {
            if (!(otherAnimal instanceof EntitySongbird)) {
                return false;
            }
            return ((EntitySongbird)otherAnimal).getTypeNumber() == this.getTypeNumber();
        }
        return false;
    }

    protected ResourceLocation func_184647_J() {
        return ModLootTables.songbird;
    }

    @Override
    public int getVariantMax() {
        return 10;
    }

    @Override
    protected IVariantTypes getBaseChild() {
        return new EntitySongbird(this.field_70170_p);
    }

    @Override
    protected int[] getTypesFor(Set<BiomeDictionary.Type> types) {
        if (types.contains(BiomeDictionary.Type.FOREST) && !types.contains(BiomeDictionary.Type.CONIFEROUS)) {
            return new int[]{2, 6, 7, 8};
        }
        if (types.contains(BiomeDictionary.Type.CONIFEROUS) && !types.contains(BiomeDictionary.Type.SNOWY)) {
            return new int[]{1, 9, 10};
        }
        if (types.contains(BiomeDictionary.Type.CONIFEROUS) && types.contains(BiomeDictionary.Type.SNOWY)) {
            return new int[]{3, 4, 5};
        }
        return new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
    }

    @Override
    protected EntityTypeContainer<? extends EntityAnimalWithTypes> getContainer() {
        return ModEntities.SONGBIRD;
    }
}

