/*
 * Decompiled with CFR 0.152.
 */
package its_meow.betteranimalsplus.client.renderer.tileentity;

import com.mojang.blaze3d.platform.GlStateManager;
import its_meow.betteranimalsplus.common.block.BlockAnimalSkull;
import its_meow.betteranimalsplus.common.tileentity.TileEntityHead;
import its_meow.betteranimalsplus.util.HeadTypes;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;

public class RenderGenericHead
extends TileEntityRenderer<TileEntityHead> {
    public static HashMap<HeadTypes, EntityModel<Entity>> modelMap = new HashMap();

    public void render(TileEntityHead te, double x, double y, double z, float partialTicks, int destroyStage) {
        BlockState iblockstate = te.func_195044_w();
        if (iblockstate == null || !(iblockstate.func_177230_c() instanceof BlockAnimalSkull)) {
            return;
        }
        Direction enumfacing = (Direction)iblockstate.func_177229_b((IProperty)BlockAnimalSkull.FACING_EXCEPT_DOWN);
        enumfacing = enumfacing == null ? Direction.NORTH : enumfacing;
        float rotation = -enumfacing.func_185119_l();
        rotation = enumfacing == Direction.NORTH || enumfacing == Direction.SOUTH ? enumfacing.func_176734_d().func_185119_l() : rotation;
        rotation = enumfacing == Direction.UP ? te.getSkullRotation() : rotation;
        EntityModel<Entity> model = modelMap.get((Object)te.field_200663_e);
        if (model == null) {
            EntityModel<Entity> newModel = te.getModel();
            modelMap.put(te.field_200663_e, newModel);
            model = newModel;
        }
        this.render((float)x, (float)y, (float)z, enumfacing, rotation, destroyStage, te.getTexture(), model, te.getOffset());
    }

    public void render(float x, float y, float z, @Nullable Direction facing, float skullRotation, int destroyStage, ResourceLocation texture, EntityModel<Entity> model, float yOffset) {
        if (destroyStage >= 0) {
            this.func_147499_a(field_178460_a[destroyStage]);
            GlStateManager.matrixMode((int)5890);
            GlStateManager.pushMatrix();
            GlStateManager.scalef((float)4.0f, (float)2.0f, (float)1.0f);
            GlStateManager.translatef((float)0.0625f, (float)0.0625f, (float)0.0625f);
            GlStateManager.matrixMode((int)5888);
        } else if (texture != null) {
            this.func_147499_a(texture);
        }
        GlStateManager.pushMatrix();
        GlStateManager.disableCull();
        RenderGenericHead.translateHead(x, y, z, facing, 1.5f + yOffset);
        GlStateManager.enableRescaleNormal();
        GlStateManager.scalef((float)-1.0f, (float)-1.0f, (float)1.0f);
        GlStateManager.enableAlphaTest();
        float rotX = 0.0f;
        if (facing != null) {
            rotX = facing == Direction.UP ? -90.0f : 0.0f;
        }
        model.func_78088_a((Entity)null, skullRotation, rotX, 0.0f, 0.0f, 0.0f, 0.0625f);
        GlStateManager.popMatrix();
        if (destroyStage >= 0) {
            GlStateManager.matrixMode((int)5890);
            GlStateManager.popMatrix();
            GlStateManager.matrixMode((int)5888);
        }
    }

    private static void translateHead(float x, float y, float z, Direction face, float yOffset) {
        if (face == null) {
            GlStateManager.translatef((float)(x + 0.5f), (float)(y + 0.25f + yOffset + 0.3f), (float)(z + 1.0f));
            return;
        }
        switch (face) {
            case NORTH: {
                GlStateManager.translatef((float)(x + 0.5f), (float)(y + 0.25f + yOffset + 0.3f), (float)(z + 1.0f));
                break;
            }
            case EAST: {
                GlStateManager.translatef((float)x, (float)(y + 0.25f + yOffset + 0.3f), (float)(z + 0.5f));
                break;
            }
            case SOUTH: {
                GlStateManager.translatef((float)(x + 0.5f), (float)(y + 0.25f + yOffset + 0.3f), (float)(z + 0.26f - 0.25f));
                break;
            }
            case WEST: {
                GlStateManager.translatef((float)(x + 0.74f + 0.25f), (float)(y + 0.25f + yOffset + 0.3f), (float)(z + 0.5f));
                break;
            }
            case UP: {
                GlStateManager.translatef((float)(x + 0.74f - 0.25f), (float)(y + 0.18f + yOffset), (float)(z + 0.5f));
                break;
            }
            default: {
                GlStateManager.translatef((float)(x + 0.26f - 0.25f), (float)(y + 0.25f + yOffset + 0.3f), (float)(z + 0.5f));
            }
        }
    }
}

