/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading.moddiscovery;

import cpw.mods.modlauncher.api.LamdbaExceptionUtils;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.LogMarkers;
import net.minecraftforge.fml.loading.ModDirTransformerDiscoverer;
import net.minecraftforge.fml.loading.StringUtils;
import net.minecraftforge.fml.loading.moddiscovery.AbstractJarFileLocator;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.forgespi.locating.IModFile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModsFolderLocator
extends AbstractJarFileLocator {
    private static final String SUFFIX = ".jar";
    private static final Logger LOGGER = LogManager.getLogger();
    private final Path modFolder;

    public ModsFolderLocator() {
        this(FMLPaths.MODSDIR.get());
    }

    ModsFolderLocator(Path modFolder) {
        this.modFolder = modFolder;
    }

    public List<IModFile> scanMods() {
        LOGGER.debug(LogMarkers.SCAN, "Scanning mods dir {} for mods", (Object)this.modFolder);
        List<Path> excluded = new ModDirTransformerDiscoverer().candidates(FMLPaths.GAMEDIR.get());
        return ((Stream)LamdbaExceptionUtils.uncheck(() -> Files.list(this.modFolder))).filter(p -> !excluded.contains(p)).sorted(Comparator.comparing(path -> StringUtils.toLowerCase(path.getFileName().toString()))).filter(p -> StringUtils.toLowerCase(p.getFileName().toString()).endsWith(SUFFIX)).map(p -> new ModFile((Path)p, this)).peek(f -> this.modJars.compute(f, (mf, fs) -> this.createFileSystem((IModFile)mf))).collect(Collectors.toList());
    }

    public String name() {
        return "mods folder";
    }

    public String toString() {
        return "{ModJarsFolder locator at " + this.modFolder + "}";
    }

    public void initArguments(Map<String, ?> arguments) {
    }
}

