/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.datafixers;

import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.DynamicLike;
import com.mojang.datafixers.types.DynamicOps;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;

public final class OptionalDynamic<T>
extends DynamicLike<T> {
    private final Optional<Dynamic<T>> delegate;

    public OptionalDynamic(DynamicOps<T> ops, Optional<Dynamic<T>> delegate) {
        super(ops);
        this.delegate = delegate;
    }

    public Optional<Dynamic<T>> get() {
        return this.delegate;
    }

    public <U> Optional<U> map(Function<? super Dynamic<T>, ? extends U> mapper) {
        return this.delegate.map(mapper);
    }

    public <U> Optional<U> flatMap(Function<? super Dynamic<T>, Optional<U>> mapper) {
        return this.delegate.flatMap(mapper);
    }

    @Override
    public Optional<Number> asNumber() {
        return this.flatMap(DynamicLike::asNumber);
    }

    @Override
    public Optional<String> asString() {
        return this.flatMap(DynamicLike::asString);
    }

    @Override
    public Optional<Stream<Dynamic<T>>> asStreamOpt() {
        return this.flatMap(DynamicLike::asStreamOpt);
    }

    @Override
    public Optional<ByteBuffer> asByteBufferOpt() {
        return this.flatMap(DynamicLike::asByteBufferOpt);
    }

    @Override
    public Optional<IntStream> asIntStreamOpt() {
        return this.flatMap(DynamicLike::asIntStreamOpt);
    }

    @Override
    public Optional<LongStream> asLongStreamOpt() {
        return this.flatMap(DynamicLike::asLongStreamOpt);
    }

    @Override
    public OptionalDynamic<T> get(String key) {
        return new OptionalDynamic<T>(this.ops, this.flatMap(k -> k.get(key).get()));
    }

    @Override
    public Optional<T> getGeneric(T key) {
        return this.flatMap(v -> v.getGeneric(key));
    }

    @Override
    public Optional<T> getElement(String key) {
        return this.flatMap(v -> v.getElement(key));
    }

    @Override
    public Optional<T> getElementGeneric(T key) {
        return this.flatMap(v -> v.getElementGeneric(key));
    }

    @Override
    public <U> Optional<List<U>> asListOpt(Function<Dynamic<T>, U> deserializer) {
        return this.flatMap(t -> t.asListOpt(deserializer));
    }

    @Override
    public <K, V> Optional<Map<K, V>> asMapOpt(Function<Dynamic<T>, K> keyDeserializer, Function<Dynamic<T>, V> valueDeserializer) {
        return this.flatMap(input -> input.asMapOpt(keyDeserializer, valueDeserializer));
    }

    public Dynamic<T> orElseEmptyMap() {
        return this.delegate.orElseGet(this::emptyMap);
    }

    public Dynamic<T> orElseEmptyList() {
        return this.delegate.orElseGet(this::emptyList);
    }
}

