/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.items.wrapper;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.EntityArmorInvWrapper;
import net.minecraftforge.items.wrapper.EntityHandsInvWrapper;

public abstract class EntityEquipmentInvWrapper
implements IItemHandlerModifiable {
    protected final LivingEntity entity;
    protected final List<EquipmentSlotType> slots;

    public EntityEquipmentInvWrapper(LivingEntity entity, EquipmentSlotType.Group slotType) {
        this.entity = entity;
        ArrayList<EquipmentSlotType> slots = new ArrayList<EquipmentSlotType>();
        for (EquipmentSlotType slot : EquipmentSlotType.values()) {
            if (slot.func_188453_a() != slotType) continue;
            slots.add(slot);
        }
        this.slots = ImmutableList.copyOf(slots);
    }

    @Override
    public int getSlots() {
        return this.slots.size();
    }

    @Override
    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return this.entity.func_184582_a(this.validateSlotIndex(slot));
    }

    @Override
    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        EquipmentSlotType equipmentSlot = this.validateSlotIndex(slot);
        ItemStack existing = this.entity.func_184582_a(equipmentSlot);
        int limit = this.getStackLimit(slot, stack);
        if (!existing.func_190926_b()) {
            if (!ItemHandlerHelper.canItemStacksStack(stack, existing)) {
                return stack;
            }
            limit -= existing.func_190916_E();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.func_190916_E() > limit;
        if (!simulate) {
            if (existing.func_190926_b()) {
                this.entity.func_184201_a(equipmentSlot, reachedLimit ? ItemHandlerHelper.copyStackWithSize(stack, limit) : stack);
            } else {
                existing.func_190917_f(reachedLimit ? limit : stack.func_190916_E());
            }
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize(stack, stack.func_190916_E() - limit) : ItemStack.field_190927_a;
    }

    @Override
    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.field_190927_a;
        }
        EquipmentSlotType equipmentSlot = this.validateSlotIndex(slot);
        ItemStack existing = this.entity.func_184582_a(equipmentSlot);
        if (existing.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        int toExtract = Math.min(amount, existing.func_77976_d());
        if (existing.func_190916_E() <= toExtract) {
            if (!simulate) {
                this.entity.func_184201_a(equipmentSlot, ItemStack.field_190927_a);
            }
            return existing;
        }
        if (!simulate) {
            this.entity.func_184201_a(equipmentSlot, ItemHandlerHelper.copyStackWithSize(existing, existing.func_190916_E() - toExtract));
        }
        return ItemHandlerHelper.copyStackWithSize(existing, toExtract);
    }

    @Override
    public int getSlotLimit(int slot) {
        EquipmentSlotType equipmentSlot = this.validateSlotIndex(slot);
        return equipmentSlot.func_188453_a() == EquipmentSlotType.Group.ARMOR ? 1 : 64;
    }

    protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
        return Math.min(this.getSlotLimit(slot), stack.func_77976_d());
    }

    @Override
    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        EquipmentSlotType equipmentSlot = this.validateSlotIndex(slot);
        if (ItemStack.func_77989_b((ItemStack)this.entity.func_184582_a(equipmentSlot), (ItemStack)stack)) {
            return;
        }
        this.entity.func_184201_a(equipmentSlot, stack);
    }

    @Override
    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return true;
    }

    protected EquipmentSlotType validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.slots.size()) {
            throw new IllegalArgumentException("Slot " + slot + " not in valid range - [0," + this.slots.size() + ")");
        }
        return this.slots.get(slot);
    }

    public static LazyOptional<IItemHandlerModifiable>[] create(LivingEntity entity) {
        LazyOptional[] ret;
        ret = new LazyOptional[]{LazyOptional.of(() -> new EntityHandsInvWrapper(entity)), LazyOptional.of(() -> new EntityArmorInvWrapper(entity)), LazyOptional.of(() -> new CombinedInvWrapper(ret[0].orElse(null), ret[1].orElse(null)))};
        return ret;
    }
}

