/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.util;

import java.lang.ref.WeakReference;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockSnapshot {
    private static final boolean DEBUG = Boolean.parseBoolean(System.getProperty("forge.debugBlockSnapshot", "false"));
    private final BlockPos pos;
    private final int dimId;
    @Nullable
    private BlockState replacedBlock;
    private int flag;
    @Nullable
    private final CompoundNBT nbt;
    @Nullable
    private WeakReference<IWorld> world;
    private final ResourceLocation registryName;
    private final int meta = 0;

    public BlockSnapshot(IWorld world, BlockPos pos, BlockState state) {
        this(world, pos, state, BlockSnapshot.getTileNBT(world.func_175625_s(pos)));
    }

    public BlockSnapshot(IWorld world, BlockPos pos, BlockState state, @Nullable CompoundNBT nbt) {
        this.setWorld(world);
        this.dimId = world.func_201675_m().func_186058_p().func_186068_a();
        this.pos = pos.func_185334_h();
        this.setReplacedBlock(state);
        this.registryName = state.func_177230_c().getRegistryName();
        this.setFlag(3);
        this.nbt = nbt;
        if (DEBUG) {
            System.out.printf("Created BlockSnapshot - [World: %s ][Location: %d,%d,%d ][Block: %s ][Meta: %d ]", world.func_72912_H().func_76065_j(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), this.getRegistryName(), this.getMeta());
        }
    }

    public BlockSnapshot(IWorld world, BlockPos pos, BlockState state, int flag) {
        this(world, pos, state);
        this.setFlag(flag);
    }

    public BlockSnapshot(int dimension, BlockPos pos, ResourceLocation registryName, int meta, int flag, @Nullable CompoundNBT nbt) {
        this.dimId = dimension;
        this.pos = pos.func_185334_h();
        this.setFlag(flag);
        this.registryName = registryName;
        this.nbt = nbt;
    }

    public static BlockSnapshot getBlockSnapshot(IWorld world, BlockPos pos) {
        return new BlockSnapshot(world, pos, world.func_180495_p(pos));
    }

    public static BlockSnapshot getBlockSnapshot(IWorld world, BlockPos pos, int flag) {
        return new BlockSnapshot(world, pos, world.func_180495_p(pos), flag);
    }

    public static BlockSnapshot readFromNBT(CompoundNBT tag) {
        return new BlockSnapshot(tag.func_74762_e("dimension"), new BlockPos(tag.func_74762_e("posX"), tag.func_74762_e("posY"), tag.func_74762_e("posZ")), new ResourceLocation(tag.func_74779_i("blockMod"), tag.func_74779_i("blockName")), tag.func_74762_e("metadata"), tag.func_74762_e("flag"), tag.func_74767_n("hasTE") ? tag.func_74775_l("tileEntity") : null);
    }

    @Nullable
    private static CompoundNBT getTileNBT(@Nullable TileEntity te) {
        if (te == null) {
            return null;
        }
        CompoundNBT nbt = new CompoundNBT();
        te.func_189515_b(nbt);
        return nbt;
    }

    public BlockState getCurrentBlock() {
        return this.getWorld().func_180495_p(this.getPos());
    }

    public IWorld getWorld() {
        IWorld world;
        IWorld iWorld = world = this.world != null ? (IWorld)this.world.get() : null;
        if (world == null) {
            world = ServerLifecycleHooks.getCurrentServer().func_71218_a(DimensionType.func_186069_a((int)this.getDimId()));
            this.world = new WeakReference<IWorld>(world);
        }
        return world;
    }

    public BlockState getReplacedBlock() {
        if (this.replacedBlock == null) {
            ForgeRegistries.BLOCKS.getValue(this.getRegistryName());
            this.replacedBlock = Block.func_196257_b((int)this.getMeta());
        }
        return this.replacedBlock;
    }

    @Nullable
    public TileEntity getTileEntity() {
        return this.getNbt() != null ? TileEntity.func_203403_c((CompoundNBT)this.getNbt()) : null;
    }

    public boolean restore() {
        return this.restore(false);
    }

    public boolean restore(boolean force) {
        return this.restore(force, true);
    }

    public boolean restore(boolean force, boolean notifyNeighbors) {
        return this.restoreToLocation(this.getWorld(), this.getPos(), force, notifyNeighbors);
    }

    public boolean restoreToLocation(IWorld world, BlockPos pos, boolean force, boolean notifyNeighbors) {
        int flags;
        BlockState current = this.getCurrentBlock();
        BlockState replaced = this.getReplacedBlock();
        int n = flags = notifyNeighbors ? 3 : 2;
        if (current != replaced) {
            if (force) {
                world.func_180501_a(pos, replaced, flags);
            } else {
                return false;
            }
        }
        world.func_180501_a(pos, replaced, flags);
        if (world instanceof World) {
            ((World)world).func_184138_a(pos, current, replaced, flags);
        }
        TileEntity te = null;
        if (this.getNbt() != null && (te = world.func_175625_s(pos)) != null) {
            te.func_145839_a(this.getNbt());
            te.func_70296_d();
        }
        if (DEBUG) {
            System.out.printf("Restored BlockSnapshot with data [World: %s ][Location: %d,%d,%d ][State: %s ][Block: %s ][TileEntity: %s ][force: %s ][notifyNeighbors: %s]", world.func_72912_H().func_76065_j(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), replaced, replaced.func_177230_c().delegate.name(), te, force, notifyNeighbors);
        }
        return true;
    }

    public void writeToNBT(CompoundNBT compound) {
        compound.func_74778_a("blockMod", this.getRegistryName().func_110624_b());
        compound.func_74778_a("blockName", this.getRegistryName().func_110623_a());
        compound.func_74768_a("posX", this.getPos().func_177958_n());
        compound.func_74768_a("posY", this.getPos().func_177956_o());
        compound.func_74768_a("posZ", this.getPos().func_177952_p());
        compound.func_74768_a("flag", this.getFlag());
        compound.func_74768_a("dimension", this.getDimId());
        compound.func_74768_a("metadata", this.getMeta());
        compound.func_74757_a("hasTE", this.getNbt() != null);
        if (this.getNbt() != null) {
            compound.func_218657_a("tileEntity", (INBT)this.getNbt());
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BlockSnapshot other = (BlockSnapshot)obj;
        return this.getMeta() == other.getMeta() && this.getDimId() == other.getDimId() && this.getPos().equals((Object)other.getPos()) && this.getRegistryName().equals((Object)other.getRegistryName()) && Objects.equals(this.getNbt(), other.getNbt());
    }

    public int hashCode() {
        int hash = 7;
        hash = 73 * hash + this.getMeta();
        hash = 73 * hash + this.getDimId();
        hash = 73 * hash + this.getPos().hashCode();
        hash = 73 * hash + this.getRegistryName().hashCode();
        hash = 73 * hash + Objects.hashCode(this.getNbt());
        return hash;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public int getDimId() {
        return this.dimId;
    }

    public void setReplacedBlock(BlockState replacedBlock) {
        this.replacedBlock = replacedBlock;
    }

    public int getFlag() {
        return this.flag;
    }

    public void setFlag(int flag) {
        this.flag = flag;
    }

    @Nullable
    public CompoundNBT getNbt() {
        return this.nbt;
    }

    public void setWorld(IWorld world) {
        this.world = new WeakReference<IWorld>(world);
    }

    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    public int getMeta() {
        return 0;
    }
}

