/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.model.BlockModelDefinition;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.client.renderer.model.Variant;
import net.minecraft.client.renderer.model.VariantList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ForgeBlockStateV1;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.MultiModel;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BlockStateLoader {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(ForgeBlockStateV1.class, (Object)ForgeBlockStateV1.Deserializer.INSTANCE).registerTypeAdapter(ForgeBlockStateV1.Variant.class, (Object)ForgeBlockStateV1.Variant.Deserializer.INSTANCE).registerTypeAdapter(TRSRTransformation.class, (Object)ForgeBlockStateV1.TRSRDeserializer.INSTANCE).create();
    private static final Logger LOGGER = LogManager.getLogger();
    private static long internalGeneratedModelId = 1L;

    public static BlockModelDefinition load(Reader reader, ResourceLocation location, Gson vanillaGSON, ModelBakery bakery, BiConsumer<ResourceLocation, IUnbakedModel> modelConsumer) {
        try {
            byte[] data = IOUtils.toByteArray((Reader)reader, (Charset)StandardCharsets.UTF_8);
            reader = new InputStreamReader((InputStream)new ByteArrayInputStream(data), StandardCharsets.UTF_8);
            Marker marker = (Marker)GSON.fromJson(new String(data, StandardCharsets.UTF_8), Marker.class);
            switch (marker.forge_marker) {
                case 1: {
                    ForgeBlockStateV1 v1 = (ForgeBlockStateV1)GSON.fromJson(reader, ForgeBlockStateV1.class);
                    LinkedHashMap variants = Maps.newLinkedHashMap();
                    for (Map.Entry entry : v1.variants.asMap().entrySet()) {
                        ArrayList mcVars = Lists.newArrayList();
                        for (ForgeBlockStateV1.Variant var : (Collection)entry.getValue()) {
                            boolean uvLock = var.getUvLock().orElse(false);
                            int weight = var.getWeight().orElse(1);
                            ResourceLocation modelLocation = var.getModel();
                            if (!var.isVanillaCompatible() && bakery != null) {
                                modelLocation = new ResourceLocation("internal", String.format("%d/%s/%s/%s", internalGeneratedModelId++, location.func_110624_b(), location.func_110623_a(), ((String)entry.getKey()).replace("=", "_").replace(",", "_")));
                                IUnbakedModel model = ForgeVariantHelper.prepareInjectedModel((ModelLoader)bakery, modelLocation, var.getModel(), var.getSmooth(), var.getGui3d(), var.getTextures(), var.getOnlyPartsVariant(), var.getCustomData());
                                modelConsumer.accept(modelLocation, model);
                            }
                            mcVars.add(new ForgeVariant(modelLocation, var.getState().orElse((IModelState)ModelRotation.X0_Y0), uvLock, weight));
                        }
                        variants.put(entry.getKey(), new VariantList((List)mcVars));
                    }
                    return new BlockModelDefinition((Map)variants, null);
                }
            }
            return (BlockModelDefinition)vanillaGSON.fromJson(reader, BlockModelDefinition.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static class ForgeVariantHelper {
        private ForgeVariantHelper() {
        }

        public static IUnbakedModel prepareInjectedModel(ModelLoader bakery, ResourceLocation blockstateLocation, @Nullable ResourceLocation modelLocation, Optional<Boolean> smooth, Optional<Boolean> gui3d, ImmutableMap<String, String> textures, ImmutableMap<String, SubModel> parts, ImmutableMap<String, String> customData) {
            int size = parts.size();
            IUnbakedModel base = null;
            if (modelLocation != null) {
                try {
                    base = ModelLoaderRegistry.getModel(modelLocation);
                    if (base != null) {
                        base = (IUnbakedModel)base.process(customData);
                        base = (IUnbakedModel)base.retexture(textures);
                        base = smooth.map(arg_0 -> base.smoothLighting(arg_0)).orElse(base);
                        base = gui3d.map(arg_0 -> base.gui3d(arg_0)).orElse(base);
                        if (size <= 0) {
                            return base;
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Error processing base model for forge blockstates pseudo-model: '" + blockstateLocation, (Throwable)e);
                }
            }
            ImmutableMap.Builder models = ImmutableMap.builder();
            for (Map.Entry entry : parts.entrySet()) {
                IUnbakedModel model;
                SubModel part = (SubModel)entry.getValue();
                ResourceLocation location = part.getModelLocation();
                if (location == null) {
                    LOGGER.error("model not found for variant {} for blockstate {}", entry.getKey(), (Object)blockstateLocation);
                    model = ModelLoaderRegistry.getMissingModel(blockstateLocation, new Throwable());
                } else {
                    model = ModelLoaderRegistry.getModelOrLogError(location, "Unable to load block sub-model '" + (String)entry.getKey() + "': '" + location + "'");
                }
                IUnbakedModel base1 = model;
                base1 = (IUnbakedModel)base1.process(part.getCustomData());
                base1 = (IUnbakedModel)base1.retexture(part.getTextures());
                base1 = Optional.of(part.smooth).map(arg_0 -> base1.smoothLighting(arg_0)).orElse(base1);
                base1 = Optional.of(part.gui3d).map(arg_0 -> base1.gui3d(arg_0)).orElse(base1);
                models.put(entry.getKey(), (Object)Pair.of((Object)base1, (Object)part.getState()));
            }
            return new MultiModel(modelLocation, base, (ImmutableMap<String, Pair<IUnbakedModel, IModelState>>)models.build());
        }
    }

    private static class ForgeVariant
    extends Variant {
        private final IModelState state;

        ForgeVariant(ResourceLocation model, IModelState state, boolean uvLock, int weight) {
            super(model, state instanceof ModelRotation ? (ModelRotation)state : ModelRotation.X0_Y0, uvLock, weight);
            this.state = state;
        }

        public IModelState getState() {
            return this.state;
        }

        public String toString() {
            return "Forge" + super.toString();
        }
    }

    public static class SubModel {
        private final IModelState state;
        private final boolean uvLock;
        private final boolean smooth;
        private final boolean gui3d;
        private final ImmutableMap<String, String> textures;
        @Nullable
        private final ResourceLocation model;
        private final ImmutableMap<String, String> customData;

        public SubModel(IModelState state, boolean uvLock, boolean smooth, boolean gui3d, ImmutableMap<String, String> textures, @Nullable ResourceLocation model, ImmutableMap<String, String> customData) {
            this.state = state;
            this.uvLock = uvLock;
            this.smooth = smooth;
            this.gui3d = gui3d;
            this.textures = textures;
            this.model = model;
            this.customData = customData;
        }

        public IModelState getState() {
            return this.state;
        }

        public boolean isUVLock() {
            return this.uvLock;
        }

        public ImmutableMap<String, String> getTextures() {
            return this.textures;
        }

        @Nullable
        public ResourceLocation getModelLocation() {
            return this.model;
        }

        public ImmutableMap<String, String> getCustomData() {
            return this.customData;
        }
    }

    public static class Marker {
        public int forge_marker = -1;
    }
}

