/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.specialsource;

import java.beans.ConstructorProperties;
import net.md_5.specialsource.SpecialSource;

public class ProgressMeter {
    private int progress;
    private int lastPrint = -1;
    private final int total;
    private final String progressFormat;
    public static double printInterval;

    public void makeProgress() {
        if (!SpecialSource.verbose()) {
            return;
        }
        ++this.progress;
        double percent = (double)this.progress / (double)this.total * 100.0;
        int currentInterval = (int)Math.floor(percent / printInterval);
        if (this.lastPrint < 0 || currentInterval > this.lastPrint) {
            System.out.println(String.format(this.progressFormat, percent));
            this.lastPrint = currentInterval;
        }
    }

    public static void main(String[] args) {
        ProgressMeter meter = new ProgressMeter(1000, "Loading %2.0f%%");
        for (int i = 0; i < 1000; ++i) {
            meter.makeProgress();
        }
    }

    @ConstructorProperties(value={"total", "progressFormat"})
    public ProgressMeter(int total, String progressFormat) {
        this.total = total;
        this.progressFormat = progressFormat;
    }

    public int getProgress() {
        return this.progress;
    }

    public int getLastPrint() {
        return this.lastPrint;
    }

    public int getTotal() {
        return this.total;
    }

    public String getProgressFormat() {
        return this.progressFormat;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    public void setLastPrint(int lastPrint) {
        this.lastPrint = lastPrint;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProgressMeter)) {
            return false;
        }
        ProgressMeter other = (ProgressMeter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getProgress() != other.getProgress()) {
            return false;
        }
        if (this.getLastPrint() != other.getLastPrint()) {
            return false;
        }
        if (this.getTotal() != other.getTotal()) {
            return false;
        }
        String this$progressFormat = this.getProgressFormat();
        String other$progressFormat = other.getProgressFormat();
        return !(this$progressFormat == null ? other$progressFormat != null : !this$progressFormat.equals(other$progressFormat));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProgressMeter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getProgress();
        result = result * 59 + this.getLastPrint();
        result = result * 59 + this.getTotal();
        String $progressFormat = this.getProgressFormat();
        result = result * 59 + ($progressFormat == null ? 43 : $progressFormat.hashCode());
        return result;
    }

    public String toString() {
        return "ProgressMeter(progress=" + this.getProgress() + ", lastPrint=" + this.getLastPrint() + ", total=" + this.getTotal() + ", progressFormat=" + this.getProgressFormat() + ")";
    }
}

