/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.eventbus.api;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.minecraftforge.eventbus.ListenerList;
import net.minecraftforge.eventbus.api.Event;

public class EventListenerHelper {
    private static final Map<Class<?>, ListenerList> listeners = new IdentityHashMap();
    private static ReadWriteLock lock = new ReentrantReadWriteLock(true);

    public static ListenerList getListenerList(Class<?> eventClass) {
        return EventListenerHelper.getListenerListInternal(eventClass, false);
    }

    static ListenerList getListenerListInternal(Class<?> eventClass, boolean fromInstanceCall) {
        Lock readLock = lock.readLock();
        readLock.lock();
        ListenerList listenerList = listeners.get(eventClass);
        readLock.unlock();
        if (listenerList == null) {
            listenerList = EventListenerHelper.computeListenerList(eventClass, fromInstanceCall);
            Lock writeLock = lock.writeLock();
            writeLock.lock();
            readLock.lock();
            listeners.putIfAbsent(eventClass, listenerList);
            listenerList = listeners.get(eventClass);
            readLock.unlock();
            writeLock.unlock();
        }
        return listenerList;
    }

    private static ListenerList computeListenerList(Class<?> eventClass, boolean fromInstanceCall) {
        if (eventClass == Event.class) {
            return new ListenerList();
        }
        if (fromInstanceCall || Modifier.isAbstract(eventClass.getModifiers())) {
            Class<?> superclass = eventClass.getSuperclass();
            ListenerList parentList = EventListenerHelper.getListenerList(superclass);
            return new ListenerList(parentList);
        }
        try {
            Constructor<?> ctr = eventClass.getConstructor(new Class[0]);
            ctr.setAccessible(true);
            Event event = (Event)ctr.newInstance(new Object[0]);
            return event.getListenerList();
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Error computing listener list for " + eventClass.getName(), e);
        }
    }

    private static void clearAll() {
        listeners.clear();
        lock = new ReentrantReadWriteLock(true);
    }
}

