/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.dimension;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import com.mojang.datafixers.types.JsonOps;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.biome.provider.BiomeProviderType;
import net.minecraft.world.biome.provider.CheckerboardBiomeProvider;
import net.minecraft.world.biome.provider.CheckerboardBiomeProviderSettings;
import net.minecraft.world.biome.provider.OverworldBiomeProvider;
import net.minecraft.world.biome.provider.OverworldBiomeProviderSettings;
import net.minecraft.world.biome.provider.SingleBiomeProvider;
import net.minecraft.world.biome.provider.SingleBiomeProviderSettings;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.ChunkGeneratorType;
import net.minecraft.world.gen.DebugChunkGenerator;
import net.minecraft.world.gen.DebugGenerationSettings;
import net.minecraft.world.gen.EndChunkGenerator;
import net.minecraft.world.gen.EndGenerationSettings;
import net.minecraft.world.gen.FlatChunkGenerator;
import net.minecraft.world.gen.FlatGenerationSettings;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.NetherChunkGenerator;
import net.minecraft.world.gen.NetherGenSettings;
import net.minecraft.world.gen.OverworldChunkGenerator;
import net.minecraft.world.gen.OverworldGenSettings;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class OverworldDimension
extends Dimension {
    public OverworldDimension(World worldIn, DimensionType typeIn) {
        super(worldIn, typeIn);
    }

    public ChunkGenerator<? extends GenerationSettings> func_186060_c() {
        WorldType worldtype = this.field_76579_a.func_72912_H().func_76067_t();
        ChunkGeneratorType<FlatGenerationSettings, FlatChunkGenerator> chunkgeneratortype = ChunkGeneratorType.field_205489_f;
        ChunkGeneratorType<DebugGenerationSettings, DebugChunkGenerator> chunkgeneratortype1 = ChunkGeneratorType.field_205488_e;
        ChunkGeneratorType<NetherGenSettings, NetherChunkGenerator> chunkgeneratortype2 = ChunkGeneratorType.field_206912_c;
        ChunkGeneratorType<EndGenerationSettings, EndChunkGenerator> chunkgeneratortype3 = ChunkGeneratorType.field_206913_d;
        ChunkGeneratorType<OverworldGenSettings, OverworldChunkGenerator> chunkgeneratortype4 = ChunkGeneratorType.field_206911_b;
        BiomeProviderType<SingleBiomeProviderSettings, SingleBiomeProvider> biomeprovidertype = BiomeProviderType.field_205461_c;
        BiomeProviderType<OverworldBiomeProviderSettings, OverworldBiomeProvider> biomeprovidertype1 = BiomeProviderType.field_206859_d;
        BiomeProviderType<CheckerboardBiomeProviderSettings, CheckerboardBiomeProvider> biomeprovidertype2 = BiomeProviderType.field_205460_b;
        if (worldtype == WorldType.field_77138_c) {
            FlatGenerationSettings flatgenerationsettings = FlatGenerationSettings.func_210835_a((Dynamic)new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, (Object)this.field_76579_a.func_72912_H().func_211027_A()));
            SingleBiomeProviderSettings singlebiomeprovidersettings1 = biomeprovidertype.func_205458_a().func_205436_a(flatgenerationsettings.func_82648_a());
            return chunkgeneratortype.create(this.field_76579_a, (BiomeProvider)biomeprovidertype.func_205457_a(singlebiomeprovidersettings1), flatgenerationsettings);
        }
        if (worldtype == WorldType.field_180272_g) {
            SingleBiomeProviderSettings singlebiomeprovidersettings = biomeprovidertype.func_205458_a().func_205436_a(Biomes.field_76772_c);
            return chunkgeneratortype1.create(this.field_76579_a, (BiomeProvider)biomeprovidertype.func_205457_a(singlebiomeprovidersettings), chunkgeneratortype1.func_205483_a());
        }
        if (worldtype != WorldType.field_205394_h) {
            OverworldGenSettings overworldgensettings = chunkgeneratortype4.func_205483_a();
            OverworldBiomeProviderSettings overworldbiomeprovidersettings = biomeprovidertype1.func_205458_a().func_205439_a(this.field_76579_a.func_72912_H()).func_205441_a(overworldgensettings);
            return chunkgeneratortype4.create(this.field_76579_a, (BiomeProvider)biomeprovidertype1.func_205457_a(overworldbiomeprovidersettings), overworldgensettings);
        }
        SingleBiomeProvider biomeprovider = null;
        JsonElement jsonelement = (JsonElement)Dynamic.convert((DynamicOps)NBTDynamicOps.field_210820_a, (DynamicOps)JsonOps.INSTANCE, (Object)this.field_76579_a.func_72912_H().func_211027_A());
        JsonObject jsonobject = jsonelement.getAsJsonObject();
        JsonObject jsonobject1 = jsonobject.getAsJsonObject("biome_source");
        if (jsonobject1 != null && jsonobject1.has("type") && jsonobject1.has("options")) {
            BiomeProviderType<?, ?> biomeprovidertype3 = Registry.field_212625_n.func_82594_a(new ResourceLocation(jsonobject1.getAsJsonPrimitive("type").getAsString()));
            JsonObject jsonobject2 = jsonobject1.getAsJsonObject("options");
            Biome[] abiome = new Biome[]{Biomes.field_76771_b};
            if (jsonobject2.has("biomes")) {
                Biome[] biomeArray;
                JsonArray jsonarray = jsonobject2.getAsJsonArray("biomes");
                if (jsonarray.size() > 0) {
                    biomeArray = new Biome[jsonarray.size()];
                } else {
                    Biome[] biomeArray2 = new Biome[1];
                    biomeArray = biomeArray2;
                    biomeArray2[0] = Biomes.field_76771_b;
                }
                abiome = biomeArray;
                for (int i = 0; i < jsonarray.size(); ++i) {
                    abiome[i] = Registry.field_212624_m.func_218349_b(new ResourceLocation(jsonarray.get(i).getAsString())).orElse(Biomes.field_76771_b);
                }
            }
            if (BiomeProviderType.field_205461_c == biomeprovidertype3) {
                SingleBiomeProviderSettings singlebiomeprovidersettings2 = biomeprovidertype.func_205458_a().func_205436_a(abiome[0]);
                biomeprovider = biomeprovidertype.func_205457_a(singlebiomeprovidersettings2);
            }
            if (BiomeProviderType.field_205460_b == biomeprovidertype3) {
                int j = jsonobject2.has("size") ? jsonobject2.getAsJsonPrimitive("size").getAsInt() : 2;
                CheckerboardBiomeProviderSettings checkerboardbiomeprovidersettings = biomeprovidertype2.func_205458_a().func_206860_a(abiome).func_206861_a(j);
                biomeprovider = biomeprovidertype2.func_205457_a(checkerboardbiomeprovidersettings);
            }
            if (BiomeProviderType.field_206859_d == biomeprovidertype3) {
                OverworldBiomeProviderSettings overworldbiomeprovidersettings1 = biomeprovidertype1.func_205458_a().func_205441_a(new OverworldGenSettings()).func_205439_a(this.field_76579_a.func_72912_H());
                biomeprovider = biomeprovidertype1.func_205457_a(overworldbiomeprovidersettings1);
            }
        }
        if (biomeprovider == null) {
            biomeprovider = biomeprovidertype.func_205457_a(biomeprovidertype.func_205458_a().func_205436_a(Biomes.field_76771_b));
        }
        BlockState blockstate = Blocks.field_150348_b.func_176223_P();
        BlockState blockstate1 = Blocks.field_150355_j.func_176223_P();
        JsonObject jsonobject3 = jsonobject.getAsJsonObject("chunk_generator");
        if (jsonobject3 != null && jsonobject3.has("options")) {
            JsonObject jsonobject4 = jsonobject3.getAsJsonObject("options");
            if (jsonobject4.has("default_block")) {
                String s = jsonobject4.getAsJsonPrimitive("default_block").getAsString();
                blockstate = ((Block)((Object)Registry.field_212618_g.func_82594_a(new ResourceLocation(s)))).func_176223_P();
            }
            if (jsonobject4.has("default_fluid")) {
                String s1 = jsonobject4.getAsJsonPrimitive("default_fluid").getAsString();
                blockstate1 = ((Block)((Object)Registry.field_212618_g.func_82594_a(new ResourceLocation(s1)))).func_176223_P();
            }
        }
        if (jsonobject3 != null && jsonobject3.has("type")) {
            ChunkGeneratorType<?, ?> chunkgeneratortype5 = Registry.field_212627_p.func_82594_a(new ResourceLocation(jsonobject3.getAsJsonPrimitive("type").getAsString()));
            if (ChunkGeneratorType.field_206912_c == chunkgeneratortype5) {
                NetherGenSettings nethergensettings = chunkgeneratortype2.func_205483_a();
                nethergensettings.func_214969_a(blockstate);
                nethergensettings.func_214970_b(blockstate1);
                return chunkgeneratortype2.create(this.field_76579_a, (BiomeProvider)biomeprovider, nethergensettings);
            }
            if (ChunkGeneratorType.field_206913_d == chunkgeneratortype5) {
                EndGenerationSettings endgenerationsettings = chunkgeneratortype3.func_205483_a();
                endgenerationsettings.func_205538_a(new BlockPos(0, 64, 0));
                endgenerationsettings.func_214969_a(blockstate);
                endgenerationsettings.func_214970_b(blockstate1);
                return chunkgeneratortype3.create(this.field_76579_a, (BiomeProvider)biomeprovider, endgenerationsettings);
            }
        }
        OverworldGenSettings overworldgensettings1 = chunkgeneratortype4.func_205483_a();
        overworldgensettings1.func_214969_a(blockstate);
        overworldgensettings1.func_214970_b(blockstate1);
        return chunkgeneratortype4.create(this.field_76579_a, (BiomeProvider)biomeprovider, overworldgensettings1);
    }

    @Override
    @Nullable
    public BlockPos func_206920_a(ChunkPos chunkPosIn, boolean checkValid) {
        for (int i = chunkPosIn.func_180334_c(); i <= chunkPosIn.func_180332_e(); ++i) {
            for (int j = chunkPosIn.func_180333_d(); j <= chunkPosIn.func_180330_f(); ++j) {
                BlockPos blockpos = this.func_206921_a(i, j, checkValid);
                if (blockpos == null) continue;
                return blockpos;
            }
        }
        return null;
    }

    @Override
    @Nullable
    public BlockPos func_206921_a(int posX, int posZ, boolean checkValid) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(posX, 0, posZ);
        Biome biome = this.field_76579_a.func_180494_b((BlockPos)blockpos$mutableblockpos);
        BlockState blockstate = biome.func_203944_q().func_204108_a();
        if (checkValid && !blockstate.func_177230_c().func_203417_a(BlockTags.field_205599_H)) {
            return null;
        }
        Chunk chunk = this.field_76579_a.func_212866_a_(posX >> 4, posZ >> 4);
        int i = chunk.func_201576_a(Heightmap.Type.MOTION_BLOCKING, posX & 0xF, posZ & 0xF);
        if (i < 0) {
            return null;
        }
        if (chunk.func_201576_a(Heightmap.Type.WORLD_SURFACE, posX & 0xF, posZ & 0xF) > chunk.func_201576_a(Heightmap.Type.OCEAN_FLOOR, posX & 0xF, posZ & 0xF)) {
            return null;
        }
        for (int j = i + 1; j >= 0; --j) {
            blockpos$mutableblockpos.func_181079_c(posX, j, posZ);
            BlockState blockstate1 = this.field_76579_a.func_180495_p((BlockPos)blockpos$mutableblockpos);
            if (!blockstate1.func_204520_s().func_206888_e()) break;
            if (!blockstate1.equals((Object)blockstate)) continue;
            return blockpos$mutableblockpos.func_177984_a().func_185334_h();
        }
        return null;
    }

    @Override
    public float func_76563_a(long worldTime, float partialTicks) {
        double d0 = MathHelper.func_181162_h((double)((double)worldTime / 24000.0 - 0.25));
        double d1 = 0.5 - Math.cos(d0 * Math.PI) / 2.0;
        return (float)(d0 * 2.0 + d1) / 3.0f;
    }

    @Override
    public boolean func_76569_d() {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Vec3d func_76562_b(float celestialAngle, float partialTicks) {
        float f = MathHelper.func_76134_b((float)(celestialAngle * ((float)Math.PI * 2))) * 2.0f + 0.5f;
        f = MathHelper.func_76131_a((float)f, (float)0.0f, (float)1.0f);
        float f1 = 0.7529412f;
        float f2 = 0.84705883f;
        float f3 = 1.0f;
        return new Vec3d(f1 *= f * 0.94f + 0.06f, f2 *= f * 0.94f + 0.06f, f3 *= f * 0.91f + 0.09f);
    }

    @Override
    public boolean func_76567_e() {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean func_76568_b(int x, int z) {
        return false;
    }
}

