/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.resources.FolderPack;
import net.minecraft.resources.IResourcePack;
import net.minecraft.resources.ResourcePack;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.resources.data.IMetadataSectionSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VanillaPack
implements IResourcePack {
    public static Path field_199754_a;
    private static final Logger field_195784_b;
    public static Class<?> field_211688_b;
    private static final Map<ResourcePackType, FileSystem> field_217810_e;
    public final Set<String> field_195783_a;

    public VanillaPack(String ... resourceNamespacesIn) {
        this.field_195783_a = ImmutableSet.copyOf((Object[])resourceNamespacesIn);
    }

    @Override
    public InputStream func_195763_b(String fileName) throws IOException {
        if (!fileName.contains("/") && !fileName.contains("\\")) {
            Path path;
            if (field_199754_a != null && Files.exists(path = field_199754_a.resolve(fileName), new LinkOption[0])) {
                return Files.newInputStream(path, new OpenOption[0]);
            }
            return this.func_200010_a(fileName);
        }
        throw new IllegalArgumentException("Root resources can only be filenames, not paths (no / allowed!)");
    }

    @Override
    public InputStream func_195761_a(ResourcePackType type, ResourceLocation location) throws IOException {
        InputStream inputstream = this.func_195782_c(type, location);
        if (inputstream != null) {
            return inputstream;
        }
        throw new FileNotFoundException(location.func_110623_a());
    }

    @Override
    public Collection<ResourceLocation> func_195758_a(ResourcePackType type, String pathIn, int maxDepth, Predicate<String> filter) {
        HashSet set = Sets.newHashSet();
        if (field_199754_a != null) {
            try {
                set.addAll(this.func_195781_a(maxDepth, "minecraft", field_199754_a.resolve(type.func_198956_a()).resolve("minecraft"), pathIn, filter));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (type == ResourcePackType.CLIENT_RESOURCES) {
                Enumeration<URL> enumeration = null;
                try {
                    enumeration = field_211688_b.getClassLoader().getResources(type.func_198956_a() + "/minecraft");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                while (enumeration != null && enumeration.hasMoreElements()) {
                    try {
                        URI uri = ((URL)enumeration.nextElement()).toURI();
                        if (!"file".equals(uri.getScheme())) continue;
                        set.addAll(this.func_195781_a(maxDepth, "minecraft", Paths.get(uri), pathIn, filter));
                    }
                    catch (IOException | URISyntaxException uri) {}
                }
            }
        }
        try {
            URL url1 = VanillaPack.class.getResource("/" + type.func_198956_a() + "/.mcassetsroot");
            if (url1 == null) {
                field_195784_b.error("Couldn't find .mcassetsroot, cannot load vanilla resources");
                return set;
            }
            URI uri1 = url1.toURI();
            if ("file".equals(uri1.getScheme())) {
                URL url = new URL(url1.toString().substring(0, url1.toString().length() - ".mcassetsroot".length()) + "minecraft");
                if (url == null) {
                    return set;
                }
                Path path = Paths.get(url.toURI());
                set.addAll(this.func_195781_a(maxDepth, "minecraft", path, pathIn, filter));
            } else if ("jar".equals(uri1.getScheme())) {
                Path path1 = field_217810_e.get(type).getPath("/" + type.func_198956_a() + "/minecraft", new String[0]);
                set.addAll(this.func_195781_a(maxDepth, "minecraft", path1, pathIn, filter));
            } else {
                field_195784_b.error("Unsupported scheme {} trying to list vanilla resources (NYI?)", (Object)uri1);
            }
        }
        catch (FileNotFoundException | NoSuchFileException url1) {
        }
        catch (IOException | URISyntaxException urisyntaxexception) {
            field_195784_b.error("Couldn't get a list of all vanilla resources", (Throwable)urisyntaxexception);
        }
        return set;
    }

    private Collection<ResourceLocation> func_195781_a(int p_195781_1_, String p_195781_2_, Path p_195781_3_, String p_195781_4_, Predicate<String> p_195781_5_) throws IOException {
        ArrayList list = Lists.newArrayList();
        Iterator iterator = Files.walk(p_195781_3_.resolve(p_195781_4_), p_195781_1_, new FileVisitOption[0]).iterator();
        while (iterator.hasNext()) {
            Path path = (Path)iterator.next();
            if (path.endsWith(".mcmeta") || !Files.isRegularFile(path, new LinkOption[0]) || !p_195781_5_.test(path.getFileName().toString())) continue;
            list.add(new ResourceLocation(p_195781_2_, p_195781_3_.relativize(path).toString().replaceAll("\\\\", "/")));
        }
        return list;
    }

    @Nullable
    protected InputStream func_195782_c(ResourcePackType type, ResourceLocation location) {
        Path path;
        String s = VanillaPack.func_223458_d(type, location);
        if (field_199754_a != null && Files.exists(path = field_199754_a.resolve(type.func_198956_a() + "/" + location.func_110624_b() + "/" + location.func_110623_a()), new LinkOption[0])) {
            try {
                return Files.newInputStream(path, new OpenOption[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            URL url = VanillaPack.class.getResource(s);
            return VanillaPack.func_223459_a(s, url) ? this.getExtraInputStream(type, s) : null;
        }
        catch (IOException var6) {
            return VanillaPack.class.getResourceAsStream(s);
        }
    }

    private static String func_223458_d(ResourcePackType p_223458_0_, ResourceLocation p_223458_1_) {
        return "/" + p_223458_0_.func_198956_a() + "/" + p_223458_1_.func_110624_b() + "/" + p_223458_1_.func_110623_a();
    }

    private static boolean func_223459_a(String p_223459_0_, @Nullable URL p_223459_1_) throws IOException {
        return p_223459_1_ != null && (p_223459_1_.getProtocol().equals("jar") || FolderPack.func_195777_a((File)new File(p_223459_1_.getFile()), (String)p_223459_0_));
    }

    @Nullable
    protected InputStream func_200010_a(String pathIn) {
        return this.getExtraInputStream(ResourcePackType.SERVER_DATA, "/" + pathIn);
    }

    @Override
    public boolean func_195764_b(ResourcePackType type, ResourceLocation location) {
        Path path;
        String s = VanillaPack.func_223458_d(type, location);
        if (field_199754_a != null && Files.exists(path = field_199754_a.resolve(type.func_198956_a() + "/" + location.func_110624_b() + "/" + location.func_110623_a()), new LinkOption[0])) {
            return true;
        }
        try {
            URL url = VanillaPack.class.getResource(s);
            return VanillaPack.func_223459_a(s, url);
        }
        catch (IOException var5) {
            return false;
        }
    }

    @Override
    public Set<String> func_195759_a(ResourcePackType type) {
        return this.field_195783_a;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public <T> T func_195760_a(IMetadataSectionSerializer<T> deserializer) throws IOException {
        try (InputStream inputstream = this.func_195763_b("pack.mcmeta");){
            Object object2;
            Object object = object2 = ResourcePack.func_195770_a(deserializer, (InputStream)inputstream);
            return (T)object;
        }
        catch (FileNotFoundException | RuntimeException var16) {
            return null;
        }
    }

    @Override
    public String func_195762_a() {
        return "Default";
    }

    @Override
    public void close() {
    }

    private InputStream getExtraInputStream(ResourcePackType type, String resource) {
        try {
            FileSystem fs = field_217810_e.get(type);
            if (fs != null) {
                return Files.newInputStream(fs.getPath(resource, new String[0]), new OpenOption[0]);
            }
            return VanillaPack.class.getResourceAsStream(resource);
        }
        catch (IOException e) {
            return VanillaPack.class.getResourceAsStream(resource);
        }
    }

    static {
        field_195784_b = LogManager.getLogger();
        field_217810_e = (Map)Util.func_200696_a((Object)Maps.newHashMap(), p_217809_0_ -> {
            Class<VanillaPack> clazz = VanillaPack.class;
            synchronized (VanillaPack.class) {
                for (ResourcePackType resourcepacktype : ResourcePackType.values()) {
                    URL url = VanillaPack.class.getResource("/" + resourcepacktype.func_198956_a() + "/.mcassetsroot");
                    try {
                        FileSystem filesystem;
                        URI uri = url.toURI();
                        if (!"jar".equals(uri.getScheme())) continue;
                        try {
                            filesystem = FileSystems.getFileSystem(uri);
                        }
                        catch (FileSystemNotFoundException var11) {
                            filesystem = FileSystems.newFileSystem(uri, Collections.emptyMap());
                        }
                        p_217809_0_.put(resourcepacktype, filesystem);
                    }
                    catch (IOException | URISyntaxException urisyntaxexception) {
                        field_195784_b.error("Couldn't get a list of all vanilla resources", (Throwable)urisyntaxexception);
                    }
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        });
    }
}

