/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.model;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.Variant;
import net.minecraft.client.renderer.model.WeightedBakedModel;
import net.minecraft.client.renderer.texture.ISprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class VariantList
implements IUnbakedModel {
    private final List<Variant> field_188115_a;

    public VariantList(List<Variant> variantListIn) {
        this.field_188115_a = variantListIn;
    }

    public List<Variant> func_188114_a() {
        return this.field_188115_a;
    }

    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        if (p_equals_1_ instanceof VariantList) {
            VariantList variantlist = (VariantList)p_equals_1_;
            return this.field_188115_a.equals(variantlist.field_188115_a);
        }
        return false;
    }

    public int hashCode() {
        return this.field_188115_a.hashCode();
    }

    @Override
    public Collection<ResourceLocation> func_187965_e() {
        return this.func_188114_a().stream().map(Variant::func_188046_a).collect(Collectors.toSet());
    }

    @Override
    public Collection<ResourceLocation> func_209559_a(Function<ResourceLocation, IUnbakedModel> modelGetter, Set<String> missingTextureErrors) {
        return this.func_188114_a().stream().map(Variant::func_188046_a).distinct().flatMap(p_209561_2_ -> ((IUnbakedModel)modelGetter.apply((ResourceLocation)p_209561_2_)).func_209559_a(modelGetter, missingTextureErrors).stream()).collect(Collectors.toSet());
    }

    @Nullable
    public IBakedModel bake(ModelBakery p_217641_1_, Function<ResourceLocation, TextureAtlasSprite> p_217641_2_, ISprite p_217641_3_, VertexFormat format) {
        if (this.func_188114_a().isEmpty()) {
            return null;
        }
        WeightedBakedModel.Builder weightedbakedmodel$builder = new WeightedBakedModel.Builder();
        for (Variant variant : this.func_188114_a()) {
            IBakedModel ibakedmodel = p_217641_1_.getBakedModel(variant.func_188046_a(), variant, p_217641_2_, format);
            weightedbakedmodel$builder.func_177677_a(ibakedmodel, variant.func_188047_d());
        }
        return weightedbakedmodel$builder.func_209614_a();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Deserializer
    implements JsonDeserializer<VariantList> {
        public VariantList deserialize(JsonElement p_deserialize_1_, Type p_deserialize_2_, JsonDeserializationContext p_deserialize_3_) throws JsonParseException {
            ArrayList list = Lists.newArrayList();
            if (p_deserialize_1_.isJsonArray()) {
                JsonArray jsonarray = p_deserialize_1_.getAsJsonArray();
                if (jsonarray.size() == 0) {
                    throw new JsonParseException("Empty variant array");
                }
                for (JsonElement jsonelement : jsonarray) {
                    list.add(p_deserialize_3_.deserialize(jsonelement, Variant.class));
                }
            } else {
                list.add(p_deserialize_3_.deserialize(p_deserialize_1_, Variant.class));
            }
            return new VariantList(list);
        }
    }
}

