/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.MapDecoration;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MapItemRenderer
implements AutoCloseable {
    private static final ResourceLocation field_148253_a = new ResourceLocation("textures/map/map_icons.png");
    private final TextureManager field_148251_b;
    private final Map<String, Instance> field_148252_c = Maps.newHashMap();

    public MapItemRenderer(TextureManager textureManagerIn) {
        this.field_148251_b = textureManagerIn;
    }

    public void func_148246_a(MapData mapdataIn) {
        this.func_148248_b(mapdataIn).func_148236_a();
    }

    public void func_148250_a(MapData mapdataIn, boolean noOverlayRendering) {
        this.func_148248_b(mapdataIn).func_148237_a(noOverlayRendering);
    }

    private Instance func_148248_b(MapData mapdataIn) {
        Instance mapitemrenderer$instance = this.field_148252_c.get(mapdataIn.func_195925_e());
        if (mapitemrenderer$instance == null) {
            mapitemrenderer$instance = new Instance(mapdataIn);
            this.field_148252_c.put(mapdataIn.func_195925_e(), mapitemrenderer$instance);
        }
        return mapitemrenderer$instance;
    }

    @Nullable
    public Instance func_191205_a(String p_191205_1_) {
        return this.field_148252_c.get(p_191205_1_);
    }

    public void func_148249_a() {
        for (Instance mapitemrenderer$instance : this.field_148252_c.values()) {
            mapitemrenderer$instance.close();
        }
        this.field_148252_c.clear();
    }

    @Nullable
    public MapData func_191207_a(@Nullable Instance p_191207_1_) {
        return p_191207_1_ != null ? p_191207_1_.field_148242_b : null;
    }

    @Override
    public void close() {
        this.func_148249_a();
    }

    @OnlyIn(value=Dist.CLIENT)
    class Instance
    implements AutoCloseable {
        private final MapData field_148242_b;
        private final DynamicTexture field_148243_c;
        private final ResourceLocation field_148240_d;

        private Instance(MapData mapdataIn) {
            this.field_148242_b = mapdataIn;
            this.field_148243_c = new DynamicTexture(128, 128, true);
            this.field_148240_d = MapItemRenderer.this.field_148251_b.func_110578_a("map/" + mapdataIn.func_195925_e(), this.field_148243_c);
        }

        private void func_148236_a() {
            for (int i = 0; i < 128; ++i) {
                for (int j = 0; j < 128; ++j) {
                    int k = j + i * 128;
                    int l = this.field_148242_b.field_76198_e[k] & 0xFF;
                    if (l / 4 == 0) {
                        this.field_148243_c.func_195414_e().func_195700_a(j, i, (k + k / 128 & 1) * 8 + 16 << 24);
                        continue;
                    }
                    this.field_148243_c.func_195414_e().func_195700_a(j, i, MaterialColor.field_76281_a[l / 4].func_151643_b(l & 3));
                }
            }
            this.field_148243_c.func_110564_a();
        }

        private void func_148237_a(boolean noOverlayRendering) {
            boolean i = false;
            boolean j = false;
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            float f = 0.0f;
            MapItemRenderer.this.field_148251_b.func_110577_a(this.field_148240_d);
            GlStateManager.enableBlend();
            GlStateManager.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            GlStateManager.disableAlphaTest();
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            bufferbuilder.func_181662_b(0.0, 128.0, -0.01f).func_187315_a(0.0, 1.0).func_181675_d();
            bufferbuilder.func_181662_b(128.0, 128.0, -0.01f).func_187315_a(1.0, 1.0).func_181675_d();
            bufferbuilder.func_181662_b(128.0, 0.0, -0.01f).func_187315_a(1.0, 0.0).func_181675_d();
            bufferbuilder.func_181662_b(0.0, 0.0, -0.01f).func_187315_a(0.0, 0.0).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.enableAlphaTest();
            GlStateManager.disableBlend();
            int k = 0;
            for (MapDecoration mapdecoration : this.field_148242_b.field_76203_h.values()) {
                if (noOverlayRendering && !mapdecoration.func_191180_f()) continue;
                if (mapdecoration.render(k)) {
                    ++k;
                    continue;
                }
                MapItemRenderer.this.field_148251_b.func_110577_a(field_148253_a);
                GlStateManager.pushMatrix();
                GlStateManager.translatef((float)(0.0f + (float)mapdecoration.func_176112_b() / 2.0f + 64.0f), (float)(0.0f + (float)mapdecoration.func_176113_c() / 2.0f + 64.0f), (float)-0.02f);
                GlStateManager.rotatef((float)((float)(mapdecoration.func_176111_d() * 360) / 16.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.scalef((float)4.0f, (float)4.0f, (float)3.0f);
                GlStateManager.translatef((float)-0.125f, (float)0.125f, (float)0.0f);
                byte b0 = mapdecoration.func_176110_a();
                float f1 = (float)(b0 % 16 + 0) / 16.0f;
                float f2 = (float)(b0 / 16 + 0) / 16.0f;
                float f3 = (float)(b0 % 16 + 1) / 16.0f;
                float f4 = (float)(b0 / 16 + 1) / 16.0f;
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                float f5 = -0.001f;
                bufferbuilder.func_181662_b(-1.0, 1.0, (float)k * -0.001f).func_187315_a(f1, f2).func_181675_d();
                bufferbuilder.func_181662_b(1.0, 1.0, (float)k * -0.001f).func_187315_a(f3, f2).func_181675_d();
                bufferbuilder.func_181662_b(1.0, -1.0, (float)k * -0.001f).func_187315_a(f3, f4).func_181675_d();
                bufferbuilder.func_181662_b(-1.0, -1.0, (float)k * -0.001f).func_187315_a(f1, f4).func_181675_d();
                tessellator.func_78381_a();
                GlStateManager.popMatrix();
                if (mapdecoration.func_204309_g() != null) {
                    FontRenderer fontrenderer = Minecraft.func_71410_x().field_71466_p;
                    String s = mapdecoration.func_204309_g().func_150254_d();
                    float f6 = fontrenderer.func_78256_a(s);
                    float f7 = MathHelper.func_76131_a((float)(25.0f / f6), (float)0.0f, (float)0.6666667f);
                    GlStateManager.pushMatrix();
                    GlStateManager.translatef((float)(0.0f + (float)mapdecoration.func_176112_b() / 2.0f + 64.0f - f6 * f7 / 2.0f), (float)(0.0f + (float)mapdecoration.func_176113_c() / 2.0f + 64.0f + 4.0f), (float)-0.025f);
                    GlStateManager.scalef((float)f7, (float)f7, (float)1.0f);
                    AbstractGui.fill((int)-1, (int)-1, (int)((int)f6), (int)8, (int)Integer.MIN_VALUE);
                    GlStateManager.translatef((float)0.0f, (float)0.0f, (float)-0.1f);
                    fontrenderer.func_211126_b(s, 0.0f, 0.0f, -1);
                    GlStateManager.popMatrix();
                }
                ++k;
            }
            GlStateManager.pushMatrix();
            GlStateManager.translatef((float)0.0f, (float)0.0f, (float)-0.04f);
            GlStateManager.scalef((float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.popMatrix();
        }

        @Override
        public void close() {
            this.field_148243_c.close();
        }
    }
}

