/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import xiroc.dungeoncrawl.util.Position2D;

public class DungeonLayerMap {
    public int width;
    public int length;
    public List<Position2D> freePositions;
    public boolean[][] map;

    public DungeonLayerMap(int width, int length) {
        this.width = width;
        this.length = length;
        this.freePositions = new ArrayList<Position2D>();
        for (int x = 0; x < width; ++x) {
            for (int z = 0; z < length; ++z) {
                this.freePositions.add(new Position2D(x, z));
            }
        }
        this.map = new boolean[width][length];
    }

    public boolean isPositionFree(int x, int z) {
        return !this.map[x][z];
    }

    public Position2D getRandomFreePosition(Random rand) {
        if (this.freePositions.size() == 0) {
            return null;
        }
        Position2D pos = this.freePositions.get(rand.nextInt(this.freePositions.size()));
        this.freePositions.remove(pos);
        this.map[pos.x][pos.z] = true;
        return pos;
    }

    public boolean markPositionAsOccupied(Position2D pos) {
        Iterator<Position2D> iterator = this.freePositions.iterator();
        while (iterator.hasNext()) {
            Position2D current = iterator.next();
            if (pos.x != current.x || pos.z != current.z) continue;
            this.map[current.x][current.z] = true;
            iterator.remove();
            return true;
        }
        return false;
    }
}

