/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.config;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.loading.FMLPaths;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.config.ObfuscationValues;
import xiroc.dungeoncrawl.config.SpecialItemTags;
import xiroc.dungeoncrawl.dungeon.monster.ArmorSet;
import xiroc.dungeoncrawl.dungeon.treasure.EnchantedBook;
import xiroc.dungeoncrawl.util.BossEntry;
import xiroc.dungeoncrawl.util.IJsonConfigurable;

public class JsonConfig
implements IJsonConfigurable {
    public static final String KEY_CONFIG_VERSION = "config_version";
    public static final String KEY_BIOME_BLACKLIST = "biome_blacklist";
    public static final String KEY_BIOME_OVERWORLD_BLACKLIST = "biome_overworld_blacklist";
    public static final String KEY_BOWS = "bows";
    public static final String KEY_COLORED_ARMOR = "colored_armor";
    public static final String KEY_SWORDS = "swords";
    public static final String KEY_SWORDS_RARE = "swords_rare";
    public static final String KEY_PICKAXES = "pickaxes";
    public static final String KEY_AXES = "axes";
    public static final String KEY_ARMOR_STAGE_1 = "armor_sets_stage_1";
    public static final String KEY_ARMOR_STAGE_2 = "armor_sets_stage_2";
    public static final String KEY_ARMOR_STAGE_3 = "armor_sets_stage_3";
    public static final String KEY_ARMOR_RARE = "armor_rare";
    public static final String KEY_BOW_ENCHANTMENTS = "bow_enchantments";
    public static final String KEY_SWORD_ENCHANTMENTS = "sword_enchantments";
    public static final String KEY_PICKAXE_ENCHANTMENTS = "pickaxe_enchantments";
    public static final String KEY_AXE_ENCHANTMENTS = "axe_enchantments";
    public static final String KEY_ARMOR_ENCHANTMENTS = "armor_enchantments";
    public static final String KEY_BOSSES = "dungeon_bosses";
    public static final String[] KEYS = new String[]{"dungeon_bosses", "armor_enchantments", "armor_rare", "armor_sets_stage_1", "armor_sets_stage_2", "armor_sets_stage_3", "axe_enchantments", "axes", "biome_blacklist", "biome_overworld_blacklist", "bow_enchantments", "bows", "colored_armor", "pickaxe_enchantments", "pickaxes", "sword_enchantments", "swords", "swords_rare"};
    public static BossEntry[] DUNGEON_BOSSES;
    public static List<?> BIOME_BLACKLIST;
    public static List<?> BIOME_OVERWORLD_BLACKLIST;
    public static String[] ASSUMPTION_SEARCHLIST;
    public static Set<?> COLORED_ARMOR;
    public static ResourceLocation[] BOWS;
    public static ResourceLocation[] SWORDS;
    public static ResourceLocation[] SWORDS_RARE;
    public static ResourceLocation[] PICKAXES;
    public static ResourceLocation[] AXES;
    public static ResourceLocation[] BOW_ENCHANTMENTS;
    public static ResourceLocation[] SWORD_ENCHANTMENTS;
    public static ResourceLocation[] PICKAXE_ENCHANTMENTS;
    public static ResourceLocation[] AXE_ENCHANTMENTS;
    public static ResourceLocation[] ARMOR_ENCHANTMENTS;
    public static ArmorSet[] ARMOR_SETS_1;
    public static ArmorSet[] ARMOR_SETS_2;
    public static ArmorSet[] ARMOR_SETS_3;
    public static ArmorSet[] ARMOR_SETS_RARE;

    public static void load(IJsonConfigurable configurable) {
        File file = configurable.getFile();
        DungeonCrawl.LOGGER.info("Loading {}", (Object)file.getAbsolutePath());
        if (!file.exists()) {
            DungeonCrawl.LOGGER.info("Creating {}", (Object)file.getAbsolutePath());
            if (file.getParentFile() != null) {
                file.getParentFile().mkdirs();
            }
            JsonObject object = configurable.create(new JsonObject());
            object.add(KEY_CONFIG_VERSION, DungeonCrawl.GSON.toJsonTree((Object)configurable.getVersion()));
            try {
                FileWriter writer = new FileWriter(file);
                DungeonCrawl.GSON.toJson((JsonElement)object, (Appendable)writer);
                writer.flush();
                writer.close();
            }
            catch (Exception e) {
                DungeonCrawl.LOGGER.error("Failed to create {}", (Object)file.getAbsolutePath());
                e.printStackTrace();
            }
        }
        Gson gson = DungeonCrawl.GSON;
        try {
            JsonObject object = (JsonObject)gson.fromJson((Reader)new FileReader(file), JsonObject.class);
            if (object.get(KEY_CONFIG_VERSION).getAsInt() < configurable.getVersion()) {
                if (!configurable.deleteOldVersion()) {
                    DungeonCrawl.LOGGER.info("Creating a backup of {} because it is outdated and will be replaced", (Object)file.getAbsolutePath());
                    File backupFile = FMLPaths.CONFIGDIR.get().resolve("DungeonCrawl/Config Backups/" + System.currentTimeMillis() + "_" + file.getName()).toFile();
                    if (!backupFile.getParentFile().exists()) {
                        backupFile.getParentFile().mkdirs();
                    }
                    Files.write((byte[])Files.toByteArray((File)file), (File)backupFile);
                }
                DungeonCrawl.LOGGER.info("Replacing {}", (Object)file.getAbsoluteFile());
                JsonObject newObject = configurable.create(new JsonObject());
                newObject.add(KEY_CONFIG_VERSION, DungeonCrawl.GSON.toJsonTree((Object)configurable.getVersion()));
                try {
                    FileWriter writer = new FileWriter(file);
                    DungeonCrawl.GSON.toJson((JsonElement)newObject, (Appendable)writer);
                    writer.flush();
                    writer.close();
                }
                catch (Exception e) {
                    DungeonCrawl.LOGGER.error("Failed to create {}", (Object)file.getAbsolutePath());
                    e.printStackTrace();
                }
            }
            configurable.load(object, file);
        }
        catch (Exception e) {
            DungeonCrawl.LOGGER.error("Failed to load {}", (Object)file.getAbsolutePath());
            e.printStackTrace();
        }
    }

    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    public boolean deleteOldVersion() {
        return false;
    }

    public static JsonElement getOrRewrite(JsonObject object, String name, IJsonConfigurable configurable) {
        return JsonConfig.getOrRewrite(object, name, configurable, false);
    }

    public static JsonElement getOrRewrite(JsonObject object, String name, IJsonConfigurable configurable, boolean rerun) {
        if (object.get(name) != null) {
            return object.get(name);
        }
        File file = configurable.getFile();
        if (rerun) {
            DungeonCrawl.LOGGER.error("Cant find \"{}\" in {}, even after rewriting the file.", (Object)name, (Object)file.getAbsolutePath());
            return DungeonCrawl.GSON.toJsonTree(configurable.getDefaults().get(name));
        }
        DungeonCrawl.LOGGER.info("Rewriting {} due to missing data.", (Object)file.getAbsolutePath());
        JsonConfigManager.rewrite(configurable);
        try {
            return JsonConfig.getOrRewrite((JsonObject)DungeonCrawl.GSON.fromJson((Reader)new FileReader(configurable.getFile()), JsonObject.class), name, configurable, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            return DungeonCrawl.GSON.toJsonTree(configurable.getDefaults().get(name));
        }
    }

    @Override
    public File getFile() {
        return FMLPaths.CONFIGDIR.get().resolve("DungeonCrawl/config.json").toFile();
    }

    @Override
    public void load(JsonObject object, File file) {
        DUNGEON_BOSSES = (BossEntry[])DungeonCrawl.GSON.fromJson(JsonConfig.getOrRewrite(object, KEY_BOSSES, this), BossEntry[].class);
        BIOME_BLACKLIST = (List)DungeonCrawl.GSON.fromJson(JsonConfig.getOrRewrite(object, KEY_BIOME_BLACKLIST, this), ArrayList.class);
        BIOME_OVERWORLD_BLACKLIST = (List)DungeonCrawl.GSON.fromJson(JsonConfig.getOrRewrite(object, KEY_BIOME_OVERWORLD_BLACKLIST, this), ArrayList.class);
        COLORED_ARMOR = (Set)DungeonCrawl.GSON.fromJson(JsonConfig.getOrRewrite(object, KEY_COLORED_ARMOR, this), Set.class);
        BOWS = JsonConfig.toResourceLocationArray((String[])DungeonCrawl.GSON.fromJson(JsonConfig.getOrRewrite(object, KEY_BOWS, this), String[].class));
        SWORDS = JsonConfig.toResourceLocationArray((String[])DungeonCrawl.GSON.fromJson(JsonConfig.getOrRewrite(object, KEY_SWORDS, this), String[].class));
        SWORDS_RARE = JsonConfig.toResourceLocationArray((String[])DungeonCrawl.GSON.fromJson(JsonConfig.getOrRewrite(object, KEY_SWORDS_RARE, this), String[].class));
        PICKAXES = JsonConfig.toResourceLocationArray((String[])DungeonCrawl.GSON.fromJson(JsonConfig.getOrRewrite(object, KEY_PICKAXES, this), String[].class));
        AXES = JsonConfig.toResourceLocationArray((String[])DungeonCrawl.GSON.fromJson(JsonConfig.getOrRewrite(object, KEY_AXES, this), String[].class));
        ARMOR_SETS_1 = (ArmorSet[])DungeonCrawl.GSON.fromJson(JsonConfig.getOrRewrite(object, KEY_ARMOR_STAGE_1, this), ArmorSet[].class);
        ARMOR_SETS_2 = (ArmorSet[])DungeonCrawl.GSON.fromJson(JsonConfig.getOrRewrite(object, KEY_ARMOR_STAGE_2, this), ArmorSet[].class);
        ARMOR_SETS_3 = (ArmorSet[])DungeonCrawl.GSON.fromJson(JsonConfig.getOrRewrite(object, KEY_ARMOR_STAGE_3, this), ArmorSet[].class);
        ARMOR_SETS_RARE = (ArmorSet[])DungeonCrawl.GSON.fromJson(JsonConfig.getOrRewrite(object, KEY_ARMOR_RARE, this), ArmorSet[].class);
        BOW_ENCHANTMENTS = JsonConfig.toResourceLocationArray((String[])DungeonCrawl.GSON.fromJson(JsonConfig.getOrRewrite(object, KEY_BOW_ENCHANTMENTS, this), String[].class));
        SWORD_ENCHANTMENTS = JsonConfig.toResourceLocationArray((String[])DungeonCrawl.GSON.fromJson(JsonConfig.getOrRewrite(object, KEY_SWORD_ENCHANTMENTS, this), String[].class));
        AXE_ENCHANTMENTS = JsonConfig.toResourceLocationArray((String[])DungeonCrawl.GSON.fromJson(JsonConfig.getOrRewrite(object, KEY_AXE_ENCHANTMENTS, this), String[].class));
        PICKAXE_ENCHANTMENTS = JsonConfig.toResourceLocationArray((String[])DungeonCrawl.GSON.fromJson(JsonConfig.getOrRewrite(object, KEY_PICKAXE_ENCHANTMENTS, this), String[].class));
        ARMOR_ENCHANTMENTS = JsonConfig.toResourceLocationArray((String[])DungeonCrawl.GSON.fromJson(JsonConfig.getOrRewrite(object, KEY_ARMOR_ENCHANTMENTS, this), String[].class));
        ArmorSet.buildAll(ARMOR_SETS_1);
        ArmorSet.buildAll(ARMOR_SETS_2);
        ArmorSet.buildAll(ARMOR_SETS_3);
        ArmorSet.buildAll(ARMOR_SETS_RARE);
    }

    @Override
    public JsonObject create(JsonObject object) {
        object.add(KEY_BIOME_BLACKLIST, DungeonCrawl.GSON.toJsonTree(JsonConfigManager.BIOME_BLACKLIST));
        object.add(KEY_BIOME_OVERWORLD_BLACKLIST, DungeonCrawl.GSON.toJsonTree(JsonConfigManager.BIOME_OVERWORLD_BLACKLIST));
        object.add(KEY_BOWS, DungeonCrawl.GSON.toJsonTree((Object)JsonConfigManager.BOWS));
        object.add(KEY_COLORED_ARMOR, DungeonCrawl.GSON.toJsonTree(JsonConfigManager.COLORED_ARMOR));
        object.add(KEY_SWORDS, DungeonCrawl.GSON.toJsonTree((Object)JsonConfigManager.SWORDS));
        object.add(KEY_SWORDS_RARE, DungeonCrawl.GSON.toJsonTree((Object)JsonConfigManager.SWORDS_RARE));
        object.add(KEY_PICKAXES, DungeonCrawl.GSON.toJsonTree((Object)JsonConfigManager.PICKAXES));
        object.add(KEY_AXES, DungeonCrawl.GSON.toJsonTree((Object)JsonConfigManager.AXES));
        object.add(KEY_ARMOR_STAGE_1, DungeonCrawl.GSON.toJsonTree((Object)JsonConfigManager.ARMOR_SETS_1));
        object.add(KEY_ARMOR_STAGE_2, DungeonCrawl.GSON.toJsonTree((Object)JsonConfigManager.ARMOR_SETS_2));
        object.add(KEY_ARMOR_STAGE_3, DungeonCrawl.GSON.toJsonTree((Object)JsonConfigManager.ARMOR_SETS_3));
        object.add(KEY_ARMOR_RARE, DungeonCrawl.GSON.toJsonTree((Object)JsonConfigManager.ARMOR_SETS_RARE));
        object.add(KEY_BOW_ENCHANTMENTS, DungeonCrawl.GSON.toJsonTree((Object)JsonConfigManager.BOW_ENCHANTMENTS));
        object.add(KEY_SWORD_ENCHANTMENTS, DungeonCrawl.GSON.toJsonTree((Object)JsonConfigManager.SWORD_ENCHANTMENTS));
        object.add(KEY_PICKAXE_ENCHANTMENTS, DungeonCrawl.GSON.toJsonTree((Object)JsonConfigManager.PICKAXE_ENCHANTMENTS));
        object.add(KEY_AXE_ENCHANTMENTS, DungeonCrawl.GSON.toJsonTree((Object)JsonConfigManager.AXE_ENCHANTMENTS));
        object.add(KEY_ARMOR_ENCHANTMENTS, DungeonCrawl.GSON.toJsonTree((Object)JsonConfigManager.ARMOR_ENCHANTMENTS));
        return object;
    }

    public static ResourceLocation[] toResourceLocationArray(String[] resourceNames) {
        ResourceLocation[] resourceLocations = new ResourceLocation[resourceNames.length];
        for (int i = 0; i < resourceNames.length; ++i) {
            String[] resource = resourceNames[i].split(":");
            resourceLocations[i] = new ResourceLocation(resource[0], resource[1]);
        }
        return resourceLocations;
    }

    @Override
    public HashMap<String, Object> getDefaults() {
        return JsonConfigManager.DEFAULTS;
    }

    @Override
    public String[] getKeys() {
        return KEYS;
    }

    static {
        COLORED_ARMOR = ImmutableSet.builder().add((Object)"minecraft:leather_boots").add((Object)"minecraft:leather_pants").add((Object)"minecraft:leather_chestplate").add((Object)"minecraft:leather_helmet").build();
        JsonConfig.load(new JsonConfig());
        JsonConfig.load(new EnchantedBook());
        JsonConfig.load(new SpecialItemTags());
        JsonConfig.load(new ObfuscationValues());
    }

    public static class JsonConfigManager {
        public static final List<?> BIOME_BLACKLIST = Lists.newArrayList((Object[])new String[]{"minecraft:the_end", "minecraft:nether", "minecraft:small_end_islands", "minecraft:end_midlands", "minecraft:end_highlands", "minecraft:end_barrens", "minecraft:the_void", "biomesoplenty:ashen_inferno", "biomesopenty:undergarden", "biomesoplenty:boneyard", "biomesoplenty:visceral_heap"});
        public static final List<?> BIOME_OVERWORLD_BLACKLIST = Lists.newArrayList((Object[])new String[]{"minecraft:ocean", "minecraft:deep_ocean", "minecraft:lukewarm_ocean", "minecraft:deep_lukewarm_ocean", "minecraft:warm_ocean", "minecraft:deep_warm_ocean", "minecraft:cold_ocean", "minecraft:deep_cold_ocean", "minecraft:frozen_ocean", "minecraft:deep_frozen_ocean"});
        public static final Set<?> COLORED_ARMOR = ImmutableSet.builder().add((Object)"minecraft:leather_boots").add((Object)"minecraft:leather_pants").add((Object)"minecraft:leather_chestplate").add((Object)"minecraft:leather_helmet").build();
        public static final String[] BOWS = new String[]{"minecraft:bow"};
        public static final String[] SWORDS = new String[]{new String("minecraft:stone_sword"), "minecraft:golden_sword", new String("minecraft:iron_sword")};
        public static final String[] SWORDS_RARE = new String[]{"minecraft:wooden_sword", "minecraft:diamond_sword"};
        public static final String[] PICKAXES = new String[]{"minecraft:stone_pickaxe", "minecraft:golden_pickaxe", "minecraft:iron_pickaxe"};
        public static final String[] AXES = new String[]{"minecraft:stone_axe", "minecraft:golden_axe", "minecraft:iron_axe", "minecraft:diamond_axe"};
        public static final ArmorSet[] ARMOR_SETS_1 = new ArmorSet[]{new ArmorSet("minecraft:leather_boots", "minecraft:leather_leggings", "minecraft:leather_chestplate", "minecraft:leather_helmet")};
        public static final ArmorSet[] ARMOR_SETS_2 = new ArmorSet[]{new ArmorSet("minecraft:leather_boots", "minecraft:leather_leggings", "minecraft:leather_chestplate", "minecraft:leather_helmet"), new ArmorSet("minecraft:golden_boots", "minecraft:golden_leggings", "minecraft:golden_chestplate", "minecraft:golden_helmet"), new ArmorSet("minecraft:chainmail_boots", "minecraft:chainmail_leggings", "minecraft:chainmail_chestplate", "minecraft:chainmail_helmet"), new ArmorSet("minecraft:iron_boots", "minecraft:iron_leggings", "minecraft:iron_chestplate", "minecraft:iron_helmet")};
        public static final ArmorSet[] ARMOR_SETS_3 = new ArmorSet[]{new ArmorSet("minecraft:leather_boots", "minecraft:leather_leggings", "minecraft:leather_chestplate", "minecraft:leather_helmet"), new ArmorSet("minecraft:golden_boots", "minecraft:golden_leggings", "minecraft:golden_chestplate", "minecraft:golden_helmet"), new ArmorSet("minecraft:chainmail_boots", "minecraft:chainmail_leggings", "minecraft:chainmail_chestplate", "minecraft:chainmail_helmet"), new ArmorSet("minecraft:iron_boots", "minecraft:iron_leggings", "minecraft:iron_chestplate", "minecraft:iron_helmet")};
        public static final ArmorSet[] ARMOR_SETS_RARE = new ArmorSet[]{new ArmorSet("minecraft:diamond_boots", "minecraft:diamond_leggings", "minecraft:diamond_chestplate", "minecraft:diamond_helmet")};
        public static final String[] BOW_ENCHANTMENTS = new String[]{"minecraft:power", "minecraft:unbreaking", "minecraft:punch"};
        public static final String[] SWORD_ENCHANTMENTS = new String[]{"minecraft:sharpness", "minecraft:unbreaking", "minecraft:fire_aspect", "minecraft:knockback"};
        public static final String[] PICKAXE_ENCHANTMENTS = new String[]{"minecraft:efficiency"};
        public static final String[] AXE_ENCHANTMENTS = new String[]{"minecraft:efficiency"};
        public static final String[] ARMOR_ENCHANTMENTS = new String[]{"minecraft:protection", "minecraft:unbreaking", "minecraft:thorns", "minecraft:projectile_protection"};
        public static final String[] ASSUMPTION_SEARCHLIST = new String[]{"nether", "end", "aether", "betweenlands", "twilight", "dimension", "mining", "rftools", "world"};
        public static final HashMap<String, Object> DEFAULTS = new HashMap();

        public static void rewrite(IJsonConfigurable configurable) {
            File file = configurable.getFile();
            try {
                JsonObject object = file.exists() ? (JsonObject)DungeonCrawl.GSON.fromJson((Reader)new FileReader(file), JsonObject.class) : new JsonObject();
                for (String key : configurable.getKeys()) {
                    if (object.has(key)) continue;
                    object.add(key, DungeonCrawl.GSON.toJsonTree(configurable.getDefaults().get(key)));
                }
                FileWriter writer = new FileWriter(file);
                DungeonCrawl.GSON.toJson((JsonElement)object, (Appendable)writer);
                writer.flush();
                writer.close();
            }
            catch (Exception e1) {
                DungeonCrawl.LOGGER.error("An error occured whilst trying to rewrite {}", (Object)file.getAbsolutePath());
                e1.printStackTrace();
            }
        }

        static {
            DEFAULTS.put(JsonConfig.KEY_BOSSES, new BossEntry[0]);
            DEFAULTS.put(JsonConfig.KEY_BIOME_BLACKLIST, BIOME_BLACKLIST);
            DEFAULTS.put(JsonConfig.KEY_BIOME_OVERWORLD_BLACKLIST, BIOME_OVERWORLD_BLACKLIST);
            DEFAULTS.put(JsonConfig.KEY_BOWS, BOWS);
            DEFAULTS.put(JsonConfig.KEY_COLORED_ARMOR, COLORED_ARMOR);
            DEFAULTS.put(JsonConfig.KEY_SWORDS, SWORDS);
            DEFAULTS.put(JsonConfig.KEY_SWORDS_RARE, SWORDS_RARE);
            DEFAULTS.put(JsonConfig.KEY_PICKAXES, PICKAXES);
            DEFAULTS.put(JsonConfig.KEY_AXES, AXES);
            DEFAULTS.put(JsonConfig.KEY_ARMOR_STAGE_1, ARMOR_SETS_1);
            DEFAULTS.put(JsonConfig.KEY_ARMOR_STAGE_2, ARMOR_SETS_2);
            DEFAULTS.put(JsonConfig.KEY_ARMOR_STAGE_3, ARMOR_SETS_3);
            DEFAULTS.put(JsonConfig.KEY_ARMOR_RARE, ARMOR_SETS_RARE);
            DEFAULTS.put(JsonConfig.KEY_BOW_ENCHANTMENTS, BOW_ENCHANTMENTS);
            DEFAULTS.put(JsonConfig.KEY_SWORD_ENCHANTMENTS, SWORD_ENCHANTMENTS);
            DEFAULTS.put(JsonConfig.KEY_PICKAXE_ENCHANTMENTS, PICKAXE_ENCHANTMENTS);
            DEFAULTS.put(JsonConfig.KEY_AXE_ENCHANTMENTS, AXE_ENCHANTMENTS);
            DEFAULTS.put(JsonConfig.KEY_ARMOR_ENCHANTMENTS, ARMOR_ENCHANTMENTS);
        }
    }
}

