/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.shaders;

import java.util.Iterator;
import net.optifine.BlockPosM;
import net.optifine.shaders.IteratorAxis;

public class Iterator3d
implements Iterator<ew> {
    private IteratorAxis iteratorAxis;
    private BlockPosM blockPos = new BlockPosM(0, 0, 0);
    private int axis = 0;
    private int kX;
    private int kY;
    private int kZ;
    private static final int AXIS_X = 0;
    private static final int AXIS_Y = 1;
    private static final int AXIS_Z = 2;

    public Iterator3d(ew posStart, ew posEnd, int width, int height) {
        boolean revX = posStart.o() > posEnd.o();
        boolean revY = posStart.p() > posEnd.p();
        boolean revZ = posStart.q() > posEnd.q();
        posStart = this.reverseCoord(posStart, revX, revY, revZ);
        posEnd = this.reverseCoord(posEnd, revX, revY, revZ);
        this.kX = revX ? -1 : 1;
        this.kY = revY ? -1 : 1;
        this.kZ = revZ ? -1 : 1;
        csi vec = new csi((double)(posEnd.o() - posStart.o()), (double)(posEnd.p() - posStart.p()), (double)(posEnd.q() - posStart.q()));
        csi vecN = vec.d();
        csi vecX = new csi(1.0, 0.0, 0.0);
        double dotX = vecN.b(vecX);
        double dotXabs = Math.abs(dotX);
        csi vecY = new csi(0.0, 1.0, 0.0);
        double dotY = vecN.b(vecY);
        double dotYabs = Math.abs(dotY);
        csi vecZ = new csi(0.0, 0.0, 1.0);
        double dotZ = vecN.b(vecZ);
        double dotZabs = Math.abs(dotZ);
        if (dotZabs >= dotYabs && dotZabs >= dotXabs) {
            this.axis = 2;
            ew pos1 = new ew(posStart.q(), posStart.p() - width, posStart.o() - height);
            ew pos2 = new ew(posEnd.q(), posStart.p() + width + 1, posStart.o() + height + 1);
            int countX = posEnd.q() - posStart.q();
            double deltaY = (double)(posEnd.p() - posStart.p()) / (1.0 * (double)countX);
            double deltaZ = (double)(posEnd.o() - posStart.o()) / (1.0 * (double)countX);
            this.iteratorAxis = new IteratorAxis(pos1, pos2, deltaY, deltaZ);
        } else if (dotYabs >= dotXabs && dotYabs >= dotZabs) {
            this.axis = 1;
            ew pos1 = new ew(posStart.p(), posStart.o() - width, posStart.q() - height);
            ew pos2 = new ew(posEnd.p(), posStart.o() + width + 1, posStart.q() + height + 1);
            int countX = posEnd.p() - posStart.p();
            double deltaY = (double)(posEnd.o() - posStart.o()) / (1.0 * (double)countX);
            double deltaZ = (double)(posEnd.q() - posStart.q()) / (1.0 * (double)countX);
            this.iteratorAxis = new IteratorAxis(pos1, pos2, deltaY, deltaZ);
        } else {
            this.axis = 0;
            ew pos1 = new ew(posStart.o(), posStart.p() - width, posStart.q() - height);
            ew pos2 = new ew(posEnd.o(), posStart.p() + width + 1, posStart.q() + height + 1);
            int countX = posEnd.o() - posStart.o();
            double deltaY = (double)(posEnd.p() - posStart.p()) / (1.0 * (double)countX);
            double deltaZ = (double)(posEnd.q() - posStart.q()) / (1.0 * (double)countX);
            this.iteratorAxis = new IteratorAxis(pos1, pos2, deltaY, deltaZ);
        }
    }

    private ew reverseCoord(ew pos, boolean revX, boolean revY, boolean revZ) {
        if (revX) {
            pos = new ew(-pos.o(), pos.p(), pos.q());
        }
        if (revY) {
            pos = new ew(pos.o(), -pos.p(), pos.q());
        }
        if (revZ) {
            pos = new ew(pos.o(), pos.p(), -pos.q());
        }
        return pos;
    }

    @Override
    public boolean hasNext() {
        return this.iteratorAxis.hasNext();
    }

    @Override
    public ew next() {
        ew pos = this.iteratorAxis.next();
        switch (this.axis) {
            case 0: {
                this.blockPos.setXyz(pos.o() * this.kX, pos.p() * this.kY, pos.q() * this.kZ);
                return this.blockPos;
            }
            case 1: {
                this.blockPos.setXyz(pos.p() * this.kX, pos.o() * this.kY, pos.q() * this.kZ);
                return this.blockPos;
            }
            case 2: {
                this.blockPos.setXyz(pos.q() * this.kX, pos.p() * this.kY, pos.o() * this.kZ);
                return this.blockPos;
            }
        }
        this.blockPos.setXyz(pos.o() * this.kX, pos.p() * this.kY, pos.q() * this.kZ);
        return this.blockPos;
    }

    @Override
    public void remove() {
        throw new RuntimeException("Not supported");
    }

    public static void main(String[] args) {
        ew posStart = new ew(10, 20, 30);
        ew posEnd = new ew(30, 40, 20);
        Iterator3d it2 = new Iterator3d(posStart, posEnd, 1, 1);
        while (it2.hasNext()) {
            ew blockPos = it2.next();
            System.out.println("" + blockPos);
        }
    }
}

