/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading.moddiscovery;

import com.electronwill.nightconfig.core.UnmodifiableConfig;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraftforge.fml.loading.StringSubstitutor;
import net.minecraftforge.fml.loading.StringUtils;
import net.minecraftforge.fml.loading.moddiscovery.InvalidModFileException;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;
import net.minecraftforge.forgespi.language.IModInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;

public class ModInfo
implements IModInfo {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final DefaultArtifactVersion DEFAULT_VERSION = new DefaultArtifactVersion("1");
    private static final Pattern VALID_LABEL = Pattern.compile("^[a-z][a-z0-9_-]{1,63}$");
    private final ModFileInfo owningFile;
    private final String modId;
    private final String namespace;
    private final ArtifactVersion version;
    private final String displayName;
    private final String description;
    private final Optional<String> logoFile;
    private final URL updateJSONURL;
    private final List<IModInfo.ModVersion> dependencies;
    private final Map<String, Object> properties;
    private final UnmodifiableConfig modConfig;

    public ModInfo(ModFileInfo owningFile, UnmodifiableConfig modConfig) {
        this.owningFile = owningFile;
        this.modConfig = modConfig;
        this.modId = (String)modConfig.getOptional("modId").orElseThrow(() -> new InvalidModFileException("Missing modId entry", owningFile));
        if (!VALID_LABEL.matcher(this.modId).matches()) {
            LOGGER.fatal("Invalid modId found in file {} - {} does not match the standard: {}", (Object)this.owningFile.getFile().getFilePath(), (Object)this.modId, (Object)VALID_LABEL.pattern());
            throw new InvalidModFileException("Invalid modId found : " + this.modId, owningFile);
        }
        this.namespace = modConfig.getOptional("namespace").orElse(this.modId);
        if (!VALID_LABEL.matcher(this.namespace).matches()) {
            LOGGER.fatal("Invalid override namespace found in file {} - {} does not match the standard: {}", (Object)this.owningFile.getFile().getFilePath(), (Object)this.namespace, (Object)VALID_LABEL.pattern());
            throw new InvalidModFileException("Invalid override namespace found : " + this.namespace, owningFile);
        }
        this.version = (ArtifactVersion)modConfig.getOptional("version").map(s -> StringSubstitutor.replace(s, owningFile != null ? owningFile.getFile() : null)).map(DefaultArtifactVersion::new).orElse(DEFAULT_VERSION);
        this.displayName = modConfig.getOptional("displayName").orElse(this.modId);
        this.description = (String)modConfig.get("description");
        Optional tmp = modConfig.getOptional("logoFile");
        if (!tmp.isPresent() && this.owningFile != null) {
            tmp = this.owningFile.getConfig().getOptional("logoFile");
        }
        this.logoFile = tmp;
        this.updateJSONURL = modConfig.getOptional("updateJSONURL").map(StringUtils::toURL).orElse(null);
        if (owningFile != null) {
            this.dependencies = owningFile.getConfig().getOptional(Arrays.asList("dependencies", this.modId)).orElse(Collections.emptyList()).stream().map(dep -> new IModInfo.ModVersion((IModInfo)this, dep)).collect(Collectors.toList());
            this.properties = owningFile.getConfig().getOptional(Arrays.asList("modproperties", this.modId)).map(UnmodifiableConfig::valueMap).orElse(Collections.emptyMap());
        } else {
            this.dependencies = Collections.emptyList();
            this.properties = Collections.emptyMap();
        }
    }

    public ModFileInfo getOwningFile() {
        return this.owningFile;
    }

    public String getModId() {
        return this.modId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public ArtifactVersion getVersion() {
        return this.version;
    }

    public List<IModInfo.ModVersion> getDependencies() {
        return this.dependencies;
    }

    public UnmodifiableConfig getModConfig() {
        return this.modConfig;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Map<String, Object> getModProperties() {
        return this.properties;
    }

    public URL getUpdateURL() {
        return this.updateJSONURL;
    }

    public Optional<String> getLogoFile() {
        return this.logoFile;
    }

    public boolean hasConfigUI() {
        return false;
    }
}

