/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading;

import cpw.mods.modlauncher.api.LamdbaExceptionUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import net.minecraftforge.fml.loading.LogMarkers;
import org.apache.logging.log4j.LogManager;

class FixSSL {
    FixSSL() {
    }

    static void fixup() {
        try {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            Path ksPath = Paths.get(System.getProperty("java.home"), "lib", "security", "cacerts");
            keyStore.load(Files.newInputStream(ksPath, new OpenOption[0]), "changeit".toCharArray());
            Map jdkTrustStore = Collections.list(keyStore.aliases()).stream().collect(Collectors.toMap(a -> a, LamdbaExceptionUtils.rethrowFunction(keyStore::getCertificate)));
            KeyStore leKS = KeyStore.getInstance(KeyStore.getDefaultType());
            InputStream leKSFile = FixSSL.class.getResourceAsStream("/lekeystore.jks");
            leKS.load(leKSFile, "supersecretpassword".toCharArray());
            Map leTrustStore = Collections.list(leKS.aliases()).stream().collect(Collectors.toMap(a -> a, LamdbaExceptionUtils.rethrowFunction(leKS::getCertificate)));
            KeyStore mergedTrustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            mergedTrustStore.load(null, new char[0]);
            jdkTrustStore.forEach(LamdbaExceptionUtils.rethrowBiConsumer(mergedTrustStore::setCertificateEntry));
            leTrustStore.forEach(LamdbaExceptionUtils.rethrowBiConsumer(mergedTrustStore::setCertificateEntry));
            TrustManagerFactory instance = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            instance.init(mergedTrustStore);
            SSLContext tls = SSLContext.getInstance("TLS");
            tls.init(null, instance.getTrustManagers(), null);
            HttpsURLConnection.setDefaultSSLSocketFactory(tls.getSocketFactory());
            LogManager.getLogger().info(LogMarkers.CORE, "Added Lets Encrypt root certificates as additional trust");
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            LogManager.getLogger().fatal(LogMarkers.CORE, "Failed to load lets encrypt certificate. Expect problems", (Throwable)e);
        }
    }
}

