/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.world;

import com.mojang.datafixers.Dynamic;
import java.util.ArrayList;
import java.util.Random;
import java.util.function.Function;
import mod.lucky.Lucky;
import mod.lucky.block.BlockLuckyBlock;
import mod.lucky.drop.DropFull;
import mod.lucky.drop.func.DropProcessData;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.placement.ChanceConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.registries.ForgeRegistries;

public class LuckyGenerator
extends Feature<NoFeatureConfig> {
    private BlockLuckyBlock block;
    private ArrayList<DropFull> surfaceDrops;
    private ArrayList<DropFull> netherDrops;
    private ArrayList<DropFull> endDrops;

    public LuckyGenerator(Function<Dynamic<?>, ? extends NoFeatureConfig> configFactoryIn) {
        super(configFactoryIn);
    }

    public void init(BlockLuckyBlock block) {
        this.block = block;
        this.surfaceDrops = new ArrayList();
        this.netherDrops = new ArrayList();
        this.endDrops = new ArrayList();
    }

    public static LuckyGenerator registerNew(BlockLuckyBlock block) {
        LuckyGenerator generator = new LuckyGenerator(NoFeatureConfig::func_214639_a);
        generator.init(block);
        ForgeRegistries.BIOMES.forEach(biome -> biome.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, Biome.func_222280_a((Feature)generator, (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215026_l, (IPlacementConfig)new ChanceConfig(1))));
        return generator;
    }

    private void generate(IWorld world, Random rand, BlockPos pos, ArrayList<DropFull> drops) {
        int initIndex = rand.nextInt(drops.size());
        for (int i = 0; i < drops.size(); ++i) {
            DropFull drop = drops.get((initIndex + i) % drops.size());
            if (rand.nextInt((int)drop.getChance()) != 0) continue;
            DropProcessData processData = new DropProcessData(world, null, pos);
            this.block.getDropProcessor().processRandomDrop(drops, processData, 0);
        }
    }

    private boolean generate(IWorld world, Random rand, BlockPos pos) {
        try {
            if (this.block.canPlaceAt(world, pos)) {
                Dimension dim = world.func_201675_m();
                if (dim.func_177495_o()) {
                    this.generate(world, rand, pos, this.netherDrops);
                } else if (dim.func_76569_d()) {
                    this.generate(world, rand, pos, this.surfaceDrops);
                } else {
                    this.generate(world, rand, pos, this.endDrops);
                }
                return true;
            }
        }
        catch (Exception e) {
            Lucky.error(e, "Error during natural generation");
        }
        return false;
    }

    public void addSurfacedDrop(DropFull drop) {
        this.addDrop(this.surfaceDrops, drop);
    }

    public void addNetherDrop(DropFull drop) {
        this.addDrop(this.netherDrops, drop);
    }

    public void addEndDrop(DropFull drop) {
        this.addDrop(this.endDrops, drop);
    }

    private void addDrop(ArrayList<DropFull> list, DropFull drop) {
        if (!drop.wasChanceSet()) {
            drop.setChance(300.0f);
        }
        list.add(drop);
    }

    public boolean place(IWorld world, ChunkGenerator<?> chunkGen, Random rand, BlockPos pos, NoFeatureConfig config) {
        return this.generate(world, rand, pos);
    }
}

