/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.resources.loader;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import mod.lucky.Lucky;
import mod.lucky.resources.BaseResource;
import mod.lucky.resources.loader.BaseLoader;

public class DefaultLoader
extends BaseLoader {
    private File resourceDir;

    public DefaultLoader(File minecraftDirectory) {
        this.resourceDir = new File(minecraftDirectory.getPath() + "/config/lucky/version-" + Lucky.VERSION);
        this.setBlock(Lucky.luckyBlock);
        this.setSword(Lucky.luckySword);
        this.setBow(Lucky.luckyBow);
        this.setPotion(Lucky.luckyPotion);
    }

    public void extractDefaultResources() {
        try {
            ZipEntry entry;
            InputStream stream = Lucky.class.getResourceAsStream("default_config.zip");
            if (stream == null) {
                Lucky.error(null, "No default resources found");
                return;
            }
            ZipInputStream inputStream = new ZipInputStream(stream);
            while ((entry = inputStream.getNextEntry()) != null) {
                int data;
                FileOutputStream outputStream = null;
                File dest = new File(this.resourceDir.getPath() + "/" + entry.getName());
                if (!entry.isDirectory() && !dest.exists()) {
                    if (!dest.getParentFile().exists()) {
                        dest.getParentFile().mkdirs();
                    }
                    dest.createNewFile();
                    outputStream = new FileOutputStream(dest);
                }
                while ((data = inputStream.read()) != -1) {
                    if (outputStream == null) continue;
                    outputStream.write(data);
                }
                if (outputStream == null) continue;
                outputStream.close();
            }
            inputStream.close();
        }
        catch (Exception e) {
            Lucky.error(e, "Error extracting default resources");
        }
    }

    private File getFile(BaseResource resource) {
        return new File(this.resourceDir.getPath() + "/" + resource.getPath());
    }

    @Override
    public InputStream getResourceStream(BaseResource resource) {
        try {
            File file = this.getFile(resource);
            if (file.isDirectory()) {
                return null;
            }
            return new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            if (!resource.isOptional()) {
                Lucky.error(e, "Lucky Block: Error getting default resource: " + resource.getPath());
            }
            return null;
        }
    }
}

