/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.network;

import java.util.function.Supplier;
import mod.lucky.Lucky;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkEvent;

public class SpawnPacket {
    private CompoundNBT entityTag;

    public SpawnPacket() {
    }

    public SpawnPacket(Entity entity) {
        this.entityTag = entity.serializeNBT();
    }

    public static SpawnPacket decode(PacketBuffer buf) {
        SpawnPacket msg = new SpawnPacket();
        msg.entityTag = buf.func_150793_b();
        return msg;
    }

    public static void encode(SpawnPacket msg, PacketBuffer buf) {
        buf.func_150786_a(msg.entityTag);
    }

    public static class Handler {
        @OnlyIn(value=Dist.CLIENT)
        private static void spawn(SpawnPacket msg) {
            ClientWorld world = Minecraft.func_71410_x().field_71441_e;
            Entity entity = EntityType.func_220335_a((CompoundNBT)msg.entityTag, (World)world, e -> {
                world.func_217411_a(e.func_145782_y(), e);
                return e;
            });
            if (entity == null) {
                Lucky.error(null, "Invalid entity spawning on the client side: " + msg.entityTag.toString());
                return;
            }
        }

        public static void handle(SpawnPacket msg, Supplier<NetworkEvent.Context> context) {
            context.get().enqueueWork(() -> Handler.spawn(msg));
            context.get().setPacketHandled(true);
        }
    }
}

