/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.drop.value;

import java.util.ArrayList;
import java.util.Random;
import mod.lucky.drop.func.DropProcessData;
import mod.lucky.drop.value.DropStringUtils;
import mod.lucky.drop.value.HashVariables;
import mod.lucky.drop.value.ValueParser;
import mod.lucky.util.LuckyUtils;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.storage.loot.LootTables;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class CustomNBTTags {
    public static final CompoundNBT protection = CustomNBTTags.getEnchantment(Enchantments.field_180310_c, 4);
    public static final CompoundNBT fireProtection = CustomNBTTags.getEnchantment(Enchantments.field_77329_d, 4);
    public static final CompoundNBT featherFalling = CustomNBTTags.getEnchantment(Enchantments.field_180309_e, 4);
    public static final CompoundNBT blastProtection = CustomNBTTags.getEnchantment(Enchantments.field_185297_d, 4);
    public static final CompoundNBT projectileProtection = CustomNBTTags.getEnchantment(Enchantments.field_180308_g, 4);
    public static final CompoundNBT respiration = CustomNBTTags.getEnchantment(Enchantments.field_185298_f, 3);
    public static final CompoundNBT aquaAffinity = CustomNBTTags.getEnchantment(Enchantments.field_185299_g, 1);
    public static final CompoundNBT thorns = CustomNBTTags.getEnchantment(Enchantments.field_92091_k, 3);
    public static final CompoundNBT sharpness = CustomNBTTags.getEnchantment(Enchantments.field_185302_k, 5);
    public static final CompoundNBT smite = CustomNBTTags.getEnchantment(Enchantments.field_185303_l, 5);
    public static final CompoundNBT baneOfArthroponds = CustomNBTTags.getEnchantment(Enchantments.field_180312_n, 5);
    public static final CompoundNBT knockBack = CustomNBTTags.getEnchantment(Enchantments.field_180313_o, 2);
    public static final CompoundNBT fireAspect = CustomNBTTags.getEnchantment(Enchantments.field_77334_n, 2);
    public static final CompoundNBT looting = CustomNBTTags.getEnchantment(Enchantments.field_185304_p, 3);
    public static final CompoundNBT efficiency = CustomNBTTags.getEnchantment(Enchantments.field_185305_q, 5);
    public static final CompoundNBT silkTouch = CustomNBTTags.getEnchantment(Enchantments.field_185306_r, 1);
    public static final CompoundNBT unbreaking = CustomNBTTags.getEnchantment(Enchantments.field_185307_s, 3);
    public static final CompoundNBT fortune = CustomNBTTags.getEnchantment(Enchantments.field_185308_t, 3);
    public static final CompoundNBT power = CustomNBTTags.getEnchantment(Enchantments.field_185309_u, 5);
    public static final CompoundNBT punch = CustomNBTTags.getEnchantment(Enchantments.field_185310_v, 2);
    public static final CompoundNBT flame = CustomNBTTags.getEnchantment(Enchantments.field_185311_w, 1);
    public static final CompoundNBT infinity = CustomNBTTags.getEnchantment(Enchantments.field_185312_x, 1);
    public static final CompoundNBT luckOfTheSea = CustomNBTTags.getEnchantment(Enchantments.field_151370_z, 3);
    public static final CompoundNBT lure = CustomNBTTags.getEnchantment(Enchantments.field_151369_A, 3);
    public static final CompoundNBT speed = CustomNBTTags.getEffectInstance(Effects.field_76424_c, 3, 9600);
    public static final CompoundNBT slowness = CustomNBTTags.getEffectInstance(Effects.field_76421_d, 3, 9600);
    public static final CompoundNBT haste = CustomNBTTags.getEffectInstance(Effects.field_76422_e, 3, 9600);
    public static final CompoundNBT miningFatigue = CustomNBTTags.getEffectInstance(Effects.field_76419_f, 3, 9600);
    public static final CompoundNBT strength = CustomNBTTags.getEffectInstance(Effects.field_76420_g, 3, 9600);
    public static final CompoundNBT instantHealth = CustomNBTTags.getEffectInstance(Effects.field_76432_h, 3, 0);
    public static final CompoundNBT instantDamage = CustomNBTTags.getEffectInstance(Effects.field_76433_i, 3, 0);
    public static final CompoundNBT jumpBoost = CustomNBTTags.getEffectInstance(Effects.field_76430_j, 3, 9600);
    public static final CompoundNBT nausea = CustomNBTTags.getEffectInstance(Effects.field_76431_k, 0, 9600);
    public static final CompoundNBT regeneration = CustomNBTTags.getEffectInstance(Effects.field_76428_l, 3, 9600);
    public static final CompoundNBT resistance = CustomNBTTags.getEffectInstance(Effects.field_76429_m, 3, 9600);
    public static final CompoundNBT fireResistance = CustomNBTTags.getEffectInstance(Effects.field_76426_n, 0, 9600);
    public static final CompoundNBT waterBreathing = CustomNBTTags.getEffectInstance(Effects.field_76427_o, 0, 9600);
    public static final CompoundNBT invisibility = CustomNBTTags.getEffectInstance(Effects.field_76441_p, 0, 9600);
    public static final CompoundNBT blindness = CustomNBTTags.getEffectInstance(Effects.field_76440_q, 0, 9600);
    public static final CompoundNBT nightVision = CustomNBTTags.getEffectInstance(Effects.field_76439_r, 0, 9600);
    public static final CompoundNBT hunger = CustomNBTTags.getEffectInstance(Effects.field_76438_s, 3, 9600);
    public static final CompoundNBT weakness = CustomNBTTags.getEffectInstance(Effects.field_76437_t, 3, 9600);
    public static final CompoundNBT poison = CustomNBTTags.getEffectInstance(Effects.field_76436_u, 3, 9600);
    public static final CompoundNBT wither = CustomNBTTags.getEffectInstance(Effects.field_82731_v, 3, 9600);
    public static final CompoundNBT healthBoost = CustomNBTTags.getEffectInstance(Effects.field_180152_w, 3, 9600);
    public static final CompoundNBT absorbtion = CustomNBTTags.getEffectInstance(Effects.field_76444_x, 3, 9600);
    public static final CompoundNBT saturation = CustomNBTTags.getEffectInstance(Effects.field_76443_y, 3, 9600);
    public static Random random = new Random();
    public static String[] nbtHashVariables = new String[]{"#luckySwordEnchantments", "#luckyAxeEnchantments", "#luckyToolEnchantments", "#luckyHelmetEnchantments", "#luckyLeggingsEnchantments", "#luckyBootsEnchantments", "#luckyBowEnchantments", "#luckyFishingRodEnchantments", "#randEnchantment", "#luckyPotionEffects", "#unluckyPotionEffects", "#randFireworksRocket", "#randLaunchMotion", "#motionFromDirection", "#bowMotion", "#chestLootTable"};

    public static CompoundNBT getEnchantment(Enchantment enchantment, int maxLevel) {
        CompoundNBT nbttag = new CompoundNBT();
        nbttag.func_74778_a("id", ForgeRegistries.ENCHANTMENTS.getKey((IForgeRegistryEntry)enchantment).toString());
        nbttag.func_74777_a("lvl", (short)maxLevel);
        return nbttag;
    }

    public static CompoundNBT getEffectInstance(Effect potion, int amplifier, int duration) {
        CompoundNBT nbttag = new CompoundNBT();
        EffectInstance effect = new EffectInstance(potion, duration, amplifier);
        return effect.func_82719_a(nbttag);
    }

    public static ArrayList<CompoundNBT> getRandomList(int minAmount, int maxAmount, CompoundNBT ... elements) {
        int amountToRemove = elements.length - (random.nextInt(maxAmount + 1 - minAmount) + minAmount);
        ArrayList<CompoundNBT> chosenElementList = new ArrayList<CompoundNBT>(elements.length);
        for (CompoundNBT element : elements) {
            chosenElementList.add(element.func_74737_b());
        }
        for (int a = 0; a < amountToRemove; ++a) {
            int index = random.nextInt(chosenElementList.size());
            chosenElementList.remove(index);
        }
        return chosenElementList;
    }

    public static ListNBT getRandomEnchantmentList(int minAmount, int maxAmount, CompoundNBT ... enchantments) {
        ArrayList<CompoundNBT> chosenEnchantments = CustomNBTTags.getRandomList(minAmount, maxAmount, enchantments);
        ListNBT nbttaglist = new ListNBT();
        for (CompoundNBT enchantment : chosenEnchantments) {
            enchantment.func_74777_a("lvl", (short)(random.nextInt(enchantment.func_74765_d("lvl")) + 1));
            nbttaglist.add((Object)enchantment);
        }
        return nbttaglist;
    }

    public static ListNBT getRandomEffectInstanceList(int minAmount, int maxAmount, CompoundNBT ... potionEffects) {
        ArrayList<CompoundNBT> chosenEffectInstances = CustomNBTTags.getRandomList(minAmount, maxAmount, potionEffects);
        ListNBT nbttaglist = new ListNBT();
        for (CompoundNBT potionEffect : chosenEffectInstances) {
            potionEffect.func_74774_a("Amplifier", (byte)random.nextInt(potionEffect.func_74771_c("Amplifier") + 1));
            int minDuration = (int)((float)potionEffect.func_74762_e("Duration") / 3.0f);
            potionEffect.func_74768_a("Duration", random.nextInt(potionEffect.func_74762_e("Duration") + 1 - minDuration) + minDuration);
            nbttaglist.add((Object)potionEffect);
        }
        return nbttaglist;
    }

    public static INBT getNBTTagFromString(String name, DropProcessData processData) {
        if (name.equals("#luckySwordEnchantments")) {
            return CustomNBTTags.getRandomEnchantmentList(4, 6, sharpness, smite, baneOfArthroponds, knockBack, fireAspect, looting, unbreaking);
        }
        if (name.equals("#luckyAxeEnchantments")) {
            return CustomNBTTags.getRandomEnchantmentList(4, 6, sharpness, smite, baneOfArthroponds, efficiency, unbreaking, fortune);
        }
        if (name.equals("#luckyToolEnchantments")) {
            return CustomNBTTags.getRandomEnchantmentList(2, 3, efficiency, unbreaking, fortune);
        }
        if (name.equals("#luckyHelmetEnchantments")) {
            return CustomNBTTags.getRandomEnchantmentList(4, 6, protection, fireProtection, blastProtection, projectileProtection, respiration, aquaAffinity, unbreaking);
        }
        if (name.equals("#luckyChestplateEnchantments")) {
            return CustomNBTTags.getRandomEnchantmentList(4, 6, protection, fireProtection, blastProtection, projectileProtection, thorns, unbreaking);
        }
        if (name.equals("#luckyLeggingsEnchantments")) {
            return CustomNBTTags.getRandomEnchantmentList(4, 6, protection, fireProtection, blastProtection, projectileProtection, thorns, unbreaking);
        }
        if (name.equals("#luckyBootsEnchantments")) {
            return CustomNBTTags.getRandomEnchantmentList(4, 6, protection, fireProtection, featherFalling, blastProtection, projectileProtection, thorns, unbreaking);
        }
        if (name.equals("#luckyBowEnchantments")) {
            return CustomNBTTags.getRandomEnchantmentList(3, 5, unbreaking, power, punch, flame, infinity);
        }
        if (name.equals("#luckyFishingRodEnchantments")) {
            return CustomNBTTags.getRandomEnchantmentList(2, 3, unbreaking, luckOfTheSea, lure);
        }
        if (name.equals("#randEnchantment")) {
            return CustomNBTTags.getRandomEnchantmentList(1, 1, protection, fireProtection, featherFalling, blastProtection, projectileProtection, thorns, sharpness, smite, baneOfArthroponds, knockBack, fireAspect, looting, efficiency, silkTouch, unbreaking, fortune, power, punch, flame, infinity, luckOfTheSea, lure);
        }
        if (name.equals("#luckyPotionEffects")) {
            return CustomNBTTags.getRandomEffectInstanceList(7, 10, speed, haste, strength, instantHealth, jumpBoost, regeneration, resistance, fireResistance, waterBreathing, invisibility, nightVision, healthBoost, absorbtion, saturation);
        }
        if (name.equals("#unluckyPotionEffects")) {
            return CustomNBTTags.getRandomEffectInstanceList(5, 7, slowness, miningFatigue, instantDamage, nausea, blindness, hunger, weakness, poison, wither);
        }
        if (name.equals("#randFireworksRocket")) {
            return LuckyUtils.getRandomFireworksRocket();
        }
        if (name.startsWith("#randLaunchMotion")) {
            try {
                float launchPower = 0.9f;
                int launchAngle = 15;
                if (name.startsWith("#randLaunchMotion(")) {
                    String contents = name.substring(name.indexOf(40) + 1, name.lastIndexOf(41));
                    String[] splitValue = DropStringUtils.splitBracketString(contents, ',');
                    splitValue[0] = DropStringUtils.removeNumSuffix(splitValue[0]);
                    launchPower = ValueParser.getFloat(splitValue[0], processData).floatValue();
                    launchAngle = ValueParser.getInteger(splitValue[1], processData);
                }
                float launchYaw = MathHelper.func_76142_g((float)(random.nextFloat() * 360.0f));
                float launchPitch = -90.0f + (float)(random.nextInt(launchAngle * 2) - launchAngle);
                float launchMotionX = -MathHelper.func_76126_a((float)(launchYaw / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(launchPitch / 180.0f * (float)Math.PI)) * launchPower;
                float launchMotionZ = MathHelper.func_76134_b((float)(launchYaw / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(launchPitch / 180.0f * (float)Math.PI)) * launchPower;
                float launchMotionY = -MathHelper.func_76126_a((float)(launchPitch / 180.0f * (float)Math.PI)) * launchPower;
                ListNBT motionList = new ListNBT();
                motionList.add((Object)new DoubleNBT((double)launchMotionX));
                motionList.add((Object)new DoubleNBT((double)launchMotionY));
                motionList.add((Object)new DoubleNBT((double)launchMotionZ));
                return motionList;
            }
            catch (Exception launchPower) {
                // empty catch block
            }
        }
        if (name.startsWith("#motionFromDirection(")) {
            try {
                String contents = name.substring(name.indexOf(40) + 1, name.lastIndexOf(41));
                String[] splitValue = DropStringUtils.splitBracketString(contents, ',');
                splitValue[2] = DropStringUtils.removeNumSuffix(splitValue[2]);
                int launchYaw = ValueParser.getInteger(splitValue[0], processData);
                int launchPitch = ValueParser.getInteger(splitValue[1], processData);
                float launchPower = ValueParser.getFloat(splitValue[2], processData).floatValue();
                float launchMotionX = -MathHelper.func_76126_a((float)((float)launchYaw / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)((float)launchPitch / 180.0f * (float)Math.PI)) * launchPower;
                float launchMotionZ = MathHelper.func_76134_b((float)((float)launchYaw / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)((float)launchPitch / 180.0f * (float)Math.PI)) * launchPower;
                float launchMotionY = -MathHelper.func_76126_a((float)((float)launchPitch / 180.0f * (float)Math.PI)) * launchPower;
                ListNBT motionList = new ListNBT();
                motionList.add((Object)new DoubleNBT((double)launchMotionX));
                motionList.add((Object)new DoubleNBT((double)launchMotionY));
                motionList.add((Object)new DoubleNBT((double)launchMotionZ));
                return motionList;
            }
            catch (Exception contents) {
                // empty catch block
            }
        }
        if (name.startsWith("#bowMotion")) {
            try {
                Entity shooter;
                float bowPowerMod = 1.0f;
                float randAngle = 0.0f;
                if (name.startsWith("#bowMotion(")) {
                    String contents = name.substring(name.indexOf(40) + 1, name.lastIndexOf(41));
                    String[] splitValue = DropStringUtils.splitBracketString(contents, ',');
                    splitValue[0] = DropStringUtils.removeNumSuffix(splitValue[0]);
                    if (splitValue.length > 1) {
                        splitValue[1] = DropStringUtils.removeNumSuffix(splitValue[1]);
                    }
                    bowPowerMod = ValueParser.getFloat(splitValue[0], processData).floatValue();
                    if (splitValue.length > 1) {
                        randAngle = ValueParser.getFloat(splitValue[1], processData).floatValue();
                    }
                }
                ArrowEntity entityArrow = (shooter = processData.getPlayer()) instanceof LivingEntity ? new ArrowEntity(processData.getWorld(), (LivingEntity)shooter) : new ArrowEntity(processData.getWorld(), shooter.field_70165_t, shooter.field_70163_u, shooter.field_70161_v);
                entityArrow.func_184547_a(shooter, shooter.field_70125_A + HashVariables.randomFloatClamp(processData.getWorld().field_73012_v, -randAngle, randAngle), shooter.field_70177_z + HashVariables.randomFloatClamp(processData.getWorld().field_73012_v, -randAngle, randAngle), 0.0f, processData.getBowPower(), 1.0f);
                ListNBT motionList = new ListNBT();
                Vec3d arrowMotion = entityArrow.func_213322_ci();
                motionList.add((Object)new DoubleNBT(arrowMotion.field_72450_a));
                motionList.add((Object)new DoubleNBT(arrowMotion.field_72448_b));
                motionList.add((Object)new DoubleNBT(arrowMotion.field_72449_c));
                return motionList;
            }
            catch (Exception bowPowerMod) {
                // empty catch block
            }
        }
        name = name.replace("#chestVillageArmorer", "#chestLootTable(" + LootTables.field_215816_g.func_110623_a() + ")");
        name = name.replace("#chestBonusChest", "#chestLootTable(" + LootTables.field_186420_b.func_110623_a() + ")");
        if ((name = name.replace("#chestDungeonChest", "#chestLootTable(" + LootTables.field_186422_d.func_110623_a() + ")")).startsWith("#chestLootTable(")) {
            ChestTileEntity tileEntityChest = new ChestTileEntity();
            String lootId = ValueParser.getString(name.substring(name.indexOf(40) + 1, name.lastIndexOf(41)));
            tileEntityChest.func_145834_a(processData.getWorld());
            tileEntityChest.func_189404_a(new ResourceLocation("minecraft", lootId), random.nextLong());
            tileEntityChest.func_70301_a(0);
            CompoundNBT tagCompound = new CompoundNBT();
            tileEntityChest.func_189515_b(tagCompound);
            return tagCompound.func_150295_c("Items", 10);
        }
        return null;
    }
}

