/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.drop;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import mod.lucky.drop.DropBase;
import mod.lucky.drop.DropSingle;
import mod.lucky.drop.func.DropProcessData;
import mod.lucky.drop.value.DropStringUtils;
import mod.lucky.drop.value.DropValue;
import net.minecraft.nbt.CompoundNBT;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class DropGroup
extends DropBase {
    private ArrayList<DropBase> drops = new ArrayList();
    private DropValue amount;
    private boolean shuffle;

    @Override
    public DropGroup initialize(DropProcessData processData) {
        DropGroup dropGroup = this.copy();
        dropGroup.amount.initialize(processData);
        if (dropGroup.shuffle) {
            Collections.shuffle(dropGroup.drops);
        }
        return dropGroup;
    }

    @Override
    public void readFromString(String string) {
        String[] colonSections = DropStringUtils.splitBracketString(string, ':');
        String lineOfContents = colonSections[colonSections.length - 1];
        Object[] commaSections = DropStringUtils.splitBracketString(lineOfContents, ',');
        lineOfContents = commaSections[0];
        String groupProperties = StringUtils.join((Object[])(commaSections = (String[])ArrayUtils.remove((Object[])commaSections, (int)0)), (char)',');
        if (!groupProperties.equals("")) {
            groupProperties = "," + groupProperties;
        }
        lineOfContents = lineOfContents.toLowerCase(Locale.ENGLISH).startsWith("group") ? lineOfContents.substring("group".length() + 1, lineOfContents.length() - 1) : lineOfContents.substring(1, lineOfContents.length() - 1);
        String[] groupContents = DropStringUtils.splitBracketString(lineOfContents, ';');
        if (colonSections.length >= 3) {
            this.amount = new DropValue(colonSections[1], Integer.class);
            this.shuffle = true;
        } else {
            this.amount = new DropValue(groupContents.length);
            this.shuffle = false;
        }
        for (String drop : groupContents) {
            if ((drop = drop + groupProperties).toLowerCase(Locale.ENGLISH).startsWith("group")) {
                DropGroup group = new DropGroup();
                group.readFromString(drop);
                this.drops.add(group);
                continue;
            }
            DropSingle properties = new DropSingle();
            properties.readFromString(drop);
            this.drops.add(properties);
        }
    }

    public ArrayList<DropBase> getDrops() {
        return this.drops;
    }

    public int getAmount() {
        return this.amount.getValueInt();
    }

    @Override
    public String writeToString() {
        return null;
    }

    @Override
    public void readFromNBT(CompoundNBT tagCompound) {
    }

    @Override
    public CompoundNBT writeToNBT() {
        return null;
    }

    public DropGroup copy() {
        DropGroup dropGroup = new DropGroup();
        dropGroup.amount = this.amount.copy();
        dropGroup.shuffle = this.shuffle;
        dropGroup.drops = this.drops;
        return dropGroup;
    }
}

