/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.HugeTreesFeature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.common.IPlantable;

public class MegaPineTree
extends HugeTreesFeature<NoFeatureConfig> {
    private static final BlockState field_181633_e = Blocks.field_196618_L.func_176223_P();
    private static final BlockState field_181634_f = Blocks.field_196645_X.func_176223_P();
    private static final BlockState field_181635_g = Blocks.field_196661_l.func_176223_P();
    private final boolean field_150542_e;

    public MegaPineTree(Function<Dynamic<?>, ? extends NoFeatureConfig> configFactoryIn, boolean doBlockNotifyOnPlace, boolean useBaseHeightIn) {
        super(configFactoryIn, doBlockNotifyOnPlace, 13, 15, field_181633_e, field_181634_f);
        this.field_150542_e = useBaseHeightIn;
        this.setSapling((IPlantable)Blocks.field_196675_u);
    }

    @Override
    public boolean func_208519_a(Set<BlockPos> changedBlocks, IWorldGenerationReader worldIn, Random rand, BlockPos position, MutableBoundingBox p_208519_5_) {
        int i = this.func_150533_a(rand);
        if (!this.func_203427_a(worldIn, position, i)) {
            return false;
        }
        this.func_214596_a(worldIn, position.func_177958_n(), position.func_177952_p(), position.func_177956_o() + i, 0, rand, p_208519_5_, changedBlocks);
        for (int j = 0; j < i; ++j) {
            if (MegaPineTree.func_214572_g((IWorldGenerationBaseReader)worldIn, position.func_177981_b(j))) {
                this.func_208520_a(changedBlocks, (IWorldWriter)worldIn, position.func_177981_b(j), this.field_76520_b, p_208519_5_);
            }
            if (j >= i - 1) continue;
            if (MegaPineTree.func_214572_g((IWorldGenerationBaseReader)worldIn, position.func_177982_a(1, j, 0))) {
                this.func_208520_a(changedBlocks, (IWorldWriter)worldIn, position.func_177982_a(1, j, 0), this.field_76520_b, p_208519_5_);
            }
            if (MegaPineTree.func_214572_g((IWorldGenerationBaseReader)worldIn, position.func_177982_a(1, j, 1))) {
                this.func_208520_a(changedBlocks, (IWorldWriter)worldIn, position.func_177982_a(1, j, 1), this.field_76520_b, p_208519_5_);
            }
            if (!MegaPineTree.func_214572_g((IWorldGenerationBaseReader)worldIn, position.func_177982_a(0, j, 1))) continue;
            this.func_208520_a(changedBlocks, (IWorldWriter)worldIn, position.func_177982_a(0, j, 1), this.field_76520_b, p_208519_5_);
        }
        this.func_180711_a(worldIn, rand, position);
        return true;
    }

    private void func_214596_a(IWorldGenerationReader p_214596_1_, int p_214596_2_, int p_214596_3_, int p_214596_4_, int p_214596_5_, Random p_214596_6_, MutableBoundingBox p_214596_7_, Set<BlockPos> p_214596_8_) {
        int i = p_214596_6_.nextInt(5) + (this.field_150542_e ? this.field_76522_a : 3);
        int j = 0;
        for (int k = p_214596_4_ - i; k <= p_214596_4_; ++k) {
            int l = p_214596_4_ - k;
            int i1 = p_214596_5_ + MathHelper.func_76141_d((float)((float)l / (float)i * 3.5f));
            this.func_222839_a(p_214596_1_, new BlockPos(p_214596_2_, k, p_214596_3_), i1 + (l > 0 && i1 == j && (k & 1) == 0 ? 1 : 0), p_214596_7_, p_214596_8_);
            j = i1;
        }
    }

    public void func_180711_a(IWorldGenerationReader worldIn, Random random, BlockPos pos) {
        this.func_175933_b(worldIn, pos.func_177976_e().func_177978_c());
        this.func_175933_b(worldIn, pos.func_177965_g(2).func_177978_c());
        this.func_175933_b(worldIn, pos.func_177976_e().func_177970_e(2));
        this.func_175933_b(worldIn, pos.func_177965_g(2).func_177970_e(2));
        for (int i = 0; i < 5; ++i) {
            int j = random.nextInt(64);
            int k = j % 8;
            int l = j / 8;
            if (k != 0 && k != 7 && l != 0 && l != 7) continue;
            this.func_175933_b(worldIn, pos.func_177982_a(-3 + k, 0, -3 + l));
        }
    }

    private void func_175933_b(IWorldGenerationReader worldIn, BlockPos center) {
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                if (Math.abs(i) == 2 && Math.abs(j) == 2) continue;
                this.func_175934_c(worldIn, center.func_177982_a(i, 0, j));
            }
        }
    }

    private void func_175934_c(IWorldGenerationReader worldIn, BlockPos pos) {
        for (int i = 2; i >= -3; --i) {
            BlockPos blockpos = pos.func_177981_b(i);
            if (MegaPineTree.isSoil((IWorldGenerationBaseReader)worldIn, blockpos, this.getSapling())) {
                this.func_202278_a((IWorldWriter)worldIn, blockpos, field_181635_g);
                break;
            }
            if (!MegaPineTree.func_214574_b((IWorldGenerationBaseReader)worldIn, blockpos) && i < 0) break;
        }
    }
}

