/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.inventory.container;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.IntReferenceHolder;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class Container {
    private final NonNullList<ItemStack> field_75153_a = NonNullList.func_191196_a();
    public final List<Slot> field_75151_b = Lists.newArrayList();
    private final List<IntReferenceHolder> field_216964_d = Lists.newArrayList();
    @Nullable
    private final ContainerType<?> field_216965_e;
    public final int field_75152_c;
    @OnlyIn(value=Dist.CLIENT)
    private short field_75150_e;
    private int field_94535_f = -1;
    private int field_94536_g;
    private final Set<Slot> field_94537_h = Sets.newHashSet();
    private final List<IContainerListener> field_75149_d = Lists.newArrayList();
    private final Set<PlayerEntity> field_75148_f = Sets.newHashSet();

    protected Container(@Nullable ContainerType<?> type, int id) {
        this.field_216965_e = type;
        this.field_75152_c = id;
    }

    protected static boolean func_216963_a(IWorldPosCallable worldPos, PlayerEntity playerIn, Block targetBlock) {
        return (Boolean)worldPos.func_221485_a((p_216960_2_, p_216960_3_) -> p_216960_2_.func_180495_p((BlockPos)p_216960_3_).func_177230_c() != targetBlock ? false : playerIn.func_70092_e((double)p_216960_3_.func_177958_n() + 0.5, (double)p_216960_3_.func_177956_o() + 0.5, (double)p_216960_3_.func_177952_p() + 0.5) <= 64.0, (Object)true);
    }

    public ContainerType<?> func_216957_a() {
        if (this.field_216965_e == null) {
            throw new UnsupportedOperationException("Unable to construct this menu by type");
        }
        return this.field_216965_e;
    }

    protected static void func_216962_a(IInventory inventoryIn, int minSize) {
        int i = inventoryIn.func_70302_i_();
        if (i < minSize) {
            throw new IllegalArgumentException("Container size " + i + " is smaller than expected " + minSize);
        }
    }

    protected static void func_216959_a(IIntArray intArrayIn, int minSize) {
        int i = intArrayIn.func_221478_a();
        if (i < minSize) {
            throw new IllegalArgumentException("Container data count " + i + " is smaller than expected " + minSize);
        }
    }

    protected Slot func_75146_a(Slot slotIn) {
        slotIn.field_75222_d = this.field_75151_b.size();
        this.field_75151_b.add(slotIn);
        this.field_75153_a.add((Object)ItemStack.field_190927_a);
        return slotIn;
    }

    protected IntReferenceHolder func_216958_a(IntReferenceHolder intIn) {
        this.field_216964_d.add(intIn);
        return intIn;
    }

    protected void func_216961_a(IIntArray arrayIn) {
        for (int i = 0; i < arrayIn.func_221478_a(); ++i) {
            this.func_216958_a(IntReferenceHolder.func_221493_a((IIntArray)arrayIn, (int)i));
        }
    }

    public void func_75132_a(IContainerListener listener) {
        if (!this.field_75149_d.contains(listener)) {
            this.field_75149_d.add(listener);
            listener.func_71110_a(this, this.func_75138_a());
            this.func_75142_b();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_82847_b(IContainerListener listener) {
        this.field_75149_d.remove(listener);
    }

    public NonNullList<ItemStack> func_75138_a() {
        NonNullList nonnulllist = NonNullList.func_191196_a();
        for (int i = 0; i < this.field_75151_b.size(); ++i) {
            nonnulllist.add((Object)this.field_75151_b.get(i).func_75211_c());
        }
        return nonnulllist;
    }

    public void func_75142_b() {
        for (int i = 0; i < this.field_75151_b.size(); ++i) {
            ItemStack itemstack = this.field_75151_b.get(i).func_75211_c();
            ItemStack itemstack1 = (ItemStack)((Object)this.field_75153_a.get(i));
            if (ItemStack.func_77989_b(itemstack1, itemstack)) continue;
            boolean clientStackChanged = !itemstack1.equals(itemstack, true);
            itemstack1 = itemstack.func_190926_b() ? ItemStack.field_190927_a : itemstack.func_77946_l();
            this.field_75153_a.set(i, (Object)itemstack1);
            if (!clientStackChanged) continue;
            for (IContainerListener icontainerlistener : this.field_75149_d) {
                icontainerlistener.func_71111_a(this, i, itemstack1);
            }
        }
        for (int j = 0; j < this.field_216964_d.size(); ++j) {
            IntReferenceHolder intreferenceholder = this.field_216964_d.get(j);
            if (!intreferenceholder.func_221496_c()) continue;
            for (IContainerListener icontainerlistener1 : this.field_75149_d) {
                icontainerlistener1.func_71112_a(this, j, intreferenceholder.func_221495_b());
            }
        }
    }

    public boolean func_75140_a(PlayerEntity playerIn, int id) {
        return false;
    }

    public Slot func_75139_a(int slotId) {
        return this.field_75151_b.get(slotId);
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        Slot slot = this.field_75151_b.get(index);
        return slot != null ? slot.func_75211_c() : ItemStack.field_190927_a;
    }

    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, PlayerEntity player) {
        ItemStack itemstack = ItemStack.field_190927_a;
        PlayerInventory playerinventory = player.field_71071_by;
        if (clickTypeIn == ClickType.QUICK_CRAFT) {
            int j1 = this.field_94536_g;
            this.field_94536_g = Container.func_94532_c(dragType);
            if ((j1 != 1 || this.field_94536_g != 2) && j1 != this.field_94536_g) {
                this.func_94533_d();
            } else if (playerinventory.func_70445_o().func_190926_b()) {
                this.func_94533_d();
            } else if (this.field_94536_g == 0) {
                this.field_94535_f = Container.func_94529_b(dragType);
                if (Container.func_180610_a(this.field_94535_f, player)) {
                    this.field_94536_g = 1;
                    this.field_94537_h.clear();
                } else {
                    this.func_94533_d();
                }
            } else if (this.field_94536_g == 1) {
                Slot slot7 = this.field_75151_b.get(slotId);
                ItemStack itemstack12 = playerinventory.func_70445_o();
                if (slot7 != null && Container.func_94527_a(slot7, itemstack12, true) && slot7.func_75214_a(itemstack12) && (this.field_94535_f == 2 || itemstack12.func_190916_E() > this.field_94537_h.size()) && this.func_94531_b(slot7)) {
                    this.field_94537_h.add(slot7);
                }
            } else if (this.field_94536_g == 2) {
                if (!this.field_94537_h.isEmpty()) {
                    ItemStack itemstack9 = playerinventory.func_70445_o().func_77946_l();
                    int k1 = playerinventory.func_70445_o().func_190916_E();
                    for (Slot slot8 : this.field_94537_h) {
                        ItemStack itemstack13 = playerinventory.func_70445_o();
                        if (slot8 == null || !Container.func_94527_a(slot8, itemstack13, true) || !slot8.func_75214_a(itemstack13) || this.field_94535_f != 2 && itemstack13.func_190916_E() < this.field_94537_h.size() || !this.func_94531_b(slot8)) continue;
                        ItemStack itemstack14 = itemstack9.func_77946_l();
                        int j3 = slot8.func_75216_d() ? slot8.func_75211_c().func_190916_E() : 0;
                        Container.func_94525_a(this.field_94537_h, this.field_94535_f, itemstack14, j3);
                        int k3 = Math.min(itemstack14.func_77976_d(), slot8.func_178170_b(itemstack14));
                        if (itemstack14.func_190916_E() > k3) {
                            itemstack14.func_190920_e(k3);
                        }
                        k1 -= itemstack14.func_190916_E() - j3;
                        slot8.func_75215_d(itemstack14);
                    }
                    itemstack9.func_190920_e(k1);
                    playerinventory.func_70437_b(itemstack9);
                }
                this.func_94533_d();
            } else {
                this.func_94533_d();
            }
        } else if (this.field_94536_g != 0) {
            this.func_94533_d();
        } else if (!(clickTypeIn != ClickType.PICKUP && clickTypeIn != ClickType.QUICK_MOVE || dragType != 0 && dragType != 1)) {
            if (slotId == -999) {
                if (!playerinventory.func_70445_o().func_190926_b()) {
                    if (dragType == 0) {
                        player.func_71019_a(playerinventory.func_70445_o(), true);
                        playerinventory.func_70437_b(ItemStack.field_190927_a);
                    }
                    if (dragType == 1) {
                        player.func_71019_a(playerinventory.func_70445_o().func_77979_a(1), true);
                    }
                }
            } else if (clickTypeIn == ClickType.QUICK_MOVE) {
                if (slotId < 0) {
                    return ItemStack.field_190927_a;
                }
                Slot slot5 = this.field_75151_b.get(slotId);
                if (slot5 == null || !slot5.func_82869_a(player)) {
                    return ItemStack.field_190927_a;
                }
                ItemStack itemstack7 = this.func_82846_b(player, slotId);
                while (!itemstack7.func_190926_b() && ItemStack.func_179545_c(slot5.func_75211_c(), itemstack7)) {
                    itemstack = itemstack7.func_77946_l();
                    itemstack7 = this.func_82846_b(player, slotId);
                }
            } else {
                if (slotId < 0) {
                    return ItemStack.field_190927_a;
                }
                Slot slot6 = this.field_75151_b.get(slotId);
                if (slot6 != null) {
                    ItemStack itemstack8 = slot6.func_75211_c();
                    ItemStack itemstack11 = playerinventory.func_70445_o();
                    if (!itemstack8.func_190926_b()) {
                        itemstack = itemstack8.func_77946_l();
                    }
                    if (itemstack8.func_190926_b()) {
                        if (!itemstack11.func_190926_b() && slot6.func_75214_a(itemstack11)) {
                            int j2;
                            int n = j2 = dragType == 0 ? itemstack11.func_190916_E() : 1;
                            if (j2 > slot6.func_178170_b(itemstack11)) {
                                j2 = slot6.func_178170_b(itemstack11);
                            }
                            slot6.func_75215_d(itemstack11.func_77979_a(j2));
                        }
                    } else if (slot6.func_82869_a(player)) {
                        int i3;
                        if (itemstack11.func_190926_b()) {
                            if (itemstack8.func_190926_b()) {
                                slot6.func_75215_d(ItemStack.field_190927_a);
                                playerinventory.func_70437_b(ItemStack.field_190927_a);
                            } else {
                                int k2 = dragType == 0 ? itemstack8.func_190916_E() : (itemstack8.func_190916_E() + 1) / 2;
                                playerinventory.func_70437_b(slot6.func_75209_a(k2));
                                if (itemstack8.func_190926_b()) {
                                    slot6.func_75215_d(ItemStack.field_190927_a);
                                }
                                slot6.func_190901_a(player, playerinventory.func_70445_o());
                            }
                        } else if (slot6.func_75214_a(itemstack11)) {
                            if (Container.func_195929_a(itemstack8, itemstack11)) {
                                int l2;
                                int n = l2 = dragType == 0 ? itemstack11.func_190916_E() : 1;
                                if (l2 > slot6.func_178170_b(itemstack11) - itemstack8.func_190916_E()) {
                                    l2 = slot6.func_178170_b(itemstack11) - itemstack8.func_190916_E();
                                }
                                if (l2 > itemstack11.func_77976_d() - itemstack8.func_190916_E()) {
                                    l2 = itemstack11.func_77976_d() - itemstack8.func_190916_E();
                                }
                                itemstack11.func_190918_g(l2);
                                itemstack8.func_190917_f(l2);
                            } else if (itemstack11.func_190916_E() <= slot6.func_178170_b(itemstack11)) {
                                slot6.func_75215_d(itemstack11);
                                playerinventory.func_70437_b(itemstack8);
                            }
                        } else if (itemstack11.func_77976_d() > 1 && Container.func_195929_a(itemstack8, itemstack11) && !itemstack8.func_190926_b() && (i3 = itemstack8.func_190916_E()) + itemstack11.func_190916_E() <= itemstack11.func_77976_d()) {
                            itemstack11.func_190917_f(i3);
                            itemstack8 = slot6.func_75209_a(i3);
                            if (itemstack8.func_190926_b()) {
                                slot6.func_75215_d(ItemStack.field_190927_a);
                            }
                            slot6.func_190901_a(player, playerinventory.func_70445_o());
                        }
                    }
                    slot6.func_75218_e();
                }
            }
        } else if (clickTypeIn == ClickType.SWAP && dragType >= 0 && dragType < 9) {
            Slot slot4 = this.field_75151_b.get(slotId);
            ItemStack itemstack6 = playerinventory.func_70301_a(dragType);
            ItemStack itemstack10 = slot4.func_75211_c();
            if (!itemstack6.func_190926_b() || !itemstack10.func_190926_b()) {
                if (itemstack6.func_190926_b()) {
                    if (slot4.func_82869_a(player)) {
                        playerinventory.func_70299_a(dragType, itemstack10);
                        slot4.func_190900_b(itemstack10.func_190916_E());
                        slot4.func_75215_d(ItemStack.field_190927_a);
                        slot4.func_190901_a(player, itemstack10);
                    }
                } else if (itemstack10.func_190926_b()) {
                    if (slot4.func_75214_a(itemstack6)) {
                        int l1 = slot4.func_178170_b(itemstack6);
                        if (itemstack6.func_190916_E() > l1) {
                            slot4.func_75215_d(itemstack6.func_77979_a(l1));
                        } else {
                            slot4.func_75215_d(itemstack6);
                            playerinventory.func_70299_a(dragType, ItemStack.field_190927_a);
                        }
                    }
                } else if (slot4.func_82869_a(player) && slot4.func_75214_a(itemstack6)) {
                    int i2 = slot4.func_178170_b(itemstack6);
                    if (itemstack6.func_190916_E() > i2) {
                        slot4.func_75215_d(itemstack6.func_77979_a(i2));
                        slot4.func_190901_a(player, itemstack10);
                        if (!playerinventory.func_70441_a(itemstack10)) {
                            player.func_71019_a(itemstack10, true);
                        }
                    } else {
                        slot4.func_75215_d(itemstack6);
                        playerinventory.func_70299_a(dragType, itemstack10);
                        slot4.func_190901_a(player, itemstack10);
                    }
                }
            }
        } else if (clickTypeIn == ClickType.CLONE && player.field_71075_bZ.field_75098_d && playerinventory.func_70445_o().func_190926_b() && slotId >= 0) {
            Slot slot3 = this.field_75151_b.get(slotId);
            if (slot3 != null && slot3.func_75216_d()) {
                ItemStack itemstack5 = slot3.func_75211_c().func_77946_l();
                itemstack5.func_190920_e(itemstack5.func_77976_d());
                playerinventory.func_70437_b(itemstack5);
            }
        } else if (clickTypeIn == ClickType.THROW && playerinventory.func_70445_o().func_190926_b() && slotId >= 0) {
            Slot slot2 = this.field_75151_b.get(slotId);
            if (slot2 != null && slot2.func_75216_d() && slot2.func_82869_a(player)) {
                ItemStack itemstack4 = slot2.func_75209_a(dragType == 0 ? 1 : slot2.func_75211_c().func_190916_E());
                slot2.func_190901_a(player, itemstack4);
                player.func_71019_a(itemstack4, true);
            }
        } else if (clickTypeIn == ClickType.PICKUP_ALL && slotId >= 0) {
            Slot slot = this.field_75151_b.get(slotId);
            ItemStack itemstack1 = playerinventory.func_70445_o();
            if (!(itemstack1.func_190926_b() || slot != null && slot.func_75216_d() && slot.func_82869_a(player))) {
                int i = dragType == 0 ? 0 : this.field_75151_b.size() - 1;
                int j = dragType == 0 ? 1 : -1;
                for (int k = 0; k < 2; ++k) {
                    for (int l = i; l >= 0 && l < this.field_75151_b.size() && itemstack1.func_190916_E() < itemstack1.func_77976_d(); l += j) {
                        Slot slot1 = this.field_75151_b.get(l);
                        if (!slot1.func_75216_d() || !Container.func_94527_a(slot1, itemstack1, true) || !slot1.func_82869_a(player) || !this.func_94530_a(itemstack1, slot1)) continue;
                        ItemStack itemstack2 = slot1.func_75211_c();
                        if (k == 0 && itemstack2.func_190916_E() == itemstack2.func_77976_d()) continue;
                        int i1 = Math.min(itemstack1.func_77976_d() - itemstack1.func_190916_E(), itemstack2.func_190916_E());
                        ItemStack itemstack3 = slot1.func_75209_a(i1);
                        itemstack1.func_190917_f(i1);
                        if (itemstack3.func_190926_b()) {
                            slot1.func_75215_d(ItemStack.field_190927_a);
                        }
                        slot1.func_190901_a(player, itemstack3);
                    }
                }
            }
            this.func_75142_b();
        }
        return itemstack;
    }

    public static boolean func_195929_a(ItemStack stack1, ItemStack stack2) {
        return stack1.func_77973_b() == stack2.func_77973_b() && ItemStack.func_77970_a(stack1, stack2);
    }

    public boolean func_94530_a(ItemStack stack, Slot slotIn) {
        return true;
    }

    public void func_75134_a(PlayerEntity playerIn) {
        PlayerInventory playerinventory = playerIn.field_71071_by;
        if (!playerinventory.func_70445_o().func_190926_b()) {
            playerIn.func_71019_a(playerinventory.func_70445_o(), false);
            playerinventory.func_70437_b(ItemStack.field_190927_a);
        }
    }

    protected void func_193327_a(PlayerEntity playerIn, World worldIn, IInventory inventoryIn) {
        if (!playerIn.func_70089_S() || playerIn instanceof ServerPlayerEntity && ((ServerPlayerEntity)playerIn).func_193105_t()) {
            for (int j = 0; j < inventoryIn.func_70302_i_(); ++j) {
                playerIn.func_71019_a(inventoryIn.func_70304_b(j), false);
            }
        } else {
            for (int i = 0; i < inventoryIn.func_70302_i_(); ++i) {
                playerIn.field_71071_by.func_191975_a(worldIn, inventoryIn.func_70304_b(i));
            }
        }
    }

    public void func_75130_a(IInventory inventoryIn) {
        this.func_75142_b();
    }

    public void func_75141_a(int slotID, ItemStack stack) {
        this.func_75139_a(slotID).func_75215_d(stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190896_a(List<ItemStack> p_190896_1_) {
        for (int i = 0; i < p_190896_1_.size(); ++i) {
            this.func_75139_a(i).func_75215_d(p_190896_1_.get(i));
        }
    }

    public void func_75137_b(int id, int data) {
        this.field_216964_d.get(id).func_221494_a(data);
    }

    @OnlyIn(value=Dist.CLIENT)
    public short func_75136_a(PlayerInventory invPlayer) {
        this.field_75150_e = (short)(this.field_75150_e + 1);
        return this.field_75150_e;
    }

    public boolean func_75129_b(PlayerEntity player) {
        return !this.field_75148_f.contains((Object)player);
    }

    public void func_75128_a(PlayerEntity player, boolean canCraft) {
        if (canCraft) {
            this.field_75148_f.remove((Object)player);
        } else {
            this.field_75148_f.add(player);
        }
    }

    public abstract boolean func_75145_c(PlayerEntity var1);

    protected boolean func_75135_a(ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
        boolean flag = false;
        int i = startIndex;
        if (reverseDirection) {
            i = endIndex - 1;
        }
        if (stack.func_77985_e()) {
            while (!stack.func_190926_b() && !(!reverseDirection ? i >= endIndex : i < startIndex)) {
                Slot slot = this.field_75151_b.get(i);
                ItemStack itemstack = slot.func_75211_c();
                if (!itemstack.func_190926_b() && Container.func_195929_a(stack, itemstack)) {
                    int maxSize;
                    int j = itemstack.func_190916_E() + stack.func_190916_E();
                    if (j <= (maxSize = Math.min(slot.func_75219_a(), stack.func_77976_d()))) {
                        stack.func_190920_e(0);
                        itemstack.func_190920_e(j);
                        slot.func_75218_e();
                        flag = true;
                    } else if (itemstack.func_190916_E() < maxSize) {
                        stack.func_190918_g(maxSize - itemstack.func_190916_E());
                        itemstack.func_190920_e(maxSize);
                        slot.func_75218_e();
                        flag = true;
                    }
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!stack.func_190926_b()) {
            i = reverseDirection ? endIndex - 1 : startIndex;
            while (!(!reverseDirection ? i >= endIndex : i < startIndex)) {
                Slot slot1 = this.field_75151_b.get(i);
                ItemStack itemstack1 = slot1.func_75211_c();
                if (itemstack1.func_190926_b() && slot1.func_75214_a(stack)) {
                    if (stack.func_190916_E() > slot1.func_75219_a()) {
                        slot1.func_75215_d(stack.func_77979_a(slot1.func_75219_a()));
                    } else {
                        slot1.func_75215_d(stack.func_77979_a(stack.func_190916_E()));
                    }
                    slot1.func_75218_e();
                    flag = true;
                    break;
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return flag;
    }

    public static int func_94529_b(int eventButton) {
        return eventButton >> 2 & 3;
    }

    public static int func_94532_c(int clickedButton) {
        return clickedButton & 3;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static int func_94534_d(int p_94534_0_, int p_94534_1_) {
        return p_94534_0_ & 3 | (p_94534_1_ & 3) << 2;
    }

    public static boolean func_180610_a(int dragModeIn, PlayerEntity player) {
        if (dragModeIn == 0) {
            return true;
        }
        if (dragModeIn == 1) {
            return true;
        }
        return dragModeIn == 2 && player.field_71075_bZ.field_75098_d;
    }

    protected void func_94533_d() {
        this.field_94536_g = 0;
        this.field_94537_h.clear();
    }

    public static boolean func_94527_a(@Nullable Slot slotIn, ItemStack stack, boolean stackSizeMatters) {
        boolean flag;
        boolean bl = flag = slotIn == null || !slotIn.func_75216_d();
        if (!flag && stack.func_77969_a(slotIn.func_75211_c()) && ItemStack.func_77970_a(slotIn.func_75211_c(), stack)) {
            return slotIn.func_75211_c().func_190916_E() + (stackSizeMatters ? 0 : stack.func_190916_E()) <= stack.func_77976_d();
        }
        return flag;
    }

    public static void func_94525_a(Set<Slot> dragSlotsIn, int dragModeIn, ItemStack stack, int slotStackSize) {
        switch (dragModeIn) {
            case 0: {
                stack.func_190920_e(MathHelper.func_76141_d((float)((float)stack.func_190916_E() / (float)dragSlotsIn.size())));
                break;
            }
            case 1: {
                stack.func_190920_e(1);
                break;
            }
            case 2: {
                stack.func_190920_e(stack.func_77976_d());
            }
        }
        stack.func_190917_f(slotStackSize);
    }

    public boolean func_94531_b(Slot slotIn) {
        return true;
    }

    public static int func_178144_a(@Nullable TileEntity te) {
        return te instanceof IInventory ? Container.func_94526_b((IInventory)te) : 0;
    }

    public static int func_94526_b(@Nullable IInventory inv) {
        if (inv == null) {
            return 0;
        }
        int i = 0;
        float f = 0.0f;
        for (int j = 0; j < inv.func_70302_i_(); ++j) {
            ItemStack itemstack = inv.func_70301_a(j);
            if (itemstack.func_190926_b()) continue;
            f += (float)itemstack.func_190916_E() / (float)Math.min(inv.func_70297_j_(), itemstack.func_77976_d());
            ++i;
        }
        return MathHelper.func_76141_d((float)((f /= (float)inv.func_70302_i_()) * 14.0f)) + (i > 0 ? 1 : 0);
    }
}

