/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.projectile;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.FishingRodItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SSpawnObjectPacket;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameterSets;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTables;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.eventbus.api.Event;

public class FishingBobberEntity
extends Entity {
    private static final DataParameter<Integer> field_184528_c = EntityDataManager.func_187226_a(FishingBobberEntity.class, DataSerializers.field_187192_b);
    private boolean field_146051_au;
    private int field_146049_av;
    private final PlayerEntity field_146042_b;
    private int field_146047_aw;
    private int field_146045_ax;
    private int field_146040_ay;
    private int field_146038_az;
    private float field_146054_aA;
    public Entity field_146043_c;
    private State field_190627_av = State.FLYING;
    private final int field_191518_aw;
    private final int field_191519_ax;

    private FishingBobberEntity(World p_i50219_1_, PlayerEntity p_i50219_2_, int p_i50219_3_, int p_i50219_4_) {
        super(EntityType.field_200730_aI, p_i50219_1_);
        this.field_70158_ak = true;
        this.field_146042_b = p_i50219_2_;
        this.field_146042_b.field_71104_cf = this;
        this.field_191518_aw = Math.max(0, p_i50219_3_);
        this.field_191519_ax = Math.max(0, p_i50219_4_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public FishingBobberEntity(World worldIn, PlayerEntity p_i47290_2_, double x, double y, double z) {
        this(worldIn, p_i47290_2_, 0, 0);
        this.func_70107_b(x, y, z);
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
    }

    public FishingBobberEntity(PlayerEntity p_i50220_1_, World p_i50220_2_, int p_i50220_3_, int p_i50220_4_) {
        this(p_i50220_2_, p_i50220_1_, p_i50220_3_, p_i50220_4_);
        float f = this.field_146042_b.field_70125_A;
        float f1 = this.field_146042_b.field_70177_z;
        float f2 = MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -MathHelper.func_76134_b((float)(-f * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76126_a((float)(-f * ((float)Math.PI / 180)));
        double d0 = this.field_146042_b.field_70165_t - (double)f3 * 0.3;
        double d1 = this.field_146042_b.field_70163_u + (double)this.field_146042_b.func_70047_e();
        double d2 = this.field_146042_b.field_70161_v - (double)f2 * 0.3;
        this.func_70012_b(d0, d1, d2, f1, f);
        Vec3d vec3d = new Vec3d(-f3, MathHelper.func_76131_a((float)(-(f5 / f4)), (float)-5.0f, (float)5.0f), -f2);
        double d3 = vec3d.func_72433_c();
        vec3d = vec3d.func_216372_d(0.6 / d3 + 0.5 + this.field_70146_Z.nextGaussian() * 0.0045, 0.6 / d3 + 0.5 + this.field_70146_Z.nextGaussian() * 0.0045, 0.6 / d3 + 0.5 + this.field_70146_Z.nextGaussian() * 0.0045);
        this.func_213317_d(vec3d);
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)vec3d.field_72450_a, (double)vec3d.field_72449_c) * 57.2957763671875);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)vec3d.field_72448_b, (double)MathHelper.func_76133_a((double)FishingBobberEntity.func_213296_b(vec3d))) * 57.2957763671875);
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
    }

    @Override
    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(field_184528_c, 0);
    }

    @Override
    public void func_184206_a(DataParameter<?> key) {
        if (field_184528_c.equals(key)) {
            int i = this.func_184212_Q().func_187225_a(field_184528_c);
            this.field_146043_c = i > 0 ? this.field_70170_p.func_73045_a(i - 1) : null;
        }
        super.func_184206_a(key);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = 64.0;
        return distance < 4096.0;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_146042_b == null) {
            this.func_70106_y();
        } else if (this.field_70170_p.field_72995_K || !this.func_190625_o()) {
            if (this.field_146051_au) {
                ++this.field_146049_av;
                if (this.field_146049_av >= 1200) {
                    this.func_70106_y();
                    return;
                }
            }
            float f = 0.0f;
            BlockPos blockpos = new BlockPos((Entity)this);
            IFluidState ifluidstate = this.field_70170_p.func_204610_c(blockpos);
            if (ifluidstate.func_206884_a(FluidTags.field_206959_a)) {
                f = ifluidstate.func_215679_a((IBlockReader)this.field_70170_p, blockpos);
            }
            if (this.field_190627_av == State.FLYING) {
                if (this.field_146043_c != null) {
                    this.func_213317_d(Vec3d.field_186680_a);
                    this.field_190627_av = State.HOOKED_IN_ENTITY;
                    return;
                }
                if (f > 0.0f) {
                    this.func_213317_d(this.func_213322_ci().func_216372_d(0.3, 0.2, 0.3));
                    this.field_190627_av = State.BOBBING;
                    return;
                }
                if (!this.field_70170_p.field_72995_K) {
                    this.func_190624_r();
                }
                if (!(this.field_146051_au || this.field_70122_E || this.field_70123_F)) {
                    ++this.field_146047_aw;
                } else {
                    this.field_146047_aw = 0;
                    this.func_213317_d(Vec3d.field_186680_a);
                }
            } else {
                if (this.field_190627_av == State.HOOKED_IN_ENTITY) {
                    if (this.field_146043_c != null) {
                        if (this.field_146043_c.field_70128_L) {
                            this.field_146043_c = null;
                            this.field_190627_av = State.FLYING;
                        } else {
                            this.field_70165_t = this.field_146043_c.field_70165_t;
                            this.field_70163_u = this.field_146043_c.func_174813_aQ().field_72338_b + (double)this.field_146043_c.func_213302_cg() * 0.8;
                            this.field_70161_v = this.field_146043_c.field_70161_v;
                            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                        }
                    }
                    return;
                }
                if (this.field_190627_av == State.BOBBING) {
                    Vec3d vec3d = this.func_213322_ci();
                    double d0 = this.field_70163_u + vec3d.field_72448_b - (double)blockpos.func_177956_o() - (double)f;
                    if (Math.abs(d0) < 0.01) {
                        d0 += Math.signum(d0) * 0.1;
                    }
                    this.func_213293_j(vec3d.field_72450_a * 0.9, vec3d.field_72448_b - d0 * (double)this.field_70146_Z.nextFloat() * 0.2, vec3d.field_72449_c * 0.9);
                    if (!this.field_70170_p.field_72995_K && f > 0.0f) {
                        this.func_190621_a(blockpos);
                    }
                }
            }
            if (!ifluidstate.func_206884_a(FluidTags.field_206959_a)) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.03, 0.0));
            }
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_190623_q();
            double d1 = 0.92;
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.92));
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
    }

    private boolean func_190625_o() {
        ItemStack itemstack = this.field_146042_b.func_184614_ca();
        ItemStack itemstack1 = this.field_146042_b.func_184592_cb();
        boolean flag = itemstack.func_77973_b() instanceof FishingRodItem;
        boolean flag1 = itemstack1.func_77973_b() instanceof FishingRodItem;
        if (!this.field_146042_b.field_70128_L && this.field_146042_b.func_70089_S() && (flag || flag1) && !(this.func_70068_e(this.field_146042_b) > 1024.0)) {
            return false;
        }
        this.func_70106_y();
        return true;
    }

    private void func_190623_q() {
        Vec3d vec3d = this.func_213322_ci();
        float f = MathHelper.func_76133_a((double)FishingBobberEntity.func_213296_b(vec3d));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)vec3d.field_72450_a, (double)vec3d.field_72449_c) * 57.2957763671875);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)vec3d.field_72448_b, (double)f) * 57.2957763671875);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = MathHelper.func_219799_g((float)0.2f, (float)this.field_70127_C, (float)this.field_70125_A);
        this.field_70177_z = MathHelper.func_219799_g((float)0.2f, (float)this.field_70126_B, (float)this.field_70177_z);
    }

    private void func_190624_r() {
        RayTraceResult raytraceresult = ProjectileHelper.func_221267_a((Entity)this, (AxisAlignedBB)this.func_174813_aQ().func_216361_a(this.func_213322_ci()).func_186662_g(1.0), p_213856_1_ -> !(p_213856_1_.func_175149_v() || !p_213856_1_.func_70067_L() && !(p_213856_1_ instanceof ItemEntity) || p_213856_1_ == this.field_146042_b && this.field_146047_aw < 5), (RayTraceContext.BlockMode)RayTraceContext.BlockMode.COLLIDER, (boolean)true);
        if (raytraceresult.func_216346_c() != RayTraceResult.Type.MISS) {
            if (raytraceresult.func_216346_c() == RayTraceResult.Type.ENTITY) {
                this.field_146043_c = ((EntityRayTraceResult)raytraceresult).func_216348_a();
                this.func_190622_s();
            } else {
                this.field_146051_au = true;
            }
        }
    }

    private void func_190622_s() {
        this.func_184212_Q().func_187227_b(field_184528_c, this.field_146043_c.func_145782_y() + 1);
    }

    private void func_190621_a(BlockPos p_190621_1_) {
        ServerWorld serverworld = (ServerWorld)this.field_70170_p;
        int i = 1;
        BlockPos blockpos = p_190621_1_.func_177984_a();
        if (this.field_70146_Z.nextFloat() < 0.25f && this.field_70170_p.func_175727_C(blockpos)) {
            ++i;
        }
        if (this.field_70146_Z.nextFloat() < 0.5f && !this.field_70170_p.func_217337_f(blockpos)) {
            --i;
        }
        if (this.field_146045_ax > 0) {
            --this.field_146045_ax;
            if (this.field_146045_ax <= 0) {
                this.field_146040_ay = 0;
                this.field_146038_az = 0;
            } else {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.2 * (double)this.field_70146_Z.nextFloat() * (double)this.field_70146_Z.nextFloat(), 0.0));
            }
        } else if (this.field_146038_az > 0) {
            this.field_146038_az -= i;
            if (this.field_146038_az > 0) {
                this.field_146054_aA = (float)((double)this.field_146054_aA + this.field_70146_Z.nextGaussian() * 4.0);
                float f = this.field_146054_aA * ((float)Math.PI / 180);
                float f1 = MathHelper.func_76126_a((float)f);
                float f2 = MathHelper.func_76134_b((float)f);
                double d0 = this.field_70165_t + (double)(f1 * (float)this.field_146038_az * 0.1f);
                double d1 = (float)MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) + 1.0f;
                double d2 = this.field_70161_v + (double)(f2 * (float)this.field_146038_az * 0.1f);
                Block block = serverworld.func_180495_p(new BlockPos(d0, d1 - 1.0, d2)).func_177230_c();
                if (serverworld.func_180495_p(new BlockPos((int)d0, (int)d1 - 1, (int)d2)).func_185904_a() == Material.field_151586_h) {
                    if (this.field_70146_Z.nextFloat() < 0.15f) {
                        serverworld.func_195598_a(ParticleTypes.field_197612_e, d0, d1 - (double)0.1f, d2, 1, f1, 0.1, f2, 0.0);
                    }
                    float f3 = f1 * 0.04f;
                    float f4 = f2 * 0.04f;
                    serverworld.func_195598_a(ParticleTypes.field_197630_w, d0, d1, d2, 0, f4, 0.01, -f3, 1.0);
                    serverworld.func_195598_a(ParticleTypes.field_197630_w, d0, d1, d2, 0, -f4, 0.01, f3, 1.0);
                }
            } else {
                Vec3d vec3d = this.func_213322_ci();
                this.func_213293_j(vec3d.field_72450_a, -0.4f * MathHelper.func_151240_a((Random)this.field_70146_Z, (float)0.6f, (float)1.0f), vec3d.field_72449_c);
                this.func_184185_a(SoundEvents.field_187609_F, 0.25f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.4f);
                double d3 = this.func_174813_aQ().field_72338_b + 0.5;
                serverworld.func_195598_a(ParticleTypes.field_197612_e, this.field_70165_t, d3, this.field_70161_v, (int)(1.0f + this.func_213311_cf() * 20.0f), this.func_213311_cf(), 0.0, this.func_213311_cf(), 0.2f);
                serverworld.func_195598_a(ParticleTypes.field_197630_w, this.field_70165_t, d3, this.field_70161_v, (int)(1.0f + this.func_213311_cf() * 20.0f), this.func_213311_cf(), 0.0, this.func_213311_cf(), 0.2f);
                this.field_146045_ax = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)20, (int)40);
            }
        } else if (this.field_146040_ay > 0) {
            this.field_146040_ay -= i;
            float f5 = 0.15f;
            if (this.field_146040_ay < 20) {
                f5 = (float)((double)f5 + (double)(20 - this.field_146040_ay) * 0.05);
            } else if (this.field_146040_ay < 40) {
                f5 = (float)((double)f5 + (double)(40 - this.field_146040_ay) * 0.02);
            } else if (this.field_146040_ay < 60) {
                f5 = (float)((double)f5 + (double)(60 - this.field_146040_ay) * 0.01);
            }
            if (this.field_70146_Z.nextFloat() < f5) {
                float f6 = MathHelper.func_151240_a((Random)this.field_70146_Z, (float)0.0f, (float)360.0f) * ((float)Math.PI / 180);
                float f7 = MathHelper.func_151240_a((Random)this.field_70146_Z, (float)25.0f, (float)60.0f);
                double d4 = this.field_70165_t + (double)(MathHelper.func_76126_a((float)f6) * f7 * 0.1f);
                double d5 = (float)MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) + 1.0f;
                double d6 = this.field_70161_v + (double)(MathHelper.func_76134_b((float)f6) * f7 * 0.1f);
                Block block1 = serverworld.func_180495_p(new BlockPos(d4, d5 - 1.0, d6)).func_177230_c();
                if (serverworld.func_180495_p(new BlockPos(d4, d5 - 1.0, d6)).func_185904_a() == Material.field_151586_h) {
                    serverworld.func_195598_a(ParticleTypes.field_218422_X, d4, d5, d6, 2 + this.field_70146_Z.nextInt(2), 0.1f, 0.0, 0.1f, 0.0);
                }
            }
            if (this.field_146040_ay <= 0) {
                this.field_146054_aA = MathHelper.func_151240_a((Random)this.field_70146_Z, (float)0.0f, (float)360.0f);
                this.field_146038_az = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)20, (int)80);
            }
        } else {
            this.field_146040_ay = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)100, (int)600);
            this.field_146040_ay -= this.field_191519_ax * 20 * 5;
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
    }

    public int func_146034_e(ItemStack p_146034_1_) {
        if (!this.field_70170_p.field_72995_K && this.field_146042_b != null) {
            int i = 0;
            ItemFishedEvent event = null;
            if (this.field_146043_c != null) {
                this.func_184527_k();
                CriteriaTriggers.field_204811_D.func_204820_a((ServerPlayerEntity)this.field_146042_b, p_146034_1_, this, Collections.emptyList());
                this.field_70170_p.func_72960_a(this, (byte)31);
                i = this.field_146043_c instanceof ItemEntity ? 3 : 5;
            } else if (this.field_146045_ax > 0) {
                LootContext.Builder lootcontext$builder = new LootContext.Builder((ServerWorld)this.field_70170_p).func_216015_a(LootParameters.field_216286_f, new BlockPos((Entity)this)).func_216015_a(LootParameters.field_216289_i, p_146034_1_).func_216023_a(this.field_70146_Z).func_186469_a((float)this.field_191518_aw + this.field_146042_b.func_184817_da());
                lootcontext$builder.func_216015_a(LootParameters.field_216284_d, this.field_146042_b).func_216015_a(LootParameters.field_216281_a, this);
                LootTable loottable = this.field_70170_p.func_73046_m().func_200249_aQ().func_186521_a(LootTables.field_186387_al);
                List<ItemStack> list = loottable.func_216113_a(lootcontext$builder.func_216022_a(LootParameterSets.field_216262_c));
                event = new ItemFishedEvent(list, this.field_146051_au ? 2 : 1, this);
                MinecraftForge.EVENT_BUS.post((Event)event);
                if (event.isCanceled()) {
                    this.func_70106_y();
                    return event.getRodDamage();
                }
                CriteriaTriggers.field_204811_D.func_204820_a((ServerPlayerEntity)this.field_146042_b, p_146034_1_, this, list);
                for (ItemStack itemstack : list) {
                    ItemEntity itementity = new ItemEntity(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, itemstack);
                    double d0 = this.field_146042_b.field_70165_t - this.field_70165_t;
                    double d1 = this.field_146042_b.field_70163_u - this.field_70163_u;
                    double d2 = this.field_146042_b.field_70161_v - this.field_70161_v;
                    double d3 = 0.1;
                    itementity.func_213293_j(d0 * 0.1, d1 * 0.1 + Math.sqrt(Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2)) * 0.08, d2 * 0.1);
                    this.field_70170_p.func_217376_c(itementity);
                    this.field_146042_b.field_70170_p.func_217376_c(new ExperienceOrbEntity(this.field_146042_b.field_70170_p, this.field_146042_b.field_70165_t, this.field_146042_b.field_70163_u + 0.5, this.field_146042_b.field_70161_v + 0.5, this.field_70146_Z.nextInt(6) + 1));
                    if (!itemstack.func_77973_b().func_206844_a(ItemTags.field_206964_G)) continue;
                    this.field_146042_b.func_195067_a(Stats.field_188071_E, 1);
                }
                i = 1;
            }
            if (this.field_146051_au) {
                i = 2;
            }
            this.func_70106_y();
            return event == null ? i : event.getRodDamage();
        }
        return 0;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 31 && this.field_70170_p.field_72995_K && this.field_146043_c instanceof PlayerEntity && ((PlayerEntity)this.field_146043_c).func_175144_cb()) {
            this.func_184527_k();
        }
        super.func_70103_a(id);
    }

    protected void func_184527_k() {
        if (this.field_146042_b != null) {
            Vec3d vec3d = new Vec3d(this.field_146042_b.field_70165_t - this.field_70165_t, this.field_146042_b.field_70163_u - this.field_70163_u, this.field_146042_b.field_70161_v - this.field_70161_v).func_186678_a(0.1);
            this.field_146043_c.func_213317_d(this.field_146043_c.func_213322_ci().func_178787_e(vec3d));
        }
    }

    @Override
    protected boolean func_70041_e_() {
        return false;
    }

    @Override
    public void remove(boolean keepData) {
        super.remove(keepData);
        if (this.field_146042_b != null) {
            this.field_146042_b.field_71104_cf = null;
        }
    }

    @Nullable
    public PlayerEntity func_190619_l() {
        return this.field_146042_b;
    }

    @Override
    public boolean func_184222_aU() {
        return false;
    }

    @Override
    public IPacket<?> func_213297_N() {
        PlayerEntity entity = this.func_190619_l();
        return new SSpawnObjectPacket((Entity)this, entity == null ? this.func_145782_y() : entity.func_145782_y());
    }

    static enum State {
        FLYING,
        HOOKED_IN_ENTITY,
        BOBBING;

    }
}

