/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.enchantment;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.enchantment.SweepingEnchantment;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.apache.commons.lang3.mutable.MutableInt;

public class EnchantmentHelper {
    public static int func_77506_a(Enchantment enchID, ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        ResourceLocation resourcelocation = Registry.field_212628_q.func_177774_c(enchID);
        ListNBT listnbt = stack.func_77986_q();
        for (int i = 0; i < listnbt.size(); ++i) {
            CompoundNBT compoundnbt = listnbt.func_150305_b(i);
            ResourceLocation resourcelocation1 = ResourceLocation.func_208304_a((String)compoundnbt.func_74779_i("id"));
            if (resourcelocation1 == null || !resourcelocation1.equals((Object)resourcelocation)) continue;
            return compoundnbt.func_74762_e("lvl");
        }
        return 0;
    }

    public static Map<Enchantment, Integer> func_82781_a(ItemStack stack) {
        LinkedHashMap map = Maps.newLinkedHashMap();
        ListNBT listnbt = stack.func_77973_b() == Items.field_151134_bR ? EnchantedBookItem.func_92110_g((ItemStack)stack) : stack.func_77986_q();
        for (int i = 0; i < listnbt.size(); ++i) {
            CompoundNBT compoundnbt = listnbt.func_150305_b(i);
            Registry.field_212628_q.func_218349_b(ResourceLocation.func_208304_a((String)compoundnbt.func_74779_i("id"))).ifPresent(p_222185_2_ -> {
                Integer integer = map.put(p_222185_2_, compoundnbt.func_74762_e("lvl"));
            });
        }
        return map;
    }

    public static void func_82782_a(Map<Enchantment, Integer> enchMap, ItemStack stack) {
        ListNBT listnbt = new ListNBT();
        for (Map.Entry<Enchantment, Integer> entry : enchMap.entrySet()) {
            Enchantment enchantment = entry.getKey();
            if (enchantment == null) continue;
            int i = entry.getValue();
            CompoundNBT compoundnbt = new CompoundNBT();
            compoundnbt.func_74778_a("id", String.valueOf(Registry.field_212628_q.func_177774_c(enchantment)));
            compoundnbt.func_74777_a("lvl", (short)i);
            listnbt.add((Object)compoundnbt);
            if (stack.func_77973_b() != Items.field_151134_bR) continue;
            EnchantedBookItem.func_92115_a((ItemStack)stack, (EnchantmentData)new EnchantmentData(enchantment, i));
        }
        if (listnbt.isEmpty()) {
            stack.func_196083_e("Enchantments");
        } else if (stack.func_77973_b() != Items.field_151134_bR) {
            stack.func_77983_a("Enchantments", (INBT)listnbt);
        }
    }

    private static void func_77518_a(IEnchantmentVisitor modifier, ItemStack stack) {
        if (!stack.func_190926_b()) {
            ListNBT listnbt = stack.func_77986_q();
            for (int i = 0; i < listnbt.size(); ++i) {
                String s = listnbt.func_150305_b(i).func_74779_i("id");
                int j = listnbt.func_150305_b(i).func_74762_e("lvl");
                Registry.field_212628_q.func_218349_b(ResourceLocation.func_208304_a((String)s)).ifPresent(p_222184_2_ -> modifier.accept((Enchantment)((Object)p_222184_2_), j));
            }
        }
    }

    private static void func_77516_a(IEnchantmentVisitor modifier, Iterable<ItemStack> stacks) {
        for (ItemStack itemstack : stacks) {
            EnchantmentHelper.func_77518_a(modifier, itemstack);
        }
    }

    public static int func_77508_a(Iterable<ItemStack> stacks, DamageSource source) {
        MutableInt mutableint = new MutableInt();
        EnchantmentHelper.func_77516_a((p_212576_2_, p_212576_3_) -> mutableint.add(p_212576_2_.func_77318_a(p_212576_3_, source)), stacks);
        return mutableint.intValue();
    }

    public static float func_152377_a(ItemStack stack, CreatureAttribute creatureAttribute) {
        MutableFloat mutablefloat = new MutableFloat();
        EnchantmentHelper.func_77518_a((p_212573_2_, p_212573_3_) -> mutablefloat.add(p_212573_2_.func_152376_a(p_212573_3_, creatureAttribute)), stack);
        return mutablefloat.floatValue();
    }

    public static float func_191527_a(LivingEntity entityIn) {
        int i = EnchantmentHelper.func_185284_a(Enchantments.field_191530_r, entityIn);
        return i > 0 ? SweepingEnchantment.func_191526_e((int)i) : 0.0f;
    }

    public static void func_151384_a(LivingEntity user, Entity attacker) {
        IEnchantmentVisitor enchantmenthelper$ienchantmentvisitor = (p_212575_2_, p_212575_3_) -> p_212575_2_.func_151367_b(user, attacker, p_212575_3_);
        if (user != null) {
            EnchantmentHelper.func_77516_a(enchantmenthelper$ienchantmentvisitor, user.func_184209_aF());
        }
        if (attacker instanceof PlayerEntity) {
            EnchantmentHelper.func_77518_a(enchantmenthelper$ienchantmentvisitor, user.func_184614_ca());
        }
    }

    public static void func_151385_b(LivingEntity user, Entity target) {
        IEnchantmentVisitor enchantmenthelper$ienchantmentvisitor = (p_212574_2_, p_212574_3_) -> p_212574_2_.func_151368_a(user, target, p_212574_3_);
        if (user != null) {
            EnchantmentHelper.func_77516_a(enchantmenthelper$ienchantmentvisitor, user.func_184209_aF());
        }
        if (user instanceof PlayerEntity) {
            EnchantmentHelper.func_77518_a(enchantmenthelper$ienchantmentvisitor, user.func_184614_ca());
        }
    }

    public static int func_185284_a(Enchantment enchantmentIn, LivingEntity entityIn) {
        Collection<ItemStack> iterable = enchantmentIn.func_222181_a(entityIn).values();
        if (iterable == null) {
            return 0;
        }
        int i = 0;
        for (ItemStack itemstack : iterable) {
            int j = EnchantmentHelper.func_77506_a(enchantmentIn, itemstack);
            if (j <= i) continue;
            i = j;
        }
        return i;
    }

    public static int func_77501_a(LivingEntity player) {
        return EnchantmentHelper.func_185284_a(Enchantments.field_180313_o, player);
    }

    public static int func_90036_a(LivingEntity player) {
        return EnchantmentHelper.func_185284_a(Enchantments.field_77334_n, player);
    }

    public static int func_185292_c(LivingEntity entityIn) {
        return EnchantmentHelper.func_185284_a(Enchantments.field_185298_f, entityIn);
    }

    public static int func_185294_d(LivingEntity entityIn) {
        return EnchantmentHelper.func_185284_a(Enchantments.field_185300_i, entityIn);
    }

    public static int func_185293_e(LivingEntity entityIn) {
        return EnchantmentHelper.func_185284_a(Enchantments.field_185305_q, entityIn);
    }

    public static int func_191529_b(ItemStack stack) {
        return EnchantmentHelper.func_77506_a(Enchantments.field_151370_z, stack);
    }

    public static int func_191528_c(ItemStack stack) {
        return EnchantmentHelper.func_77506_a(Enchantments.field_151369_A, stack);
    }

    public static int func_185283_h(LivingEntity entityIn) {
        return EnchantmentHelper.func_185284_a(Enchantments.field_185304_p, entityIn);
    }

    public static boolean func_185287_i(LivingEntity entityIn) {
        return EnchantmentHelper.func_185284_a(Enchantments.field_185299_g, entityIn) > 0;
    }

    public static boolean func_189869_j(LivingEntity player) {
        return EnchantmentHelper.func_185284_a(Enchantments.field_185301_j, player) > 0;
    }

    public static boolean func_190938_b(ItemStack stack) {
        return EnchantmentHelper.func_77506_a(Enchantments.field_190941_k, stack) > 0;
    }

    public static boolean func_190939_c(ItemStack stack) {
        return EnchantmentHelper.func_77506_a(Enchantments.field_190940_C, stack) > 0;
    }

    public static int func_203191_f(ItemStack stack) {
        return EnchantmentHelper.func_77506_a(Enchantments.field_203193_C, stack);
    }

    public static int func_203190_g(ItemStack stack) {
        return EnchantmentHelper.func_77506_a(Enchantments.field_203195_E, stack);
    }

    public static boolean func_203192_h(ItemStack stack) {
        return EnchantmentHelper.func_77506_a(Enchantments.field_203196_F, stack) > 0;
    }

    @Nullable
    public static Map.Entry<EquipmentSlotType, ItemStack> func_222189_b(Enchantment p_222189_0_, LivingEntity p_222189_1_) {
        Map<EquipmentSlotType, ItemStack> map = p_222189_0_.func_222181_a(p_222189_1_);
        if (map.isEmpty()) {
            return null;
        }
        ArrayList list = Lists.newArrayList();
        for (Map.Entry<EquipmentSlotType, ItemStack> entry : map.entrySet()) {
            ItemStack itemstack = entry.getValue();
            if (itemstack.func_190926_b() || EnchantmentHelper.func_77506_a(p_222189_0_, itemstack) <= 0) continue;
            list.add(entry);
        }
        return list.isEmpty() ? null : (Map.Entry)list.get(p_222189_1_.func_70681_au().nextInt(list.size()));
    }

    public static int func_77514_a(Random rand, int enchantNum, int power, ItemStack stack) {
        Item item = stack.func_77973_b();
        int i = stack.getItemEnchantability();
        if (i <= 0) {
            return 0;
        }
        if (power > 15) {
            power = 15;
        }
        int j = rand.nextInt(8) + 1 + (power >> 1) + rand.nextInt(power + 1);
        if (enchantNum == 0) {
            return Math.max(j / 3, 1);
        }
        return enchantNum == 1 ? j * 2 / 3 + 1 : Math.max(j, power * 2);
    }

    public static ItemStack func_77504_a(Random random, ItemStack stack, int level, boolean allowTreasure) {
        boolean flag;
        List<EnchantmentData> list = EnchantmentHelper.func_77513_b(random, stack, level, allowTreasure);
        boolean bl = flag = stack.func_77973_b() == Items.field_151122_aG;
        if (flag) {
            stack = new ItemStack(Items.field_151134_bR);
        }
        for (EnchantmentData enchantmentdata : list) {
            if (flag) {
                EnchantedBookItem.func_92115_a((ItemStack)stack, (EnchantmentData)enchantmentdata);
                continue;
            }
            stack.func_77966_a(enchantmentdata.field_76302_b, enchantmentdata.field_76303_c);
        }
        return stack;
    }

    public static List<EnchantmentData> func_77513_b(Random randomIn, ItemStack itemStackIn, int level, boolean allowTreasure) {
        ArrayList list = Lists.newArrayList();
        Item item = itemStackIn.func_77973_b();
        int i = itemStackIn.getItemEnchantability();
        if (i <= 0) {
            return list;
        }
        level = level + 1 + randomIn.nextInt(i / 4 + 1) + randomIn.nextInt(i / 4 + 1);
        float f = (randomIn.nextFloat() + randomIn.nextFloat() - 1.0f) * 0.15f;
        List<EnchantmentData> list1 = EnchantmentHelper.func_185291_a(level = MathHelper.func_76125_a((int)Math.round((float)level + (float)level * f), (int)1, (int)Integer.MAX_VALUE), itemStackIn, allowTreasure);
        if (!list1.isEmpty()) {
            list.add(WeightedRandom.func_76271_a((Random)randomIn, list1));
            while (randomIn.nextInt(50) <= level) {
                EnchantmentHelper.func_185282_a(list1, (EnchantmentData)Util.func_223378_a((List)list));
                if (list1.isEmpty()) break;
                list.add(WeightedRandom.func_76271_a((Random)randomIn, list1));
                level /= 2;
            }
        }
        return list;
    }

    public static void func_185282_a(List<EnchantmentData> dataList, EnchantmentData data) {
        Iterator<EnchantmentData> iterator = dataList.iterator();
        while (iterator.hasNext()) {
            if (data.field_76302_b.func_191560_c(iterator.next().field_76302_b)) continue;
            iterator.remove();
        }
    }

    public static boolean func_201840_a(Collection<Enchantment> enchantmentsIn, Enchantment enchantmentIn) {
        for (Enchantment enchantment : enchantmentsIn) {
            if (enchantment.func_191560_c(enchantmentIn)) continue;
            return false;
        }
        return true;
    }

    public static List<EnchantmentData> func_185291_a(int p_185291_0_, ItemStack stack, boolean allowTreasure) {
        ArrayList list = Lists.newArrayList();
        Item item = stack.func_77973_b();
        boolean flag = stack.func_77973_b() == Items.field_151122_aG;
        Iterator iterator = Registry.field_212628_q.iterator();
        block0: while (iterator.hasNext()) {
            Enchantment enchantment = (Enchantment)((Object)iterator.next());
            if (enchantment.func_185261_e() && !allowTreasure || !enchantment.canApplyAtEnchantingTable(stack) && (!flag || !enchantment.isAllowedOnBooks())) continue;
            for (int i = enchantment.func_77325_b(); i > enchantment.func_77319_d() - 1; --i) {
                if (p_185291_0_ < enchantment.func_77321_a(i) || p_185291_0_ > enchantment.func_223551_b(i)) continue;
                list.add(new EnchantmentData(enchantment, i));
                continue block0;
            }
        }
        return list;
    }

    @FunctionalInterface
    static interface IEnchantmentVisitor {
        public void accept(Enchantment var1, int var2);
    }
}

