/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.tileentity;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.model.ShulkerModel;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.tileentity.BannerTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.BeaconTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.BedTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.BellTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.CampfireTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.ChestTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.ConduitTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.EnchantmentTableTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.EndGatewayTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.EndPortalTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.LecternTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.MobSpawnerTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.PistonTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.ShulkerBoxTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.SignTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.SkullTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.StructureTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.tileentity.BannerTileEntity;
import net.minecraft.tileentity.BeaconTileEntity;
import net.minecraft.tileentity.BedTileEntity;
import net.minecraft.tileentity.BellTileEntity;
import net.minecraft.tileentity.CampfireTileEntity;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.ConduitTileEntity;
import net.minecraft.tileentity.EnchantingTableTileEntity;
import net.minecraft.tileentity.EndGatewayTileEntity;
import net.minecraft.tileentity.EndPortalTileEntity;
import net.minecraft.tileentity.EnderChestTileEntity;
import net.minecraft.tileentity.LecternTileEntity;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.PistonTileEntity;
import net.minecraft.tileentity.ShulkerBoxTileEntity;
import net.minecraft.tileentity.SignTileEntity;
import net.minecraft.tileentity.SkullTileEntity;
import net.minecraft.tileentity.StructureBlockTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TileEntityRendererDispatcher {
    private final Map<Class<? extends TileEntity>, TileEntityRenderer<? extends TileEntity>> field_147559_m = Maps.newHashMap();
    public static final TileEntityRendererDispatcher field_147556_a = new TileEntityRendererDispatcher();
    public FontRenderer field_147557_n;
    public static double field_147554_b;
    public static double field_147555_c;
    public static double field_147552_d;
    public TextureManager field_147553_e;
    public World field_147550_f;
    public ActiveRenderInfo field_217666_g;
    public RayTraceResult field_190057_j;
    private Tessellator batchBuffer = new Tessellator(0x200000);
    private boolean drawingBatch = false;

    private TileEntityRendererDispatcher() {
        this.field_147559_m.put(SignTileEntity.class, (TileEntityRenderer<? extends TileEntity>)new SignTileEntityRenderer());
        this.field_147559_m.put(MobSpawnerTileEntity.class, (TileEntityRenderer<? extends TileEntity>)new MobSpawnerTileEntityRenderer());
        this.field_147559_m.put(PistonTileEntity.class, new PistonTileEntityRenderer());
        this.field_147559_m.put(ChestTileEntity.class, (TileEntityRenderer<? extends TileEntity>)new ChestTileEntityRenderer());
        this.field_147559_m.put(EnderChestTileEntity.class, (TileEntityRenderer<? extends TileEntity>)new ChestTileEntityRenderer());
        this.field_147559_m.put(EnchantingTableTileEntity.class, (TileEntityRenderer<? extends TileEntity>)new EnchantmentTableTileEntityRenderer());
        this.field_147559_m.put(LecternTileEntity.class, (TileEntityRenderer<? extends TileEntity>)new LecternTileEntityRenderer());
        this.field_147559_m.put(EndPortalTileEntity.class, (TileEntityRenderer<? extends TileEntity>)new EndPortalTileEntityRenderer());
        this.field_147559_m.put(EndGatewayTileEntity.class, (TileEntityRenderer<? extends TileEntity>)new EndGatewayTileEntityRenderer());
        this.field_147559_m.put(BeaconTileEntity.class, (TileEntityRenderer<? extends TileEntity>)new BeaconTileEntityRenderer());
        this.field_147559_m.put(SkullTileEntity.class, (TileEntityRenderer<? extends TileEntity>)new SkullTileEntityRenderer());
        this.field_147559_m.put(BannerTileEntity.class, (TileEntityRenderer<? extends TileEntity>)new BannerTileEntityRenderer());
        this.field_147559_m.put(StructureBlockTileEntity.class, (TileEntityRenderer<? extends TileEntity>)new StructureTileEntityRenderer());
        this.field_147559_m.put(ShulkerBoxTileEntity.class, (TileEntityRenderer<? extends TileEntity>)new ShulkerBoxTileEntityRenderer(new ShulkerModel()));
        this.field_147559_m.put(BedTileEntity.class, (TileEntityRenderer<? extends TileEntity>)new BedTileEntityRenderer());
        this.field_147559_m.put(ConduitTileEntity.class, (TileEntityRenderer<? extends TileEntity>)new ConduitTileEntityRenderer());
        this.field_147559_m.put(BellTileEntity.class, (TileEntityRenderer<? extends TileEntity>)new BellTileEntityRenderer());
        this.field_147559_m.put(CampfireTileEntity.class, (TileEntityRenderer<? extends TileEntity>)new CampfireTileEntityRenderer());
        for (TileEntityRenderer<? extends TileEntity> tileentityrenderer : this.field_147559_m.values()) {
            tileentityrenderer.func_147497_a(this);
        }
    }

    public <T extends TileEntity> TileEntityRenderer<T> func_147546_a(Class<? extends TileEntity> teClass) {
        TileEntityRenderer<TileEntity> tileentityrenderer = this.field_147559_m.get(teClass);
        if (tileentityrenderer == null && teClass != TileEntity.class) {
            tileentityrenderer = this.func_147546_a(teClass.getSuperclass());
            this.field_147559_m.put(teClass, tileentityrenderer);
        }
        return tileentityrenderer;
    }

    @Nullable
    public <T extends TileEntity> TileEntityRenderer<T> func_147547_b(@Nullable TileEntity tileEntityIn) {
        return tileEntityIn == null || tileEntityIn.func_145837_r() ? null : this.func_147546_a(((Object)((Object)tileEntityIn)).getClass());
    }

    public void func_217665_a(World p_217665_1_, TextureManager p_217665_2_, FontRenderer p_217665_3_, ActiveRenderInfo p_217665_4_, RayTraceResult p_217665_5_) {
        if (this.field_147550_f != p_217665_1_) {
            this.func_147543_a(p_217665_1_);
        }
        this.field_147553_e = p_217665_2_;
        this.field_217666_g = p_217665_4_;
        this.field_147557_n = p_217665_3_;
        this.field_190057_j = p_217665_5_;
    }

    public void func_180546_a(TileEntity tileentityIn, float partialTicks, int destroyStage) {
        if (tileentityIn.func_145835_a(this.field_217666_g.func_216785_c().field_72450_a, this.field_217666_g.func_216785_c().field_72448_b, this.field_217666_g.func_216785_c().field_72449_c) < tileentityIn.func_145833_n()) {
            if (!this.drawingBatch || !tileentityIn.hasFastRenderer()) {
                RenderHelper.func_74519_b();
                int i = this.field_147550_f.func_217338_b(tileentityIn.func_174877_v(), 0);
                int j = i % 65536;
                int k = i / 65536;
                GLX.glMultiTexCoord2f(GLX.GL_TEXTURE1, j, k);
                GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            BlockPos blockpos = tileentityIn.func_174877_v();
            this.func_203602_a(tileentityIn, (double)blockpos.func_177958_n() - field_147554_b, (double)blockpos.func_177956_o() - field_147555_c, (double)blockpos.func_177952_p() - field_147552_d, partialTicks, destroyStage, false);
        }
    }

    public void func_147549_a(TileEntity tileEntityIn, double x, double y, double z, float partialTicks) {
        this.func_203602_a(tileEntityIn, x, y, z, partialTicks, -1, false);
    }

    public void func_203601_b(TileEntity tileEntityIn) {
        this.func_203602_a(tileEntityIn, 0.0, 0.0, 0.0, 0.0f, -1, true);
    }

    public void func_203602_a(TileEntity tileEntityIn, double x, double y, double z, float partialTicks, int destroyStage, boolean hasNoBlock) {
        TileEntityRenderer<TileEntity> tileentityrenderer = this.func_147547_b(tileEntityIn);
        if (tileentityrenderer != null) {
            try {
                if (hasNoBlock || tileEntityIn.func_145830_o() && tileEntityIn.func_200662_C().func_223045_a(tileEntityIn.func_195044_w().func_177230_c())) {
                    if (this.drawingBatch && tileEntityIn.hasFastRenderer()) {
                        tileentityrenderer.renderTileEntityFast(tileEntityIn, x, y, z, partialTicks, destroyStage, this.batchBuffer.func_178180_c());
                    } else {
                        tileentityrenderer.func_199341_a(tileEntityIn, x, y, z, partialTicks, destroyStage);
                    }
                }
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.func_85055_a(throwable, "Rendering Block Entity");
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("Block Entity Details");
                tileEntityIn.func_145828_a(crashreportcategory);
                throw new ReportedException(crashreport);
            }
        }
    }

    public void func_147543_a(@Nullable World worldIn) {
        this.field_147550_f = worldIn;
        if (worldIn == null) {
            this.field_217666_g = null;
        }
    }

    public FontRenderer func_147548_a() {
        return this.field_147557_n;
    }

    public void preDrawBatch() {
        this.batchBuffer.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_176600_a);
        this.drawingBatch = true;
    }

    public void drawBatch() {
        this.field_147553_e.func_110577_a(AtlasTexture.field_110575_b);
        RenderHelper.func_74518_a();
        GlStateManager.blendFunc((int)770, (int)771);
        GlStateManager.enableBlend();
        GlStateManager.disableCull();
        if (Minecraft.func_71379_u()) {
            GlStateManager.shadeModel((int)7425);
        } else {
            GlStateManager.shadeModel((int)7424);
        }
        this.batchBuffer.func_78381_a();
        RenderHelper.func_74519_b();
        this.drawingBatch = false;
    }

    public synchronized <T extends TileEntity> void setSpecialRenderer(Class<T> tileEntityClass, TileEntityRenderer<? super T> specialRenderer) {
        this.field_147559_m.put(tileEntityClass, specialRenderer);
    }
}

