/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.multiplayer;

import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.SectionPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.AbstractChunkProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.EmptyChunk;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.chunk.IChunkLightProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.lighting.WorldLightManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.eventbus.api.Event;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ClientChunkProvider
extends AbstractChunkProvider {
    private static final Logger field_147436_a = LogManager.getLogger();
    private final Chunk field_73238_a;
    private final WorldLightManager field_217255_c;
    private volatile ChunkArray field_217256_d;
    private final ClientWorld field_73235_d;

    public ClientChunkProvider(ClientWorld p_i51057_1_, int viewDistance) {
        this.field_73235_d = p_i51057_1_;
        this.field_73238_a = new EmptyChunk((World)p_i51057_1_, new ChunkPos(0, 0));
        this.field_217255_c = new WorldLightManager((IChunkLightProvider)this, true, p_i51057_1_.func_201675_m().func_191066_m());
        this.field_217256_d = new ChunkArray(ClientChunkProvider.func_217254_b(viewDistance));
    }

    public WorldLightManager func_212863_j_() {
        return this.field_217255_c;
    }

    private static boolean func_217249_a(@Nullable Chunk p_217249_0_, int p_217249_1_, int p_217249_2_) {
        if (p_217249_0_ == null) {
            return false;
        }
        ChunkPos chunkpos = p_217249_0_.func_76632_l();
        return chunkpos.field_77276_a == p_217249_1_ && chunkpos.field_77275_b == p_217249_2_;
    }

    public void func_73234_b(int x, int z) {
        int i;
        Chunk chunk;
        if (this.field_217256_d.func_217183_b(x, z) && ClientChunkProvider.func_217249_a(chunk = this.field_217256_d.func_217192_a(i = this.field_217256_d.func_217191_a(x, z)), x, z)) {
            this.field_217256_d.func_217190_a(i, chunk, null);
        }
    }

    @Nullable
    public Chunk func_212849_a_(int chunkX, int chunkZ, ChunkStatus requiredStatus, boolean load) {
        Chunk chunk;
        if (this.field_217256_d.func_217183_b(chunkX, chunkZ) && ClientChunkProvider.func_217249_a(chunk = this.field_217256_d.func_217192_a(this.field_217256_d.func_217191_a(chunkX, chunkZ)), chunkX, chunkZ)) {
            MinecraftForge.EVENT_BUS.post((Event)new ChunkEvent.Load((IChunk)chunk));
            return chunk;
        }
        return load ? this.field_73238_a : null;
    }

    public IBlockReader func_212864_k_() {
        return this.field_73235_d;
    }

    @Nullable
    public Chunk func_217250_a(World p_217250_1_, int p_217250_2_, int p_217250_3_, PacketBuffer p_217250_4_, CompoundNBT p_217250_5_, int p_217250_6_, boolean p_217250_7_) {
        if (!this.field_217256_d.func_217183_b(p_217250_2_, p_217250_3_)) {
            field_147436_a.warn("Ignoring chunk since it's not in the view range: {}, {}", (Object)p_217250_2_, (Object)p_217250_3_);
            return null;
        }
        int i = this.field_217256_d.func_217191_a(p_217250_2_, p_217250_3_);
        Chunk chunk = (Chunk)this.field_217256_d.field_217195_b.get(i);
        if (!ClientChunkProvider.func_217249_a(chunk, p_217250_2_, p_217250_3_)) {
            if (!p_217250_7_) {
                field_147436_a.warn("Ignoring chunk since we don't have complete data: {}, {}", (Object)p_217250_2_, (Object)p_217250_3_);
                return null;
            }
            chunk = new Chunk(p_217250_1_, new ChunkPos(p_217250_2_, p_217250_3_), new Biome[256]);
            chunk.func_217326_a(p_217250_4_, p_217250_5_, p_217250_6_, p_217250_7_);
            this.field_217256_d.func_217181_a(i, chunk);
        } else {
            chunk.func_217326_a(p_217250_4_, p_217250_5_, p_217250_6_, p_217250_7_);
        }
        ChunkSection[] achunksection = chunk.func_76587_i();
        WorldLightManager worldlightmanager = this.func_212863_j_();
        worldlightmanager.func_215571_a(new ChunkPos(p_217250_2_, p_217250_3_), true);
        for (int j = 0; j < achunksection.length; ++j) {
            ChunkSection chunksection = achunksection[j];
            worldlightmanager.func_215566_a(SectionPos.func_218154_a((int)p_217250_2_, (int)j, (int)p_217250_3_), ChunkSection.func_222628_a((ChunkSection)chunksection));
        }
        return chunk;
    }

    public void func_217207_a(BooleanSupplier hasTimeLeft) {
    }

    public void func_217251_d(int p_217251_1_, int p_217251_2_) {
        this.field_217256_d.field_217198_e = p_217251_1_;
        this.field_217256_d.field_217199_f = p_217251_2_;
    }

    public void func_217248_a(int p_217248_1_) {
        int j;
        int i = this.field_217256_d.field_217196_c;
        if (i != (j = ClientChunkProvider.func_217254_b(p_217248_1_))) {
            ChunkArray clientchunkprovider$chunkarray = new ChunkArray(j);
            clientchunkprovider$chunkarray.field_217198_e = this.field_217256_d.field_217198_e;
            clientchunkprovider$chunkarray.field_217199_f = this.field_217256_d.field_217199_f;
            for (int k = 0; k < this.field_217256_d.field_217195_b.length(); ++k) {
                Chunk chunk = (Chunk)this.field_217256_d.field_217195_b.get(k);
                if (chunk == null) continue;
                ChunkPos chunkpos = chunk.func_76632_l();
                if (!clientchunkprovider$chunkarray.func_217183_b(chunkpos.field_77276_a, chunkpos.field_77275_b)) continue;
                clientchunkprovider$chunkarray.func_217181_a(clientchunkprovider$chunkarray.func_217191_a(chunkpos.field_77276_a, chunkpos.field_77275_b), chunk);
            }
            this.field_217256_d = clientchunkprovider$chunkarray;
        }
    }

    private static int func_217254_b(int p_217254_0_) {
        return Math.max(2, p_217254_0_) + 3;
    }

    public String func_73148_d() {
        return "Client Chunk Cache: " + this.field_217256_d.field_217195_b.length() + ", " + this.func_217252_g();
    }

    public ChunkGenerator<?> func_201711_g() {
        return null;
    }

    public int func_217252_g() {
        return this.field_217256_d.field_217200_g;
    }

    public void func_217201_a(LightType type, SectionPos pos) {
        Minecraft.func_71410_x().field_71438_f.func_215328_b(pos.func_218149_a(), pos.func_218163_b(), pos.func_218148_c());
    }

    public boolean func_222866_a(BlockPos pos) {
        return this.func_73149_a(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
    }

    public boolean func_222865_a(ChunkPos pos) {
        return this.func_73149_a(pos.field_77276_a, pos.field_77275_b);
    }

    public boolean func_217204_a(Entity entityIn) {
        return this.func_73149_a(MathHelper.func_76128_c((double)entityIn.field_70165_t) >> 4, MathHelper.func_76128_c((double)entityIn.field_70161_v) >> 4);
    }

    @OnlyIn(value=Dist.CLIENT)
    final class ChunkArray {
        private final AtomicReferenceArray<Chunk> field_217195_b;
        private final int field_217196_c;
        private final int field_217197_d;
        private volatile int field_217198_e;
        private volatile int field_217199_f;
        private int field_217200_g;

        private ChunkArray(int p_i50568_2_) {
            this.field_217196_c = p_i50568_2_;
            this.field_217197_d = p_i50568_2_ * 2 + 1;
            this.field_217195_b = new AtomicReferenceArray(this.field_217197_d * this.field_217197_d);
        }

        private int func_217191_a(int x, int z) {
            return Math.floorMod(z, this.field_217197_d) * this.field_217197_d + Math.floorMod(x, this.field_217197_d);
        }

        protected void func_217181_a(int p_217181_1_, @Nullable Chunk p_217181_2_) {
            Chunk chunk = this.field_217195_b.getAndSet(p_217181_1_, p_217181_2_);
            if (chunk != null) {
                --this.field_217200_g;
                ClientChunkProvider.this.field_73235_d.func_217409_a(chunk);
            }
            if (p_217181_2_ != null) {
                ++this.field_217200_g;
            }
        }

        protected Chunk func_217190_a(int p_217190_1_, Chunk p_217190_2_, @Nullable Chunk p_217190_3_) {
            if (this.field_217195_b.compareAndSet(p_217190_1_, p_217190_2_, p_217190_3_) && p_217190_3_ == null) {
                --this.field_217200_g;
            }
            ClientChunkProvider.this.field_73235_d.func_217409_a(p_217190_2_);
            return p_217190_2_;
        }

        private boolean func_217183_b(int p_217183_1_, int p_217183_2_) {
            return Math.abs(p_217183_1_ - this.field_217198_e) <= this.field_217196_c && Math.abs(p_217183_2_ - this.field_217199_f) <= this.field_217196_c;
        }

        @Nullable
        protected Chunk func_217192_a(int p_217192_1_) {
            return this.field_217195_b.get(p_217192_1_);
        }
    }
}

