/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.audio;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.client.GameSettings;
import net.minecraft.client.audio.AudioStreamManager;
import net.minecraft.client.audio.ChannelManager;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.ISoundEventListener;
import net.minecraft.client.audio.ITickableSound;
import net.minecraft.client.audio.Listener;
import net.minecraft.client.audio.Sound;
import net.minecraft.client.audio.SoundEngineExecutor;
import net.minecraft.client.audio.SoundEventAccessor;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.audio.SoundSource;
import net.minecraft.client.audio.SoundSystem;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.sound.PlaySoundSourceEvent;
import net.minecraftforge.client.event.sound.PlayStreamingSourceEvent;
import net.minecraftforge.client.event.sound.SoundLoadEvent;
import net.minecraftforge.client.event.sound.SoundSetupEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

@OnlyIn(value=Dist.CLIENT)
public class SoundEngine {
    private static final Marker field_148623_a = MarkerManager.getMarker((String)"SOUNDS");
    private static final Logger field_148621_b = LogManager.getLogger();
    private static final Set<ResourceLocation> field_188775_c = Sets.newHashSet();
    public final SoundHandler field_148622_c;
    private final GameSettings field_148619_d;
    private boolean field_148617_f;
    private final SoundSystem field_217937_g = new SoundSystem();
    private final Listener field_217938_h = this.field_217937_g.func_216407_c();
    private final AudioStreamManager field_217939_i;
    private final SoundEngineExecutor field_217940_j = new SoundEngineExecutor();
    private final ChannelManager field_217941_k = new ChannelManager(this.field_217937_g, (Executor)this.field_217940_j);
    private int field_148618_g;
    private final Map<ISound, ChannelManager.Entry> field_217942_m = Maps.newHashMap();
    private final Multimap<SoundCategory, ISound> field_217943_n = HashMultimap.create();
    private final List<ITickableSound> field_148625_l = Lists.newArrayList();
    private final Map<ISound, Integer> field_148626_m = Maps.newHashMap();
    private final Map<ISound, Integer> field_148624_n = Maps.newHashMap();
    private final List<ISoundEventListener> field_188777_o = Lists.newArrayList();
    private final List<Sound> field_204261_q = Lists.newArrayList();

    public SoundEngine(SoundHandler p_i50892_1_, GameSettings p_i50892_2_, IResourceManager p_i50892_3_) {
        this.field_148622_c = p_i50892_1_;
        this.field_148619_d = p_i50892_2_;
        this.field_217939_i = new AudioStreamManager(p_i50892_3_);
        MinecraftForge.EVENT_BUS.post((Event)new SoundSetupEvent(this));
    }

    public void func_148596_a() {
        field_188775_c.clear();
        Iterator iterator = Registry.field_212633_v.iterator();
        while (iterator.hasNext()) {
            SoundEvent soundevent = (SoundEvent)((Object)iterator.next());
            ResourceLocation resourcelocation = soundevent.func_187503_a();
            if (this.field_148622_c.func_184398_a(resourcelocation) != null) continue;
            field_148621_b.warn("Missing sound for event: {}", (Object)Registry.field_212633_v.func_177774_c(soundevent));
            field_188775_c.add(resourcelocation);
        }
        this.func_148613_b();
        this.func_148608_i();
        MinecraftForge.EVENT_BUS.post((Event)new SoundLoadEvent(this));
    }

    private synchronized void func_148608_i() {
        if (!this.field_148617_f) {
            try {
                this.field_217937_g.func_216404_a();
                this.field_217938_h.func_216468_b();
                this.field_217938_h.func_216466_a(this.field_148619_d.func_186711_a(SoundCategory.MASTER));
                this.field_217939_i.func_217908_a(this.field_204261_q).thenRun(this.field_204261_q::clear);
                this.field_148617_f = true;
                field_148621_b.info(field_148623_a, "Sound engine started");
            }
            catch (RuntimeException runtimeexception) {
                field_148621_b.error(field_148623_a, "Error starting SoundSystem. Turning off sounds & music", (Throwable)runtimeexception);
            }
        }
    }

    private float func_188769_a(SoundCategory category) {
        return category != null && category != SoundCategory.MASTER ? this.field_148619_d.func_186711_a(category) : 1.0f;
    }

    public void func_188771_a(SoundCategory category, float volume) {
        if (this.field_148617_f) {
            if (category == SoundCategory.MASTER) {
                this.field_217938_h.func_216466_a(volume);
            } else {
                this.field_217942_m.forEach((p_217926_1_, p_217926_2_) -> {
                    float f = this.func_188770_e((ISound)p_217926_1_);
                    p_217926_2_.func_217888_a(p_217923_1_ -> {
                        if (f <= 0.0f) {
                            p_217923_1_.func_216418_f();
                        } else {
                            p_217923_1_.func_216430_b(f);
                        }
                    });
                });
            }
        }
    }

    public void func_148613_b() {
        if (this.field_148617_f) {
            this.func_148614_c();
            this.field_217939_i.func_217912_a();
            this.field_217937_g.func_216409_b();
            this.field_148617_f = false;
        }
    }

    public void func_148602_b(ISound sound) {
        ChannelManager.Entry channelmanager$entry;
        if (this.field_148617_f && (channelmanager$entry = this.field_217942_m.get(sound)) != null) {
            channelmanager$entry.func_217888_a(SoundSource::func_216418_f);
        }
    }

    public void func_148614_c() {
        if (this.field_148617_f) {
            this.field_217940_j.func_213176_a();
            this.field_217942_m.values().forEach(p_217922_0_ -> p_217922_0_.func_217888_a(SoundSource::func_216418_f));
            this.field_217942_m.clear();
            this.field_217941_k.func_217903_b();
            this.field_148626_m.clear();
            this.field_148625_l.clear();
            this.field_217943_n.clear();
            this.field_148624_n.clear();
        }
    }

    public void func_188774_a(ISoundEventListener listener) {
        this.field_188777_o.add(listener);
    }

    public void func_188773_b(ISoundEventListener listener) {
        this.field_188777_o.remove(listener);
    }

    public void func_217921_a(boolean p_217921_1_) {
        if (!p_217921_1_) {
            this.func_217927_h();
        }
        this.field_217941_k.func_217899_a();
    }

    private void func_217927_h() {
        ++this.field_148618_g;
        for (ITickableSound itickablesound : this.field_148625_l) {
            itickablesound.func_73660_a();
            if (itickablesound.func_147667_k()) {
                this.func_148602_b((ISound)itickablesound);
                continue;
            }
            float f = this.func_188770_e((ISound)itickablesound);
            float f1 = this.func_188772_d((ISound)itickablesound);
            Vec3d vec3d = new Vec3d(itickablesound.func_147649_g(), itickablesound.func_147654_h(), itickablesound.func_147651_i());
            ChannelManager.Entry channelmanager$entry = this.field_217942_m.get(itickablesound);
            if (channelmanager$entry == null) continue;
            channelmanager$entry.func_217888_a(p_217924_3_ -> {
                p_217924_3_.func_216430_b(f);
                p_217924_3_.func_216422_a(f1);
                p_217924_3_.func_216420_a(vec3d);
            });
        }
        Iterator<Map.Entry<ISound, ChannelManager.Entry>> iterator = this.field_217942_m.entrySet().iterator();
        while (iterator.hasNext()) {
            int j;
            Map.Entry<ISound, ChannelManager.Entry> entry = iterator.next();
            ChannelManager.Entry channelmanager$entry1 = entry.getValue();
            ISound isound = entry.getKey();
            float f2 = this.field_148619_d.func_186711_a(isound.func_184365_d());
            if (f2 <= 0.0f) {
                channelmanager$entry1.func_217888_a(SoundSource::func_216418_f);
                iterator.remove();
                continue;
            }
            if (!channelmanager$entry1.func_217889_a() || (j = this.field_148624_n.get(isound).intValue()) > this.field_148618_g) continue;
            int i = isound.func_147652_d();
            if (isound.func_147657_c() && i > 0) {
                this.field_148626_m.put(isound, this.field_148618_g + i);
            }
            iterator.remove();
            field_148621_b.debug(field_148623_a, "Removed channel {} because it's not playing anymore", (Object)channelmanager$entry1);
            this.field_148624_n.remove(isound);
            try {
                this.field_217943_n.remove((Object)isound.func_184365_d(), (Object)isound);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            if (!(isound instanceof ITickableSound)) continue;
            this.field_148625_l.remove(isound);
        }
        Iterator<Map.Entry<ISound, Integer>> iterator1 = this.field_148626_m.entrySet().iterator();
        while (iterator1.hasNext()) {
            Map.Entry<ISound, Integer> entry1 = iterator1.next();
            if (this.field_148618_g < entry1.getValue()) continue;
            ISound isound1 = entry1.getKey();
            if (isound1 instanceof ITickableSound) {
                ((ITickableSound)isound1).func_73660_a();
            }
            this.func_148611_c(isound1);
            iterator1.remove();
        }
    }

    public boolean func_217933_b(ISound p_217933_1_) {
        if (!this.field_148617_f) {
            return false;
        }
        return this.field_148624_n.containsKey(p_217933_1_) && this.field_148624_n.get(p_217933_1_) <= this.field_148618_g ? true : this.field_217942_m.containsKey(p_217933_1_);
    }

    public void func_148611_c(ISound p_sound) {
        if (this.field_148617_f) {
            if ((p_sound = ForgeHooksClient.playSound((SoundEngine)this, (ISound)p_sound)) == null) {
                return;
            }
            SoundEventAccessor soundeventaccessor = p_sound.func_184366_a(this.field_148622_c);
            ResourceLocation resourcelocation = p_sound.func_147650_b();
            if (soundeventaccessor == null) {
                if (field_188775_c.add(resourcelocation)) {
                    field_148621_b.warn(field_148623_a, "Unable to play unknown soundEvent: {}", (Object)resourcelocation);
                }
            } else {
                if (!this.field_188777_o.isEmpty()) {
                    for (ISoundEventListener isoundeventlistener : this.field_188777_o) {
                        isoundeventlistener.func_184067_a(p_sound, soundeventaccessor);
                    }
                }
                if (this.field_217938_h.func_216467_a() <= 0.0f) {
                    field_148621_b.debug(field_148623_a, "Skipped playing soundEvent: {}, master volume was zero", (Object)resourcelocation);
                } else {
                    Sound sound = p_sound.func_184364_b();
                    if (sound == SoundHandler.field_147700_a) {
                        if (field_188775_c.add(resourcelocation)) {
                            field_148621_b.warn(field_148623_a, "Unable to play empty soundEvent: {}", (Object)resourcelocation);
                        }
                    } else {
                        float f3 = p_sound.func_147653_e();
                        float f = Math.max(f3, 1.0f) * (float)sound.func_206255_j();
                        SoundCategory soundcategory = p_sound.func_184365_d();
                        float f1 = this.func_188770_e(p_sound);
                        float f2 = this.func_188772_d(p_sound);
                        ISound.AttenuationType isound$attenuationtype = p_sound.func_147656_j();
                        boolean flag = p_sound.func_217861_m();
                        if (f1 == 0.0f && !p_sound.func_211503_n()) {
                            field_148621_b.debug(field_148623_a, "Skipped playing sound {}, volume was zero.", (Object)sound.func_188719_a());
                        } else {
                            boolean flag1 = p_sound.func_147657_c() && p_sound.func_147652_d() == 0;
                            Vec3d vec3d = new Vec3d(p_sound.func_147649_g(), p_sound.func_147654_h(), p_sound.func_147651_i());
                            ChannelManager.Entry channelmanager$entry = this.field_217941_k.func_217895_a(sound.func_188723_h() ? SoundSystem.Mode.STREAMING : SoundSystem.Mode.STATIC);
                            field_148621_b.debug(field_148623_a, "Playing sound {} for event {}", (Object)sound.func_188719_a(), (Object)resourcelocation);
                            this.field_148624_n.put(p_sound, this.field_148618_g + 20);
                            this.field_217942_m.put(p_sound, channelmanager$entry);
                            this.field_217943_n.put((Object)soundcategory, (Object)p_sound);
                            channelmanager$entry.func_217888_a(p_217930_7_ -> {
                                p_217930_7_.func_216422_a(f2);
                                p_217930_7_.func_216430_b(f1);
                                if (isound$attenuationtype == ISound.AttenuationType.LINEAR) {
                                    p_217930_7_.func_216423_c(f);
                                } else {
                                    p_217930_7_.func_216419_h();
                                }
                                p_217930_7_.func_216425_a(flag1);
                                p_217930_7_.func_216420_a(vec3d);
                                p_217930_7_.func_216432_b(flag);
                            });
                            ISound isound = p_sound;
                            if (!sound.func_188723_h()) {
                                this.field_217939_i.func_217909_a(sound.func_188721_b()).thenAccept(p_217934_1_ -> channelmanager$entry.func_217888_a(p_217925_1_ -> {
                                    p_217925_1_.func_216429_a(p_217934_1_);
                                    p_217925_1_.func_216438_c();
                                    MinecraftForge.EVENT_BUS.post((Event)new PlaySoundSourceEvent(this, isound, p_217925_1_));
                                }));
                            } else {
                                this.field_217939_i.func_217917_b(sound.func_188721_b()).thenAccept(p_217928_1_ -> channelmanager$entry.func_217888_a(p_217935_1_ -> {
                                    p_217935_1_.func_216433_a(p_217928_1_);
                                    p_217935_1_.func_216438_c();
                                    MinecraftForge.EVENT_BUS.post((Event)new PlayStreamingSourceEvent(this, isound, p_217935_1_));
                                }));
                            }
                            if (p_sound instanceof ITickableSound) {
                                this.field_148625_l.add((ITickableSound)p_sound);
                            }
                        }
                    }
                }
            }
        }
    }

    public void func_204259_a(Sound soundIn) {
        this.field_204261_q.add(soundIn);
    }

    private float func_188772_d(ISound soundIn) {
        return MathHelper.func_76131_a((float)soundIn.func_147655_f(), (float)0.5f, (float)2.0f);
    }

    private float func_188770_e(ISound soundIn) {
        return MathHelper.func_76131_a((float)(soundIn.func_147653_e() * this.func_188769_a(soundIn.func_184365_d())), (float)0.0f, (float)1.0f);
    }

    public void func_148610_e() {
        if (this.field_148617_f) {
            this.field_217941_k.func_217897_a(p_217929_0_ -> p_217929_0_.forEach(SoundSource::func_216439_d));
        }
    }

    public void func_148604_f() {
        if (this.field_148617_f) {
            this.field_217941_k.func_217897_a(p_217936_0_ -> p_217936_0_.forEach(SoundSource::func_216437_e));
        }
    }

    public void func_148599_a(ISound sound, int delay) {
        this.field_148626_m.put(sound, this.field_148618_g + delay);
    }

    public void func_217920_a(ActiveRenderInfo p_217920_1_) {
        if (this.field_148617_f && p_217920_1_.func_216786_h()) {
            Vec3d vec3d = p_217920_1_.func_216785_c();
            Vec3d vec3d1 = p_217920_1_.func_216787_l();
            Vec3d vec3d2 = p_217920_1_.func_216788_m();
            this.field_217940_j.execute(() -> {
                this.field_217938_h.func_216465_a(vec3d);
                this.field_217938_h.func_216469_a(vec3d1, vec3d2);
            });
        }
    }

    public void func_195855_a(@Nullable ResourceLocation soundName, @Nullable SoundCategory category) {
        if (category != null) {
            for (ISound isound : this.field_217943_n.get((Object)category)) {
                if (soundName != null && !isound.func_147650_b().equals((Object)soundName)) continue;
                this.func_148602_b(isound);
            }
        } else if (soundName == null) {
            this.func_148614_c();
        } else {
            for (ISound isound1 : this.field_217942_m.keySet()) {
                if (!isound1.func_147650_b().equals((Object)soundName)) continue;
                this.func_148602_b(isound1);
            }
        }
    }

    public String func_217932_f() {
        return this.field_217937_g.func_216402_d();
    }
}

