/*
 * Decompiled with CFR 0.152.
 */
package owmii.enemyz;

import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import owmii.enemyz.Config;
import owmii.enemyz.SyncTarget;
import owmii.enemyz.client.KeyHandler;

@Mod(value="enemyz")
public class Enemyz {
    public static final String MOD_ID = "enemyz";
    public static final SimpleChannel NET = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("enemyz", "main")).clientAcceptedVersions("1"::equals).serverAcceptedVersions("1"::equals).networkProtocolVersion(() -> "1").simpleChannel();

    public Enemyz() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::clientSetup);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, Config.CONFIG_SPEC);
    }

    void commonSetup(FMLCommonSetupEvent event) {
        NET.registerMessage(0, SyncTarget.class, SyncTarget::encode, SyncTarget::decode, SyncTarget::handle);
    }

    void clientSetup(FMLClientSetupEvent event) {
        KeyHandler.register();
    }

    @Mod.EventBusSubscriber
    public static class Handler {
        public static final String TAG_PLAYER_UUID = "PlayerTargetId";
        private static final UUID EMPTY_UUID = new UUID(0L, 0L);
        public static boolean visible = true;

        @SubscribeEvent
        public static void setAndSyncTarget(LivingEvent.LivingUpdateEvent event) {
            LivingEntity entity = event.getEntityLiving();
            if (entity instanceof MobEntity) {
                World world = entity.func_130014_f_();
                if (!world.field_72995_K) {
                    PlayerEntity player;
                    MobEntity mobEntity = (MobEntity)entity;
                    CompoundNBT nbt = mobEntity.getPersistentData();
                    LivingEntity target = mobEntity.func_70638_az();
                    if (target instanceof ServerPlayerEntity) {
                        ServerPlayerEntity player2 = (ServerPlayerEntity)target;
                        if (!nbt.func_186857_a(TAG_PLAYER_UUID).equals(player2.func_110124_au())) {
                            nbt.func_186854_a(TAG_PLAYER_UUID, player2.func_110124_au());
                            NET.sendTo((Object)new SyncTarget(mobEntity.func_145782_y(), player2.func_110124_au()), player2.field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT);
                        }
                    } else if (nbt.func_186855_b(TAG_PLAYER_UUID) && (player = world.func_217371_b(nbt.func_186857_a(TAG_PLAYER_UUID))) instanceof ServerPlayerEntity) {
                        nbt.func_186854_a(TAG_PLAYER_UUID, EMPTY_UUID);
                        NET.sendTo((Object)new SyncTarget(mobEntity.func_145782_y(), EMPTY_UUID), ((ServerPlayerEntity)player).field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT);
                    }
                }
            }
        }

        @SubscribeEvent
        @OnlyIn(value=Dist.CLIENT)
        public static void renderIcon(RenderLivingEvent.Post event) {
            if (!visible) {
                return;
            }
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            LivingEntity entity = event.getEntity();
            UUID uuid = entity.getPersistentData().func_186857_a(TAG_PLAYER_UUID);
            if (player.func_110124_au().equals(uuid) && entity.func_70089_S()) {
                if ((double)player.func_70032_d((Entity)entity) > (Double)Config.CONFIG.distance.get()) {
                    return;
                }
                GlStateManager.pushMatrix();
                float neatOffset = ModList.get().isLoaded("neat") ? 0.45f : 0.0f;
                GlStateManager.translated((double)event.getX(), (double)((double)entity.func_213302_cg() + 0.5 + event.getY() + (Double)Config.CONFIG.yOffset.get() + (double)neatOffset), (double)event.getZ());
                GlStateManager.enableBlend();
                GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
                GLX.glMultiTexCoord2f((int)GLX.GL_TEXTURE1, (float)240.0f, (float)240.0f);
                GlStateManager.scalef((float)((float)(0.5 * (Double)Config.CONFIG.iconSize.get())), (float)((float)(0.5 * (Double)Config.CONFIG.iconSize.get())), (float)((float)(0.5 * (Double)Config.CONFIG.iconSize.get())));
                GlStateManager.color4f((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.rotatef((float)(180.0f - event.getRenderer().func_177068_d().field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
                ItemStack stack = new ItemStack((IItemProvider)Objects.ICON);
                ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
                TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
                textureManager.func_110577_a(AtlasTexture.field_110575_b);
                textureManager.func_110581_b(AtlasTexture.field_110575_b).func_174936_b(false, false);
                IBakedModel bakedmodel = ForgeHooksClient.handleCameraTransforms((IBakedModel)itemRenderer.func_204206_b(stack), (ItemCameraTransforms.TransformType)ItemCameraTransforms.TransformType.FIXED, (boolean)false);
                GlStateManager.disableLighting();
                GlStateManager.scalef((float)1.0f, (float)1.0f, (float)0.3f);
                itemRenderer.func_180454_a(stack, bakedmodel);
                GlStateManager.enableLighting();
                textureManager.func_110577_a(AtlasTexture.field_110575_b);
                textureManager.func_110581_b(AtlasTexture.field_110575_b).func_174935_a();
                GlStateManager.disableBlend();
                GlStateManager.popMatrix();
            }
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class Objects {
        public static final Item ICON = new Item(new Item.Properties());

        @SubscribeEvent
        public static void onRegistry(RegistryEvent.Register<Item> event) {
            event.getRegistry().register(ICON.setRegistryName("icon"));
        }
    }
}

