/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.network;

import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.ServerPlayNetHandler;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.concurrent.ThreadTaskExecutor;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.network.ICustomPacket;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDispatcher;

public class NetworkEvent
extends Event {
    private final PacketBuffer payload;
    private final Supplier<Context> source;
    private final int loginIndex;

    private NetworkEvent(ICustomPacket<?> payload, Supplier<Context> source) {
        this.payload = payload.getInternalData();
        this.source = source;
        this.loginIndex = payload.getIndex();
    }

    private NetworkEvent(PacketBuffer payload, Supplier<Context> source, int loginIndex) {
        this.payload = payload;
        this.source = source;
        this.loginIndex = loginIndex;
    }

    public PacketBuffer getPayload() {
        return this.payload;
    }

    public Supplier<Context> getSource() {
        return this.source;
    }

    public int getLoginIndex() {
        return this.loginIndex;
    }

    public static class Context {
        private final NetworkManager networkManager;
        private final NetworkDirection networkDirection;
        private final PacketDispatcher packetDispatcher;
        private boolean packetHandled;

        Context(NetworkManager netHandler, NetworkDirection networkDirection, int index) {
            this(netHandler, networkDirection, new PacketDispatcher.NetworkManagerDispatcher(netHandler, index, networkDirection.reply()::buildPacket));
        }

        Context(NetworkManager networkManager, NetworkDirection networkDirection, PacketDispatcher dispatcher) {
            this.networkManager = networkManager;
            this.networkDirection = networkDirection;
            this.packetDispatcher = dispatcher;
        }

        public NetworkDirection getDirection() {
            return this.networkDirection;
        }

        public PacketDispatcher getPacketDispatcher() {
            return this.packetDispatcher;
        }

        public <T> Attribute<T> attr(AttributeKey<T> key) {
            return this.networkManager.channel().attr(key);
        }

        public void setPacketHandled(boolean packetHandled) {
            this.packetHandled = packetHandled;
        }

        public boolean getPacketHandled() {
            return this.packetHandled;
        }

        public CompletableFuture<Void> enqueueWork(Runnable runnable) {
            ThreadTaskExecutor executor = (ThreadTaskExecutor)LogicalSidedProvider.WORKQUEUE.get(this.getDirection().getReceptionSide());
            if (!executor.func_213162_bc()) {
                return executor.func_213165_a(runnable);
            }
            runnable.run();
            return CompletableFuture.completedFuture(null);
        }

        @Nullable
        public ServerPlayerEntity getSender() {
            INetHandler netHandler = this.networkManager.func_150729_e();
            if (netHandler instanceof ServerPlayNetHandler) {
                ServerPlayNetHandler netHandlerPlayServer = (ServerPlayNetHandler)netHandler;
                return netHandlerPlayServer.field_147369_b;
            }
            return null;
        }

        NetworkManager getNetworkManager() {
            return this.networkManager;
        }
    }

    public static class LoginPayloadEvent
    extends NetworkEvent {
        LoginPayloadEvent(PacketBuffer payload, Supplier<Context> source, int loginIndex) {
            super(payload, source, loginIndex);
        }
    }

    public static class GatherLoginPayloadsEvent
    extends Event {
        private final List<NetworkRegistry.LoginPayload> collected;
        private final boolean isLocal;

        public GatherLoginPayloadsEvent(List<NetworkRegistry.LoginPayload> loginPayloadList, boolean isLocal) {
            this.collected = loginPayloadList;
            this.isLocal = isLocal;
        }

        public void add(PacketBuffer buffer, ResourceLocation channelName, String context) {
            this.collected.add(new NetworkRegistry.LoginPayload(buffer, channelName, context));
        }

        public boolean isLocal() {
            return this.isLocal;
        }
    }

    public static class ClientCustomPayloadLoginEvent
    extends ClientCustomPayloadEvent {
        ClientCustomPayloadLoginEvent(ICustomPacket<?> payload, Supplier<Context> source) {
            super(payload, source);
        }
    }

    public static class ServerCustomPayloadLoginEvent
    extends ServerCustomPayloadEvent {
        ServerCustomPayloadLoginEvent(ICustomPacket<?> payload, Supplier<Context> source) {
            super(payload, source);
        }
    }

    public static class ClientCustomPayloadEvent
    extends NetworkEvent {
        ClientCustomPayloadEvent(ICustomPacket<?> payload, Supplier<Context> source) {
            super(payload, source);
        }
    }

    public static class ServerCustomPayloadEvent
    extends NetworkEvent {
        ServerCustomPayloadEvent(ICustomPacket<?> payload, Supplier<Context> source) {
            super(payload, source);
        }
    }
}

