/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.network;

import io.netty.buffer.Unpooled;
import io.netty.util.Attribute;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.FMLNetworkConstants;
import net.minecraftforge.fml.network.ICustomPacket;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.commons.lang3.tuple.Pair;

public class FMLMCRegisterPacketHandler {
    public static final FMLMCRegisterPacketHandler INSTANCE = new FMLMCRegisterPacketHandler();

    public void addChannels(Set<ResourceLocation> locations, NetworkManager manager) {
        FMLMCRegisterPacketHandler.getFrom(manager).locations.addAll(locations);
    }

    void registerListener(NetworkEvent evt) {
        ChannelList channelList = FMLMCRegisterPacketHandler.getFrom(evt);
        channelList.updateFrom(evt.getPayload());
        evt.getSource().get().setPacketHandled(true);
    }

    void unregisterListener(NetworkEvent evt) {
        ChannelList channelList = FMLMCRegisterPacketHandler.getFrom(evt);
        channelList.updateFrom(evt.getPayload());
        evt.getSource().get().setPacketHandled(true);
    }

    private static ChannelList getFrom(NetworkManager manager) {
        return FMLMCRegisterPacketHandler.fromAttr((Attribute<ChannelList>)manager.channel().attr(FMLNetworkConstants.FML_MC_REGISTRY));
    }

    private static ChannelList getFrom(NetworkEvent event) {
        return FMLMCRegisterPacketHandler.fromAttr(event.getSource().get().attr(FMLNetworkConstants.FML_MC_REGISTRY));
    }

    private static ChannelList fromAttr(Attribute<ChannelList> attr) {
        attr.setIfAbsent((Object)new ChannelList());
        return (ChannelList)attr.get();
    }

    public void sendRegistry(NetworkManager manager, NetworkDirection dir) {
        PacketBuffer pb = new PacketBuffer(Unpooled.buffer());
        pb.writeBytes(FMLMCRegisterPacketHandler.getFrom(manager).toByteArray());
        ICustomPacket iPacketICustomPacket = dir.buildPacket((Pair<PacketBuffer, Integer>)Pair.of((Object)pb, (Object)0), FMLNetworkConstants.MC_REGISTER_RESOURCE);
        manager.func_179290_a(iPacketICustomPacket.getThis());
    }

    public static class ChannelList {
        private Set<ResourceLocation> locations = new HashSet<ResourceLocation>();

        public void updateFrom(PacketBuffer buffer) {
            byte[] data = new byte[buffer.readableBytes() < 0 ? 0 : buffer.readableBytes()];
            buffer.readBytes(data);
            this.locations = this.bytesToResLocation(data);
        }

        byte[] toByteArray() {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            for (ResourceLocation rl : this.locations) {
                try {
                    bos.write(rl.toString().getBytes(StandardCharsets.UTF_8));
                    bos.write(0);
                }
                catch (IOException iOException) {}
            }
            return bos.toByteArray();
        }

        private Set<ResourceLocation> bytesToResLocation(byte[] all) {
            HashSet<ResourceLocation> rl = new HashSet<ResourceLocation>();
            int last = 0;
            for (int cur = 0; cur < all.length; ++cur) {
                if (all[cur] != 0) continue;
                String s = new String(all, last, cur - last, StandardCharsets.UTF_8);
                rl.add(new ResourceLocation(s));
                last = cur + 1;
            }
            return rl;
        }
    }
}

