/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.collect.ImmutableList;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;
import net.minecraft.client.GameSettings;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.common.model.TRSRTransformation;

public abstract class SimpleModelFontRenderer
extends FontRenderer {
    private float r;
    private float g;
    private float b;
    private float a;
    private final TRSRTransformation transform;
    private ImmutableList.Builder<BakedQuad> builder = ImmutableList.builder();
    private final VertexFormat format;
    private final Vector3f normal = new Vector3f(0.0f, 0.0f, 1.0f);
    private final Direction orientation;
    private boolean fillBlanks = false;
    private TextureAtlasSprite sprite;
    private final Vector4f vec = new Vector4f();

    public SimpleModelFontRenderer(GameSettings settings, ResourceLocation font, TextureManager manager, boolean isUnicode, Matrix4f matrix, VertexFormat format) {
        super(manager, null);
        this.transform = new TRSRTransformation(matrix);
        this.format = format;
        this.transform.transformNormal(this.normal);
        this.orientation = Direction.func_176737_a((float)this.normal.x, (float)this.normal.y, (float)this.normal.z);
    }

    public void setSprite(TextureAtlasSprite sprite) {
        this.sprite = sprite;
    }

    public void setFillBlanks(boolean fillBlanks) {
        this.fillBlanks = fillBlanks;
    }

    private void addVertex(UnpackedBakedQuad.Builder quadBuilder, float x, float y, float u, float v) {
        block6: for (int e = 0; e < this.format.func_177345_h(); ++e) {
            switch (this.format.func_177348_c(e).func_177375_c()) {
                case POSITION: {
                    this.vec.set(x, y, 0.0f, 1.0f);
                    this.transform.transformPosition(this.vec);
                    quadBuilder.put(e, this.vec.x, this.vec.y, this.vec.z, this.vec.w);
                    continue block6;
                }
                case COLOR: {
                    quadBuilder.put(e, this.r, this.g, this.b, this.a);
                    continue block6;
                }
                case NORMAL: {
                    quadBuilder.put(e, 0.0f, 0.0f, 1.0f, 1.0f);
                    continue block6;
                }
                case UV: {
                    if (this.format.func_177348_c(e).func_177369_e() == 0) {
                        quadBuilder.put(e, this.sprite.func_94214_a((double)(u * 16.0f)), this.sprite.func_94207_b((double)(v * 16.0f)), 0.0f, 1.0f);
                        continue block6;
                    }
                }
                default: {
                    quadBuilder.put(e, new float[0]);
                }
            }
        }
    }

    public ImmutableList<BakedQuad> build() {
        ImmutableList ret = this.builder.build();
        this.builder = ImmutableList.builder();
        return ret;
    }
}

