package net.minecraft.src;

import java.io.File;
import java.io.PrintStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.Map;

import net.minecraft.client.Minecraft;
import net.minecraft.src.forge.*;

public class mod_littleMaidMob extends NetworkMod implements IGuiHandler,IConnectionHandler, IPacketHandler
{
    public static Minecraft mcGame;
    public static Achievement ac_Contract;
    @MLProp(info = "Relative spawn weight. The lower the less common. 10=pigs. 0=off")
    public static int spawnWeight = 5;
    @MLProp(info = "Maximum spawn count in the World.")
    public static int spawnLimit = 50;
    @MLProp(info = "Minimum spawn group count.")
    public static int minGroupSize = 1;
    @MLProp(info = "Maximum spawn group count.")
    public static int maxGroupSize = 3;
    public static boolean trampleCrops = false;
    @MLProp(info = "It will despawn, if it lets things go.")
    public static boolean canDespawn = false;
    @MLProp(info = "Living Voice Rate. 1.0=100%, 0.5=50%, 0.0=0%")
    public static float LivingVoiceRate = 1.0F;
    @MLProp(info = "LittleMaid Voice distortion.")
    public static boolean VoiceDistortion = true;
    @MLProp(info = "Default selected Texture Packege. Null is Random")
    public static String defaultTexture = "";
    @MLProp(info = "Print Debug Massages.")
    public static boolean DebugMessage = false;
    @MLProp(info = "Spawn Anywhere.")
    public static boolean Dominant = false;
    @MLProp(info = "true: AlphaBlend(request power), false: AlphaTest(more fast)")
    public static boolean AlphaBlend = true;
    @MLProp(info="true: Will be hostile, false: Is a pacifist")
    public static boolean Aggressive = false;
    @MLProp(info = "used Achievement index.(0 = Disable)")
    public static int AchievementID = 0x36330;
    public static boolean isDebugView = false;
    @MLProp(info = "change EntityID by littleMaid")
    public static int litttleMaidID = 109;
    public static int dummyID = 83;
    @MLProp(info = "change netID by STAND")
    public static int avatarID = 84;
    @MLProp(info = "change guiID by littleMaidInventory")
    public static int inventoryGUI = 66;
    public static int packetCloseGUI = 1;
    public static int packetPlaySound = 2;
    public static int packetIFFTrigger = 3;
    public static int packetMaidName = 4;
    public static int packetRequestIFF = 5;
    public static int packetInventory = 6;
    public static int packetPotion = 8;
    public static int packetAngle = 9;
    public static boolean IFFServerSetting = false;
    public static boolean TriggerItemServerSetting = false;
    //public static NetworkMod mod_lMM;
    public static mod_littleMaidMob instance;
    public static String channel = "lMM";

    public mod_littleMaidMob()
    {
    	instance = this;
    }

    public static void Debug(String s)
    {
        if (DebugMessage)
        {
            System.out.println((new StringBuilder()).append("littleMaidMob-").append(s).toString());
        }
    }

    @Override
    public String getVersion()
    {
        return "SMP_0.5.5";
    }

    @Override
    public boolean clientSideRequired()
    {
    	return true;
    }

    @Override
    public boolean serverSideRequired()
    {
    	return true;
    }

    @Override
    public void load()
    {
        mcGame = ModLoader.getMinecraftInstance();
        //mod_lMM = MinecraftForge.getModByID(instance.toString().hashCode());
        ModLoader.registerEntityID(net.minecraft.src.EntityLittleMaid.class, "LittleMaid", litttleMaidID, 0xefffef, 0x9f5f5f);
        ModLoader.addLocalization("entity.LittleMaid.name", "LittleMaid");
        //ModLoaderMp.RegisterNetClientHandlerEntity(net.minecraft.src.EntityDummy.class, dummyID);
        MinecraftForge.registerEntity(net.minecraft.src.EntityLittleMaidAvatar.class, instance,avatarID,160, 10, true);
        //ModLoaderMp.registerNetClientHandlerEntity(net.minecraft.src.EntityLittleMaidAvatar.class, avatarID);
        //ModLoaderMp.registerGUI(this, inventoryGUI);
        MinecraftForge.setGuiHandler(instance, instance);
        MinecraftForge.registerConnectionHandler(instance);
        //ModLoader.setInGameHook(instance, true, true);
        Debug("SoundDir:".concat(Minecraft.getAppDir("minecraft/resources/mod/sound").toString()));
        SoundLittleMaid.loadDefaultSoundPack();
        SoundLittleMaid.loadSoundPack();

        if (AchievementID != 0)
        {
            ac_Contract = (new Achievement(AchievementID, "littleMaid", 1, -4, Item.cake, AchievementList.bakeCake)).registerAchievement();
            ModLoader.addAchievementDesc(ac_Contract, "Enlightenment!", "Capture the LittleMaid!");
            ModLoader.addLocalization("achievement.littleMaid", "ja_JP", "\u609F\u308A\u3002");
            ModLoader.addLocalization("achievement.littleMaid.desc", "ja_JP", "\u30E1\u30A4\u30C9\u3055\u3093\u3092\u5165\u624B\u3057\u307E\u3057\u305F\u3002");
        }
    }

    public void addRenderer(Map map)
    {
        map.put(net.minecraft.src.EntityLittleMaid.class, new RenderLittleMaid(new ModelLittleMaid(), 0.3F));

        if (isDebugView)
        {
            map.put(net.minecraft.src.EntityLittleMaidDummy.class, new RenderLittleMaidDummy());
        }
    }

    public void modsLoaded()
    {
        if (Dominant)
        {
            try
            {
                Field afield[] = (net.minecraft.src.BiomeGenBase.class).getDeclaredFields();
                LinkedList linkedlist = new LinkedList();

                for (int i = 0; i < afield.length; i++)
                {
                    Class class1 = afield[i].getType();

                    if ((afield[i].getModifiers() & 8) != 0 && class1.isAssignableFrom(net.minecraft.src.BiomeGenBase.class))
                    {
                        BiomeGenBase biomegenbase = (BiomeGenBase)afield[i].get(null);
                        linkedlist.add(biomegenbase);
                    }
                }

                BiomeGenBase abiomegenbase[] = (BiomeGenBase[])linkedlist.toArray(new BiomeGenBase[0]);
                ModLoader.addSpawn(net.minecraft.src.EntityLittleMaid.class, 1, minGroupSize, maxGroupSize, EnumCreatureType.creature, abiomegenbase);
            }
            catch (Exception exception)
            {
                Debug("Dominate Exception.");
            }
        }
        else if (spawnWeight > 0)
        {
            ModLoader.addSpawn(net.minecraft.src.EntityLittleMaid.class, spawnWeight, minGroupSize, maxGroupSize, EnumCreatureType.creature);
        }

        TextureLittleMaid.getArmorPrefix();
        TextureLittleMaid.getModFile();
        TextureLittleMaid.getTextures();
        GuiLittleMaidIFF.loadIFF();
        GuiLittleMaidTriggerSelect.initTriggerItem();
        //String as[] = {GuiLittleMaidTriggerSelect.SwordIndex, GuiLittleMaidTriggerSelect.AxeIndex, GuiLittleMaidTriggerSelect.BowIndex, GuiLittleMaidIFF.tmpIFFMap};
        //SendPacketLittleMaidData(packetIFFTrigger, as, null, null);
    }

//    @Override
//    public boolean onTickInGame(float var1, Minecraft var2)
//    {
//    	int i = 0;
//        EntityLittleMaid entitylittlemaid = null;
//    	do
//        {
//            if (i >= mcGame.theWorld.loadedEntityList.size())
//            {
//                break;
//            }
//
//            Entity entity = (Entity)mcGame.theWorld.loadedEntityList.get(i);
//
//            if (entity instanceof EntityLittleMaid)
//            {
//                entitylittlemaid = (EntityLittleMaid)entity;
//                entitylittlemaid.setTextureValue();
//            }
//            i++;
//        }
//        while (true);
//        return true;
//    }

    @Override
    public Object getGuiElement(int ID, EntityPlayer player, World world, int maidID, int y, int z)
    {
        if (player == null)
        {
            return null;
        }

        if (ID == inventoryGUI)
        {
            int i = 0;
            EntityLittleMaid entitylittlemaid = null;

            do
            {
                if (i >= world.loadedEntityList.size())
                {
                    break;
                }

                Entity entity = (Entity)world.loadedEntityList.get(i);

                if (entity instanceof EntityLittleMaid)
                {
                    entitylittlemaid = (EntityLittleMaid)entity;
                    if (entitylittlemaid.getMaidContractTime() == maidID)
                    {
                        return new GuiLittleMaidInventory(entitylittlemaid, player.inventory, entitylittlemaid.maidInventory);
                    }
                }
                i++;
            }
            while (true);
        }
        else if (ID == 1 && !world.isRemote)
        {
        	return new GuiLittleMaidIFF(world);
        }
        else if (ID == 2&& !world.isRemote)
        {
            int i = 0;
            EntityLittleMaid entitylittlemaid = null;
            do
            {
                if (i >= world.loadedEntityList.size())
                {
                    break;
                }

                Entity entity = (Entity)world.loadedEntityList.get(i);

                if (entity instanceof EntityLittleMaid)
                {
                    entitylittlemaid = (EntityLittleMaid)entity;
                    if (entitylittlemaid.entityId == maidID)
                    {
                    	//ModLoader.openGUI(player, new GuiLittleMaidEditName(entitylittlemaid));
                    	return new GuiLittleMaidEditName(entitylittlemaid);
                    }
                }
                i++;
            }
            while (true);
        }
        return null;
    }

    @Override
    public void onConnect(NetworkManager network)
    {
    	MessageManager.getInstance().registerChannel(network, this, channel);
        String as[] = {GuiLittleMaidTriggerSelect.SwordIndex, GuiLittleMaidTriggerSelect.AxeIndex, GuiLittleMaidTriggerSelect.BowIndex, GuiLittleMaidIFF.tmpIFFMap};
        SendPacketLittleMaidData(packetIFFTrigger, as, null, null);
    }

    @Override
    public void onLogin(NetworkManager network, Packet1Login login)
    {
    }

    @Override
    public void onDisconnect(NetworkManager network, String message, Object[] args)
    {
    }

    @Override
    public void onPacketData(NetworkManager network, String channel, byte[] data)
    {
    	if(channel.equals(this.channel))
    	{
    		DataInputStream dataStream = new DataInputStream(new ByteArrayInputStream(data));
    		int packetType = 0;
    		try{
    			packetType = dataStream.readInt();

	    		if (packetType == packetPlaySound)
	            {
	    			int ai[] = new int[2];
	    			for(int a = 0;a < 2;a++)
	    			{
	    				ai[a] = dataStream.readInt();
	    			}
	                int i = 0;
	                EntityLittleMaid entitylittlemaid = null;
	                EntityPlayerSP entityplayersp = ModLoader.getMinecraftInstance().thePlayer;

	                do
	                {
	                    if (i >= mcGame.theWorld.loadedEntityList.size())
	                    {
	                        break;
	                    }

	                    Entity entity = (Entity)mcGame.theWorld.loadedEntityList.get(i);

	                    if (entity instanceof EntityLittleMaid)
	                    {
	                        entitylittlemaid = (EntityLittleMaid)entity;

	                        if (ai[0] == entitylittlemaid.getMaidContractTime())
	                        {
	                            for (EnumSoundLittleMaid obj : EnumSoundLittleMaid.values())
	                            {
	                                if (obj.index == ai[1])
	                                {
	                                    entitylittlemaid.playSound(obj);
	                                    break;
	                                }
	                            }

	                            return;
	                        }
	                    }

	                    i++;
	                }
	                while (true);
	            }
	            else if (packetType == packetIFFTrigger)
	            {
	            	String as[] = new String[4];
	            	int ai[] = new int[2];
	            	for(int a = 0;a < 4;a++)
	    			{
	    				as[a] = dataStream.readUTF();
	    			}
	    			for(int a = 0;a < 2;a++)
	    			{
	    				ai[a] = dataStream.readInt();
	    			}

                    if (ai[0] == 1)
                    {
                        GuiLittleMaidIFF.setPacketIFF(as[3]);
                        IFFServerSetting = true;
                    }
                    else
                    {
                        IFFServerSetting = false;
                    }

                    if (ai[1] == 1)
                    {
                        GuiLittleMaidTriggerSelect.SwordIndex = as[0];
                        GuiLittleMaidTriggerSelect.AxeIndex = as[1];
                        GuiLittleMaidTriggerSelect.BowIndex = as[2];
                        GuiLittleMaidTriggerSelect.initTriggerItem();
                        TriggerItemServerSetting = true;
                    }
                    else
                    {
                        TriggerItemServerSetting = false;
                    }
	            }
                else if (packetType == packetRequestIFF)
                {
                    String as2[] = {GuiLittleMaidTriggerSelect.SwordIndex, GuiLittleMaidTriggerSelect.AxeIndex, GuiLittleMaidTriggerSelect.BowIndex, GuiLittleMaidIFF.tmpIFFMap};
                    SendPacketLittleMaidData(packetIFFTrigger, as2, null, null);
                }
                else if (packetType == packetInventory)
                {
                	int ai[] = new int[20];
	    			for(int a = 0;a < 20;a++)
	    			{
	    				ai[a] = dataStream.readInt();
	    			}
	                int i = 0;
	                EntityLittleMaid entitylittlemaid = null;
	                ItemStack itemstack = null;
	                EntityPlayerSP entityplayersp = ModLoader.getMinecraftInstance().thePlayer;

	                do
	                {
	                    if (i >= mcGame.theWorld.loadedEntityList.size())
	                    {
	                        break;
	                    }

	                    Entity entity = (Entity)mcGame.theWorld.loadedEntityList.get(i);

	                    if (entity instanceof EntityLittleMaid)
	                    {
	                        entitylittlemaid = (EntityLittleMaid)entity;

	                        if (ai[0] == entitylittlemaid.getMaidContractTime())
	                        {
	                        	int currentItem = ai[19];
	                        	if (currentItem != -1)
	                        	{
	                        		if (ai[1] == 0 && ai[2] == 0 && ai[3] == 0)
		                        	{
		                        		//entitylittlemaid.maidInventory.setInventoryCurrentSlotContents(null);
		                        		entitylittlemaid.maidInventory.setInventorySlotContents(ai[19], null);
		                        	}
		                        	else
		                        	{
		                        		itemstack = new ItemStack(ai[1],ai[2],ai[3]);
		                        		if (entitylittlemaid.maidInventory.getCurrentItem() != itemstack)
		                        		{
		                        			entitylittlemaid.maidInventory.setInventorySlotContents(ai[19], itemstack);
		                        			//entitylittlemaid.maidInventory.setInventoryCurrentSlotContents(itemstack);
		                        		}
		                        	}
	                        	}

	                        	for (int j = 0 ;j < 4;j++)
	                        	{
	                        		if (ai[4+j*3] == 0 && ai[5+j*3] == 0 && ai[6+j*3] == 0)
		                        	{
	                        			entitylittlemaid.maidInventory.armorInventory[j] = null;
		                        	}
	                        		else
	                        		{
	                        			itemstack = new ItemStack(ai[4+j*3],ai[5+j*3],ai[6+j*3]);
	                        			if (entitylittlemaid.maidInventory.armorInventory[j] != itemstack)
	                        			{
	                        				entitylittlemaid.maidInventory.armorInventory[j] = itemstack;
	                        			}
	                        		}
	                        	}
	                        	if (ai[16] == 0 && ai[17] == 0 && ai[18] == 0)
	                        	{
	                        		entitylittlemaid.maidInventory.setInventorySlotContents(17, null);
	                        	}
	                        	else
	                        	{
	                        		itemstack = new ItemStack(ai[16],ai[17],ai[18]);
	                        		if (entitylittlemaid.maidInventory.getStackInSlot(17) != itemstack)
	                        		{
	                        			entitylittlemaid.maidInventory.setInventorySlotContents(17,itemstack);
	                        		}
	                        	}
	                            return;
	                        }
	                    }
	                    i++;
	                }
	                while (true);
                }
                else if (packetType == packetMaidName)
	            {
	    			int ai = dataStream.readInt();
	                int i = 0;
	                EntityLittleMaid entitylittlemaid = null;
	                EntityPlayerSP entityplayersp = ModLoader.getMinecraftInstance().thePlayer;

	                do
	                {
	                    if (i >= mcGame.theWorld.loadedEntityList.size())
	                    {
	                        break;
	                    }
	                    Entity entity = (Entity)mcGame.theWorld.loadedEntityList.get(i);
	                    if (entity instanceof EntityLittleMaid)
	                    {
	                        entitylittlemaid = (EntityLittleMaid)entity;

	                        if (ai == entitylittlemaid.entityId)
	                        {
	                        	ModLoader.openGUI(entityplayersp, new GuiLittleMaidEditName(entitylittlemaid));
	                            return;
	                        }
	                    }
	                    i++;
	                }
	                while (true);
	            }
                else if (packetType == 7)
                {
                	ModLoader.openGUI(ModLoader.getMinecraftInstance().thePlayer, new GuiLittleMaidIFF(mcGame.theWorld));
                }
                else if (packetType == packetPotion)
	            {
                	int ai[] = new int[5];
	    			for(int a = 0;a < 5;a++)
	    			{
	    				ai[a] = dataStream.readInt();
	    			}
	                int i = 0;
	                EntityLittleMaid entitylittlemaid = null;
	                EntityPlayerSP entityplayersp = ModLoader.getMinecraftInstance().thePlayer;

	                do
	                {
	                    if (i >= mcGame.theWorld.loadedEntityList.size())
	                    {
	                        break;
	                    }
	                    Entity entity = (Entity)mcGame.theWorld.loadedEntityList.get(i);
	                    if (entity instanceof EntityLittleMaid)
	                    {
	                        entitylittlemaid = (EntityLittleMaid)entity;

	                        if (ai[0] == entitylittlemaid.getMaidContractTime())
	                        {
	                        	PotionEffect potioneffect;
	                        	potioneffect = new PotionEffect(ai[2], ai[3], ai[4]);
	                        	if (ai[1] == 1)
	                        	{
	                        		entitylittlemaid.addPotionEffect(potioneffect);
	                        	}
	                        	else if (ai[1] == 0)
	                        	{
	                        		entitylittlemaid.removePotionEffect(Integer.valueOf(potioneffect.getPotionID()));
	                        	}
	                            return;
	                        }
	                    }
	                    i++;
	                }
	                while (true);
	            }
                else if (packetType == packetPotion)
	            {
                	int ai[] = new int[5];
	    			for(int a = 0;a < 5;a++)
	    			{
	    				ai[a] = dataStream.readInt();
	    			}
	                int i = 0;
	                EntityLittleMaid entitylittlemaid = null;
	                EntityPlayerSP entityplayersp = ModLoader.getMinecraftInstance().thePlayer;

	                do
	                {
	                    if (i >= mcGame.theWorld.loadedEntityList.size())
	                    {
	                        break;
	                    }
	                    Entity entity = (Entity)mcGame.theWorld.loadedEntityList.get(i);
	                    if (entity instanceof EntityLittleMaid)
	                    {
	                        entitylittlemaid = (EntityLittleMaid)entity;

	                        if (ai[0] == entitylittlemaid.getMaidContractTime())
	                        {
	                        	PotionEffect potioneffect;
	                        	potioneffect = new PotionEffect(ai[2], ai[3], ai[4]);
	                        	if (ai[1] == 1)
	                        	{
	                        		entitylittlemaid.addPotionEffect(potioneffect);
	                        	}
	                        	else if (ai[1] == 0)
	                        	{
	                        		entitylittlemaid.removePotionEffect(Integer.valueOf(potioneffect.getPotionID()));
	                        	}
	                            return;
	                        }
	                    }
	                    i++;
	                }
	                while (true);
	            }
                else if (packetType == packetAngle)
	            {
                	int ai[] = new int[2];
                	float af[] = new float[3];
	    			for(int a = 0;a < 2;a++)
	    			{
	    				ai[a] = dataStream.readInt();
	    			}
	    			for(int a = 0;a < 3;a++)
	    			{
	    				af[a] = dataStream.readFloat();
	    			}
	                int i = 0;
	                EntityLittleMaid entitylittlemaid = null;
	                EntityPlayerSP entityplayersp = ModLoader.getMinecraftInstance().thePlayer;

	                do
	                {
	                    if (i >= mcGame.theWorld.loadedEntityList.size())
	                    {
	                        break;
	                    }
	                    Entity entity = (Entity)mcGame.theWorld.loadedEntityList.get(i);
	                    if (entity instanceof EntityLittleMaid)
	                    {
	                        entitylittlemaid = (EntityLittleMaid)entity;

	                        if (ai[0] == entitylittlemaid.entityId)
	                        {
	                        	entitylittlemaid.setInterestedAngle(ai[1], af[0], af[1], af[2]);
	                            return;
	                        }
	                    }
	                    i++;
	                }
	                while (true);
	            }
	    	}catch(IOException e)
            {
                e.printStackTrace();
            }
    	}
    }

    public static void SendPacketLittleMaidData(int packetType, String as[], int ai[], float af[])
    {
	    ByteArrayOutputStream bytes = new ByteArrayOutputStream();
	    DataOutputStream data = new DataOutputStream(bytes);
	    try
	    {
	    	data.writeInt(packetType);
	    	if (packetType == packetCloseGUI)
	        {
	    		for(int a = 0; a < 2; a++)
	            {
	                    data.writeUTF(as[a]);
	            }
	    		data.writeInt(ai[0]);
	        }
	        else if (packetType == packetIFFTrigger)
	        {
	        	for(int a = 0; a < 4; a++)
	            {
	                    data.writeUTF(as[a]);
	            }
	        }
	        else if (packetType == packetMaidName)
	        {
	        	data.writeUTF(as[0]);
	        	data.writeInt(ai[0]);
	        }
	    }
	    catch(IOException e)
	    {
	            e.printStackTrace();
	    }

	    Packet250CustomPayload packet = new Packet250CustomPayload();
	    packet.channel = channel;
	    packet.data = bytes.toByteArray();
	    packet.length = packet.data.length;
	    ModLoader.sendPacket(packet);
    }
}
