package net.minecraft.src;

import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.*;
import java.util.Map.Entry;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.minecraft.client.Minecraft;

public class TextureLittleMaid
{
    private static final Minecraft mc = ModLoader.getMinecraftInstance();
    private static File minecraft_jar = null;
    private static List littlemaid_zips = new ArrayList();
    private static String defDirName = "/mob/littleMaid/";
    private static String defNames[] =
    {
        "mob_littlemaid0.png", "mob_littlemaid1.png", "mob_littlemaid2.png", "mob_littlemaid3.png", "mob_littlemaid4.png", "mob_littlemaid5.png", "mob_littlemaid6.png", "mob_littlemaid7.png", "mob_littlemaid8.png", "mob_littlemaid9.png",
        "mob_littlemaida.png", "mob_littlemaidb.png", "mob_littlemaidc.png", "mob_littlemaidd.png", "mob_littlemaide.png", "mob_littlemaidf.png", "mob_littlemaidw.png", "mob_littlemaid_a00.png", "mob_littlemaid_a01.png"
    };
    public static final int tx_oldwild = 16;
    public static final int tx_oldarmor1 = 17;
    public static final int tx_oldarmor2 = 18;
    public static final int tx_gui = 32;
    public static final int tx_wild = 48;
    public static final int tx_armor1 = 64;
    public static final int tx_armor2 = 80;
    public static Map textures = new TreeMap();
    public static Map modelMap = new TreeMap();
    public static Map armors = new TreeMap();
    public static String armorFilenamePrefix[];

    public TextureLittleMaid()
    {
    }

    public static void getArmorPrefix()
    {
        try
        {
            Field field = (net.minecraft.src.RenderPlayer.class).getDeclaredFields()[3];
            field.setAccessible(true);
            String as[] = (String[])field.get(null);
            List list = Arrays.asList(as);
            armorFilenamePrefix = (String[])list.toArray(new String[0]);
        }
        catch (Exception exception) { }
    }

    protected static void getModFile()
    {
        try
        {
            Minecraft _tmp = mc;
            File file = new File(Minecraft.getMinecraftDir(), "/mods/");

            if (file.isDirectory())
            {
                mod_littleMaidMob.Debug(String.format("getModFile-get:%d.", new Object[]
                        {
                            Integer.valueOf(file.list().length)
                        }));
                File afile[] = file.listFiles();
                int i = afile.length;

                for (int j = 0; j < i; j++)
                {
                    File file1 = afile[j];

                    if (file1.getName().indexOf("littleMaidMob") != -1 && file1.getName().endsWith(".zip"))
                    {
                        littlemaid_zips.add(file1);
                        mod_littleMaidMob.Debug(String.format("getModFile-file:%s", new Object[]
                                {
                                    file1.getName()
                                }));
                    }
                }

                mod_littleMaidMob.Debug(String.format("getModFile-files:%d", new Object[]
                        {
                            Integer.valueOf(littlemaid_zips.size())
                        }));
            }
            else
            {
                mod_littleMaidMob.Debug("getModFile-fail.");
            }
        }
        catch (Exception exception)
        {
            mod_littleMaidMob.Debug("getModFile-Exception.");
        }

        try
        {
            minecraft_jar = new File((net.minecraft.src.ModLoader.class).getProtectionDomain().getCodeSource().getLocation().toURI());
            mod_littleMaidMob.Debug(String.format("getMincraftFile-file:%s", new Object[]
                    {
                        minecraft_jar.getName()
                    }));
        }
        catch (Exception exception1)
        {
            mod_littleMaidMob.Debug("getMincrafFile-Exception.");
        }
    }

    public static boolean getTextures()
    {
        for (int var0 = 0; var0 < defNames.length; ++var0)
        {
            addTextureName(defDirName + "default/" + defNames[var0]);
        }

        mod_littleMaidMob.Debug("getTexture-append-default-done.");

        if (addTexturesJar(minecraft_jar))
        {
            mod_littleMaidMob.Debug("getTexture-append-jar-done.");
        }
        else
        {
            mod_littleMaidMob.Debug("getTexture-append-jar-fail.");
        }

        Iterator var5 = littlemaid_zips.iterator();

        while (var5.hasNext())
        {
            File var1 = (File)var5.next();

            if (addTexturesZip(var1))
            {
                mod_littleMaidMob.Debug(String.format("getTexture-append-%s-done.", new Object[] {var1.getName()}));
            }
            else
            {
                mod_littleMaidMob.Debug(String.format("getTexture-append-%s-fail.", new Object[] {var1.getName()}));
            }
        }

        try
        {
            File var6 = new File(mod_littleMaidMob.class.getResource("/mob/littleMaid/").getFile());

            if (addTexturesDebug(var6))
            {
                mod_littleMaidMob.Debug("getTexture-append-debug-done.");
            }
            else
            {
                mod_littleMaidMob.Debug("getTexture-append-debug-fail.");
            }
        }
        catch (Exception var4)
        {
            mod_littleMaidMob.Debug("getTexture-append-debug-Exception.");
        }

        var5 = textures.entrySet().iterator();

        while (var5.hasNext())
        {
            Entry var7 = (Entry)var5.next();
            String var2 = (String)var7.getKey();
            int var3 = var2.lastIndexOf("_");

            if (var3 > -1)
            {
                var2 = var2.substring(var3 + 1);

                if (!var2.isEmpty())
                {
                    addModelClass("ModelLittleMaid_".concat(var2).concat(".class"));
                }
            }
        }

        mod_littleMaidMob.Debug("getTexture-append-Models-append-done.");
        return false;
    }

    private static void addModelClass(String s)
    {
        String s1 = "ModelLittleMaid_";

        if (s.startsWith(s1) && s.endsWith(".class") && s.indexOf('_') > -1)
        {
            String s2 = s.replace(".class", "");
            String s3 = s2.substring(s1.length());

            if (modelMap.containsKey(s3)) return;
            try
            {
                ClassLoader classloader = (net.minecraft.client.Minecraft.class).getClassLoader();
                Package package1 = (net.minecraft.src.ModLoader.class).getPackage();
                Class class1;

                if (package1 != null)
                {
                    s2 = (new StringBuilder(String.valueOf(package1.getName()))).append(".").append(s2).toString();
                    class1 = classloader.loadClass(s2);
                }
                else
                {
                    class1 = Class.forName(s2);
                }

                if (!(net.minecraft.src.ModelLittleMaid.class).isAssignableFrom(class1))
                {
                    mod_littleMaidMob.Debug(String.format("getModelClass-fail.", new Object[0]));
                    return;
                }

                ModelLittleMaid amodellittlemaid[] = new ModelLittleMaid[3];
                Constructor constructor = class1.getConstructor(new Class[]
                        {
                            Float.TYPE
                        });
                amodellittlemaid[0] = (ModelLittleMaid)constructor.newInstance(new Object[]
                        {
                            Float.valueOf(0.0F)
                        });
                amodellittlemaid[1] = (ModelLittleMaid)constructor.newInstance(new Object[]
                        {
                            Float.valueOf(0.5F)
                        });
                amodellittlemaid[2] = (ModelLittleMaid)constructor.newInstance(new Object[]
                        {
                            Float.valueOf(0.1F)
                        });
                modelMap.put(s3, amodellittlemaid);
                mod_littleMaidMob.Debug(String.format("getModelClass-%s", new Object[]
                        {
                            s2
                        }));
            }
            catch (Exception exception)
            {
                mod_littleMaidMob.Debug(String.format("getModelClass-Exception.", new Object[0]));
            }
            catch (Error error)
            {
            	mod_littleMaidMob.Debug(String.format("getModelClass-Error:".concat(s)));
            }
        }
    }

    private static void addTextureName(String s)
    {
        if (!s.startsWith("/"))
        {
            s = (new StringBuilder()).append("/").append(s).toString();
        }

        if (s.startsWith(defDirName))
        {
            int i = s.lastIndexOf("/");

            if (defDirName.length() < i)
            {
                String s1 = s.substring(defDirName.length(), i);
                s1 = s1.replace('/', '.');
                String s2 = s.substring(i);
                int j = getIndex(s2);

                if (j > -1)
                {
                    String s3 = null;

                    if (j == 17)
                    {
                        j = 64;
                        s3 = "default";
                    }

                    if (j == 18)
                    {
                        j = 80;
                        s3 = "default";
                    }

                    if (j == 16)
                    {
                        j = 60;
                    }

                    if (j >= 64 && j <= 95)
                    {
                        Object obj = (Map)armors.get(s1);

                        if (obj == null)
                        {
                            obj = new HashMap();
                            armors.put(s1, obj);
                            mod_littleMaidMob.Debug(String.format("getTextureName-append-armorPack-%s", new Object[]
                                    {
                                        s1
                                    }));
                        }

                        if (s3 == null)
                        {
                            s3 = s2.substring(1, s2.lastIndexOf('_'));
                        }

                        Object obj2 = (Map)((Map)(obj)).get(s3);

                        if (obj2 == null)
                        {
                            obj2 = new HashMap();
                            ((Map)(obj)).put(s3, obj2);
                        }

                        ((Map)(obj2)).put(Integer.valueOf(j), s2);
                    }
                    else
                    {
                      Map obj1 = (Map)textures.get(s1);
                      if (obj1 == null) {
                    	  obj1 = new HashMap();
                        textures.put(s1, obj1);
                        mod_littleMaidMob.Debug(String.format("getTextureName-append-texturePack-%s", new Object[] { s1 }));
                      }
                      obj1.put(Integer.valueOf(j), s2);
                    }
                }
            }
        }
    }

    public static boolean addTexturesZip(File file)
    {
        if (file == null || file.isDirectory())
        {
            return false;
        }

        try
        {
            FileInputStream fileinputstream = new FileInputStream(file);
            ZipInputStream zipinputstream = new ZipInputStream(fileinputstream);

            do
            {
                ZipEntry zipentry = zipinputstream.getNextEntry();

                if (zipentry == null)
                {
                    break;
                }

                if (!zipentry.isDirectory())
                {
                    if (zipentry.getName().endsWith(".class"))
                    {
                        addModelClass(zipentry.getName());
                    }
                    else
                    {
                        addTextureName(zipentry.getName());
                    }
                }
            }
            while (true);

            zipinputstream.close();
            fileinputstream.close();
            return true;
        }
        catch (Exception exception)
        {
            mod_littleMaidMob.Debug("addTextureZip-Exception.");
        }

        return false;
    }

    protected static boolean addTexturesJar(File file)
    {
        if (file.isFile())
        {
            mod_littleMaidMob.Debug("addTextureJar-zip.");
            return addTexturesZip(file);
        }

        if (file.isDirectory())
        {
            mod_littleMaidMob.Debug("addTextureJar-file.");
            Package package1 = (net.minecraft.src.ModLoader.class).getPackage();

            if (package1 != null)
            {
                String s = package1.getName().replace('.', File.separatorChar);
                file = new File(file, s);
                mod_littleMaidMob.Debug(String.format("addTextureJar-file-Packege:%s", new Object[]
                        {
                            s
                        }));
            }
            else
            {
                mod_littleMaidMob.Debug("addTextureJar-file-null.");
            }

            return addTexturesZip(file);
        }
        else
        {
            return false;
        }
    }

    public static boolean addTexturesDebug(File file)
    {
        if (file == null)
        {
            return false;
        }

        try
        {
            File afile[] = file.listFiles();
            int i = afile.length;

            for (int j = 0; j < i; j++)
            {
                File file1 = afile[j];

                if (file1.isDirectory())
                {
                    addTexturesDebug(file1);
                    continue;
                }

                String s = file1.getPath().replace('\\', '/');

                if (file1.getName().endsWith(".class"))
                {
                    addModelClass(file1.getName());
                    continue;
                }

                int k = s.indexOf(defDirName);

                if (k > -1)
                {
                    addTextureName(s.substring(k).replace('\\', '/'));
                }
            }

            return true;
        }
        catch (Exception exception)
        {
            mod_littleMaidMob.Debug("addTextureDebug-Exception.");
        }

        return false;
    }

    private static int getIndex(String s)
    {
        for (int i = 0; i < defNames.length; i++)
        {
            if (s.endsWith(defNames[i]))
            {
                return i;
            }
        }

        Pattern pattern = Pattern.compile("_([0-9a-f]+).png");
        Matcher matcher = pattern.matcher(s);

        if (matcher.find())
        {
            return Integer.decode((new StringBuilder()).append("0x").append(matcher.group(1)).toString()).intValue();
        }
        else
        {
            return -1;
        }
    }

    public static String getNextPackege(String s, int i)
    {
        boolean flag = false;
        Iterator iterator = textures.entrySet().iterator();

        do
        {
            if (!iterator.hasNext())
            {
                break;
            }

            java.util.Map.Entry entry = (java.util.Map.Entry)iterator.next();

            if (flag && ((Map)entry.getValue()).get(Integer.valueOf(i)) != null)
            {
                return (String)entry.getKey();
            }

            if (((String)entry.getKey()).equalsIgnoreCase(s))
            {
                flag = true;
            }
        }
        while (true);

        for (Iterator iterator1 = textures.entrySet().iterator(); iterator1.hasNext();)
        {
            java.util.Map.Entry entry1 = (java.util.Map.Entry)iterator1.next();

            if (((Map)entry1.getValue()).get(Integer.valueOf(i)) != null)
            {
                return (String)entry1.getKey();
            }
        }

        return null;
    }

    public static String getPrevPackege(String s, int i)
    {
        String s1 = null;
        Iterator iterator = textures.entrySet().iterator();

        do
        {
            if (!iterator.hasNext())
            {
                break;
            }

            java.util.Map.Entry entry = (java.util.Map.Entry)iterator.next();

            if (((String)entry.getKey()).equalsIgnoreCase(s) && s1 != null)
            {
                break;
            }

            if (((Map)entry.getValue()).get(Integer.valueOf(i)) != null)
            {
                s1 = (String)entry.getKey();
            }
        }
        while (true);

        return s1;
    }

    public static String getTextureName(String s, int i)
    {
        if (textures.get(s) == null || ((Map)textures.get(s)).get(Integer.valueOf(i)) == null)
        {
            return null;
        }
        else
        {
            return (new StringBuilder()).append(defDirName).append(s.replace('.', '/')).append((String)((Map)textures.get(s)).get(Integer.valueOf(i))).toString();
        }
    }

    public static int getTextureCount()
    {
        return textures.size();
    }

    public static String getNextArmorPackege(String s)
    {
        boolean flag = false;
        Iterator iterator = armors.entrySet().iterator();

        do
        {
            if (!iterator.hasNext())
            {
                break;
            }

            java.util.Map.Entry entry = (java.util.Map.Entry)iterator.next();

            if (flag)
            {
                return (String)entry.getKey();
            }

            if (((String)entry.getKey()).equalsIgnoreCase(s))
            {
                flag = true;
            }
        }
        while (true);

        iterator = armors.entrySet().iterator();

        if (iterator.hasNext())
        {
            java.util.Map.Entry entry1 = (java.util.Map.Entry)iterator.next();
            return (String)entry1.getKey();
        }
        else
        {
            return null;
        }
    }

    public static String getPrevArmorPackege(String s)
    {
        String s1 = null;
        Iterator iterator = armors.entrySet().iterator();

        do
        {
            if (!iterator.hasNext())
            {
                break;
            }

            java.util.Map.Entry entry = (java.util.Map.Entry)iterator.next();

            if (((String)entry.getKey()).equalsIgnoreCase(s) && s1 != null)
            {
                break;
            }

            s1 = (String)entry.getKey();
        }
        while (true);

        return s1;
    }

    public static String getArmorTextureName(String s, int i, ItemStack itemstack)
    {
        Map map = (Map)armors.get(s);

        if (map == null || itemstack == null)
        {
            return null;
        }

        if (!(itemstack.getItem() instanceof ItemArmor))
        {
            return null;
        }

        Map map1 = (Map)map.get(armorFilenamePrefix[((ItemArmor)itemstack.getItem()).renderIndex]);

        if (map1 == null)
        {
            map1 = (Map)map.get("default");

            if (map1 == null)
            {
                return null;
            }
        }

        int j = 0;

        if (itemstack.getMaxDamage() > 0)
        {
            j = (10 * itemstack.getItemDamage()) / itemstack.getMaxDamage();
        }

        String s1 = null;
        int k = i + j;

        do
        {
            if (k < i)
            {
                break;
            }

            s1 = (String)map1.get(Integer.valueOf(k));

            if (s1 != null)
            {
                break;
            }

            k--;
        }
        while (true);

        if (s1 == null)
        {
            return null;
        }
        else
        {
            return (new StringBuilder()).append(defDirName).append(s.replace('.', '/')).append(s1).toString();
        }
    }

    public static int getArmorTextureCount()
    {
        return armors.size();
    }

    public static int getRandomWildColor(String s, Random random)
    {
        ArrayList arraylist = new ArrayList();
        Iterator iterator = ((Map)textures.get(s)).keySet().iterator();

        do
        {
            if (!iterator.hasNext())
            {
                break;
            }

            Integer integer = (Integer)iterator.next();

            if (integer.intValue() >= 48 && integer.intValue() <= 63)
            {
                arraylist.add(Integer.valueOf(integer.intValue() & 0xf));
            }
        }
        while (true);

        if (arraylist.size() > 0)
        {
            return ((Integer)arraylist.get(random.nextInt(arraylist.size()))).intValue();
        }
        else
        {
            return -1;
        }
    }
}
