package net.minecraft.src;

import java.io.*;
import java.util.*;
import net.minecraft.client.Minecraft;

public class SoundLittleMaid
{
    public static Map soundsDefault = new HashMap();
    public static Map soundsTexture = new HashMap();

    public SoundLittleMaid()
    {
    }

    public static void setSoundValue(int i, String s, String s1)
    {
        String as[] = s.split(",");
        String as1[] = as;
        int j = as1.length;

        for (int k = 0; k < j; k++)
        {
            String s2 = as1[k];
            String s3;

            if (s2.indexOf(';') == -1)
            {
                if (s1 == null || s1.isEmpty())
                {
                    s3 = s;
                }
                else
                {
                    s3 = (new StringBuilder()).append(s1).append(";-1;").append(s).toString();
                }
            }
            else
            {
                String as2[] = s2.trim().split(";");

                if (as2.length == 2)
                {
                    s3 = (new StringBuilder()).append(s1).append(";").append(s).toString();
                }
                else
                {
                    s3 = s;
                }
            }

            setSoundValue(i, s3);
        }
    }

    public static void setSoundValue(int i, String s)
    {
        String as[] = s.split(",");
        String as1[] = as;
        int j = as1.length;

        for (int k = 0; k < j; k++)
        {
            String s1 = as1[k];

            if (s1.indexOf(';') == -1)
            {
                soundsDefault.put(Integer.valueOf(i), s1.trim());
                continue;
            }

            Object obj = (Map)soundsTexture.get(Integer.valueOf(i));

            if (obj == null)
            {
                obj = new HashMap();
                soundsTexture.put(Integer.valueOf(i), obj);
            }

            String as2[] = s1.trim().split(";");

            if (as2.length < 2)
            {
                continue;
            }

            if (as2[0].length() == 0)
            {
                as2[0] = ";";
            }

            Object obj1 = (Map)((Map)(obj)).get(as2[0]);

            if (obj1 == null)
            {
                obj1 = new HashMap();
                ((Map)(obj)).put(as2[0], obj1);
            }

            as2[1] = as2[1].trim();
            int l = as2[1].length() != 0 ? Integer.valueOf(as2[1]).intValue() : -1;

            if (as2.length < 3)
            {
                ((Map)(obj1)).put(Integer.valueOf(l), "");
            }
            else
            {
                ((Map)(obj1)).put(Integer.valueOf(l), as2[2].trim());
            }
        }
    }

    public static String getSoundValue(EnumSoundLittleMaid enumsoundlittlemaid, String s, int i)
    {
        if (enumsoundlittlemaid == EnumSoundLittleMaid.Null)
        {
            return null;
        }

        Map map = (Map)soundsTexture.get(Integer.valueOf(enumsoundlittlemaid.index));

        if (map == null)
        {
            return (String)soundsDefault.get(Integer.valueOf(enumsoundlittlemaid.index));
        }

        if (s == null || s.length() == 0)
        {
            s = ";";
        }

        Map map1 = (Map)map.get(s);

        if (map1 == null)
        {
            map1 = (Map)map.get(";");

            if (map1 == null)
            {
                return (String)soundsDefault.get(Integer.valueOf(enumsoundlittlemaid.index));
            }
        }

        String s1 = (String)map1.get(Integer.valueOf(i));

        if (s1 == null)
        {
            s1 = (String)map1.get(Integer.valueOf(-1));

            if (s1 == null)
            {
                return (String)soundsDefault.get(Integer.valueOf(enumsoundlittlemaid.index));
            }
        }

        return s1;
    }

    public static void decodeSoundPack(File file, boolean flag)
    {
        try
        {
            ArrayList arraylist = new ArrayList();
            arraylist.addAll(Arrays.asList(EnumSoundLittleMaid.values()));
            arraylist.remove(EnumSoundLittleMaid.Null);
            BufferedReader bufferedreader = new BufferedReader(new FileReader(file));
            String s1 = file.getName();
            s1 = s1.substring(0, s1.lastIndexOf("."));

            do
            {
                String s;

                if ((s = bufferedreader.readLine()) == null)
                {
                    break;
                }

                s = s.trim();

                if (!s.isEmpty() && !s.startsWith("#"))
                {
                    int i = s.indexOf('=');

                    if (i > -1)
                    {
                        String s2 = s.substring(0, i).trim();
                        String s3 = s.substring(i + 1).trim();
                        int k = -1;

                        if (s2.startsWith("se_"))
                        {
                            String s4 = s2.substring(3);

                            try
                            {
                                k = EnumSoundLittleMaid.valueOf(s4).index;
                                arraylist.remove(EnumSoundLittleMaid.valueOf(s4));
                            }
                            catch (Exception exception1)
                            {
                                mod_littleMaidMob.Debug(String.format("unknown sound parameter:%s.cfg - %s", new Object[]
                                        {
                                            s1, s4
                                        }));
                            }
                        }

                        if (k > -1)
                        {
                            if (flag)
                            {
                                setSoundValue(k, s3);
                            }
                            else
                            {
                                setSoundValue(k, s3, s1);
                            }
                        }
                    }
                }
            }
            while (true);

            bufferedreader.close();

            if (!arraylist.isEmpty())
            {
                BufferedWriter bufferedwriter = new BufferedWriter(new FileWriter(file, true));

                for (int j = 0; j < arraylist.size(); j++)
                {
                    writeBuffer(bufferedwriter, (EnumSoundLittleMaid)arraylist.get(j));
                }

                bufferedwriter.close();
            }
        }
        catch (Exception exception)
        {
            mod_littleMaidMob.Debug("decodeSound Exception.");
        }
    }

    public static void loadSoundPack()
    {
        File file = Minecraft.getAppDir("minecraft/resources/mod/sound/littleMaidMob");

        if (file.exists() && file.isDirectory())
        {
            File afile[] = file.listFiles();
            int i = afile.length;

            for (int j = 0; j < i; j++)
            {
                File file1 = afile[j];

                if (file1.getName().compareToIgnoreCase("littleMaidMob.cfg") != 0 && file1.isFile() && file1.canRead() && file1.getName().endsWith(".cfg"))
                {
                    mod_littleMaidMob.Debug(file1.getName());
                    decodeSoundPack(file1, false);
                }
            }
        }
        else
        {
            mod_littleMaidMob.Debug("no Sound Directory.");
        }
    }

    public static boolean loadDefaultSoundPack()
    {
        File file = Minecraft.getAppDir("minecraft/resources/mod/sound/littleMaidMob");
        File file1 = new File(file, "littleMaidMob.cfg");

        if (file1.exists() && file1.isFile())
        {
            mod_littleMaidMob.Debug(file1.getName());
            decodeSoundPack(file1, true);
            return true;
        }
        else
        {
            mod_littleMaidMob.Debug("no Default Sound cfg.");
            createDefaultSoundPack(file1);
            return false;
        }
    }

    public static boolean createDefaultSoundPack(File file)
    {
        EnumSoundLittleMaid aenumsoundlittlemaid[] = EnumSoundLittleMaid.values();
        int i = aenumsoundlittlemaid.length;

        for (int j = 0; j < i; j++)
        {
            EnumSoundLittleMaid enumsoundlittlemaid = aenumsoundlittlemaid[j];

            if (enumsoundlittlemaid != EnumSoundLittleMaid.Null)
            {
                setSoundValue(enumsoundlittlemaid.index, enumsoundlittlemaid.DefaultValue);
            }
        }

        if (file.exists())
        {
            return false;
        }

        try
        {
            if (file.createNewFile())
            {
                BufferedWriter bufferedwriter = new BufferedWriter(new FileWriter(file));
                EnumSoundLittleMaid aenumsoundlittlemaid1[] = EnumSoundLittleMaid.values();
                int k = aenumsoundlittlemaid1.length;

                for (int l = 0; l < k; l++)
                {
                    EnumSoundLittleMaid enumsoundlittlemaid1 = aenumsoundlittlemaid1[l];
                    writeBuffer(bufferedwriter, enumsoundlittlemaid1);
                }

                bufferedwriter.close();
                mod_littleMaidMob.Debug("Success create Default Sound cfg.");
            }
        }
        catch (IOException ioexception)
        {
            ioexception.printStackTrace();
            return false;
        }

        return true;
    }

    protected static void writeBuffer(BufferedWriter bufferedwriter, EnumSoundLittleMaid enumsoundlittlemaid) throws IOException
    {
        if (enumsoundlittlemaid == EnumSoundLittleMaid.Null)
        {
            return;
        }
        else
        {
            bufferedwriter.write("# ");
            bufferedwriter.write(enumsoundlittlemaid.info);
            bufferedwriter.newLine();
            bufferedwriter.write("se_");
            bufferedwriter.write(enumsoundlittlemaid.name());
            bufferedwriter.write("=");
            bufferedwriter.write(enumsoundlittlemaid.DefaultValue);
            bufferedwriter.newLine();
            bufferedwriter.newLine();
            return;
        }
    }
}
